/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.RpcChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.AsyncMetaTableAccessor;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncAdminBuilderBase;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncHBaseAdmin;
import org.apache.hadoop.hbase.client.AsyncRegistry;
import org.apache.hadoop.hbase.client.AsyncRegistryFactory;
import org.apache.hadoop.hbase.client.AsyncRpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.ClientCoprocessorRpcController;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.CompactType;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.MasterCoprocessorRpcChannelImpl;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.NoServerForRegionException;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.RawAsyncTable;
import org.apache.hadoop.hbase.client.RawScanResultConsumer;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionServerCoprocessorRpcChannelImpl;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.client.replication.ReplicationSerDeHelper;
import org.apache.hadoop.hbase.client.replication.TableCFs;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcCallback;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcController;
import org.apache.hadoop.hbase.shaded.io.netty.util.Timeout;
import org.apache.hadoop.hbase.shaded.io.netty.util.TimerTask;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ErrorHandlingProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ForeignExceptionUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RawAsyncHBaseAdmin
implements AsyncAdmin {
    public static final String FLUSH_TABLE_PROCEDURE_SIGNATURE = "flush-table-proc";
    private static final Log LOG = LogFactory.getLog(AsyncHBaseAdmin.class);
    private final AsyncConnectionImpl connection;
    private final RawAsyncTable metaTable;
    private final long rpcTimeoutNs;
    private final long operationTimeoutNs;
    private final long pauseNs;
    private final int maxAttempts;
    private final int startLogErrorsCnt;
    private final NonceGenerator ng;

    RawAsyncHBaseAdmin(AsyncConnectionImpl connection, AsyncAdminBuilderBase builder) {
        this.connection = connection;
        this.metaTable = connection.getRawTable(TableName.META_TABLE_NAME);
        this.rpcTimeoutNs = builder.rpcTimeoutNs;
        this.operationTimeoutNs = builder.operationTimeoutNs;
        this.pauseNs = builder.pauseNs;
        this.maxAttempts = builder.maxAttempts;
        this.startLogErrorsCnt = builder.startLogErrorsCnt;
        this.ng = connection.getNonceGenerator();
    }

    private <T> AsyncRpcRetryingCallerFactory.MasterRequestCallerBuilder<T> newMasterCaller() {
        return this.connection.callerFactory.masterRequest().rpcTimeout(this.rpcTimeoutNs, TimeUnit.NANOSECONDS).operationTimeout(this.operationTimeoutNs, TimeUnit.NANOSECONDS).pause(this.pauseNs, TimeUnit.NANOSECONDS).maxAttempts(this.maxAttempts).startLogErrorsCnt(this.startLogErrorsCnt);
    }

    private <T> AsyncRpcRetryingCallerFactory.AdminRequestCallerBuilder<T> newAdminCaller() {
        return this.connection.callerFactory.adminRequest().rpcTimeout(this.rpcTimeoutNs, TimeUnit.NANOSECONDS).operationTimeout(this.operationTimeoutNs, TimeUnit.NANOSECONDS).pause(this.pauseNs, TimeUnit.NANOSECONDS).maxAttempts(this.maxAttempts).startLogErrorsCnt(this.startLogErrorsCnt);
    }

    private <PREQ, PRESP, RESP> CompletableFuture<RESP> call(final HBaseRpcController controller, MasterProtos.MasterService.Interface stub, PREQ preq, MasterRpcCall<PRESP, PREQ> rpcCall, final Converter<RESP, PRESP> respConverter) {
        final CompletableFuture future = new CompletableFuture();
        rpcCall.call(stub, controller, preq, new RpcCallback<PRESP>(){

            public void run(PRESP resp) {
                if (controller.failed()) {
                    future.completeExceptionally(controller.getFailed());
                } else {
                    try {
                        future.complete(respConverter.convert(resp));
                    }
                    catch (IOException e) {
                        future.completeExceptionally(e);
                    }
                }
            }
        });
        return future;
    }

    private <PREQ, PRESP, RESP> CompletableFuture<RESP> adminCall(final HBaseRpcController controller, AdminProtos.AdminService.Interface stub, PREQ preq, AdminRpcCall<PRESP, PREQ> rpcCall, final Converter<RESP, PRESP> respConverter) {
        final CompletableFuture future = new CompletableFuture();
        rpcCall.call(stub, controller, preq, new RpcCallback<PRESP>(){

            public void run(PRESP resp) {
                if (controller.failed()) {
                    future.completeExceptionally(new IOException(controller.errorText()));
                } else {
                    try {
                        future.complete(respConverter.convert(resp));
                    }
                    catch (IOException e) {
                        future.completeExceptionally(e);
                    }
                }
            }
        });
        return future;
    }

    private <PREQ, PRESP> CompletableFuture<Void> procedureCall(PREQ preq, MasterRpcCall<PRESP, PREQ> rpcCall, Converter<Long, PRESP> respConverter, ProcedureBiConsumer consumer) {
        CompletableFuture<Long> procFuture = this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, preq, rpcCall, respConverter)).call();
        return this.waitProcedureResult(procFuture).whenComplete((BiConsumer)consumer);
    }

    @Override
    public CompletableFuture<Boolean> tableExists(TableName tableName) {
        return AsyncMetaTableAccessor.tableExists(this.metaTable, tableName);
    }

    @Override
    public CompletableFuture<List<TableDescriptor>> listTables(Optional<Pattern> pattern, boolean includeSysTables) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildGetTableDescriptorsRequest(pattern, includeSysTables), (s, c, req, done) -> s.getTableDescriptors((RpcController)c, req, done), resp -> ProtobufUtil.toTableDescriptorList(resp))).call();
    }

    @Override
    public CompletableFuture<List<TableName>> listTableNames(Optional<Pattern> pattern, boolean includeSysTables) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildGetTableNamesRequest(pattern, includeSysTables), (s, c, req, done) -> s.getTableNames((RpcController)c, req, done), resp -> ProtobufUtil.toTableNameList(resp.getTableNamesList()))).call();
    }

    @Override
    public CompletableFuture<TableDescriptor> getTableDescriptor(TableName tableName) {
        CompletableFuture<TableDescriptor> future = new CompletableFuture<TableDescriptor>();
        this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildGetTableDescriptorsRequest(tableName), (s, c, req, done) -> s.getTableDescriptors((RpcController)c, req, done), resp -> resp.getTableSchemaList())).call().whenComplete((tableSchemas, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            if (!tableSchemas.isEmpty()) {
                future.complete(ProtobufUtil.toTableDescriptor((HBaseProtos.TableSchema)tableSchemas.get(0)));
            } else {
                future.completeExceptionally((Throwable)((Object)new TableNotFoundException(tableName.getNameAsString())));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> createTable(TableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) {
        try {
            return this.createTable(desc, Optional.of(this.getSplitKeys(startKey, endKey, numRegions)));
        }
        catch (IllegalArgumentException e) {
            return this.failedFuture(e);
        }
    }

    @Override
    public CompletableFuture<Void> createTable(TableDescriptor desc, Optional<byte[][]> splitKeys) {
        if (desc.getTableName() == null) {
            return this.failedFuture(new IllegalArgumentException("TableName cannot be null"));
        }
        try {
            splitKeys.ifPresent(keys -> this.verifySplitKeys((byte[][])keys));
            return this.procedureCall(RequestConverter.buildCreateTableRequest(desc, splitKeys, this.ng.getNonceGroup(), this.ng.newNonce()), (s, c, req, done) -> s.createTable((RpcController)c, req, done), resp -> resp.getProcId(), new CreateTableProcedureBiConsumer(this, desc.getTableName()));
        }
        catch (IllegalArgumentException e) {
            return this.failedFuture(e);
        }
    }

    @Override
    public CompletableFuture<Void> deleteTable(TableName tableName) {
        return this.procedureCall(RequestConverter.buildDeleteTableRequest(tableName, this.ng.getNonceGroup(), this.ng.newNonce()), (s, c, req, done) -> s.deleteTable((RpcController)c, req, done), resp -> resp.getProcId(), new DeleteTableProcedureBiConsumer(this, tableName));
    }

    @Override
    public CompletableFuture<Void> truncateTable(TableName tableName, boolean preserveSplits) {
        return this.procedureCall(RequestConverter.buildTruncateTableRequest(tableName, preserveSplits, this.ng.getNonceGroup(), this.ng.newNonce()), (s, c, req, done) -> s.truncateTable((RpcController)c, req, done), resp -> resp.getProcId(), new TruncateTableProcedureBiConsumer(this, tableName));
    }

    @Override
    public CompletableFuture<Void> enableTable(TableName tableName) {
        return this.procedureCall(RequestConverter.buildEnableTableRequest(tableName, this.ng.getNonceGroup(), this.ng.newNonce()), (s, c, req, done) -> s.enableTable((RpcController)c, req, done), resp -> resp.getProcId(), new EnableTableProcedureBiConsumer(this, tableName));
    }

    @Override
    public CompletableFuture<Void> disableTable(TableName tableName) {
        return this.procedureCall(RequestConverter.buildDisableTableRequest(tableName, this.ng.getNonceGroup(), this.ng.newNonce()), (s, c, req, done) -> s.disableTable((RpcController)c, req, done), resp -> resp.getProcId(), new DisableTableProcedureBiConsumer(this, tableName));
    }

    @Override
    public CompletableFuture<Boolean> isTableEnabled(TableName tableName) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        AsyncMetaTableAccessor.getTableState(this.metaTable, tableName).whenComplete((state, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            if (state.isPresent()) {
                future.complete(((TableState)state.get()).inStates(TableState.State.ENABLED));
            } else {
                future.completeExceptionally((Throwable)((Object)new TableNotFoundException(tableName)));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Boolean> isTableDisabled(TableName tableName) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        AsyncMetaTableAccessor.getTableState(this.metaTable, tableName).whenComplete((state, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            if (state.isPresent()) {
                future.complete(((TableState)state.get()).inStates(TableState.State.DISABLED));
            } else {
                future.completeExceptionally((Throwable)((Object)new TableNotFoundException(tableName)));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Boolean> isTableAvailable(TableName tableName) {
        return this.isTableAvailable(tableName, null);
    }

    @Override
    public CompletableFuture<Boolean> isTableAvailable(TableName tableName, byte[][] splitKeys) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.isTableEnabled(tableName).whenComplete((enabled, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            if (!enabled.booleanValue()) {
                future.complete(false);
            } else {
                AsyncMetaTableAccessor.getTableHRegionLocations(this.metaTable, Optional.of(tableName)).whenComplete((locations, error1) -> {
                    if (error1 != null) {
                        future.completeExceptionally((Throwable)error1);
                        return;
                    }
                    int notDeployed = 0;
                    int regionCount = 0;
                    block0: for (HRegionLocation location : locations) {
                        HRegionInfo info = location.getRegionInfo();
                        if (location.getServerName() == null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Table " + tableName + " has not deployed region " + info.getEncodedName()));
                            }
                            ++notDeployed;
                            continue;
                        }
                        if (splitKeys != null && !Bytes.equals((byte[])info.getStartKey(), (byte[])HConstants.EMPTY_BYTE_ARRAY)) {
                            for (byte[] splitKey : splitKeys) {
                                if (!Bytes.equals((byte[])info.getStartKey(), (byte[])splitKey)) continue;
                                ++regionCount;
                                continue block0;
                            }
                            continue;
                        }
                        ++regionCount;
                    }
                    if (notDeployed > 0) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Table " + tableName + " has " + notDeployed + " regions"));
                        }
                        future.complete(false);
                    } else if (splitKeys != null && regionCount != splitKeys.length + 1) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Table " + tableName + " expected to have " + (splitKeys.length + 1) + " regions, but only " + regionCount + " available"));
                        }
                        future.complete(false);
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Table " + tableName + " should be available"));
                        }
                        future.complete(true);
                    }
                });
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> addColumnFamily(TableName tableName, ColumnFamilyDescriptor columnFamily) {
        return this.procedureCall(RequestConverter.buildAddColumnRequest(tableName, columnFamily, this.ng.getNonceGroup(), this.ng.newNonce()), (s, c, req, done) -> s.addColumn((RpcController)c, req, done), resp -> resp.getProcId(), new AddColumnFamilyProcedureBiConsumer(this, tableName));
    }

    @Override
    public CompletableFuture<Void> deleteColumnFamily(TableName tableName, byte[] columnFamily) {
        return this.procedureCall(RequestConverter.buildDeleteColumnRequest(tableName, columnFamily, this.ng.getNonceGroup(), this.ng.newNonce()), (s, c, req, done) -> s.deleteColumn((RpcController)c, req, done), resp -> resp.getProcId(), new DeleteColumnFamilyProcedureBiConsumer(this, tableName));
    }

    @Override
    public CompletableFuture<Void> modifyColumnFamily(TableName tableName, ColumnFamilyDescriptor columnFamily) {
        return this.procedureCall(RequestConverter.buildModifyColumnRequest(tableName, columnFamily, this.ng.getNonceGroup(), this.ng.newNonce()), (s, c, req, done) -> s.modifyColumn((RpcController)c, req, done), resp -> resp.getProcId(), new ModifyColumnFamilyProcedureBiConsumer(this, tableName));
    }

    @Override
    public CompletableFuture<Void> createNamespace(NamespaceDescriptor descriptor) {
        return this.procedureCall(RequestConverter.buildCreateNamespaceRequest(descriptor), (s, c, req, done) -> s.createNamespace((RpcController)c, req, done), resp -> resp.getProcId(), new CreateNamespaceProcedureBiConsumer(this, descriptor.getName()));
    }

    @Override
    public CompletableFuture<Void> modifyNamespace(NamespaceDescriptor descriptor) {
        return this.procedureCall(RequestConverter.buildModifyNamespaceRequest(descriptor), (s, c, req, done) -> s.modifyNamespace((RpcController)c, req, done), resp -> resp.getProcId(), new ModifyNamespaceProcedureBiConsumer(this, descriptor.getName()));
    }

    @Override
    public CompletableFuture<Void> deleteNamespace(String name) {
        return this.procedureCall(RequestConverter.buildDeleteNamespaceRequest(name), (s, c, req, done) -> s.deleteNamespace((RpcController)c, req, done), resp -> resp.getProcId(), new DeleteNamespaceProcedureBiConsumer(this, name));
    }

    @Override
    public CompletableFuture<NamespaceDescriptor> getNamespaceDescriptor(String name) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildGetNamespaceDescriptorRequest(name), (s, c, req, done) -> s.getNamespaceDescriptor((RpcController)c, req, done), resp -> ProtobufUtil.toNamespaceDescriptor(resp.getNamespaceDescriptor()))).call();
    }

    @Override
    public CompletableFuture<List<NamespaceDescriptor>> listNamespaceDescriptors() {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.ListNamespaceDescriptorsRequest.newBuilder().build(), (s, c, req, done) -> s.listNamespaceDescriptors((RpcController)c, req, done), resp -> ProtobufUtil.toNamespaceDescriptorList(resp))).call();
    }

    @Override
    public CompletableFuture<List<RegionInfo>> getOnlineRegions(ServerName serverName) {
        return this.newAdminCaller().action((controller, stub) -> this.adminCall(controller, stub, RequestConverter.buildGetOnlineRegionRequest(), (s, c, req, done) -> s.getOnlineRegion((RpcController)c, req, done), resp -> ProtobufUtil.getRegionInfos(resp))).serverName(serverName).call();
    }

    @Override
    public CompletableFuture<List<RegionInfo>> getTableRegions(TableName tableName) {
        if (tableName.equals((Object)TableName.META_TABLE_NAME)) {
            return this.connection.getLocator().getRegionLocation(tableName, null, null, this.operationTimeoutNs).thenApply(loc -> Arrays.asList(loc.getRegionInfo()));
        }
        return AsyncMetaTableAccessor.getTableHRegionLocations(this.metaTable, Optional.of(tableName)).thenApply(locs -> locs.stream().map(loc -> loc.getRegionInfo()).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Void> flush(TableName tableName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.tableExists(tableName).whenComplete((exists, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
            } else if (!exists.booleanValue()) {
                future.completeExceptionally((Throwable)((Object)new TableNotFoundException(tableName)));
            } else {
                this.isTableEnabled(tableName).whenComplete((tableEnabled, err2) -> {
                    if (err2 != null) {
                        future.completeExceptionally((Throwable)err2);
                    } else if (!tableEnabled.booleanValue()) {
                        future.completeExceptionally((Throwable)((Object)new TableNotEnabledException(tableName)));
                    } else {
                        this.execProcedure(FLUSH_TABLE_PROCEDURE_SIGNATURE, tableName.getNameAsString(), new HashMap<String, String>()).whenComplete((ret, err3) -> {
                            if (err3 != null) {
                                future.completeExceptionally((Throwable)err3);
                            } else {
                                future.complete((Void)ret);
                            }
                        });
                    }
                });
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> flushRegion(byte[] regionName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getRegionLocation(regionName).whenComplete((location, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            ServerName serverName = location.getServerName();
            if (serverName == null) {
                future.completeExceptionally((Throwable)((Object)new NoServerForRegionException(Bytes.toStringBinary((byte[])regionName))));
                return;
            }
            HRegionInfo regionInfo = location.getRegionInfo();
            this.newAdminCaller().serverName(serverName).action((controller, stub) -> this.adminCall(controller, stub, RequestConverter.buildFlushRegionRequest(regionInfo.getRegionName()), (s, c, req, done) -> s.flushRegion((RpcController)c, req, done), resp -> null)).call().whenComplete((ret, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                } else {
                    future.complete((Void)ret);
                }
            });
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> compact(TableName tableName, Optional<byte[]> columnFamily) {
        return this.compact(tableName, columnFamily, false, CompactType.NORMAL);
    }

    @Override
    public CompletableFuture<Void> compactRegion(byte[] regionName, Optional<byte[]> columnFamily) {
        return this.compactRegion(regionName, columnFamily, false);
    }

    @Override
    public CompletableFuture<Void> majorCompact(TableName tableName, Optional<byte[]> columnFamily) {
        return this.compact(tableName, columnFamily, true, CompactType.NORMAL);
    }

    @Override
    public CompletableFuture<Void> majorCompactRegion(byte[] regionName, Optional<byte[]> columnFamily) {
        return this.compactRegion(regionName, columnFamily, true);
    }

    @Override
    public CompletableFuture<Void> compactRegionServer(ServerName sn) {
        return this.compactRegionServer(sn, false);
    }

    @Override
    public CompletableFuture<Void> majorCompactRegionServer(ServerName sn) {
        return this.compactRegionServer(sn, true);
    }

    private CompletableFuture<Void> compactRegionServer(ServerName sn, boolean major) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getOnlineRegions(sn).whenComplete((hRegionInfos, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            ArrayList compactFutures = new ArrayList();
            if (hRegionInfos != null) {
                hRegionInfos.forEach(region -> compactFutures.add(this.compact(sn, (RegionInfo)region, major, Optional.empty())));
            }
            CompletableFuture.allOf(compactFutures.toArray(new CompletableFuture[compactFutures.size()])).whenComplete((ret, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                } else {
                    future.complete((Void)ret);
                }
            });
        });
        return future;
    }

    private CompletableFuture<Void> compactRegion(byte[] regionName, Optional<byte[]> columnFamily, boolean major) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getRegionLocation(regionName).whenComplete((location, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            ServerName serverName = location.getServerName();
            if (serverName == null) {
                future.completeExceptionally((Throwable)((Object)new NoServerForRegionException(Bytes.toStringBinary((byte[])regionName))));
                return;
            }
            this.compact(location.getServerName(), location.getRegionInfo(), major, columnFamily).whenComplete((ret, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                } else {
                    future.complete((Void)ret);
                }
            });
        });
        return future;
    }

    private CompletableFuture<List<HRegionLocation>> getTableHRegionLocations(TableName tableName) {
        if (TableName.META_TABLE_NAME.equals((Object)tableName)) {
            CompletableFuture<List<HRegionLocation>> future = new CompletableFuture<List<HRegionLocation>>();
            AsyncRegistry registry = AsyncRegistryFactory.getRegistry(this.connection.getConfiguration());
            registry.getMetaRegionLocation().whenComplete((metaRegions, err) -> {
                if (err != null) {
                    future.completeExceptionally((Throwable)err);
                } else if (metaRegions == null || metaRegions.isEmpty() || metaRegions.getDefaultRegionLocation() == null) {
                    future.completeExceptionally(new IOException("meta region does not found"));
                } else {
                    future.complete(Collections.singletonList(metaRegions.getDefaultRegionLocation()));
                }
                IOUtils.closeQuietly((Closeable)registry);
            });
            return future;
        }
        return AsyncMetaTableAccessor.getTableHRegionLocations(this.metaTable, Optional.of(tableName));
    }

    private CompletableFuture<Void> compact(TableName tableName, Optional<byte[]> columnFamily, boolean major, CompactType compactType) {
        if (CompactType.MOB.equals((Object)compactType)) {
            return this.failedFuture(new UnsupportedOperationException("MOB compact does not support"));
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getTableHRegionLocations(tableName).whenComplete((locations, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            ArrayList<CompletableFuture<Void>> compactFutures = new ArrayList<CompletableFuture<Void>>();
            for (HRegionLocation location : locations) {
                if (location.getRegionInfo() == null || location.getRegionInfo().isOffline() || location.getServerName() == null) continue;
                compactFutures.add(this.compact(location.getServerName(), location.getRegionInfo(), major, columnFamily));
            }
            CompletableFuture.allOf(compactFutures.toArray(new CompletableFuture[compactFutures.size()])).whenComplete((ret, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                } else {
                    future.complete((Void)ret);
                }
            });
        });
        return future;
    }

    private CompletableFuture<Void> compact(ServerName sn, RegionInfo hri, boolean major, Optional<byte[]> columnFamily) {
        return this.newAdminCaller().serverName(sn).action((controller, stub) -> this.adminCall(controller, stub, RequestConverter.buildCompactRegionRequest(hri.getRegionName(), major, columnFamily), (s, c, req, done) -> s.compactRegion((RpcController)c, req, done), resp -> null)).call();
    }

    private byte[] toEncodeRegionName(byte[] regionName) {
        try {
            return RegionInfo.isEncodedRegionName(regionName) ? regionName : Bytes.toBytes((String)RegionInfo.encodeRegionName(regionName));
        }
        catch (IOException e) {
            return regionName;
        }
    }

    private void checkAndGetTableName(byte[] encodeRegionName, AtomicReference<TableName> tableName, CompletableFuture<TableName> result) {
        this.getRegionLocation(encodeRegionName).whenComplete((location, err) -> {
            if (err != null) {
                result.completeExceptionally((Throwable)err);
                return;
            }
            HRegionInfo regionInfo = location.getRegionInfo();
            if (regionInfo.getReplicaId() != 0) {
                result.completeExceptionally(new IllegalArgumentException("Can't invoke merge on non-default regions directly"));
                return;
            }
            if (!tableName.compareAndSet(null, regionInfo.getTable())) {
                if (!((TableName)tableName.get()).equals((Object)regionInfo.getTable())) {
                    result.completeExceptionally(new IllegalArgumentException("Cannot merge regions from two different tables " + tableName.get() + " and " + regionInfo.getTable()));
                } else {
                    result.complete((TableName)tableName.get());
                }
            }
        });
    }

    private CompletableFuture<TableName> checkRegionsAndGetTableName(byte[] encodeRegionNameA, byte[] encodeRegionNameB) {
        AtomicReference<TableName> tableNameRef = new AtomicReference<TableName>();
        CompletableFuture<TableName> future = new CompletableFuture<TableName>();
        this.checkAndGetTableName(encodeRegionNameA, tableNameRef, future);
        this.checkAndGetTableName(encodeRegionNameB, tableNameRef, future);
        return future;
    }

    @Override
    public CompletableFuture<Boolean> setMergeOn(boolean on) {
        return this.setSplitOrMergeOn(on, MasterSwitchType.MERGE);
    }

    @Override
    public CompletableFuture<Boolean> isMergeOn() {
        return this.isSplitOrMergeOn(MasterSwitchType.MERGE);
    }

    @Override
    public CompletableFuture<Boolean> setSplitOn(boolean on) {
        return this.setSplitOrMergeOn(on, MasterSwitchType.SPLIT);
    }

    @Override
    public CompletableFuture<Boolean> isSplitOn() {
        return this.isSplitOrMergeOn(MasterSwitchType.SPLIT);
    }

    private CompletableFuture<Boolean> setSplitOrMergeOn(boolean on, MasterSwitchType switchType) {
        MasterProtos.SetSplitOrMergeEnabledRequest request = RequestConverter.buildSetSplitOrMergeEnabledRequest(on, false, switchType);
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, request, (s, c, req, done) -> s.setSplitOrMergeEnabled((RpcController)c, req, done), resp -> (Boolean)resp.getPrevValueList().get(0))).call();
    }

    private CompletableFuture<Boolean> isSplitOrMergeOn(MasterSwitchType switchType) {
        MasterProtos.IsSplitOrMergeEnabledRequest request = RequestConverter.buildIsSplitOrMergeEnabledRequest(switchType);
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, request, (s, c, req, done) -> s.isSplitOrMergeEnabled((RpcController)c, req, done), resp -> resp.getEnabled())).call();
    }

    @Override
    public CompletableFuture<Void> mergeRegions(byte[] nameOfRegionA, byte[] nameOfRegionB, boolean forcible) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        byte[] encodeRegionNameA = this.toEncodeRegionName(nameOfRegionA);
        byte[] encodeRegionNameB = this.toEncodeRegionName(nameOfRegionB);
        this.checkRegionsAndGetTableName(encodeRegionNameA, encodeRegionNameB).whenComplete((tableName, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            MasterProtos.MergeTableRegionsRequest request = null;
            try {
                request = RequestConverter.buildMergeTableRegionsRequest(new byte[][]{encodeRegionNameA, encodeRegionNameB}, forcible, this.ng.getNonceGroup(), this.ng.newNonce());
            }
            catch (DeserializationException e) {
                future.completeExceptionally(e);
                return;
            }
            this.procedureCall(request, (s, c, req, done) -> s.mergeTableRegions((RpcController)c, req, done), resp -> resp.getProcId(), new MergeTableRegionProcedureBiConsumer(this, (TableName)tableName)).whenComplete((ret, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                } else {
                    future.complete((Void)ret);
                }
            });
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> split(TableName tableName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.tableExists(tableName).whenComplete((exist, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            if (!exist.booleanValue()) {
                future.completeExceptionally((Throwable)((Object)new TableNotFoundException(tableName)));
                return;
            }
            this.metaTable.scanAll(new Scan().setReadType(Scan.ReadType.PREAD).addFamily(HConstants.CATALOG_FAMILY).withStartRow(MetaTableAccessor.getTableStartRowForMeta(tableName, MetaTableAccessor.QueryType.REGION)).withStopRow(MetaTableAccessor.getTableStopRowForMeta(tableName, MetaTableAccessor.QueryType.REGION))).whenComplete((results, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                    return;
                }
                if (results != null && !results.isEmpty()) {
                    ArrayList<CompletableFuture<Void>> splitFutures = new ArrayList<CompletableFuture<Void>>();
                    for (Result r : results) {
                        RegionLocations rl;
                        if (r.isEmpty() || MetaTableAccessor.getRegionInfo(r) == null || (rl = MetaTableAccessor.getRegionLocations(r)) == null) continue;
                        for (HRegionLocation h : rl.getRegionLocations()) {
                            RegionInfo hri;
                            if (h == null || h.getServerName() == null || (hri = h.getRegion()) == null || hri.isSplitParent() || hri.getReplicaId() != 0) continue;
                            splitFutures.add(this.split(hri, Optional.empty()));
                        }
                    }
                    CompletableFuture.allOf(splitFutures.toArray(new CompletableFuture[splitFutures.size()])).whenComplete((ret, exception) -> {
                        if (exception != null) {
                            future.completeExceptionally((Throwable)exception);
                            return;
                        }
                        future.complete((Void)ret);
                    });
                } else {
                    future.complete(null);
                }
            });
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> split(TableName tableName, byte[] splitPoint) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        if (splitPoint == null) {
            return this.failedFuture(new IllegalArgumentException("splitPoint can not be null."));
        }
        this.connection.getRegionLocator(tableName).getRegionLocation(splitPoint).whenComplete((loc, err) -> {
            if (err != null) {
                result.completeExceptionally((Throwable)err);
            } else if (loc == null || loc.getRegionInfo() == null) {
                result.completeExceptionally(new IllegalArgumentException("Region does not found: rowKey=" + Bytes.toStringBinary((byte[])splitPoint)));
            } else {
                this.splitRegion(loc.getRegionInfo().getRegionName(), Optional.of(splitPoint)).whenComplete((ret, err2) -> {
                    if (err2 != null) {
                        result.completeExceptionally((Throwable)err2);
                    } else {
                        result.complete((Void)ret);
                    }
                });
            }
        });
        return result;
    }

    @Override
    public CompletableFuture<Void> splitRegion(byte[] regionName, Optional<byte[]> splitPoint) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getRegionLocation(regionName).whenComplete((location, err) -> {
            HRegionInfo regionInfo = location.getRegionInfo();
            if (regionInfo.getReplicaId() != 0) {
                future.completeExceptionally(new IllegalArgumentException("Can't split replicas directly. Replicas are auto-split when their primary is split."));
                return;
            }
            ServerName serverName = location.getServerName();
            if (serverName == null) {
                future.completeExceptionally((Throwable)((Object)new NoServerForRegionException(Bytes.toStringBinary((byte[])regionName))));
                return;
            }
            this.split(regionInfo, splitPoint).whenComplete((ret, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                } else {
                    future.complete((Void)ret);
                }
            });
        });
        return future;
    }

    private CompletableFuture<Void> split(RegionInfo hri, Optional<byte[]> splitPoint) {
        if (hri.getStartKey() != null && splitPoint.isPresent() && Bytes.compareTo((byte[])hri.getStartKey(), (byte[])splitPoint.get()) == 0) {
            return this.failedFuture(new IllegalArgumentException("should not give a splitkey which equals to startkey!"));
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        TableName tableName = hri.getTable();
        MasterProtos.SplitTableRegionRequest request = null;
        try {
            request = RequestConverter.buildSplitTableRegionRequest(hri, splitPoint.isPresent() ? splitPoint.get() : null, this.ng.getNonceGroup(), this.ng.newNonce());
        }
        catch (DeserializationException e) {
            future.completeExceptionally(e);
            return future;
        }
        this.procedureCall(request, (s, c, req, done) -> s.splitRegion((RpcController)c, req, done), resp -> resp.getProcId(), new SplitTableRegionProcedureBiConsumer(this, tableName)).whenComplete((ret, err2) -> {
            if (err2 != null) {
                future.completeExceptionally((Throwable)err2);
            } else {
                future.complete((Void)ret);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> assign(byte[] regionName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getRegionInfo(regionName).whenComplete((regionInfo, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildAssignRegionRequest(regionInfo.getRegionName()), (s, c, req, done) -> s.assignRegion((RpcController)c, req, done), resp -> null)).call().whenComplete((ret, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                } else {
                    future.complete((Void)ret);
                }
            });
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> unassign(byte[] regionName, boolean forcible) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getRegionInfo(regionName).whenComplete((regionInfo, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildUnassignRegionRequest(regionInfo.getRegionName(), forcible), (s, c, req, done) -> s.unassignRegion((RpcController)c, req, done), resp -> null)).call().whenComplete((ret, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                } else {
                    future.complete((Void)ret);
                }
            });
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> offline(byte[] regionName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getRegionInfo(regionName).whenComplete((regionInfo, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildOfflineRegionRequest(regionInfo.getRegionName()), (s, c, req, done) -> s.offlineRegion((RpcController)c, req, done), resp -> null)).call().whenComplete((ret, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                } else {
                    future.complete((Void)ret);
                }
            });
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> move(byte[] regionName, Optional<ServerName> destServerName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getRegionInfo(regionName).whenComplete((regionInfo, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildMoveRegionRequest(regionInfo.getEncodedNameAsBytes(), destServerName), (s, c, req, done) -> s.moveRegion((RpcController)c, req, done), resp -> null)).call().whenComplete((ret, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                } else {
                    future.complete((Void)ret);
                }
            });
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> setQuota(QuotaSettings quota) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, QuotaSettings.buildSetQuotaRequestProto(quota), (s, c, req, done) -> s.setQuota((RpcController)c, req, done), resp -> null)).call();
    }

    @Override
    public CompletableFuture<List<QuotaSettings>> getQuota(QuotaFilter filter) {
        final CompletableFuture<List<QuotaSettings>> future = new CompletableFuture<List<QuotaSettings>>();
        Scan scan = QuotaTableUtil.makeScan(filter);
        this.connection.getRawTableBuilder(QuotaTableUtil.QUOTA_TABLE_NAME).build().scan(scan, new RawScanResultConsumer(){
            List<QuotaSettings> settings = new ArrayList<QuotaSettings>();

            @Override
            public void onNext(Result[] results, RawScanResultConsumer.ScanController controller) {
                for (Result result : results) {
                    try {
                        QuotaTableUtil.parseResultToCollection(result, this.settings);
                    }
                    catch (IOException e) {
                        controller.terminate();
                        future.completeExceptionally(e);
                    }
                }
            }

            @Override
            public void onError(Throwable error) {
                future.completeExceptionally(error);
            }

            @Override
            public void onComplete() {
                future.complete(this.settings);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> addReplicationPeer(String peerId, ReplicationPeerConfig peerConfig) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildAddReplicationPeerRequest(peerId, peerConfig), (s, c, req, done) -> s.addReplicationPeer((RpcController)c, req, done), resp -> null)).call();
    }

    @Override
    public CompletableFuture<Void> removeReplicationPeer(String peerId) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildRemoveReplicationPeerRequest(peerId), (s, c, req, done) -> s.removeReplicationPeer((RpcController)c, req, done), resp -> null)).call();
    }

    @Override
    public CompletableFuture<Void> enableReplicationPeer(String peerId) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildEnableReplicationPeerRequest(peerId), (s, c, req, done) -> s.enableReplicationPeer((RpcController)c, req, done), resp -> null)).call();
    }

    @Override
    public CompletableFuture<Void> disableReplicationPeer(String peerId) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildDisableReplicationPeerRequest(peerId), (s, c, req, done) -> s.disableReplicationPeer((RpcController)c, req, done), resp -> null)).call();
    }

    @Override
    public CompletableFuture<ReplicationPeerConfig> getReplicationPeerConfig(String peerId) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildGetReplicationPeerConfigRequest(peerId), (s, c, req, done) -> s.getReplicationPeerConfig((RpcController)c, req, done), resp -> ReplicationSerDeHelper.convert(resp.getPeerConfig()))).call();
    }

    @Override
    public CompletableFuture<Void> updateReplicationPeerConfig(String peerId, ReplicationPeerConfig peerConfig) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildUpdateReplicationPeerConfigRequest(peerId, peerConfig), (s, c, req, done) -> s.updateReplicationPeerConfig((RpcController)c, req, done), resp -> null)).call();
    }

    @Override
    public CompletableFuture<Void> appendReplicationPeerTableCFs(String id, Map<TableName, ? extends Collection<String>> tableCfs) {
        if (tableCfs == null) {
            return this.failedFuture((Throwable)((Object)new ReplicationException("tableCfs is null")));
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getReplicationPeerConfig(id).whenComplete((peerConfig, error) -> {
            if (!this.completeExceptionally(future, (Throwable)error)) {
                ReplicationSerDeHelper.appendTableCFsToReplicationPeerConfig(tableCfs, peerConfig);
                this.updateReplicationPeerConfig(id, (ReplicationPeerConfig)peerConfig).whenComplete((result, err) -> {
                    if (!this.completeExceptionally(future, (Throwable)error)) {
                        future.complete((Void)result);
                    }
                });
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> removeReplicationPeerTableCFs(String id, Map<TableName, ? extends Collection<String>> tableCfs) {
        if (tableCfs == null) {
            return this.failedFuture((Throwable)((Object)new ReplicationException("tableCfs is null")));
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getReplicationPeerConfig(id).whenComplete((peerConfig, error) -> {
            if (!this.completeExceptionally(future, (Throwable)error)) {
                try {
                    ReplicationSerDeHelper.removeTableCFsFromReplicationPeerConfig(tableCfs, peerConfig, id);
                }
                catch (ReplicationException e) {
                    future.completeExceptionally((Throwable)((Object)e));
                    return;
                }
                this.updateReplicationPeerConfig(id, (ReplicationPeerConfig)peerConfig).whenComplete((result, err) -> {
                    if (!this.completeExceptionally(future, (Throwable)error)) {
                        future.complete((Void)result);
                    }
                });
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<List<ReplicationPeerDescription>> listReplicationPeers(Optional<Pattern> pattern) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildListReplicationPeersRequest(pattern), (s, c, req, done) -> s.listReplicationPeers((RpcController)c, req, done), resp -> resp.getPeerDescList().stream().map(ReplicationSerDeHelper::toReplicationPeerDescription).collect(Collectors.toList()))).call();
    }

    @Override
    public CompletableFuture<List<TableCFs>> listReplicatedTableCFs() {
        CompletableFuture<List<TableCFs>> future = new CompletableFuture<List<TableCFs>>();
        this.listTables().whenComplete((tables, error) -> {
            if (!this.completeExceptionally(future, (Throwable)error)) {
                ArrayList replicatedTableCFs = new ArrayList();
                tables.forEach(table -> {
                    HashMap<String, Integer> cfs = new HashMap<String, Integer>();
                    Stream.of(table.getColumnFamilies()).filter(column -> column.getScope() != 0).forEach(column -> cfs.put(column.getNameAsString(), column.getScope()));
                    if (!cfs.isEmpty()) {
                        replicatedTableCFs.add(new TableCFs(table.getTableName(), cfs));
                    }
                });
                future.complete(replicatedTableCFs);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> snapshot(SnapshotDescription snapshotDesc) {
        SnapshotProtos.SnapshotDescription snapshot = ProtobufUtil.createHBaseProtosSnapshotDesc(snapshotDesc);
        try {
            ClientSnapshotDescriptionUtils.assertSnapshotRequestIsValid(snapshot);
        }
        catch (IllegalArgumentException e) {
            return this.failedFuture(e);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        MasterProtos.SnapshotRequest request = MasterProtos.SnapshotRequest.newBuilder().setSnapshot(snapshot).build();
        this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, request, (s, c, req, done) -> s.snapshot((RpcController)c, req, done), resp -> resp.getExpectedTimeout())).call().whenComplete((expectedTimeout, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            TimerTask pollingTask = new TimerTask((Long)expectedTimeout, snapshotDesc, future, snapshot){
                int tries = 0;
                long startTime = EnvironmentEdgeManager.currentTime();
                long endTime = this.startTime + this.val$expectedTimeout;
                long maxPauseTime = this.val$expectedTimeout / (long)RawAsyncHBaseAdmin.access$200(RawAsyncHBaseAdmin.this);
                final /* synthetic */ Long val$expectedTimeout;
                final /* synthetic */ SnapshotDescription val$snapshotDesc;
                final /* synthetic */ CompletableFuture val$future;
                final /* synthetic */ SnapshotProtos.SnapshotDescription val$snapshot;
                {
                    this.val$expectedTimeout = l;
                    this.val$snapshotDesc = snapshotDescription;
                    this.val$future = completableFuture;
                    this.val$snapshot = snapshotDescription2;
                }

                public void run(Timeout timeout) throws Exception {
                    if (EnvironmentEdgeManager.currentTime() < this.endTime) {
                        RawAsyncHBaseAdmin.this.isSnapshotFinished(this.val$snapshotDesc).whenComplete((done, err2) -> {
                            if (err2 != null) {
                                this.val$future.completeExceptionally((Throwable)err2);
                            } else if (done.booleanValue()) {
                                this.val$future.complete(null);
                            } else {
                                long pauseTime = ConnectionUtils.getPauseTime(TimeUnit.NANOSECONDS.toMillis(RawAsyncHBaseAdmin.this.pauseNs), ++this.tries);
                                pauseTime = Math.min(pauseTime, this.maxPauseTime);
                                AsyncConnectionImpl.RETRY_TIMER.newTimeout((TimerTask)this, pauseTime, TimeUnit.MILLISECONDS);
                            }
                        });
                    } else {
                        this.val$future.completeExceptionally((Throwable)((Object)new SnapshotCreationException("Snapshot '" + this.val$snapshot.getName() + "' wasn't completed in expectedTime:" + this.val$expectedTimeout + " ms", this.val$snapshotDesc)));
                    }
                }
            };
            AsyncConnectionImpl.RETRY_TIMER.newTimeout(pollingTask, 1L, TimeUnit.MILLISECONDS);
        });
        return future;
    }

    @Override
    public CompletableFuture<Boolean> isSnapshotFinished(SnapshotDescription snapshot) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.IsSnapshotDoneRequest.newBuilder().setSnapshot(ProtobufUtil.createHBaseProtosSnapshotDesc(snapshot)).build(), (s, c, req, done) -> s.isSnapshotDone((RpcController)c, req, done), resp -> resp.getDone())).call();
    }

    @Override
    public CompletableFuture<Void> restoreSnapshot(String snapshotName) {
        boolean takeFailSafeSnapshot = this.connection.getConfiguration().getBoolean("hbase.snapshot.restore.take.failsafe.snapshot", true);
        return this.restoreSnapshot(snapshotName, takeFailSafeSnapshot);
    }

    @Override
    public CompletableFuture<Void> restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.listSnapshots(Optional.of(Pattern.compile(snapshotName))).whenComplete((snapshotDescriptions, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            TableName tableName = null;
            if (snapshotDescriptions != null && !snapshotDescriptions.isEmpty()) {
                for (SnapshotDescription snap : snapshotDescriptions) {
                    if (!snap.getName().equals(snapshotName)) continue;
                    tableName = snap.getTableName();
                    break;
                }
            }
            if (tableName == null) {
                future.completeExceptionally((Throwable)((Object)new RestoreSnapshotException("Unable to find the table name for snapshot=" + snapshotName)));
                return;
            }
            TableName finalTableName = tableName;
            this.tableExists(finalTableName).whenComplete((exists, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                } else if (!exists.booleanValue()) {
                    this.completeConditionalOnFuture(future, this.internalRestoreSnapshot(snapshotName, finalTableName));
                } else {
                    this.isTableDisabled(finalTableName).whenComplete((disabled, err4) -> {
                        if (err4 != null) {
                            future.completeExceptionally((Throwable)err4);
                        } else if (!disabled.booleanValue()) {
                            future.completeExceptionally((Throwable)((Object)new TableNotDisabledException(finalTableName)));
                        } else {
                            this.completeConditionalOnFuture(future, this.restoreSnapshot(snapshotName, finalTableName, takeFailSafeSnapshot));
                        }
                    });
                }
            });
        });
        return future;
    }

    private CompletableFuture<Void> restoreSnapshot(String snapshotName, TableName tableName, boolean takeFailSafeSnapshot) {
        if (takeFailSafeSnapshot) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            String failSafeSnapshotSnapshotNameFormat = this.connection.getConfiguration().get("hbase.snapshot.restore.failsafe.name", "hbase-failsafe-{snapshot.name}-{restore.timestamp}");
            String failSafeSnapshotSnapshotName = failSafeSnapshotSnapshotNameFormat.replace("{snapshot.name}", snapshotName).replace("{table.name}", tableName.toString().replace(':', '.')).replace("{restore.timestamp}", String.valueOf(EnvironmentEdgeManager.currentTime()));
            LOG.info((Object)("Taking restore-failsafe snapshot: " + failSafeSnapshotSnapshotName));
            this.snapshot(failSafeSnapshotSnapshotName, tableName).whenComplete((ret, err) -> {
                if (err != null) {
                    future.completeExceptionally((Throwable)err);
                } else {
                    this.internalRestoreSnapshot(snapshotName, tableName).whenComplete((void2, err2) -> {
                        if (err2 != null) {
                            this.internalRestoreSnapshot(failSafeSnapshotSnapshotName, tableName).whenComplete((void3, err3) -> {
                                if (err3 != null) {
                                    future.completeExceptionally((Throwable)err3);
                                } else {
                                    String msg = "Restore snapshot=" + snapshotName + " failed. Rollback to snapshot=" + failSafeSnapshotSnapshotName + " succeeded.";
                                    future.completeExceptionally((Throwable)((Object)new RestoreSnapshotException(msg)));
                                }
                            });
                        } else {
                            LOG.info((Object)("Deleting restore-failsafe snapshot: " + failSafeSnapshotSnapshotName));
                            this.deleteSnapshot(failSafeSnapshotSnapshotName).whenComplete((ret3, err3) -> {
                                if (err3 != null) {
                                    LOG.error((Object)("Unable to remove the failsafe snapshot: " + failSafeSnapshotSnapshotName), err3);
                                    future.completeExceptionally((Throwable)err3);
                                } else {
                                    future.complete((Void)ret3);
                                }
                            });
                        }
                    });
                }
            });
            return future;
        }
        return this.internalRestoreSnapshot(snapshotName, tableName);
    }

    private <T> void completeConditionalOnFuture(CompletableFuture<T> dependentFuture, CompletableFuture<T> parentFuture) {
        parentFuture.whenComplete((res, err) -> {
            if (err != null) {
                dependentFuture.completeExceptionally((Throwable)err);
            } else {
                dependentFuture.complete(res);
            }
        });
    }

    @Override
    public CompletableFuture<Void> cloneSnapshot(String snapshotName, TableName tableName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.tableExists(tableName).whenComplete((exists, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
            } else if (exists.booleanValue()) {
                future.completeExceptionally((Throwable)((Object)new TableExistsException(tableName)));
            } else {
                this.completeConditionalOnFuture(future, this.internalRestoreSnapshot(snapshotName, tableName));
            }
        });
        return future;
    }

    private CompletableFuture<Void> internalRestoreSnapshot(String snapshotName, TableName tableName) {
        SnapshotProtos.SnapshotDescription snapshot = SnapshotProtos.SnapshotDescription.newBuilder().setName(snapshotName).setTable(tableName.getNameAsString()).build();
        try {
            ClientSnapshotDescriptionUtils.assertSnapshotRequestIsValid(snapshot);
        }
        catch (IllegalArgumentException e) {
            return this.failedFuture(e);
        }
        return this.waitProcedureResult(this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.RestoreSnapshotRequest.newBuilder().setSnapshot(snapshot).setNonceGroup(this.ng.getNonceGroup()).setNonce(this.ng.newNonce()).build(), (s, c, req, done) -> s.restoreSnapshot((RpcController)c, req, done), resp -> resp.getProcId())).call());
    }

    @Override
    public CompletableFuture<List<SnapshotDescription>> listSnapshots(Optional<Pattern> pattern) {
        CompletableFuture<List<SnapshotDescription>> future = new CompletableFuture<List<SnapshotDescription>>();
        this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.GetCompletedSnapshotsRequest.newBuilder().build(), (s, c, req, done) -> s.getCompletedSnapshots((RpcController)c, req, done), resp -> resp)).call().whenComplete((resp, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            future.complete(resp.getSnapshotsList().stream().map(ProtobufUtil::createSnapshotDesc).filter(snap -> pattern.isPresent() ? ((Pattern)pattern.get()).matcher(snap.getName()).matches() : true).collect(Collectors.toList()));
        });
        return future;
    }

    @Override
    public CompletableFuture<List<SnapshotDescription>> listTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) {
        CompletableFuture<List<SnapshotDescription>> future = new CompletableFuture<List<SnapshotDescription>>();
        this.listTableNames(Optional.ofNullable(tableNamePattern), false).whenComplete((tableNames, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            if (tableNames == null || tableNames.size() <= 0) {
                future.complete(Collections.emptyList());
                return;
            }
            this.listSnapshots(Optional.ofNullable(snapshotNamePattern)).whenComplete((snapshotDescList, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                    return;
                }
                if (snapshotDescList == null || snapshotDescList.isEmpty()) {
                    future.complete(Collections.emptyList());
                    return;
                }
                future.complete(snapshotDescList.stream().filter(snap -> snap != null && tableNames.contains(snap.getTableName())).collect(Collectors.toList()));
            });
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> deleteSnapshot(String snapshotName) {
        return this.internalDeleteSnapshot(new SnapshotDescription(snapshotName));
    }

    @Override
    public CompletableFuture<Void> deleteSnapshots(Pattern snapshotNamePattern) {
        return this.deleteTableSnapshots(null, snapshotNamePattern);
    }

    @Override
    public CompletableFuture<Void> deleteTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.listTableSnapshots(tableNamePattern, snapshotNamePattern).whenComplete((snapshotDescriptions, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            if (snapshotDescriptions == null || snapshotDescriptions.isEmpty()) {
                future.complete(null);
                return;
            }
            ArrayList deleteSnapshotFutures = new ArrayList();
            snapshotDescriptions.forEach(snapDesc -> deleteSnapshotFutures.add(this.internalDeleteSnapshot((SnapshotDescription)snapDesc)));
            CompletableFuture.allOf(deleteSnapshotFutures.toArray(new CompletableFuture[deleteSnapshotFutures.size()])).thenAccept(v -> future.complete((Void)v));
        });
        return future;
    }

    private CompletableFuture<Void> internalDeleteSnapshot(SnapshotDescription snapshot) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.DeleteSnapshotRequest.newBuilder().setSnapshot(ProtobufUtil.createHBaseProtosSnapshotDesc(snapshot)).build(), (s, c, req, done) -> s.deleteSnapshot((RpcController)c, req, done), resp -> null)).call();
    }

    @Override
    public CompletableFuture<Void> execProcedure(String signature, String instance, Map<String, String> props) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        HBaseProtos.ProcedureDescription procDesc = ProtobufUtil.buildProcedureDescription(signature, instance, props);
        this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.ExecProcedureRequest.newBuilder().setProcedure(procDesc).build(), (s, c, req, done) -> s.execProcedure((RpcController)c, req, done), resp -> resp.getExpectedTimeout())).call().whenComplete((expectedTimeout, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            TimerTask pollingTask = new TimerTask((Long)expectedTimeout, signature, instance, props, future){
                int tries = 0;
                long startTime = EnvironmentEdgeManager.currentTime();
                long endTime = this.startTime + this.val$expectedTimeout;
                long maxPauseTime = this.val$expectedTimeout / (long)RawAsyncHBaseAdmin.access$200(RawAsyncHBaseAdmin.this);
                final /* synthetic */ Long val$expectedTimeout;
                final /* synthetic */ String val$signature;
                final /* synthetic */ String val$instance;
                final /* synthetic */ Map val$props;
                final /* synthetic */ CompletableFuture val$future;
                {
                    this.val$expectedTimeout = l;
                    this.val$signature = string;
                    this.val$instance = string2;
                    this.val$props = map;
                    this.val$future = completableFuture;
                }

                public void run(Timeout timeout) throws Exception {
                    if (EnvironmentEdgeManager.currentTime() < this.endTime) {
                        RawAsyncHBaseAdmin.this.isProcedureFinished(this.val$signature, this.val$instance, this.val$props).whenComplete((done, err2) -> {
                            if (err2 != null) {
                                this.val$future.completeExceptionally((Throwable)err2);
                                return;
                            }
                            if (done.booleanValue()) {
                                this.val$future.complete(null);
                            } else {
                                long pauseTime = ConnectionUtils.getPauseTime(TimeUnit.NANOSECONDS.toMillis(RawAsyncHBaseAdmin.this.pauseNs), ++this.tries);
                                pauseTime = Math.min(pauseTime, this.maxPauseTime);
                                AsyncConnectionImpl.RETRY_TIMER.newTimeout((TimerTask)this, pauseTime, TimeUnit.MICROSECONDS);
                            }
                        });
                    } else {
                        this.val$future.completeExceptionally(new IOException("Procedure '" + this.val$signature + " : " + this.val$instance + "' wasn't completed in expectedTime:" + this.val$expectedTimeout + " ms"));
                    }
                }
            };
            AsyncConnectionImpl.RETRY_TIMER.newTimeout(pollingTask, 1L, TimeUnit.MILLISECONDS);
        });
        return future;
    }

    @Override
    public CompletableFuture<byte[]> execProcedureWithRet(String signature, String instance, Map<String, String> props) {
        HBaseProtos.ProcedureDescription proDesc = ProtobufUtil.buildProcedureDescription(signature, instance, props);
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.ExecProcedureRequest.newBuilder().setProcedure(proDesc).build(), (s, c, req, done) -> s.execProcedureWithRet((RpcController)c, req, done), resp -> resp.hasReturnData() ? resp.getReturnData().toByteArray() : null)).call();
    }

    @Override
    public CompletableFuture<Boolean> isProcedureFinished(String signature, String instance, Map<String, String> props) {
        HBaseProtos.ProcedureDescription proDesc = ProtobufUtil.buildProcedureDescription(signature, instance, props);
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.IsProcedureDoneRequest.newBuilder().setProcedure(proDesc).build(), (s, c, req, done) -> s.isProcedureDone((RpcController)c, req, done), resp -> resp.getDone())).call();
    }

    @Override
    public CompletableFuture<Boolean> abortProcedure(long procId, boolean mayInterruptIfRunning) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.AbortProcedureRequest.newBuilder().setProcId(procId).build(), (s, c, req, done) -> s.abortProcedure((RpcController)c, req, done), resp -> resp.getIsProcedureAborted())).call();
    }

    @Override
    public CompletableFuture<String> getProcedures() {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.GetProceduresRequest.newBuilder().build(), (s, c, req, done) -> s.getProcedures((RpcController)c, req, done), resp -> ProtobufUtil.toProcedureJson(resp.getProcedureList()))).call();
    }

    @Override
    public CompletableFuture<String> getLocks() {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.GetLocksRequest.newBuilder().build(), (s, c, req, done) -> s.getLocks((RpcController)c, req, done), resp -> ProtobufUtil.toLockJson(resp.getLockList()))).call();
    }

    @Override
    public CompletableFuture<Void> decommissionRegionServers(List<ServerName> servers, boolean offload) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildDecommissionRegionServersRequest(servers, offload), (s, c, req, done) -> s.decommissionRegionServers((RpcController)c, req, done), resp -> null)).call();
    }

    @Override
    public CompletableFuture<List<ServerName>> listDecommissionedRegionServers() {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.ListDecommissionedRegionServersRequest.newBuilder().build(), (s, c, req, done) -> s.listDecommissionedRegionServers((RpcController)c, req, done), resp -> resp.getServerNameList().stream().map(ProtobufUtil::toServerName).collect(Collectors.toList()))).call();
    }

    @Override
    public CompletableFuture<Void> recommissionRegionServer(ServerName server, List<byte[]> encodedRegionNames) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildRecommissionRegionServerRequest(server, encodedRegionNames), (s, c, req, done) -> s.recommissionRegionServer((RpcController)c, req, done), resp -> null)).call();
    }

    @VisibleForTesting
    CompletableFuture<HRegionLocation> getRegionLocation(byte[] regionNameOrEncodedRegionName) {
        if (regionNameOrEncodedRegionName == null) {
            return this.failedFuture(new IllegalArgumentException("Passed region name can't be null"));
        }
        try {
            CompletableFuture<Optional<HRegionLocation>> future = RegionInfo.isEncodedRegionName(regionNameOrEncodedRegionName) ? AsyncMetaTableAccessor.getRegionLocationWithEncodedName(this.metaTable, regionNameOrEncodedRegionName) : AsyncMetaTableAccessor.getRegionLocation(this.metaTable, regionNameOrEncodedRegionName);
            CompletableFuture<HRegionLocation> returnedFuture = new CompletableFuture<HRegionLocation>();
            future.whenComplete((location, err) -> {
                if (err != null) {
                    returnedFuture.completeExceptionally((Throwable)err);
                    return;
                }
                LOG.info((Object)("location is " + location));
                if (!location.isPresent() || ((HRegionLocation)location.get()).getRegionInfo() == null) {
                    LOG.info((Object)("unknown location is " + location));
                    returnedFuture.completeExceptionally((Throwable)((Object)new UnknownRegionException("Invalid region name or encoded region name: " + Bytes.toStringBinary((byte[])regionNameOrEncodedRegionName))));
                } else {
                    returnedFuture.complete((HRegionLocation)location.get());
                }
            });
            return returnedFuture;
        }
        catch (IOException e) {
            return this.failedFuture(e);
        }
    }

    private CompletableFuture<RegionInfo> getRegionInfo(byte[] regionNameOrEncodedRegionName) {
        if (regionNameOrEncodedRegionName == null) {
            return this.failedFuture(new IllegalArgumentException("Passed region name can't be null"));
        }
        if (Bytes.equals((byte[])regionNameOrEncodedRegionName, (byte[])RegionInfoBuilder.FIRST_META_REGIONINFO.getRegionName()) || Bytes.equals((byte[])regionNameOrEncodedRegionName, (byte[])RegionInfoBuilder.FIRST_META_REGIONINFO.getEncodedNameAsBytes())) {
            return CompletableFuture.completedFuture(RegionInfoBuilder.FIRST_META_REGIONINFO);
        }
        CompletableFuture<RegionInfo> future = new CompletableFuture<RegionInfo>();
        this.getRegionLocation(regionNameOrEncodedRegionName).whenComplete((location, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
            } else {
                future.complete(location.getRegionInfo());
            }
        });
        return future;
    }

    private byte[][] getSplitKeys(byte[] startKey, byte[] endKey, int numRegions) {
        if (numRegions < 3) {
            throw new IllegalArgumentException("Must create at least three regions");
        }
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) >= 0) {
            throw new IllegalArgumentException("Start key must be smaller than end key");
        }
        if (numRegions == 3) {
            return new byte[][]{startKey, endKey};
        }
        byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
        if (splitKeys == null || splitKeys.length != numRegions - 1) {
            throw new IllegalArgumentException("Unable to split key range into enough regions");
        }
        return splitKeys;
    }

    private void verifySplitKeys(byte[][] splitKeys) {
        Arrays.sort(splitKeys, Bytes.BYTES_COMPARATOR);
        byte[] lastKey = null;
        for (byte[] splitKey : splitKeys) {
            if (Bytes.compareTo((byte[])splitKey, (byte[])HConstants.EMPTY_BYTE_ARRAY) == 0) {
                throw new IllegalArgumentException("Empty split key must not be passed in the split keys.");
            }
            if (lastKey != null && Bytes.equals((byte[])splitKey, (byte[])lastKey)) {
                throw new IllegalArgumentException("All split keys must be unique, found duplicate: " + Bytes.toStringBinary((byte[])splitKey) + ", " + Bytes.toStringBinary((byte[])lastKey));
            }
            lastKey = splitKey;
        }
    }

    private CompletableFuture<Void> waitProcedureResult(CompletableFuture<Long> procFuture) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        procFuture.whenComplete((procId, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            this.getProcedureResult((long)procId, future);
        });
        return future;
    }

    private void getProcedureResult(long procId, CompletableFuture<Void> future) {
        this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.GetProcedureResultRequest.newBuilder().setProcId(procId).build(), (s, c, req, done) -> s.getProcedureResult((RpcController)c, req, done), resp -> resp)).call().whenComplete((response, error) -> {
            if (error != null) {
                LOG.warn((Object)("failed to get the procedure result procId=" + procId), ConnectionUtils.translateException(error));
                AsyncConnectionImpl.RETRY_TIMER.newTimeout(t -> this.getProcedureResult(procId, future), this.pauseNs, TimeUnit.NANOSECONDS);
                return;
            }
            if (response.getState() == MasterProtos.GetProcedureResultResponse.State.RUNNING) {
                AsyncConnectionImpl.RETRY_TIMER.newTimeout(t -> this.getProcedureResult(procId, future), this.pauseNs, TimeUnit.NANOSECONDS);
                return;
            }
            if (response.hasException()) {
                IOException ioe = ForeignExceptionUtil.toIOException((ErrorHandlingProtos.ForeignExceptionMessage)response.getException());
                future.completeExceptionally(ioe);
            } else {
                future.complete(null);
            }
        });
    }

    private <T> CompletableFuture<T> failedFuture(Throwable error) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(error);
        return future;
    }

    private <T> boolean completeExceptionally(CompletableFuture<T> future, Throwable error) {
        if (error != null) {
            future.completeExceptionally(error);
            return true;
        }
        return false;
    }

    @Override
    public CompletableFuture<ClusterStatus> getClusterStatus() {
        return this.getClusterStatus(EnumSet.allOf(ClusterStatus.Option.class));
    }

    @Override
    public CompletableFuture<ClusterStatus> getClusterStatus(EnumSet<ClusterStatus.Option> options) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildGetClusterStatusRequest(options), (s, c, req, done) -> s.getClusterStatus((RpcController)c, req, done), resp -> ProtobufUtil.convert(resp.getClusterStatus()))).call();
    }

    @Override
    public CompletableFuture<Void> shutdown() {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.ShutdownRequest.newBuilder().build(), (s, c, req, done) -> s.shutdown((RpcController)c, req, done), resp -> null)).call();
    }

    @Override
    public CompletableFuture<Void> stopMaster() {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.StopMasterRequest.newBuilder().build(), (s, c, req, done) -> s.stopMaster((RpcController)c, req, done), resp -> null)).call();
    }

    @Override
    public CompletableFuture<Void> stopRegionServer(ServerName serverName) {
        AdminProtos.StopServerRequest request = RequestConverter.buildStopServerRequest("Called by admin client " + this.connection.toString());
        return this.newAdminCaller().action((controller, stub) -> this.adminCall(controller, stub, request, (s, c, req, done) -> s.stopServer((RpcController)controller, req, done), resp -> null)).serverName(serverName).call();
    }

    @Override
    public CompletableFuture<Void> updateConfiguration(ServerName serverName) {
        return this.newAdminCaller().action((controller, stub) -> this.adminCall(controller, stub, AdminProtos.UpdateConfigurationRequest.getDefaultInstance(), (s, c, req, done) -> s.updateConfiguration((RpcController)controller, req, done), resp -> null)).serverName(serverName).call();
    }

    @Override
    public CompletableFuture<Void> updateConfiguration() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getClusterStatus(EnumSet.of(ClusterStatus.Option.LIVE_SERVERS, ClusterStatus.Option.MASTER, ClusterStatus.Option.BACKUP_MASTERS)).whenComplete((status, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
            } else {
                ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
                status.getServers().forEach(server -> futures.add(this.updateConfiguration((ServerName)server)));
                futures.add(this.updateConfiguration(status.getMaster()));
                status.getBackupMasters().forEach(master -> futures.add(this.updateConfiguration((ServerName)master)));
                CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).whenComplete((result, err2) -> {
                    if (err2 != null) {
                        future.completeExceptionally((Throwable)err2);
                    } else {
                        future.complete((Void)result);
                    }
                });
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> rollWALWriter(ServerName serverName) {
        return this.newAdminCaller().action((controller, stub) -> this.adminCall(controller, stub, RequestConverter.buildRollWALWriterRequest(), (s, c, req, done) -> s.rollWALWriter((RpcController)controller, req, done), resp -> null)).serverName(serverName).call();
    }

    @Override
    public CompletableFuture<Void> clearCompactionQueues(ServerName serverName, Set<String> queues) {
        return this.newAdminCaller().action((controller, stub) -> this.adminCall(controller, stub, RequestConverter.buildClearCompactionQueuesRequest(queues), (s, c, req, done) -> s.clearCompactionQueues((RpcController)controller, req, done), resp -> null)).serverName(serverName).call();
    }

    @Override
    public CompletableFuture<List<SecurityCapability>> getSecurityCapabilities() {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.SecurityCapabilitiesRequest.newBuilder().build(), (s, c, req, done) -> s.getSecurityCapabilities((RpcController)c, req, done), resp -> ProtobufUtil.toSecurityCapabilityList(resp.getCapabilitiesList()))).call();
    }

    @Override
    public CompletableFuture<List<RegionLoad>> getRegionLoads(ServerName serverName, Optional<TableName> tableName) {
        return this.newAdminCaller().action((controller, stub) -> this.adminCall(controller, stub, RequestConverter.buildGetRegionLoadRequest(tableName), (s, c, req, done) -> s.getRegionLoad((RpcController)controller, req, done), ProtobufUtil::getRegionLoadInfo)).serverName(serverName).call();
    }

    @Override
    public CompletableFuture<Boolean> isMasterInMaintenanceMode() {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.IsInMaintenanceModeRequest.newBuilder().build(), (s, c, req, done) -> s.isMasterInMaintenanceMode((RpcController)c, req, done), resp -> resp.getInMaintenanceMode())).call();
    }

    @Override
    public CompletableFuture<CompactionState> getCompactionState(TableName tableName) {
        CompletableFuture<CompactionState> future = new CompletableFuture<CompactionState>();
        this.getTableHRegionLocations(tableName).whenComplete((locations, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            ArrayList regionStates = new ArrayList();
            ArrayList futures = new ArrayList();
            locations.stream().filter(loc -> loc.getServerName() != null).filter(loc -> loc.getRegionInfo() != null).filter(loc -> !loc.getRegionInfo().isOffline()).map(loc -> loc.getRegionInfo().getRegionName()).forEach(region -> futures.add(this.getCompactionStateForRegion((byte[])region).whenComplete((regionState, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                } else if (regionState == CompactionState.MAJOR_AND_MINOR) {
                    future.complete((CompactionState)((Object)regionState));
                } else {
                    regionStates.add(regionState);
                }
            })));
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).whenComplete((ret, err3) -> {
                if (!future.isCompletedExceptionally() && !future.isDone()) {
                    CompactionState state = CompactionState.NONE;
                    for (CompactionState regionState : regionStates) {
                        switch (regionState) {
                            case MAJOR: {
                                if (state == CompactionState.MINOR) {
                                    future.complete(CompactionState.MAJOR_AND_MINOR);
                                    break;
                                }
                                state = CompactionState.MAJOR;
                                break;
                            }
                            case MINOR: {
                                if (state == CompactionState.MAJOR) {
                                    future.complete(CompactionState.MAJOR_AND_MINOR);
                                    break;
                                }
                                state = CompactionState.MINOR;
                                break;
                            }
                        }
                        if (future.isDone()) continue;
                        future.complete(state);
                    }
                }
            });
        });
        return future;
    }

    @Override
    public CompletableFuture<CompactionState> getCompactionStateForRegion(byte[] regionName) {
        CompletableFuture<CompactionState> future = new CompletableFuture<CompactionState>();
        this.getRegionLocation(regionName).whenComplete((location, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            ServerName serverName = location.getServerName();
            if (serverName == null) {
                future.completeExceptionally((Throwable)((Object)new NoServerForRegionException(Bytes.toStringBinary((byte[])regionName))));
                return;
            }
            this.newAdminCaller().action((controller, stub) -> this.adminCall(controller, stub, RequestConverter.buildGetRegionInfoRequest(location.getRegionInfo().getRegionName(), true), (s, c, req, done) -> s.getRegionInfo((RpcController)controller, req, done), resp -> resp)).serverName(serverName).call().whenComplete((resp2, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                } else if (resp2.hasCompactionState()) {
                    future.complete(ProtobufUtil.createCompactionState(resp2.getCompactionState()));
                } else {
                    future.complete(CompactionState.NONE);
                }
            });
        });
        return future;
    }

    @Override
    public CompletableFuture<Optional<Long>> getLastMajorCompactionTimestamp(TableName tableName) {
        MasterProtos.MajorCompactionTimestampRequest request = MasterProtos.MajorCompactionTimestampRequest.newBuilder().setTableName(ProtobufUtil.toProtoTableName(tableName)).build();
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, request, (s, c, req, done) -> s.getLastMajorCompactionTimestamp((RpcController)c, req, done), ProtobufUtil::toOptionalTimestamp)).call();
    }

    @Override
    public CompletableFuture<Optional<Long>> getLastMajorCompactionTimestampForRegion(byte[] regionName) {
        CompletableFuture<Optional<Long>> future = new CompletableFuture<Optional<Long>>();
        this.getRegionInfo(regionName).whenComplete((region, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            MasterProtos.MajorCompactionTimestampForRegionRequest.Builder builder = MasterProtos.MajorCompactionTimestampForRegionRequest.newBuilder();
            builder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName));
            this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, builder.build(), (s, c, req, done) -> s.getLastMajorCompactionTimestampForRegion((RpcController)c, req, done), ProtobufUtil::toOptionalTimestamp)).call().whenComplete((timestamp, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                } else {
                    future.complete((Optional<Long>)timestamp);
                }
            });
        });
        return future;
    }

    @Override
    public CompletableFuture<Boolean> setBalancerOn(boolean on) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildSetBalancerRunningRequest(on, true), (s, c, req, done) -> s.setBalancerRunning((RpcController)c, req, done), resp -> resp.getPrevBalanceValue())).call();
    }

    @Override
    public CompletableFuture<Boolean> balance(boolean forcible) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildBalanceRequest(forcible), (s, c, req, done) -> s.balance((RpcController)c, req, done), resp -> resp.getBalancerRan())).call();
    }

    @Override
    public CompletableFuture<Boolean> isBalancerOn() {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildIsBalancerEnabledRequest(), (s, c, req, done) -> s.isBalancerEnabled((RpcController)c, req, done), resp -> resp.getEnabled())).call();
    }

    @Override
    public CompletableFuture<Boolean> setNormalizerOn(boolean on) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildSetNormalizerRunningRequest(on), (s, c, req, done) -> s.setNormalizerRunning((RpcController)c, req, done), resp -> resp.getPrevNormalizerValue())).call();
    }

    @Override
    public CompletableFuture<Boolean> isNormalizerOn() {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildIsNormalizerEnabledRequest(), (s, c, req, done) -> s.isNormalizerEnabled((RpcController)c, req, done), resp -> resp.getEnabled())).call();
    }

    @Override
    public CompletableFuture<Boolean> normalize() {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildNormalizeRequest(), (s, c, req, done) -> s.normalize((RpcController)c, req, done), resp -> resp.getNormalizerRan())).call();
    }

    @Override
    public CompletableFuture<Boolean> setCleanerChoreOn(boolean enabled) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildSetCleanerChoreRunningRequest(enabled), (s, c, req, done) -> s.setCleanerChoreRunning((RpcController)c, req, done), resp -> resp.getPrevValue())).call();
    }

    @Override
    public CompletableFuture<Boolean> isCleanerChoreOn() {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildIsCleanerChoreEnabledRequest(), (s, c, req, done) -> s.isCleanerChoreEnabled((RpcController)c, req, done), resp -> resp.getValue())).call();
    }

    @Override
    public CompletableFuture<Boolean> runCleanerChore() {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildRunCleanerChoreRequest(), (s, c, req, done) -> s.runCleanerChore((RpcController)c, req, done), resp -> resp.getCleanerChoreRan())).call();
    }

    @Override
    public CompletableFuture<Boolean> setCatalogJanitorOn(boolean enabled) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildEnableCatalogJanitorRequest(enabled), (s, c, req, done) -> s.enableCatalogJanitor((RpcController)c, req, done), resp -> resp.getPrevValue())).call();
    }

    @Override
    public CompletableFuture<Boolean> isCatalogJanitorOn() {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildIsCatalogJanitorEnabledRequest(), (s, c, req, done) -> s.isCatalogJanitorEnabled((RpcController)c, req, done), resp -> resp.getValue())).call();
    }

    @Override
    public CompletableFuture<Integer> runCatalogJanitor() {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildCatalogScanRequest(), (s, c, req, done) -> s.runCatalogScan((RpcController)c, req, done), resp -> resp.getScanResult())).call();
    }

    @Override
    public <S, R> CompletableFuture<R> coprocessorService(Function<RpcChannel, S> stubMaker, RawAsyncTable.CoprocessorCallable<S, R> callable) {
        MasterCoprocessorRpcChannelImpl channel = new MasterCoprocessorRpcChannelImpl(this.newMasterCaller());
        S stub = stubMaker.apply(channel);
        CompletableFuture future = new CompletableFuture();
        ClientCoprocessorRpcController controller = new ClientCoprocessorRpcController();
        callable.call(stub, controller, resp -> {
            if (controller.failed()) {
                future.completeExceptionally(controller.getFailed());
            } else {
                future.complete(resp);
            }
        });
        return future;
    }

    @Override
    public <S, R> CompletableFuture<R> coprocessorService(Function<RpcChannel, S> stubMaker, RawAsyncTable.CoprocessorCallable<S, R> callable, ServerName serverName) {
        RegionServerCoprocessorRpcChannelImpl channel = new RegionServerCoprocessorRpcChannelImpl(this.newServerCaller().serverName(serverName));
        S stub = stubMaker.apply(channel);
        CompletableFuture future = new CompletableFuture();
        ClientCoprocessorRpcController controller = new ClientCoprocessorRpcController();
        callable.call(stub, controller, resp -> {
            if (controller.failed()) {
                future.completeExceptionally(controller.getFailed());
            } else {
                future.complete(resp);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<List<ServerName>> listDeadServers() {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.ListDeadServersRequest.newBuilder().build(), (s, c, req, done) -> s.listDeadServers((RpcController)c, req, done), resp -> ProtobufUtil.toServerNameList(resp.getServerNameList()))).call();
    }

    @Override
    public CompletableFuture<List<ServerName>> clearDeadServers(List<ServerName> servers) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildClearDeadServersRequest(servers), (s, c, req, done) -> s.clearDeadServers((RpcController)c, req, done), resp -> ProtobufUtil.toServerNameList(resp.getServerNameList()))).call();
    }

    private <T> AsyncRpcRetryingCallerFactory.ServerRequestCallerBuilder<T> newServerCaller() {
        return this.connection.callerFactory.serverRequest().rpcTimeout(this.rpcTimeoutNs, TimeUnit.NANOSECONDS).operationTimeout(this.operationTimeoutNs, TimeUnit.NANOSECONDS).pause(this.pauseNs, TimeUnit.NANOSECONDS).maxAttempts(this.maxAttempts).startLogErrorsCnt(this.startLogErrorsCnt);
    }

    static /* synthetic */ int access$200(RawAsyncHBaseAdmin x0) {
        return x0.maxAttempts;
    }

    private class SplitTableRegionProcedureBiConsumer
    extends TableProcedureBiConsumer {
        SplitTableRegionProcedureBiConsumer(AsyncAdmin admin, TableName tableName) {
            super(admin, tableName);
        }

        @Override
        String getOperationType() {
            return "SPLIT_REGION";
        }
    }

    private class MergeTableRegionProcedureBiConsumer
    extends TableProcedureBiConsumer {
        MergeTableRegionProcedureBiConsumer(AsyncAdmin admin, TableName tableName) {
            super(admin, tableName);
        }

        @Override
        String getOperationType() {
            return "MERGE_REGIONS";
        }
    }

    private class ModifyNamespaceProcedureBiConsumer
    extends NamespaceProcedureBiConsumer {
        ModifyNamespaceProcedureBiConsumer(AsyncAdmin admin, String namespaceName) {
            super(admin, namespaceName);
        }

        @Override
        String getOperationType() {
            return "MODIFY_NAMESPACE";
        }
    }

    private class DeleteNamespaceProcedureBiConsumer
    extends NamespaceProcedureBiConsumer {
        DeleteNamespaceProcedureBiConsumer(AsyncAdmin admin, String namespaceName) {
            super(admin, namespaceName);
        }

        @Override
        String getOperationType() {
            return "DELETE_NAMESPACE";
        }
    }

    private class CreateNamespaceProcedureBiConsumer
    extends NamespaceProcedureBiConsumer {
        CreateNamespaceProcedureBiConsumer(AsyncAdmin admin, String namespaceName) {
            super(admin, namespaceName);
        }

        @Override
        String getOperationType() {
            return "CREATE_NAMESPACE";
        }
    }

    private class ModifyColumnFamilyProcedureBiConsumer
    extends TableProcedureBiConsumer {
        ModifyColumnFamilyProcedureBiConsumer(AsyncAdmin admin, TableName tableName) {
            super(admin, tableName);
        }

        @Override
        String getOperationType() {
            return "MODIFY_COLUMN_FAMILY";
        }
    }

    private class DeleteColumnFamilyProcedureBiConsumer
    extends TableProcedureBiConsumer {
        DeleteColumnFamilyProcedureBiConsumer(AsyncAdmin admin, TableName tableName) {
            super(admin, tableName);
        }

        @Override
        String getOperationType() {
            return "DELETE_COLUMN_FAMILY";
        }
    }

    private class AddColumnFamilyProcedureBiConsumer
    extends TableProcedureBiConsumer {
        AddColumnFamilyProcedureBiConsumer(AsyncAdmin admin, TableName tableName) {
            super(admin, tableName);
        }

        @Override
        String getOperationType() {
            return "ADD_COLUMN_FAMILY";
        }
    }

    private class DisableTableProcedureBiConsumer
    extends TableProcedureBiConsumer {
        DisableTableProcedureBiConsumer(AsyncAdmin admin, TableName tableName) {
            super(admin, tableName);
        }

        @Override
        String getOperationType() {
            return "DISABLE";
        }
    }

    private class EnableTableProcedureBiConsumer
    extends TableProcedureBiConsumer {
        EnableTableProcedureBiConsumer(AsyncAdmin admin, TableName tableName) {
            super(admin, tableName);
        }

        @Override
        String getOperationType() {
            return "ENABLE";
        }
    }

    private class TruncateTableProcedureBiConsumer
    extends TableProcedureBiConsumer {
        TruncateTableProcedureBiConsumer(AsyncAdmin admin, TableName tableName) {
            super(admin, tableName);
        }

        @Override
        String getOperationType() {
            return "TRUNCATE";
        }
    }

    private class DeleteTableProcedureBiConsumer
    extends TableProcedureBiConsumer {
        DeleteTableProcedureBiConsumer(AsyncAdmin admin, TableName tableName) {
            super(admin, tableName);
        }

        @Override
        String getOperationType() {
            return "DELETE";
        }

        @Override
        void onFinished() {
            RawAsyncHBaseAdmin.this.connection.getLocator().clearCache(this.tableName);
            super.onFinished();
        }
    }

    private class CreateTableProcedureBiConsumer
    extends TableProcedureBiConsumer {
        CreateTableProcedureBiConsumer(AsyncAdmin admin, TableName tableName) {
            super(admin, tableName);
        }

        @Override
        String getOperationType() {
            return "CREATE";
        }
    }

    private abstract class NamespaceProcedureBiConsumer
    extends ProcedureBiConsumer {
        protected final String namespaceName;

        NamespaceProcedureBiConsumer(AsyncAdmin admin, String namespaceName) {
            super(admin);
            this.namespaceName = namespaceName;
        }

        abstract String getOperationType();

        String getDescription() {
            return "Operation: " + this.getOperationType() + ", Namespace: " + this.namespaceName;
        }

        @Override
        void onFinished() {
            LOG.info((Object)(this.getDescription() + " completed"));
        }

        @Override
        void onError(Throwable error) {
            LOG.info((Object)(this.getDescription() + " failed with " + error.getMessage()));
        }
    }

    private abstract class TableProcedureBiConsumer
    extends ProcedureBiConsumer {
        protected final TableName tableName;

        TableProcedureBiConsumer(AsyncAdmin admin, TableName tableName) {
            super(admin);
            this.tableName = tableName;
        }

        abstract String getOperationType();

        String getDescription() {
            return "Operation: " + this.getOperationType() + ", Table Name: " + this.tableName.getNameWithNamespaceInclAsString();
        }

        @Override
        void onFinished() {
            LOG.info((Object)(this.getDescription() + " completed"));
        }

        @Override
        void onError(Throwable error) {
            LOG.info((Object)(this.getDescription() + " failed with " + error.getMessage()));
        }
    }

    private abstract class ProcedureBiConsumer
    implements BiConsumer<Void, Throwable> {
        protected final AsyncAdmin admin;

        ProcedureBiConsumer(AsyncAdmin admin) {
            this.admin = admin;
        }

        abstract void onFinished();

        abstract void onError(Throwable var1);

        @Override
        public void accept(Void v, Throwable error) {
            if (error != null) {
                this.onError(error);
                return;
            }
            this.onFinished();
        }
    }

    @FunctionalInterface
    private static interface TableOperator {
        public CompletableFuture<Void> operate(TableName var1);
    }

    @FunctionalInterface
    private static interface Converter<D, S> {
        public D convert(S var1) throws IOException;
    }

    @FunctionalInterface
    private static interface AdminRpcCall<RESP, REQ> {
        public void call(AdminProtos.AdminService.Interface var1, HBaseRpcController var2, REQ var3, RpcCallback<RESP> var4);
    }

    @FunctionalInterface
    private static interface MasterRpcCall<RESP, REQ> {
        public void call(MasterProtos.MasterService.Interface var1, HBaseRpcController var2, REQ var3, RpcCallback<RESP> var4);
    }
}

