/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaType;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class ThrottleSettings
extends QuotaSettings {
    final QuotaProtos.ThrottleRequest proto;

    ThrottleSettings(String userName, TableName tableName, String namespace, QuotaProtos.ThrottleRequest proto) {
        super(userName, tableName, namespace);
        this.proto = proto;
    }

    public ThrottleType getThrottleType() {
        return ProtobufUtil.toThrottleType(this.proto.getType());
    }

    public long getSoftLimit() {
        return this.proto.hasTimedQuota() ? this.proto.getTimedQuota().getSoftLimit() : -1L;
    }

    public TimeUnit getTimeUnit() {
        return this.proto.hasTimedQuota() ? ProtobufUtil.toTimeUnit(this.proto.getTimedQuota().getTimeUnit()) : null;
    }

    @Override
    public QuotaType getQuotaType() {
        return QuotaType.THROTTLE;
    }

    @Override
    protected void setupSetQuotaRequest(MasterProtos.SetQuotaRequest.Builder builder) {
        builder.setThrottle(this.proto);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TYPE => THROTTLE");
        if (this.proto.hasType()) {
            builder.append(", THROTTLE_TYPE => ");
            builder.append(this.proto.getType().toString());
        }
        if (this.proto.hasTimedQuota()) {
            QuotaProtos.TimedQuota timedQuota = this.proto.getTimedQuota();
            builder.append(", LIMIT => ");
            if (timedQuota.hasSoftLimit()) {
                switch (this.getThrottleType()) {
                    case REQUEST_NUMBER: 
                    case WRITE_NUMBER: 
                    case READ_NUMBER: {
                        builder.append(String.format("%dreq", timedQuota.getSoftLimit()));
                        break;
                    }
                    case REQUEST_SIZE: 
                    case WRITE_SIZE: 
                    case READ_SIZE: {
                        builder.append(ThrottleSettings.sizeToString(timedQuota.getSoftLimit()));
                    }
                }
            } else if (timedQuota.hasShare()) {
                builder.append(String.format("%.2f%%", Float.valueOf(timedQuota.getShare())));
            }
            builder.append('/');
            builder.append(ThrottleSettings.timeToString(ProtobufUtil.toTimeUnit(timedQuota.getTimeUnit())));
            if (timedQuota.hasScope()) {
                builder.append(", SCOPE => ");
                builder.append(timedQuota.getScope().toString());
            }
        } else {
            builder.append(", LIMIT => NONE");
        }
        return builder.toString();
    }

    @Override
    protected ThrottleSettings merge(QuotaSettings other) throws IOException {
        if (other instanceof ThrottleSettings) {
            ThrottleSettings otherThrottle = (ThrottleSettings)other;
            this.validateQuotaTarget(other);
            QuotaProtos.ThrottleRequest.Builder builder = this.proto.toBuilder();
            if (!otherThrottle.proto.hasType()) {
                return null;
            }
            QuotaProtos.ThrottleRequest otherProto = otherThrottle.proto;
            if (otherProto.hasTimedQuota()) {
                if (otherProto.hasTimedQuota()) {
                    this.validateTimedQuota(otherProto.getTimedQuota());
                }
                if (!this.proto.getType().equals((Object)otherProto.getType())) {
                    throw new IllegalArgumentException("Cannot merge a ThrottleRequest for " + this.proto.getType() + " with " + otherProto.getType());
                }
                QuotaProtos.TimedQuota.Builder timedQuotaBuilder = this.proto.getTimedQuota().toBuilder();
                timedQuotaBuilder.mergeFrom(otherProto.getTimedQuota());
                QuotaProtos.ThrottleRequest mergedReq = builder.setTimedQuota(timedQuotaBuilder.build()).build();
                return new ThrottleSettings(this.getUserName(), this.getTableName(), this.getNamespace(), mergedReq);
            }
        }
        return this;
    }

    private void validateTimedQuota(QuotaProtos.TimedQuota timedQuota) throws IOException {
        if (timedQuota.getSoftLimit() < 1L) {
            throw new DoNotRetryIOException(new UnsupportedOperationException("The throttle limit must be greater then 0, got " + timedQuota.getSoftLimit()));
        }
    }

    static ThrottleSettings fromTimedQuota(String userName, TableName tableName, String namespace, ThrottleType type, QuotaProtos.TimedQuota timedQuota) {
        QuotaProtos.ThrottleRequest.Builder builder = QuotaProtos.ThrottleRequest.newBuilder();
        builder.setType(ProtobufUtil.toProtoThrottleType(type));
        builder.setTimedQuota(timedQuota);
        return new ThrottleSettings(userName, tableName, namespace, builder.build());
    }
}

