/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.types.DataType;
import org.apache.hadoop.hbase.types.RawBytes;
import org.apache.hadoop.hbase.types.RawBytesTerminated;
import org.apache.hadoop.hbase.types.RawDouble;
import org.apache.hadoop.hbase.types.RawInteger;
import org.apache.hadoop.hbase.types.RawStringTerminated;
import org.apache.hadoop.hbase.types.Struct;
import org.apache.hadoop.hbase.types.StructBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MiscTests.class, SmallTests.class})
public class TestStruct {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStruct.class);
    @Parameterized.Parameter(value=0)
    public Struct generic;
    @Parameterized.Parameter(value=1)
    public DataType specialized;
    @Parameterized.Parameter(value=2)
    public Object[][] constructorArgs;
    static final Comparator<byte[]> NULL_SAFE_BYTES_COMPARATOR = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] o1, byte[] o2) {
            if (o1 == o2) {
                return 0;
            }
            if (null == o1) {
                return -1;
            }
            if (null == o2) {
                return 1;
            }
            return Bytes.compareTo((byte[])o1, (byte[])o2);
        }
    };

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        Object[][] pojo1Args = new Object[][]{{"foo", 5, 10.001}, {"foo", 100, 7.0}, {"foo", 100, 10.001}, {"bar", 5, 10.001}, {"bar", 100, 10.001}, {"baz", 5, 10.001}};
        Object[][] pojo2Args = new Object[][]{{new byte[0], Bytes.toBytes((String)"it"), "was", Bytes.toBytes((String)"the")}, {Bytes.toBytes((String)"best"), new byte[0], "of", Bytes.toBytes((String)"times,")}, {Bytes.toBytes((String)"it"), Bytes.toBytes((String)"was"), "", Bytes.toBytes((String)"the")}, {Bytes.toBytes((String)"worst"), Bytes.toBytes((String)"of"), "times,", new byte[0]}, {new byte[0], new byte[0], "", new byte[0]}};
        Object[][] params = new Object[][]{{SpecializedPojo1Type1.GENERIC, new SpecializedPojo1Type1(), pojo1Args}, {SpecializedPojo2Type1.GENERIC, new SpecializedPojo2Type1(), pojo2Args}};
        return Arrays.asList(params);
    }

    @Test
    public void testOrderPreservation() throws Exception {
        int i;
        Object[] vals = new Object[this.constructorArgs.length];
        Object[] encodedGeneric = new PositionedByteRange[this.constructorArgs.length];
        Object[] encodedSpecialized = new PositionedByteRange[this.constructorArgs.length];
        Constructor ctor = this.specialized.encodedClass().getConstructor(Object[].class);
        for (i = 0; i < vals.length; ++i) {
            vals[i] = ctor.newInstance(new Object[]{this.constructorArgs[i]});
            encodedGeneric[i] = new SimplePositionedMutableByteRange(this.generic.encodedLength(this.constructorArgs[i]));
            encodedSpecialized[i] = new SimplePositionedMutableByteRange(this.specialized.encodedLength(vals[i]));
        }
        for (i = 0; i < vals.length; ++i) {
            this.generic.encode((PositionedByteRange)encodedGeneric[i], this.constructorArgs[i]);
            encodedGeneric[i].setPosition(0);
            this.specialized.encode((PositionedByteRange)encodedSpecialized[i], vals[i]);
            encodedSpecialized[i].setPosition(0);
            Assert.assertArrayEquals((byte[])encodedGeneric[i].getBytes(), (byte[])encodedSpecialized[i].getBytes());
        }
        Arrays.sort(vals);
        Arrays.sort(encodedGeneric);
        Arrays.sort(encodedSpecialized);
        for (i = 0; i < vals.length; ++i) {
            Assert.assertEquals((String)("Struct encoder does not preserve sort order at position " + i), (Object)vals[i], ctor.newInstance(new Object[]{this.generic.decode((PositionedByteRange)encodedGeneric[i])}));
            Assert.assertEquals((String)("Specialized encoder does not preserve sort order at position " + i), (Object)vals[i], (Object)this.specialized.decode((PositionedByteRange)encodedSpecialized[i]));
        }
    }

    private static class SpecializedPojo2Type1
    implements DataType<Pojo2> {
        private static RawBytesTerminated byteField1 = new RawBytesTerminated("/");
        private static RawBytesTerminated byteField2 = new RawBytesTerminated(Order.DESCENDING, "/");
        private static RawStringTerminated stringField = new RawStringTerminated(Order.DESCENDING, new byte[]{0});
        private static RawBytes byteField3 = RawBytes.DESCENDING;
        public static Struct GENERIC = new StructBuilder().add((DataType)byteField1).add((DataType)byteField2).add((DataType)stringField).add((DataType)byteField3).toStruct();

        private SpecializedPojo2Type1() {
        }

        public boolean isOrderPreserving() {
            return true;
        }

        public Order getOrder() {
            return null;
        }

        public boolean isNullable() {
            return false;
        }

        public boolean isSkippable() {
            return true;
        }

        public int encodedLength(Pojo2 val) {
            return byteField1.encodedLength((Object)val.byteField1Asc) + byteField2.encodedLength((Object)val.byteField2Dsc) + stringField.encodedLength((Object)val.stringFieldDsc) + byteField3.encodedLength(val.byteField3Dsc);
        }

        public Class<Pojo2> encodedClass() {
            return Pojo2.class;
        }

        public int skip(PositionedByteRange src) {
            int skipped = byteField1.skip(src);
            skipped += byteField2.skip(src);
            skipped += stringField.skip(src);
            return skipped += byteField3.skip(src);
        }

        public Pojo2 decode(PositionedByteRange src) {
            Object[] ret = new Object[]{byteField1.decode(src), byteField2.decode(src), stringField.decode(src), byteField3.decode(src)};
            return new Pojo2(ret);
        }

        public int encode(PositionedByteRange dst, Pojo2 val) {
            int written = byteField1.encode(dst, (Object)val.byteField1Asc);
            written += byteField2.encode(dst, (Object)val.byteField2Dsc);
            written += stringField.encode(dst, (Object)val.stringFieldDsc);
            return written += byteField3.encode(dst, val.byteField3Dsc);
        }
    }

    private static class SpecializedPojo1Type1
    implements DataType<Pojo1> {
        private static final RawStringTerminated stringField = new RawStringTerminated("/");
        private static final RawInteger intField = new RawInteger();
        private static final RawDouble doubleField = new RawDouble();
        public static Struct GENERIC = new StructBuilder().add((DataType)stringField).add((DataType)intField).add((DataType)doubleField).toStruct();

        private SpecializedPojo1Type1() {
        }

        public boolean isOrderPreserving() {
            return true;
        }

        public Order getOrder() {
            return null;
        }

        public boolean isNullable() {
            return false;
        }

        public boolean isSkippable() {
            return true;
        }

        public int encodedLength(Pojo1 val) {
            return stringField.encodedLength((Object)val.stringFieldAsc) + intField.encodedLength(Integer.valueOf(val.intFieldAsc)) + doubleField.encodedLength(Double.valueOf(val.doubleFieldAsc));
        }

        public Class<Pojo1> encodedClass() {
            return Pojo1.class;
        }

        public int skip(PositionedByteRange src) {
            int skipped = stringField.skip(src);
            skipped += intField.skip(src);
            return skipped += doubleField.skip(src);
        }

        public Pojo1 decode(PositionedByteRange src) {
            Object[] ret = new Object[]{stringField.decode(src), intField.decode(src), doubleField.decode(src)};
            return new Pojo1(ret);
        }

        public int encode(PositionedByteRange dst, Pojo1 val) {
            int written = stringField.encode(dst, (Object)val.stringFieldAsc);
            written += intField.encode(dst, Integer.valueOf(val.intFieldAsc));
            return written += doubleField.encode(dst, Double.valueOf(val.doubleFieldAsc));
        }
    }

    private static class Pojo2
    implements Comparable<Pojo2> {
        final byte[] byteField1Asc;
        final byte[] byteField2Dsc;
        final String stringFieldDsc;
        final byte[] byteField3Dsc;
        final transient String str;

        public Pojo2(Object ... vals) {
            this.byteField1Asc = vals.length > 0 ? (byte[])vals[0] : null;
            this.byteField2Dsc = vals.length > 1 ? (byte[])vals[1] : null;
            this.stringFieldDsc = vals.length > 2 ? (String)vals[2] : null;
            this.byteField3Dsc = vals.length > 3 ? (byte[])vals[3] : null;
            this.str = "{ " + Bytes.toStringBinary((byte[])this.byteField1Asc) + ", " + Bytes.toStringBinary((byte[])this.byteField2Dsc) + ", " + (null == this.stringFieldDsc ? "" : "\"") + this.stringFieldDsc + (null == this.stringFieldDsc ? "" : "\"") + ", " + Bytes.toStringBinary((byte[])this.byteField3Dsc) + " }";
        }

        public String toString() {
            return this.str;
        }

        @Override
        public int compareTo(Pojo2 o) {
            int cmp = NULL_SAFE_BYTES_COMPARATOR.compare(this.byteField1Asc, o.byteField1Asc);
            if (cmp != 0) {
                return cmp;
            }
            cmp = -NULL_SAFE_BYTES_COMPARATOR.compare(this.byteField2Dsc, o.byteField2Dsc);
            if (cmp != 0) {
                return cmp;
            }
            cmp = null == this.stringFieldDsc ? 1 : (null == o.stringFieldDsc ? -1 : (this.stringFieldDsc.equals(o.stringFieldDsc) ? 0 : -this.stringFieldDsc.compareTo(o.stringFieldDsc)));
            if (cmp != 0) {
                return cmp;
            }
            return -NULL_SAFE_BYTES_COMPARATOR.compare(this.byteField3Dsc, o.byteField3Dsc);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.byteField1Asc);
            result = 31 * result + Arrays.hashCode(this.byteField2Dsc);
            result = 31 * result + Arrays.hashCode(this.byteField3Dsc);
            result = 31 * result + (this.stringFieldDsc == null ? 0 : this.stringFieldDsc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pojo2 other = (Pojo2)obj;
            if (!Arrays.equals(this.byteField1Asc, other.byteField1Asc)) {
                return false;
            }
            if (!Arrays.equals(this.byteField2Dsc, other.byteField2Dsc)) {
                return false;
            }
            if (!Arrays.equals(this.byteField3Dsc, other.byteField3Dsc)) {
                return false;
            }
            return !(this.stringFieldDsc == null ? other.stringFieldDsc != null : !this.stringFieldDsc.equals(other.stringFieldDsc));
        }
    }

    private static class Pojo1
    implements Comparable<Pojo1> {
        final String stringFieldAsc;
        final int intFieldAsc;
        final double doubleFieldAsc;
        final transient String str;

        public Pojo1(Object ... argv) {
            this.stringFieldAsc = (String)argv[0];
            this.intFieldAsc = (Integer)argv[1];
            this.doubleFieldAsc = (Double)argv[2];
            this.str = "{ " + (null == this.stringFieldAsc ? "" : "\"") + this.stringFieldAsc + (null == this.stringFieldAsc ? "" : "\"") + ", " + this.intFieldAsc + ", " + this.doubleFieldAsc + " }";
        }

        public String toString() {
            return this.str;
        }

        @Override
        public int compareTo(Pojo1 o) {
            int cmp = this.stringFieldAsc.compareTo(o.stringFieldAsc);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Integer.valueOf(this.intFieldAsc).compareTo(o.intFieldAsc);
            if (cmp != 0) {
                return cmp;
            }
            return Double.compare(this.doubleFieldAsc, o.doubleFieldAsc);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            long temp = Double.doubleToLongBits(this.doubleFieldAsc);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + this.intFieldAsc;
            result = 31 * result + (this.stringFieldAsc == null ? 0 : this.stringFieldAsc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pojo1 other = (Pojo1)obj;
            if (Double.doubleToLongBits(this.doubleFieldAsc) != Double.doubleToLongBits(other.doubleFieldAsc)) {
                return false;
            }
            if (this.intFieldAsc != other.intFieldAsc) {
                return false;
            }
            return !(this.stringFieldAsc == null ? other.stringFieldAsc != null : !this.stringFieldAsc.equals(other.stringFieldAsc));
        }
    }
}

