/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.security.token.AuthenticationKey;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSecretManager;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.Writable;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ZKSecretWatcher
extends ZooKeeperListener {
    private static final String DEFAULT_ROOT_NODE = "tokenauth";
    private static final String DEFAULT_KEYS_PARENT = "keys";
    private static Log LOG = LogFactory.getLog(ZKSecretWatcher.class);
    private AuthenticationTokenSecretManager secretManager;
    private String baseKeyZNode;
    private String keysParentZNode;

    public ZKSecretWatcher(Configuration conf, ZooKeeperWatcher watcher, AuthenticationTokenSecretManager secretManager) {
        super(watcher);
        this.secretManager = secretManager;
        String keyZNodeParent = conf.get("zookeeper.znode.tokenauth.parent", DEFAULT_ROOT_NODE);
        this.baseKeyZNode = ZKUtil.joinZNode((String)watcher.baseZNode, (String)keyZNodeParent);
        this.keysParentZNode = ZKUtil.joinZNode((String)this.baseKeyZNode, (String)DEFAULT_KEYS_PARENT);
    }

    public void start() throws KeeperException {
        this.watcher.registerListener((ZooKeeperListener)this);
        ZKUtil.createWithParents((ZooKeeperWatcher)this.watcher, (String)this.keysParentZNode);
        if (ZKUtil.watchAndCheckExists((ZooKeeperWatcher)this.watcher, (String)this.keysParentZNode)) {
            List nodes = ZKUtil.getChildDataAndWatchForNewChildren((ZooKeeperWatcher)this.watcher, (String)this.keysParentZNode);
            this.refreshNodes(nodes);
        }
    }

    public void nodeCreated(String path) {
        if (path.equals(this.keysParentZNode)) {
            try {
                List nodes = ZKUtil.getChildDataAndWatchForNewChildren((ZooKeeperWatcher)this.watcher, (String)this.keysParentZNode);
                this.refreshNodes(nodes);
            }
            catch (KeeperException ke) {
                LOG.fatal((Object)"Error reading data from zookeeper", (Throwable)ke);
                this.watcher.abort("Error reading new key znode " + path, (Throwable)ke);
            }
        }
    }

    public void nodeDeleted(String path) {
        if (this.keysParentZNode.equals(ZKUtil.getParent((String)path))) {
            String keyId = ZKUtil.getNodeName((String)path);
            try {
                Integer id = Integer.valueOf(keyId);
                this.secretManager.removeKey(id);
            }
            catch (NumberFormatException nfe) {
                LOG.error((Object)("Invalid znode name for key ID '" + keyId + "'"), (Throwable)nfe);
            }
        }
    }

    public void nodeDataChanged(String path) {
        if (this.keysParentZNode.equals(ZKUtil.getParent((String)path))) {
            try {
                byte[] data = ZKUtil.getDataAndWatch((ZooKeeperWatcher)this.watcher, (String)path);
                if (data == null || data.length == 0) {
                    LOG.debug((Object)("Ignoring empty node " + path));
                    return;
                }
                AuthenticationKey key = (AuthenticationKey)Writables.getWritable((byte[])data, (Writable)new AuthenticationKey());
                this.secretManager.addKey(key);
            }
            catch (KeeperException ke) {
                LOG.fatal((Object)"Error reading data from zookeeper", (Throwable)ke);
                this.watcher.abort("Error reading updated key znode " + path, (Throwable)ke);
            }
            catch (IOException ioe) {
                LOG.fatal((Object)"Error reading key writables", (Throwable)ioe);
                this.watcher.abort("Error reading key writables from znode " + path, (Throwable)ioe);
            }
        }
    }

    public void nodeChildrenChanged(String path) {
        if (path.equals(this.keysParentZNode)) {
            try {
                List nodes = ZKUtil.getChildDataAndWatchForNewChildren((ZooKeeperWatcher)this.watcher, (String)this.keysParentZNode);
                this.refreshNodes(nodes);
            }
            catch (KeeperException ke) {
                LOG.fatal((Object)"Error reading data from zookeeper", (Throwable)ke);
                this.watcher.abort("Error reading changed keys from zookeeper", (Throwable)ke);
            }
        }
    }

    public String getRootKeyZNode() {
        return this.baseKeyZNode;
    }

    private void refreshNodes(List<ZKUtil.NodeAndData> nodes) {
        for (ZKUtil.NodeAndData n : nodes) {
            String path = n.getNode();
            String keyId = ZKUtil.getNodeName((String)path);
            try {
                byte[] data = n.getData();
                if (data == null || data.length == 0) {
                    LOG.debug((Object)("Ignoring empty node " + path));
                    continue;
                }
                AuthenticationKey key = (AuthenticationKey)Writables.getWritable((byte[])data, (Writable)new AuthenticationKey());
                this.secretManager.addKey(key);
            }
            catch (IOException ioe) {
                LOG.fatal((Object)("Failed reading new secret key for id '" + keyId + "' from zk"), (Throwable)ioe);
                this.watcher.abort("Error deserializing key from znode " + path, (Throwable)ioe);
            }
        }
    }

    private String getKeyNode(int keyId) {
        return ZKUtil.joinZNode((String)this.keysParentZNode, (String)Integer.toString(keyId));
    }

    public void removeKeyFromZK(AuthenticationKey key) {
        String keyZNode = this.getKeyNode(key.getKeyId());
        try {
            ZKUtil.deleteNode((ZooKeeperWatcher)this.watcher, (String)keyZNode);
        }
        catch (KeeperException.NoNodeException nne) {
            LOG.error((Object)("Non-existent znode " + keyZNode + " for key " + key.getKeyId()), (Throwable)nne);
        }
        catch (KeeperException ke) {
            LOG.fatal((Object)("Failed removing znode " + keyZNode + " for key " + key.getKeyId()), (Throwable)ke);
            this.watcher.abort("Unhandled zookeeper error removing znode " + keyZNode + " for key " + key.getKeyId(), (Throwable)ke);
        }
    }

    public void addKeyToZK(AuthenticationKey key) {
        String keyZNode = this.getKeyNode(key.getKeyId());
        try {
            byte[] keyData = Writables.getBytes((Writable)key);
            ZKUtil.createSetData((ZooKeeperWatcher)this.watcher, (String)keyZNode, (byte[])keyData);
        }
        catch (KeeperException ke) {
            LOG.fatal((Object)("Unable to synchronize master key " + key.getKeyId() + " to znode " + keyZNode), (Throwable)ke);
            this.watcher.abort("Unable to synchronize secret key " + key.getKeyId() + " in zookeeper", (Throwable)ke);
        }
        catch (IOException ioe) {
            this.watcher.abort("Failed serializing key " + key.getKeyId(), (Throwable)ioe);
        }
    }

    public void updateKeyInZK(AuthenticationKey key) {
        String keyZNode = this.getKeyNode(key.getKeyId());
        try {
            byte[] keyData = Writables.getBytes((Writable)key);
            try {
                ZKUtil.updateExistingNodeData((ZooKeeperWatcher)this.watcher, (String)keyZNode, (byte[])keyData, (int)-1);
            }
            catch (KeeperException.NoNodeException ne) {
                ZKUtil.createSetData((ZooKeeperWatcher)this.watcher, (String)keyZNode, (byte[])keyData);
            }
        }
        catch (KeeperException ke) {
            LOG.fatal((Object)("Unable to update master key " + key.getKeyId() + " in znode " + keyZNode));
            this.watcher.abort("Unable to synchronize secret key " + key.getKeyId() + " in zookeeper", (Throwable)ke);
        }
        catch (IOException ioe) {
            this.watcher.abort("Failed serializing key " + key.getKeyId(), (Throwable)ioe);
        }
    }
}

