/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.PerClientRandomNonceGenerator;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.codec.KeyValueCodec;
import org.apache.hadoop.hbase.exceptions.OperationConflictException;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMultiParallel {
    private static final Log LOG = LogFactory.getLog(TestMultiParallel.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] VALUE = Bytes.toBytes((String)"value");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"qual");
    private static final String FAMILY = "family";
    private static final TableName TEST_TABLE = TableName.valueOf((String)"multi_test_table");
    private static final byte[] BYTES_FAMILY = Bytes.toBytes((String)"family");
    private static final byte[] ONE_ROW = Bytes.toBytes((String)"xxx");
    private static final byte[][] KEYS = TestMultiParallel.makeKeys();
    private static final int slaves = 5;
    private static Connection CONNECTION;

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.getConfiguration().set("hbase.client.rpc.codec", KeyValueCodec.class.getCanonicalName());
        UTIL.startMiniCluster(5);
        HTable t = UTIL.createMultiRegionTable(TEST_TABLE, Bytes.toBytes((String)FAMILY));
        UTIL.waitTableEnabled(TEST_TABLE);
        t.close();
        CONNECTION = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
    }

    @AfterClass
    public static void afterClass() throws Exception {
        CONNECTION.close();
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() throws Exception {
        LOG.info((Object)"before");
        if (UTIL.ensureSomeRegionServersAvailable(5)) {
            UTIL.getMiniHBaseCluster().getMaster().balance();
            UTIL.waitFor(15000L, UTIL.predicateNoRegionsInTransition());
        }
        LOG.info((Object)"before done");
    }

    private static byte[][] makeKeys() {
        byte[] cp;
        byte[] k;
        int kIdx;
        int i;
        byte[][] starterKeys = HBaseTestingUtility.KEYS;
        int numKeys = (int)((float)starterKeys.length * 10.33f);
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        for (i = 0; i < numKeys; ++i) {
            kIdx = i % starterKeys.length;
            k = starterKeys[kIdx];
            cp = new byte[k.length + 1];
            System.arraycopy(k, 0, cp, 0, k.length);
            cp[k.length] = new Integer(i % 256).byteValue();
            keys.add(cp);
        }
        for (i = 0; i < 100; ++i) {
            kIdx = i % starterKeys.length;
            k = starterKeys[kIdx];
            cp = new byte[k.length + 1];
            System.arraycopy(k, 0, cp, 0, k.length);
            cp[k.length] = new Integer(i % 256).byteValue();
            keys.add(cp);
        }
        return (byte[][])keys.toArray((T[])new byte[][]{new byte[0]});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testActiveThreadsCount() throws Exception {
        try (Connection connection = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());){
            ThreadPoolExecutor executor = HTable.getDefaultExecutor((Configuration)UTIL.getConfiguration());
            try (Table t = connection.getTable(TEST_TABLE, (ExecutorService)executor);){
                List<Put> puts = this.constructPutRequests();
                t.batch(puts);
                HashSet<ServerName> regionservers = new HashSet<ServerName>();
                try (RegionLocator locator = connection.getRegionLocator(TEST_TABLE);){
                    for (Row row : puts) {
                        HRegionLocation location = locator.getRegionLocation(row.getRow());
                        regionservers.add(location.getServerName());
                    }
                }
                Assert.assertEquals((long)regionservers.size(), (long)executor.getLargestPoolSize());
            }
            finally {
                executor.shutdownNow();
            }
        }
    }

    @Test(timeout=300000L)
    public void testBatchWithGet() throws Exception {
        LOG.info((Object)"test=testBatchWithGet");
        HTable table = new HTable(UTIL.getConfiguration(), TEST_TABLE);
        List<Put> puts = this.constructPutRequests();
        table.batch(puts);
        ArrayList<Get> gets = new ArrayList<Get>();
        for (byte[] byArray : KEYS) {
            Get get = new Get(byArray);
            get.addColumn(BYTES_FAMILY, QUALIFIER);
            gets.add(get);
        }
        Object[] multiRes = new Result[gets.size()];
        table.batch(gets, multiRes);
        ArrayList<Result> singleRes = new ArrayList<Result>();
        for (Row row : gets) {
            singleRes.add(table.get((Get)row));
        }
        Assert.assertEquals((long)singleRes.size(), (long)multiRes.length);
        for (int i = 0; i < singleRes.size(); ++i) {
            Assert.assertTrue((boolean)((Result)singleRes.get(i)).containsColumn(BYTES_FAMILY, QUALIFIER));
            Cell[] cellArray = ((Result)singleRes.get(i)).rawCells();
            Cell[] multiKvs = multiRes[i].rawCells();
            for (int j = 0; j < cellArray.length; ++j) {
                Assert.assertEquals((Object)cellArray[j], (Object)multiKvs[j]);
                Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])CellUtil.cloneValue((Cell)cellArray[j]), (byte[])CellUtil.cloneValue((Cell)multiKvs[j])));
            }
        }
        table.close();
    }

    @Test
    public void testBadFam() throws Exception {
        LOG.info((Object)"test=testBadFam");
        HTable table = new HTable(UTIL.getConfiguration(), TEST_TABLE);
        ArrayList<Put> actions = new ArrayList<Put>();
        Put p = new Put(Bytes.toBytes((String)"row1"));
        p.add(Bytes.toBytes((String)"bad_family"), Bytes.toBytes((String)"qual"), Bytes.toBytes((String)"value"));
        actions.add(p);
        p = new Put(Bytes.toBytes((String)"row2"));
        p.add(BYTES_FAMILY, Bytes.toBytes((String)"qual"), Bytes.toBytes((String)"value"));
        actions.add(p);
        Object[] r = new Object[actions.size()];
        try {
            table.batch(actions, r);
            Assert.fail();
        }
        catch (RetriesExhaustedWithDetailsException ex) {
            LOG.debug((Object)ex);
            Assert.assertFalse((boolean)ex.mayHaveClusterIssues());
        }
        Assert.assertEquals((long)2L, (long)r.length);
        Assert.assertTrue((boolean)(r[0] instanceof Throwable));
        Assert.assertTrue((boolean)(r[1] instanceof Result));
        table.close();
    }

    @Test(timeout=300000L)
    public void testFlushCommitsNoAbort() throws Exception {
        LOG.info((Object)"test=testFlushCommitsNoAbort");
        this.doTestFlushCommits(false);
    }

    @Test(timeout=360000L)
    public void testFlushCommitsWithAbort() throws Exception {
        LOG.info((Object)"test=testFlushCommitsWithAbort");
        this.doTestFlushCommits(true);
    }

    private void doTestFlushCommits(boolean doAbort) throws Exception {
        LOG.info((Object)"get new table");
        Table table = UTIL.getConnection().getTable(TEST_TABLE);
        table.setWriteBufferSize(0xA00000L);
        LOG.info((Object)"constructPutRequests");
        List<Put> puts = this.constructPutRequests();
        table.put(puts);
        LOG.info((Object)"puts");
        final int liveRScount = UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().size();
        assert (liveRScount > 0);
        JVMClusterUtil.RegionServerThread liveRS = UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().get(0);
        if (doAbort) {
            liveRS.getRegionServer().abort("Aborting for tests", (Throwable)new Exception("doTestFlushCommits"));
            while (liveRS.getRegionServer().getNumberOfOnlineRegions() != 0) {
                Thread.sleep(100L);
            }
            puts = this.constructPutRequests();
            table.put(puts);
        }
        LOG.info((Object)"validating loaded data");
        this.validateLoadedData(table);
        List<JVMClusterUtil.RegionServerThread> liveRSs = UTIL.getMiniHBaseCluster().getLiveRegionServerThreads();
        int count = 0;
        for (JVMClusterUtil.RegionServerThread t : liveRSs) {
            LOG.info((Object)("Count=" + ++count + ", Alive=" + t.getRegionServer()));
        }
        LOG.info((Object)("Count=" + count));
        Assert.assertEquals((String)("Server count=" + count + ", abort=" + doAbort), (long)(doAbort ? liveRScount - 1 : liveRScount), (long)count);
        if (doAbort) {
            UTIL.getMiniHBaseCluster().waitOnRegionServer(0);
            UTIL.waitFor(15000L, new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return UTIL.getMiniHBaseCluster().getMaster().getClusterStatus().getServersSize() == liveRScount - 1;
                }
            });
            UTIL.waitFor(15000L, UTIL.predicateNoRegionsInTransition());
        }
        table.close();
        LOG.info((Object)"done");
    }

    @Test(timeout=300000L)
    public void testBatchWithPut() throws Exception {
        LOG.info((Object)"test=testBatchWithPut");
        Table table = CONNECTION.getTable(TEST_TABLE);
        List<Put> puts = this.constructPutRequests();
        Object[] results = table.batch(puts);
        this.validateSizeAndEmpty(results, KEYS.length);
        int liveRScount = UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().size();
        assert (liveRScount > 0);
        JVMClusterUtil.RegionServerThread liveRS = UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().get(0);
        liveRS.getRegionServer().abort("Aborting for tests", (Throwable)new Exception("testBatchWithPut"));
        puts = this.constructPutRequests();
        try {
            results = table.batch(puts);
        }
        catch (RetriesExhaustedWithDetailsException ree) {
            LOG.info((Object)ree.getExhaustiveDescription());
            table.close();
            throw ree;
        }
        this.validateSizeAndEmpty(results, KEYS.length);
        this.validateLoadedData(table);
        table.close();
    }

    @Test(timeout=300000L)
    public void testBatchWithDelete() throws Exception {
        LOG.info((Object)"test=testBatchWithDelete");
        HTable table = new HTable(UTIL.getConfiguration(), TEST_TABLE);
        List<Put> puts = this.constructPutRequests();
        Object[] results = table.batch(puts);
        this.validateSizeAndEmpty(results, KEYS.length);
        ArrayList<Delete> deletes = new ArrayList<Delete>();
        for (int i = 0; i < KEYS.length; ++i) {
            Delete delete = new Delete(KEYS[i]);
            delete.addFamily(BYTES_FAMILY);
            deletes.add(delete);
        }
        results = table.batch(deletes);
        this.validateSizeAndEmpty(results, KEYS.length);
        for (byte[] k : KEYS) {
            Get get = new Get(k);
            get.addColumn(BYTES_FAMILY, QUALIFIER);
            Assert.assertFalse((boolean)table.exists(get));
        }
        table.close();
    }

    @Test(timeout=300000L)
    public void testHTableDeleteWithList() throws Exception {
        LOG.info((Object)"test=testHTableDeleteWithList");
        HTable table = new HTable(UTIL.getConfiguration(), TEST_TABLE);
        List<Put> puts = this.constructPutRequests();
        Object[] results = table.batch(puts);
        this.validateSizeAndEmpty(results, KEYS.length);
        ArrayList<Delete> deletes = new ArrayList<Delete>();
        for (int i = 0; i < KEYS.length; ++i) {
            Delete delete = new Delete(KEYS[i]);
            delete.deleteFamily(BYTES_FAMILY);
            deletes.add(delete);
        }
        table.delete(deletes);
        Assert.assertTrue((boolean)deletes.isEmpty());
        for (byte[] k : KEYS) {
            Get get = new Get(k);
            get.addColumn(BYTES_FAMILY, QUALIFIER);
            Assert.assertFalse((boolean)table.exists(get));
        }
        table.close();
    }

    @Test(timeout=300000L)
    public void testBatchWithManyColsInOneRowGetAndPut() throws Exception {
        LOG.info((Object)"test=testBatchWithManyColsInOneRowGetAndPut");
        HTable table = new HTable(UTIL.getConfiguration(), TEST_TABLE);
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i < 100; ++i) {
            Put put = new Put(ONE_ROW);
            byte[] qual = Bytes.toBytes((String)("column" + i));
            put.add(BYTES_FAMILY, qual, VALUE);
            puts.add(put);
        }
        Object[] results = table.batch(puts);
        this.validateSizeAndEmpty(results, 100);
        ArrayList<Get> gets = new ArrayList<Get>();
        for (int i = 0; i < 100; ++i) {
            Get get = new Get(ONE_ROW);
            byte[] qual = Bytes.toBytes((String)("column" + i));
            get.addColumn(BYTES_FAMILY, qual);
            gets.add(get);
        }
        Object[] multiRes = table.batch(gets);
        int idx = 0;
        for (Object r : multiRes) {
            byte[] qual = Bytes.toBytes((String)("column" + idx));
            this.validateResult(r, qual, VALUE);
            ++idx;
        }
        table.close();
    }

    @Test(timeout=300000L)
    public void testBatchWithIncrementAndAppend() throws Exception {
        LOG.info((Object)"test=testBatchWithIncrementAndAppend");
        byte[] QUAL1 = Bytes.toBytes((String)"qual1");
        byte[] QUAL2 = Bytes.toBytes((String)"qual2");
        byte[] QUAL3 = Bytes.toBytes((String)"qual3");
        byte[] QUAL4 = Bytes.toBytes((String)"qual4");
        HTable table = new HTable(UTIL.getConfiguration(), TEST_TABLE);
        Delete d = new Delete(ONE_ROW);
        table.delete(d);
        Put put = new Put(ONE_ROW);
        put.add(BYTES_FAMILY, QUAL1, Bytes.toBytes((String)"abc"));
        put.add(BYTES_FAMILY, QUAL2, Bytes.toBytes((long)1L));
        table.put(put);
        Increment inc = new Increment(ONE_ROW);
        inc.addColumn(BYTES_FAMILY, QUAL2, 1L);
        inc.addColumn(BYTES_FAMILY, QUAL3, 1L);
        Append a = new Append(ONE_ROW);
        a.add(BYTES_FAMILY, QUAL1, Bytes.toBytes((String)"def"));
        a.add(BYTES_FAMILY, QUAL4, Bytes.toBytes((String)"xyz"));
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(inc);
        actions.add(a);
        Object[] multiRes = table.batch(actions);
        this.validateResult(multiRes[1], QUAL1, Bytes.toBytes((String)"abcdef"));
        this.validateResult(multiRes[1], QUAL4, Bytes.toBytes((String)"xyz"));
        this.validateResult(multiRes[0], QUAL2, Bytes.toBytes((long)2L));
        this.validateResult(multiRes[0], QUAL3, Bytes.toBytes((long)1L));
        table.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testNonceCollision() throws Exception {
        LOG.info((Object)"test=testNonceCollision");
        final Connection connection = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
        Table table = connection.getTable(TEST_TABLE);
        Put put = new Put(ONE_ROW);
        put.add(BYTES_FAMILY, QUALIFIER, Bytes.toBytes((long)0L));
        PerClientRandomNonceGenerator cnm = new PerClientRandomNonceGenerator(){
            long lastNonce = -1L;

            public synchronized long newNonce() {
                long nonce = 0L;
                if (this.lastNonce == -1L) {
                    this.lastNonce = nonce = super.newNonce();
                } else {
                    nonce = this.lastNonce;
                    this.lastNonce = -1L;
                }
                return nonce;
            }
        };
        NonceGenerator oldCnm = ConnectionUtils.injectNonceGeneratorForTesting((ClusterConnection)((ClusterConnection)connection), (NonceGenerator)cnm);
        try {
            Increment inc = new Increment(ONE_ROW);
            inc.addColumn(BYTES_FAMILY, QUALIFIER, 1L);
            table.increment(inc);
            inc = new Increment(ONE_ROW);
            inc.addColumn(BYTES_FAMILY, QUALIFIER, 1L);
            try {
                table.increment(inc);
                Assert.fail((String)"Should have thrown an exception");
            }
            catch (OperationConflictException operationConflictException) {
                // empty catch block
            }
            Get get = new Get(ONE_ROW);
            get.addColumn(BYTES_FAMILY, QUALIFIER);
            Result result = table.get(get);
            this.validateResult(result, QUALIFIER, Bytes.toBytes((long)1L));
            int numRequests = 40;
            final CountDownLatch startedLatch = new CountDownLatch(numRequests);
            final CountDownLatch startLatch = new CountDownLatch(1);
            final CountDownLatch doneLatch = new CountDownLatch(numRequests);
            for (int i = 0; i < numRequests; ++i) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        Table table = null;
                        try {
                            table = connection.getTable(TEST_TABLE);
                        }
                        catch (IOException e) {
                            Assert.fail((String)"Not expected");
                        }
                        Increment inc = new Increment(ONE_ROW);
                        inc.addColumn(BYTES_FAMILY, QUALIFIER, 1L);
                        startedLatch.countDown();
                        try {
                            startLatch.await();
                        }
                        catch (InterruptedException e) {
                            Assert.fail((String)"Not expected");
                        }
                        try {
                            table.increment(inc);
                        }
                        catch (OperationConflictException e) {
                        }
                        catch (IOException ioEx) {
                            Assert.fail((String)"Not expected");
                        }
                        doneLatch.countDown();
                    }
                };
                Threads.setDaemonThreadRunning((Thread)new Thread(r));
            }
            startedLatch.await();
            startLatch.countDown();
            doneLatch.await();
            get = new Get(ONE_ROW);
            get.addColumn(BYTES_FAMILY, QUALIFIER);
            result = table.get(get);
            this.validateResult(result, QUALIFIER, Bytes.toBytes((long)((long)(numRequests / 2) + 1L)));
            table.close();
        }
        finally {
            ConnectionManager.injectNonceGeneratorForTesting((ClusterConnection)((ClusterConnection)connection), (NonceGenerator)oldCnm);
        }
    }

    @Test(timeout=300000L)
    public void testBatchWithMixedActions() throws Exception {
        LOG.info((Object)"test=testBatchWithMixedActions");
        HTable table = new HTable(UTIL.getConfiguration(), TEST_TABLE);
        Object[] results = table.batch(this.constructPutRequests());
        this.validateSizeAndEmpty(results, KEYS.length);
        ArrayList<Object> actions = new ArrayList<Object>();
        byte[] qual2 = Bytes.toBytes((String)"qual2");
        byte[] val2 = Bytes.toBytes((String)"putvalue2");
        Get get = new Get(KEYS[10]);
        get.addColumn(BYTES_FAMILY, QUALIFIER);
        actions.add(get);
        get = new Get(KEYS[11]);
        get.addColumn(BYTES_FAMILY, QUALIFIER);
        actions.add(get);
        Put put = new Put(KEYS[10]);
        put.add(BYTES_FAMILY, qual2, val2);
        actions.add(put);
        Delete delete = new Delete(KEYS[20]);
        delete.deleteFamily(BYTES_FAMILY);
        actions.add(delete);
        get = new Get(KEYS[30]);
        get.addColumn(BYTES_FAMILY, QUALIFIER);
        actions.add(get);
        put = new Put(KEYS[40]);
        put.add(BYTES_FAMILY, qual2, val2);
        actions.add(put);
        results = table.batch(actions);
        this.validateResult(results[0]);
        this.validateResult(results[1]);
        this.validateEmpty(results[2]);
        this.validateEmpty(results[3]);
        this.validateResult(results[4]);
        this.validateEmpty(results[5]);
        get = new Get(KEYS[40]);
        get.addColumn(BYTES_FAMILY, qual2);
        Result r = table.get(get);
        this.validateResult(r, qual2, val2);
        table.close();
    }

    private void validateResult(Object r) {
        this.validateResult(r, QUALIFIER, VALUE);
    }

    private void validateResult(Object r1, byte[] qual, byte[] val) {
        Result r = (Result)r1;
        Assert.assertTrue((boolean)r.containsColumn(BYTES_FAMILY, qual));
        byte[] value = r.getValue(BYTES_FAMILY, qual);
        if (0 != Bytes.compareTo((byte[])val, (byte[])value)) {
            Assert.fail((String)("Expected [" + Bytes.toStringBinary((byte[])val) + "] but got [" + Bytes.toStringBinary((byte[])value) + "]"));
        }
    }

    private List<Put> constructPutRequests() {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (byte[] k : KEYS) {
            Put put = new Put(k);
            put.add(BYTES_FAMILY, QUALIFIER, VALUE);
            puts.add(put);
        }
        return puts;
    }

    private void validateLoadedData(Table table) throws IOException {
        LOG.info((Object)("Validating data on " + table));
        for (byte[] k : KEYS) {
            Get get = new Get(k);
            get.addColumn(BYTES_FAMILY, QUALIFIER);
            Result r = table.get(get);
            Assert.assertTrue((boolean)r.containsColumn(BYTES_FAMILY, QUALIFIER));
            Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])VALUE, (byte[])r.getValue(BYTES_FAMILY, QUALIFIER)));
        }
    }

    private void validateEmpty(Object r1) {
        Result result = (Result)r1;
        Assert.assertTrue((result != null ? 1 : 0) != 0);
        Assert.assertTrue((result.getRow() == null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)result.rawCells().length);
    }

    private void validateSizeAndEmpty(Object[] results, int expectedSize) {
        Assert.assertEquals((long)expectedSize, (long)results.length);
        for (Object result : results) {
            this.validateEmpty(result);
        }
    }
}

