/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.coprocessor.ColumnAggregationEndpoint;
import org.apache.hadoop.hbase.coprocessor.protobuf.generated.ColumnAggregationProtos;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestCoprocessorTableEndpoint {
    private static final byte[] TEST_FAMILY = Bytes.toBytes((String)"TestFamily");
    private static final byte[] TEST_QUALIFIER = Bytes.toBytes((String)"TestQualifier");
    private static final byte[] ROW = Bytes.toBytes((String)"testRow");
    private static final int ROWSIZE = 20;
    private static final int rowSeperator1 = 5;
    private static final int rowSeperator2 = 12;
    private static final byte[][] ROWS = TestCoprocessorTableEndpoint.makeN(ROW, 20);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCoprocessorTableEndpoint() throws Throwable {
        TableName tableName = TableName.valueOf((String)"testCoprocessorTableEndpoint");
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(TEST_FAMILY));
        desc.addCoprocessor(ColumnAggregationEndpoint.class.getName());
        TestCoprocessorTableEndpoint.createTable(desc);
        TestCoprocessorTableEndpoint.verifyTable(tableName);
    }

    @Test
    public void testDynamicCoprocessorTableEndpoint() throws Throwable {
        TableName tableName = TableName.valueOf((String)"testDynamicCoprocessorTableEndpoint");
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(TEST_FAMILY));
        TestCoprocessorTableEndpoint.createTable(desc);
        desc.addCoprocessor(ColumnAggregationEndpoint.class.getName());
        TestCoprocessorTableEndpoint.updateTable(desc);
        TestCoprocessorTableEndpoint.verifyTable(tableName);
    }

    private static byte[][] makeN(byte[] base, int n) {
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            ret[i] = Bytes.add((byte[])base, (byte[])Bytes.toBytes((String)String.format("%02d", i)));
        }
        return ret;
    }

    private static Map<byte[], Long> sum(Table table, final byte[] family, final byte[] qualifier, byte[] start, byte[] end) throws ServiceException, Throwable {
        return table.coprocessorService(ColumnAggregationProtos.ColumnAggregationService.class, start, end, (Batch.Call)new Batch.Call<ColumnAggregationProtos.ColumnAggregationService, Long>(){

            public Long call(ColumnAggregationProtos.ColumnAggregationService instance) throws IOException {
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                ColumnAggregationProtos.SumRequest.Builder builder = ColumnAggregationProtos.SumRequest.newBuilder();
                builder.setFamily(ByteStringer.wrap((byte[])family));
                if (qualifier != null && qualifier.length > 0) {
                    builder.setQualifier(ByteStringer.wrap((byte[])qualifier));
                }
                instance.sum(null, builder.build(), (RpcCallback<ColumnAggregationProtos.SumResponse>)rpcCallback);
                return ((ColumnAggregationProtos.SumResponse)rpcCallback.get()).getSum();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void createTable(HTableDescriptor desc) throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        admin.createTable(desc, (byte[][])new byte[][]{ROWS[5], ROWS[12]});
        TEST_UTIL.waitUntilAllRegionsAssigned(desc.getTableName());
        try (Table table = TEST_UTIL.getConnection().getTable(desc.getTableName());){
            for (int i = 0; i < 20; ++i) {
                Put put = new Put(ROWS[i]);
                put.addColumn(TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes((int)i));
                table.put(put);
            }
        }
    }

    private static void updateTable(HTableDescriptor desc) throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        admin.disableTable(desc.getTableName());
        admin.modifyTable(desc.getTableName(), desc);
        admin.enableTable(desc.getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void verifyTable(TableName tableName) throws Throwable {
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            Map<byte[], Long> results = TestCoprocessorTableEndpoint.sum(table, TEST_FAMILY, TEST_QUALIFIER, ROWS[0], ROWS[ROWS.length - 1]);
            int sumResult = 0;
            int expectedResult = 0;
            for (Map.Entry<byte[], Long> e : results.entrySet()) {
                sumResult = (int)((long)sumResult + e.getValue());
            }
            for (int i = 0; i < 20; ++i) {
                expectedResult += i;
            }
            Assert.assertEquals((String)"Invalid result", (long)expectedResult, (long)sumResult);
            results.clear();
            results = TestCoprocessorTableEndpoint.sum(table, TEST_FAMILY, TEST_QUALIFIER, ROWS[5], ROWS[ROWS.length - 1]);
            sumResult = 0;
            expectedResult = 0;
            for (Map.Entry<byte[], Long> e : results.entrySet()) {
                sumResult = (int)((long)sumResult + e.getValue());
            }
            for (int i = 5; i < 20; ++i) {
                expectedResult += i;
            }
            Assert.assertEquals((String)"Invalid result", (long)expectedResult, (long)sumResult);
        }
    }
}

