/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMultiRowRangeFilter {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final Log LOG = LogFactory.getLog(this.getClass());
    private byte[] family = Bytes.toBytes((String)"family");
    private byte[] qf = Bytes.toBytes((String)"qf");
    private byte[] value = Bytes.toBytes((String)"val");
    private byte[] tableName;
    private int numRows = 100;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRanges() throws IOException {
        byte[] key1Start = new byte[]{-3};
        byte[] key1End = new byte[]{-2};
        byte[] key2Start = new byte[]{5};
        byte[] key2End = new byte[]{6};
        byte[] badKey = new byte[]{-10};
        MultiRowRangeFilter filter = new MultiRowRangeFilter(Arrays.asList(new MultiRowRangeFilter.RowRange(key1Start, true, key1End, false), new MultiRowRangeFilter.RowRange(key2Start, true, key2End, false)));
        filter.filterRowKey(badKey, 0, 1);
        Assert.assertEquals((Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT, (Object)filter.filterKeyValue(null));
    }

    @Test
    public void testOutOfOrderScannerNextException() throws Exception {
        MultiRowRangeFilter filter = new MultiRowRangeFilter(Arrays.asList(new MultiRowRangeFilter.RowRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"c"), true), new MultiRowRangeFilter.RowRange(Bytes.toBytes((String)"d"), true, Bytes.toBytes((String)"e"), true)));
        filter.filterRowKey(Bytes.toBytes((String)"a"), 0, 1);
        Assert.assertEquals((Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT, (Object)filter.filterKeyValue(null));
        filter.filterRowKey(Bytes.toBytes((String)"b"), 0, 1);
        Assert.assertEquals((Object)Filter.ReturnCode.INCLUDE, (Object)filter.filterKeyValue(null));
        filter.filterRowKey(Bytes.toBytes((String)"c"), 0, 1);
        Assert.assertEquals((Object)Filter.ReturnCode.INCLUDE, (Object)filter.filterKeyValue(null));
        filter.filterRowKey(Bytes.toBytes((String)"d"), 0, 1);
        Assert.assertEquals((Object)Filter.ReturnCode.INCLUDE, (Object)filter.filterKeyValue(null));
        filter.filterRowKey(Bytes.toBytes((String)"e"), 0, 1);
        Assert.assertEquals((Object)Filter.ReturnCode.INCLUDE, (Object)filter.filterKeyValue(null));
    }

    @Test
    public void testMergeAndSortWithEmptyStartRow() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((String)""), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)15), true, Bytes.toBytes((int)40), false));
        List actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((String)""), true, Bytes.toBytes((int)40), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test
    public void testMergeAndSortWithEmptyStopRow() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)15), true, Bytes.toBytes((String)""), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)70), false));
        List actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((String)""), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test
    public void testMergeAndSortWithEmptyStartRowAndStopRow() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((String)""), true, Bytes.toBytes((String)""), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)70), false));
        List actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((String)""), true, Bytes.toBytes((String)""), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMultiRowRangeWithoutRange() throws IOException {
        ArrayList ranges = new ArrayList();
        new MultiRowRangeFilter(ranges);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMultiRowRangeWithInvalidRange() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)80), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)70), false));
        new MultiRowRangeFilter(ranges);
    }

    @Test
    public void testMergeAndSortWithoutOverlap() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)40), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)60), true, Bytes.toBytes((int)70), false));
        List actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)40), false));
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)60), true, Bytes.toBytes((int)70), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test
    public void testMergeAndSortWithOverlap() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)15), true, Bytes.toBytes((int)40), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)20), true, Bytes.toBytes((int)30), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)50), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)70), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)90), true, Bytes.toBytes((int)100), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)95), true, Bytes.toBytes((int)100), false));
        List actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)70), false));
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)90), true, Bytes.toBytes((int)100), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test
    public void testMergeAndSortWithStartRowInclusive() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)20), true, Bytes.toBytes((String)""), false));
        List actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((String)""), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test
    public void testMergeAndSortWithRowExclusive() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)20), false, Bytes.toBytes((String)""), false));
        List actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)20), false, Bytes.toBytes((String)""), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    @Test
    public void testMergeAndSortWithRowInclusive() throws IOException {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), true));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)20), false, Bytes.toBytes((String)""), false));
        List actualRanges = MultiRowRangeFilter.sortAndMerge(ranges);
        ArrayList<MultiRowRangeFilter.RowRange> expectedRanges = new ArrayList<MultiRowRangeFilter.RowRange>();
        expectedRanges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((String)""), false));
        this.assertRangesEqual(expectedRanges, actualRanges);
    }

    public void assertRangesEqual(List<MultiRowRangeFilter.RowRange> expected, List<MultiRowRangeFilter.RowRange> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertTrue((boolean)Bytes.equals((byte[])expected.get(i).getStartRow(), (byte[])actual.get(i).getStartRow()));
            Assert.assertTrue((expected.get(i).isStartRowInclusive() == actual.get(i).isStartRowInclusive() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])expected.get(i).getStopRow(), (byte[])actual.get(i).getStopRow()));
            Assert.assertTrue((expected.get(i).isStopRowInclusive() == actual.get(i).isStopRowInclusive() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMultiRowRangeFilterWithRangeOverlap() throws IOException {
        this.tableName = Bytes.toBytes((String)"testMultiRowRangeFilterWithRangeOverlap");
        HTable ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.setMaxVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)15), true, Bytes.toBytes((int)40), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)65), true, Bytes.toBytes((int)75), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)60), true, null, false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)60), true, Bytes.toBytes((int)80), false));
        MultiRowRangeFilter filter = new MultiRowRangeFilter(ranges);
        scan.setFilter((Filter)filter);
        int resultsSize = this.getResultsSize(ht, scan);
        this.LOG.info((Object)("found " + resultsSize + " results"));
        List<Cell> results1 = this.getScanResult(Bytes.toBytes((int)10), Bytes.toBytes((int)40), ht);
        List<Cell> results2 = this.getScanResult(Bytes.toBytes((int)60), Bytes.toBytes((String)""), ht);
        Assert.assertEquals((long)(results1.size() + results2.size()), (long)resultsSize);
        ht.close();
    }

    @Test
    public void testMultiRowRangeFilterWithoutRangeOverlap() throws IOException {
        this.tableName = Bytes.toBytes((String)"testMultiRowRangeFilterWithoutRangeOverlap");
        HTable ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.setMaxVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)40), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)60), true, Bytes.toBytes((int)70), false));
        MultiRowRangeFilter filter = new MultiRowRangeFilter(ranges);
        scan.setFilter((Filter)filter);
        int resultsSize = this.getResultsSize(ht, scan);
        this.LOG.info((Object)("found " + resultsSize + " results"));
        List<Cell> results1 = this.getScanResult(Bytes.toBytes((int)10), Bytes.toBytes((int)20), ht);
        List<Cell> results2 = this.getScanResult(Bytes.toBytes((int)30), Bytes.toBytes((int)40), ht);
        List<Cell> results3 = this.getScanResult(Bytes.toBytes((int)60), Bytes.toBytes((int)70), ht);
        Assert.assertEquals((long)(results1.size() + results2.size() + results3.size()), (long)resultsSize);
        ht.close();
    }

    @Test
    public void testMultiRowRangeFilterWithEmptyStartRow() throws IOException {
        this.tableName = Bytes.toBytes((String)"testMultiRowRangeFilterWithEmptyStartRow");
        HTable ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.setMaxVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((String)""), true, Bytes.toBytes((int)10), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)40), false));
        MultiRowRangeFilter filter = new MultiRowRangeFilter(ranges);
        scan.setFilter((Filter)filter);
        int resultsSize = this.getResultsSize(ht, scan);
        List<Cell> results1 = this.getScanResult(Bytes.toBytes((String)""), Bytes.toBytes((int)10), ht);
        List<Cell> results2 = this.getScanResult(Bytes.toBytes((int)30), Bytes.toBytes((int)40), ht);
        Assert.assertEquals((long)(results1.size() + results2.size()), (long)resultsSize);
        ht.close();
    }

    @Test
    public void testMultiRowRangeFilterWithEmptyStopRow() throws IOException {
        this.tableName = Bytes.toBytes((String)"testMultiRowRangeFilterWithEmptyStopRow");
        HTable ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.setMaxVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((String)""), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)40), false));
        MultiRowRangeFilter filter = new MultiRowRangeFilter(ranges);
        scan.setFilter((Filter)filter);
        int resultsSize = this.getResultsSize(ht, scan);
        List<Cell> results1 = this.getScanResult(Bytes.toBytes((int)10), Bytes.toBytes((String)""), ht);
        Assert.assertEquals((long)results1.size(), (long)resultsSize);
        ht.close();
    }

    @Test
    public void testMultiRowRangeFilterWithInclusive() throws IOException {
        this.tableName = Bytes.toBytes((String)"testMultiRowRangeFilterWithInclusive");
        HTable ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.setMaxVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)20), true, Bytes.toBytes((int)40), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)65), true, Bytes.toBytes((int)75), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)60), true, null, false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)60), true, Bytes.toBytes((int)80), false));
        MultiRowRangeFilter filter = new MultiRowRangeFilter(ranges);
        scan.setFilter((Filter)filter);
        int resultsSize = this.getResultsSize(ht, scan);
        this.LOG.info((Object)("found " + resultsSize + " results"));
        List<Cell> results1 = this.getScanResult(Bytes.toBytes((int)10), Bytes.toBytes((int)40), ht);
        List<Cell> results2 = this.getScanResult(Bytes.toBytes((int)60), Bytes.toBytes((String)""), ht);
        Assert.assertEquals((long)(results1.size() + results2.size()), (long)resultsSize);
        ht.close();
    }

    @Test
    public void testMultiRowRangeFilterWithExclusive() throws IOException {
        this.tableName = Bytes.toBytes((String)"testMultiRowRangeFilterWithExclusive");
        HTable ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.setMaxVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)20), false, Bytes.toBytes((int)40), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)65), true, Bytes.toBytes((int)75), false));
        MultiRowRangeFilter filter = new MultiRowRangeFilter(ranges);
        scan.setFilter((Filter)filter);
        int resultsSize = this.getResultsSize(ht, scan);
        this.LOG.info((Object)("found " + resultsSize + " results"));
        List<Cell> results1 = this.getScanResult(Bytes.toBytes((int)10), Bytes.toBytes((int)40), ht);
        List<Cell> results2 = this.getScanResult(Bytes.toBytes((int)65), Bytes.toBytes((int)75), ht);
        Assert.assertEquals((long)(results1.size() - 1 + results2.size()), (long)resultsSize);
        ht.close();
    }

    @Test
    public void testMultiRowRangeWithFilterListAndOperator() throws IOException {
        this.tableName = Bytes.toBytes((String)"TestMultiRowRangeFilterWithFilterListAndOperator");
        HTable ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.setMaxVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges1 = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges1.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges1.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)40), false));
        ranges1.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)60), true, Bytes.toBytes((int)70), false));
        MultiRowRangeFilter filter1 = new MultiRowRangeFilter(ranges1);
        ArrayList<MultiRowRangeFilter.RowRange> ranges2 = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges2.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)20), true, Bytes.toBytes((int)40), false));
        ranges2.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)80), true, Bytes.toBytes((int)90), false));
        MultiRowRangeFilter filter2 = new MultiRowRangeFilter(ranges2);
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        filterList.addFilter((Filter)filter1);
        filterList.addFilter((Filter)filter2);
        scan.setFilter((Filter)filterList);
        int resultsSize = this.getResultsSize(ht, scan);
        this.LOG.info((Object)("found " + resultsSize + " results"));
        List<Cell> results1 = this.getScanResult(Bytes.toBytes((int)30), Bytes.toBytes((int)40), ht);
        Assert.assertEquals((long)results1.size(), (long)resultsSize);
        ht.close();
    }

    @Test
    public void testMultiRowRangeWithFilterListOrOperator() throws IOException {
        this.tableName = Bytes.toBytes((String)"TestMultiRowRangeFilterWithFilterListOrOperator");
        HTable ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.setMaxVersions();
        ArrayList<MultiRowRangeFilter.RowRange> ranges1 = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges1.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)40), false));
        ranges1.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges1.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)60), true, Bytes.toBytes((int)70), false));
        MultiRowRangeFilter filter1 = new MultiRowRangeFilter(ranges1);
        ArrayList<MultiRowRangeFilter.RowRange> ranges2 = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges2.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)20), true, Bytes.toBytes((int)40), false));
        ranges2.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)80), true, Bytes.toBytes((int)90), false));
        MultiRowRangeFilter filter2 = new MultiRowRangeFilter(ranges2);
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        filterList.addFilter((Filter)filter1);
        filterList.addFilter((Filter)filter2);
        scan.setFilter((Filter)filterList);
        int resultsSize = this.getResultsSize(ht, scan);
        this.LOG.info((Object)("found " + resultsSize + " results"));
        List<Cell> results1 = this.getScanResult(Bytes.toBytes((int)10), Bytes.toBytes((int)40), ht);
        List<Cell> results2 = this.getScanResult(Bytes.toBytes((int)60), Bytes.toBytes((int)70), ht);
        List<Cell> results3 = this.getScanResult(Bytes.toBytes((int)80), Bytes.toBytes((int)90), ht);
        Assert.assertEquals((long)(results1.size() + results2.size() + results3.size()), (long)resultsSize);
        ht.close();
    }

    private void generateRows(int numberOfRows, HTable ht, byte[] family, byte[] qf, byte[] value) throws IOException {
        for (int i = 0; i < numberOfRows; ++i) {
            byte[] row = Bytes.toBytes((int)i);
            Put p = new Put(row);
            p.add(family, qf, value);
            ht.put(p);
        }
        TEST_UTIL.flush();
    }

    private List<Cell> getScanResult(byte[] startRow, byte[] stopRow, HTable ht) throws IOException {
        Result r;
        Scan scan = new Scan();
        scan.setMaxVersions();
        if (!Bytes.toString((byte[])startRow).isEmpty()) {
            scan.setStartRow(startRow);
        }
        if (!Bytes.toString((byte[])stopRow).isEmpty()) {
            scan.setStopRow(stopRow);
        }
        ResultScanner scanner = ht.getScanner(scan);
        ArrayList<Cell> kvList = new ArrayList<Cell>();
        while ((r = scanner.next()) != null) {
            for (Cell kv : r.listCells()) {
                kvList.add(kv);
            }
        }
        return kvList;
    }

    private int getResultsSize(HTable ht, Scan scan) throws IOException {
        Result r;
        ResultScanner scanner = ht.getScanner(scan);
        ArrayList<Cell> results = new ArrayList<Cell>();
        while ((r = scanner.next()) != null) {
            for (Cell kv : r.listCells()) {
                results.add(kv);
            }
        }
        return results.size();
    }
}

