/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.exceptions.OutOfOrderScannerNextException;
import org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServer;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerSource;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapper;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapperStub;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestRpcMetrics {
    public MetricsAssertHelper HELPER = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);

    @Test
    public void testFactory() {
        MetricsHBaseServer masterMetrics = new MetricsHBaseServer("HMaster", (MetricsHBaseServerWrapper)new MetricsHBaseServerWrapperStub());
        MetricsHBaseServerSource masterSource = masterMetrics.getMetricsSource();
        MetricsHBaseServer rsMetrics = new MetricsHBaseServer("HRegionServer", (MetricsHBaseServerWrapper)new MetricsHBaseServerWrapperStub());
        MetricsHBaseServerSource rsSource = rsMetrics.getMetricsSource();
        Assert.assertEquals((Object)"master", (Object)masterSource.getMetricsContext());
        Assert.assertEquals((Object)"regionserver", (Object)rsSource.getMetricsContext());
        Assert.assertEquals((Object)"Master,sub=IPC", (Object)masterSource.getMetricsJmxContext());
        Assert.assertEquals((Object)"RegionServer,sub=IPC", (Object)rsSource.getMetricsJmxContext());
        Assert.assertEquals((Object)"Master", (Object)masterSource.getMetricsName());
        Assert.assertEquals((Object)"RegionServer", (Object)rsSource.getMetricsName());
    }

    @Test
    public void testWrapperSource() {
        MetricsHBaseServer mrpc = new MetricsHBaseServer("HMaster", (MetricsHBaseServerWrapper)new MetricsHBaseServerWrapperStub());
        MetricsHBaseServerSource serverSource = mrpc.getMetricsSource();
        this.HELPER.assertGauge("queueSize", 101L, (BaseSource)serverSource);
        this.HELPER.assertGauge("numCallsInGeneralQueue", 102L, (BaseSource)serverSource);
        this.HELPER.assertGauge("numCallsInReplicationQueue", 103L, (BaseSource)serverSource);
        this.HELPER.assertGauge("numCallsInPriorityQueue", 104L, (BaseSource)serverSource);
        this.HELPER.assertGauge("numOpenConnections", 105L, (BaseSource)serverSource);
        this.HELPER.assertGauge("numActiveHandler", 106L, (BaseSource)serverSource);
    }

    @Test
    public void testSourceMethods() {
        int i;
        MetricsHBaseServer mrpc = new MetricsHBaseServer("HMaster", (MetricsHBaseServerWrapper)new MetricsHBaseServerWrapperStub());
        MetricsHBaseServerSource serverSource = mrpc.getMetricsSource();
        for (i = 0; i < 12; ++i) {
            mrpc.authenticationFailure();
        }
        for (i = 0; i < 13; ++i) {
            mrpc.authenticationSuccess();
        }
        this.HELPER.assertCounter("authenticationFailures", 12L, (BaseSource)serverSource);
        this.HELPER.assertCounter("authenticationSuccesses", 13L, (BaseSource)serverSource);
        for (i = 0; i < 14; ++i) {
            mrpc.authorizationSuccess();
        }
        for (i = 0; i < 15; ++i) {
            mrpc.authorizationFailure();
        }
        this.HELPER.assertCounter("authorizationSuccesses", 14L, (BaseSource)serverSource);
        this.HELPER.assertCounter("authorizationFailures", 15L, (BaseSource)serverSource);
        mrpc.dequeuedCall(100);
        mrpc.processedCall(101);
        mrpc.totalCall(102);
        this.HELPER.assertCounter("queueCallTime_NumOps", 1L, (BaseSource)serverSource);
        this.HELPER.assertCounter("processCallTime_NumOps", 1L, (BaseSource)serverSource);
        this.HELPER.assertCounter("totalCallTime_NumOps", 1L, (BaseSource)serverSource);
        mrpc.sentBytes(103L);
        mrpc.sentBytes(103L);
        mrpc.sentBytes(103L);
        mrpc.receivedBytes(104);
        mrpc.receivedBytes(104);
        this.HELPER.assertCounter("sentBytes", 309L, (BaseSource)serverSource);
        this.HELPER.assertCounter("receivedBytes", 208L, (BaseSource)serverSource);
        mrpc.exception(null);
        this.HELPER.assertCounter("exceptions", 1L, (BaseSource)serverSource);
        mrpc.exception((Throwable)new RegionMovedException(ServerName.parseServerName((String)"localhost:60020"), 100L));
        mrpc.exception((Throwable)new RegionTooBusyException());
        mrpc.exception((Throwable)new OutOfOrderScannerNextException());
        mrpc.exception((Throwable)new NotServingRegionException());
        this.HELPER.assertCounter("exceptions.RegionMovedException", 1L, (BaseSource)serverSource);
        this.HELPER.assertCounter("exceptions.RegionTooBusyException", 1L, (BaseSource)serverSource);
        this.HELPER.assertCounter("exceptions.OutOfOrderScannerNextException", 1L, (BaseSource)serverSource);
        this.HELPER.assertCounter("exceptions.NotServingRegionException", 1L, (BaseSource)serverSource);
        this.HELPER.assertCounter("exceptions", 5L, (BaseSource)serverSource);
    }

    @Test
    public void testServerContextNameWithHostName() {
        String[] masterServerNames = new String[]{"master/node-xyz/10.19.250.253:16020", "master/node-regionserver-xyz/10.19.250.253:16020", "HMaster/node-xyz/10.19.250.253:16020", "HMaster/node-regionserver-xyz/10.19.250.253:16020"};
        String[] regionServerNames = new String[]{"regionserver/node-xyz/10.19.250.253:16020", "regionserver/node-master1-xyz/10.19.250.253:16020", "HRegionserver/node-xyz/10.19.250.253:16020", "HRegionserver/node-master1-xyz/10.19.250.253:16020"};
        MetricsHBaseServerSource masterSource = null;
        for (String serverName : masterServerNames) {
            masterSource = new MetricsHBaseServer(serverName, (MetricsHBaseServerWrapper)new MetricsHBaseServerWrapperStub()).getMetricsSource();
            Assert.assertEquals((Object)"master", (Object)masterSource.getMetricsContext());
            Assert.assertEquals((Object)"Master,sub=IPC", (Object)masterSource.getMetricsJmxContext());
            Assert.assertEquals((Object)"Master", (Object)masterSource.getMetricsName());
        }
        MetricsHBaseServerSource rsSource = null;
        for (String serverName : regionServerNames) {
            rsSource = new MetricsHBaseServer(serverName, (MetricsHBaseServerWrapper)new MetricsHBaseServerWrapperStub()).getMetricsSource();
            Assert.assertEquals((Object)"regionserver", (Object)rsSource.getMetricsContext());
            Assert.assertEquals((Object)"RegionServer,sub=IPC", (Object)rsSource.getMetricsJmxContext());
            Assert.assertEquals((Object)"RegionServer", (Object)rsSource.getMetricsName());
        }
    }
}

