/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.CoordinatedStateException;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.CoordinatedStateManagerFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaMockingUtil;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MockRegionServer;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.RegionServerTracker;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestMasterNoCluster {
    private static final Log LOG = LogFactory.getLog(TestMasterNoCluster.class);
    private static final HBaseTestingUtility TESTUTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration c = TESTUTIL.getConfiguration();
        FSUtils.setRootDir((Configuration)c, (Path)TESTUTIL.getDataTestDir());
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
        TESTUTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TESTUTIL.shutdownMiniZKCluster();
    }

    @After
    public void tearDown() throws KeeperException, ZooKeeperConnectionException, IOException {
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(TESTUTIL.getConfiguration(), "@Before", new Abortable(){

            public void abort(String why, Throwable e) {
                throw new RuntimeException(why, e);
            }

            public boolean isAborted() {
                return false;
            }
        });
        ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)zkw.baseZNode);
        zkw.close();
    }

    @Test(timeout=30000L)
    public void testStopDuringStart() throws IOException, KeeperException, InterruptedException {
        CoordinatedStateManager cp = CoordinatedStateManagerFactory.getCoordinatedStateManager((Configuration)TESTUTIL.getConfiguration());
        HMaster master = new HMaster(TESTUTIL.getConfiguration(), cp);
        master.start();
        master.stopMaster();
        master.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testFailover() throws IOException, KeeperException, InterruptedException, ServiceException {
        long now = System.currentTimeMillis();
        ServerName sn0 = ServerName.valueOf((String)"0.example.org", (int)0, (long)now);
        ServerName sn1 = ServerName.valueOf((String)"1.example.org", (int)1, (long)now);
        ServerName sn2 = ServerName.valueOf((String)"2.example.org", (int)2, (long)now);
        final ServerName[] sns = new ServerName[]{sn0, sn1, sn2};
        Configuration conf = TESTUTIL.getConfiguration();
        MockRegionServer rs0 = new MockRegionServer(conf, sn0);
        MockRegionServer rs1 = new MockRegionServer(conf, sn1);
        MockRegionServer rs2 = new MockRegionServer(conf, sn2);
        MetaTableLocator.setMetaLocation((ZooKeeperWatcher)rs0.getZooKeeper(), (ServerName)rs0.getServerName(), (RegionState.State)RegionState.State.OPEN);
        TableName tableName = TableName.valueOf((String)"t");
        Result[] results = new Result[]{MetaMockingUtil.getMetaTableRowResult(new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HBaseTestingUtility.KEYS[1]), rs2.getServerName()), MetaMockingUtil.getMetaTableRowResult(new HRegionInfo(tableName, HBaseTestingUtility.KEYS[1], HBaseTestingUtility.KEYS[2]), rs2.getServerName()), MetaMockingUtil.getMetaTableRowResult(new HRegionInfo(tableName, HBaseTestingUtility.KEYS[2], HConstants.EMPTY_END_ROW), rs2.getServerName())};
        rs1.setNextResults(HRegionInfo.FIRST_META_REGIONINFO.getRegionName(), results);
        CoordinatedStateManager cp = CoordinatedStateManagerFactory.getCoordinatedStateManager((Configuration)TESTUTIL.getConfiguration());
        final ClusterConnection mockedConnection = HConnectionTestingUtility.getMockedConnectionAndDecorate(TESTUTIL.getConfiguration(), rs0, rs0, rs0.getServerName(), HRegionInfo.FIRST_META_REGIONINFO);
        HMaster master = new HMaster(conf, cp){

            InetAddress getRemoteInetAddress(int port, long serverStartCode) throws UnknownHostException {
                if (port > sns.length) {
                    return super.getRemoteInetAddress(port, serverStartCode);
                }
                ServerName sn = sns[port];
                return InetAddress.getByAddress(sn.getHostname(), new byte[]{10, 0, 0, (byte)sn.getPort()});
            }

            ServerManager createServerManager(Server master, MasterServices services) throws IOException {
                ServerManager sm = super.createServerManager(master, services);
                ServerManager spy = (ServerManager)Mockito.spy((Object)sm);
                ((ServerManager)Mockito.doReturn((Object)true).when((Object)spy)).sendRegionClose((ServerName)Mockito.any(), (HRegionInfo)Mockito.any(), Mockito.anyInt(), (ServerName)Mockito.any(), Mockito.anyBoolean());
                return spy;
            }

            public ClusterConnection getConnection() {
                return mockedConnection;
            }

            void initNamespace() {
            }
        };
        master.start();
        try {
            while (!master.serviceStarted) {
                Threads.sleep((long)10L);
            }
            for (int i = 0; i < sns.length; ++i) {
                RegionServerStatusProtos.RegionServerReportRequest.Builder request = RegionServerStatusProtos.RegionServerReportRequest.newBuilder();
                ServerName sn = ServerName.parseVersionedServerName((byte[])sns[i].getVersionedBytes());
                request.setServer(ProtobufUtil.toServerName((ServerName)sn));
                request.setLoad(ServerLoad.EMPTY_SERVERLOAD.obtainServerLoadPB());
                master.getMasterRpcServices().regionServerReport(null, request.build());
            }
            ZooKeeperWatcher zkw = master.getZooKeeper();
            while (!master.isInitialized()) {
                ZKAssign.transitionNodeClosed((ZooKeeperWatcher)zkw, (HRegionInfo)HRegionInfo.FIRST_META_REGIONINFO, (ServerName)sn0, (int)-1);
                Threads.sleep((long)100L);
            }
            Assert.assertTrue((boolean)master.isInitialized());
        }
        finally {
            rs0.stop("Test is done");
            rs1.stop("Test is done");
            rs2.stop("Test is done");
            master.stopMaster();
            master.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotPullingDeadRegionServerFromZK() throws IOException, KeeperException, InterruptedException {
        Configuration conf = TESTUTIL.getConfiguration();
        final ServerName newServer = ServerName.valueOf((String)"test.sample", (int)1, (long)101L);
        final ServerName deadServer = ServerName.valueOf((String)"test.sample", (int)1, (long)100L);
        final MockRegionServer rs0 = new MockRegionServer(conf, newServer);
        CoordinatedStateManager cp = CoordinatedStateManagerFactory.getCoordinatedStateManager((Configuration)TESTUTIL.getConfiguration());
        HMaster master = new HMaster(conf, cp){

            void assignMeta(MonitoredTask status, Set<ServerName> previouslyFailedMeatRSs, int replicaId) {
            }

            void initializeZKBasedSystemTrackers() throws IOException, InterruptedException, KeeperException, CoordinatedStateException {
                super.initializeZKBasedSystemTrackers();
                this.serverManager.recordNewServerWithLock(newServer, ServerLoad.EMPTY_SERVERLOAD);
                ArrayList<ServerName> onlineServers = new ArrayList<ServerName>();
                onlineServers.add(deadServer);
                onlineServers.add(newServer);
                this.regionServerTracker = (RegionServerTracker)Mockito.spy((Object)this.regionServerTracker);
                ((RegionServerTracker)Mockito.doReturn(onlineServers).when((Object)this.regionServerTracker)).getOnlineServers();
            }

            public ClusterConnection getConnection() {
                try {
                    return HConnectionTestingUtility.getMockedConnectionAndDecorate(TESTUTIL.getConfiguration(), rs0, rs0, rs0.getServerName(), HRegionInfo.FIRST_META_REGIONINFO);
                }
                catch (IOException e) {
                    return null;
                }
            }

            void initNamespace() {
            }
        };
        master.start();
        try {
            while (!master.initialized) {
                Threads.sleep((long)10L);
            }
            LOG.info((Object)"Master is initialized");
            Assert.assertFalse((String)"The dead server should not be pulled in", (boolean)master.serverManager.isServerOnline(deadServer));
        }
        finally {
            master.stopMaster();
            master.join();
        }
    }
}

