/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.balancer.RegionLocationFinder;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestRegionLocationFinder {
    private static final Log LOG = LogFactory.getLog(TestRegionLocationFinder.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static MiniHBaseCluster cluster;
    private static final TableName tableName;
    private static final byte[] FAMILY;
    private static Table table;
    private static final int ServerNum = 5;
    private static RegionLocationFinder finder;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        cluster = TEST_UTIL.startMiniCluster(1, 5);
        table = TEST_UTIL.createTable(tableName, FAMILY, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        TEST_UTIL.waitTableAvailable(tableName, 1000L);
        TEST_UTIL.loadTable(table, FAMILY);
        for (int i = 0; i < 5; ++i) {
            HRegionServer server = cluster.getRegionServer(i);
            for (Region region : server.getOnlineRegions(tableName)) {
                region.flush(true);
            }
        }
        finder.setConf(TEST_UTIL.getConfiguration());
        finder.setServices((MasterServices)cluster.getMaster());
        finder.setClusterStatus(cluster.getMaster().getClusterStatus());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        table.close();
        TEST_UTIL.deleteTable(tableName);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testInternalGetTopBlockLocation() throws Exception {
        for (int i = 0; i < 5; ++i) {
            HRegionServer server = cluster.getRegionServer(i);
            for (Region region : server.getOnlineRegions(tableName)) {
                List topHosts;
                List servers = finder.internalGetTopBlockLocation(region.getRegionInfo());
                if (region.getHDFSBlocksDistribution().getUniqueBlocksTotalWeight() == 0L || !(topHosts = region.getHDFSBlocksDistribution().getTopHosts()).contains(server.getServerName().getHostname())) continue;
                for (int j = 0; j < 5; ++j) {
                    ServerName serverName = cluster.getRegionServer(j).getServerName();
                    Assert.assertTrue((boolean)servers.contains(serverName));
                }
            }
        }
    }

    @Test
    public void testMapHostNameToServerName() throws Exception {
        ArrayList<String> topHosts = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            HRegionServer server = cluster.getRegionServer(i);
            String serverHost = server.getServerName().getHostname();
            if (topHosts.contains(serverHost)) continue;
            topHosts.add(serverHost);
        }
        List servers = finder.mapHostNameToServerName(topHosts);
        Assert.assertEquals((long)1L, (long)topHosts.size());
        for (int i = 0; i < 5; ++i) {
            ServerName server = cluster.getRegionServer(i).getServerName();
            Assert.assertTrue((boolean)servers.contains(server));
        }
    }

    @Test
    public void testGetTopBlockLocations() throws Exception {
        for (int i = 0; i < 5; ++i) {
            HRegionServer server = cluster.getRegionServer(i);
            for (Region region : server.getOnlineRegions(tableName)) {
                List topHosts;
                List servers = finder.getTopBlockLocations(region.getRegionInfo());
                if (region.getHDFSBlocksDistribution().getUniqueBlocksTotalWeight() == 0L || !(topHosts = region.getHDFSBlocksDistribution().getTopHosts()).contains(server.getServerName().getHostname())) continue;
                for (int j = 0; j < 5; ++j) {
                    ServerName serverName = cluster.getRegionServer(j).getServerName();
                    Assert.assertTrue((boolean)servers.contains(serverName));
                }
            }
        }
    }

    static {
        tableName = TableName.valueOf((String)"table");
        FAMILY = Bytes.toBytes((String)"cf");
        finder = new RegionLocationFinder();
    }
}

