/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StorefileRefresherChore;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.StoppableImplementation;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestStoreFileRefresherChore {
    private HBaseTestingUtility TEST_UTIL;
    private Path testDir;

    @Before
    public void setUp() throws IOException {
        this.TEST_UTIL = new HBaseTestingUtility();
        this.testDir = this.TEST_UTIL.getDataTestDir("TestStoreFileRefresherChore");
        FSUtils.setRootDir((Configuration)this.TEST_UTIL.getConfiguration(), (Path)this.testDir);
    }

    private HTableDescriptor getTableDesc(TableName tableName, byte[] ... families) {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family);
            hcd.setMaxVersions(Integer.MAX_VALUE);
            htd.addFamily(hcd);
        }
        return htd;
    }

    private Region initHRegion(HTableDescriptor htd, byte[] startKey, byte[] stopKey, int replicaId) throws IOException {
        Configuration conf = this.TEST_UTIL.getConfiguration();
        Path tableDir = FSUtils.getTableDir((Path)this.testDir, (TableName)htd.getTableName());
        HRegionInfo info = new HRegionInfo(htd.getTableName(), startKey, stopKey, false, 0L, replicaId);
        FailingHRegionFileSystem fs = new FailingHRegionFileSystem(conf, tableDir.getFileSystem(conf), tableDir, info);
        Configuration walConf = new Configuration(conf);
        FSUtils.setRootDir((Configuration)walConf, (Path)tableDir);
        WALFactory wals = new WALFactory(walConf, null, "log_" + replicaId);
        HRegion region = new HRegion((HRegionFileSystem)fs, wals.getWAL(info.getEncodedNameAsBytes()), conf, htd, null);
        region.initialize();
        return region;
    }

    private void putData(Region region, int startRow, int numRows, byte[] qf, byte[] ... families) throws IOException {
        for (int i = startRow; i < startRow + numRows; ++i) {
            Put put = new Put(Bytes.toBytes((String)("" + i)));
            put.setDurability(Durability.SKIP_WAL);
            for (byte[] family : families) {
                put.add(family, qf, null);
            }
            region.put(put);
        }
    }

    private void verifyData(Region newReg, int startRow, int numRows, byte[] qf, byte[] ... families) throws IOException {
        for (int i = startRow; i < startRow + numRows; ++i) {
            byte[] row = Bytes.toBytes((String)("" + i));
            Get get = new Get(row);
            for (byte[] family : families) {
                get.addColumn(family, qf);
            }
            Result result = newReg.get(get);
            Cell[] raw = result.rawCells();
            Assert.assertEquals((long)families.length, (long)result.size());
            for (int j = 0; j < families.length; ++j) {
                Assert.assertTrue((boolean)CellUtil.matchingRow((Cell)raw[j], (byte[])row));
                Assert.assertTrue((boolean)CellUtil.matchingFamily((Cell)raw[j], (byte[])families[j]));
                Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)raw[j], (byte[])qf));
            }
        }
    }

    @Test(timeout=60000L)
    public void testIsStale() throws IOException {
        int period = 0;
        byte[][] families = new byte[][]{Bytes.toBytes((String)"cf")};
        byte[] qf = Bytes.toBytes((String)"cq");
        HRegionServer regionServer = (HRegionServer)Mockito.mock(HRegionServer.class);
        ArrayList<Region> regions = new ArrayList<Region>();
        Mockito.when((Object)regionServer.getOnlineRegionsLocalContext()).thenReturn(regions);
        Mockito.when((Object)regionServer.getConfiguration()).thenReturn((Object)this.TEST_UTIL.getConfiguration());
        HTableDescriptor htd = this.getTableDesc(TableName.valueOf((String)"testIsStale"), families);
        Region primary = this.initHRegion(htd, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, 0);
        Region replica1 = this.initHRegion(htd, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, 1);
        regions.add(primary);
        regions.add(replica1);
        StaleStorefileRefresherChore chore = new StaleStorefileRefresherChore(period, regionServer, new StoppableImplementation());
        this.putData(primary, 0, 100, qf, families);
        primary.flush(true);
        this.verifyData(primary, 0, 100, qf, families);
        try {
            this.verifyData(replica1, 0, 100, qf, families);
            Assert.fail((String)"should have failed");
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        chore.chore();
        this.verifyData(replica1, 0, 100, qf, families);
        ((FailingHRegionFileSystem)((HRegion)replica1).getRegionFileSystem()).fail = true;
        this.putData(primary, 100, 100, qf, families);
        primary.flush(true);
        this.verifyData(primary, 0, 200, qf, families);
        chore.chore();
        this.verifyData(replica1, 0, 100, qf, families);
        try {
            this.verifyData(replica1, 100, 100, qf, families);
            Assert.fail((String)"should have failed");
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        chore.isStale = true;
        chore.chore();
        try {
            this.verifyData(replica1, 0, 100, qf, families);
            Assert.fail((String)"should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static class StaleStorefileRefresherChore
    extends StorefileRefresherChore {
        boolean isStale = false;

        public StaleStorefileRefresherChore(int period, HRegionServer regionServer, Stoppable stoppable) {
            super(period, false, regionServer, stoppable);
        }

        protected boolean isRegionStale(String encodedName, long time) {
            return this.isStale;
        }
    }

    static class FailingHRegionFileSystem
    extends HRegionFileSystem {
        boolean fail = false;

        FailingHRegionFileSystem(Configuration conf, FileSystem fs, Path tableDir, HRegionInfo regionInfo) {
            super(conf, fs, tableDir, regionInfo);
        }

        public Collection<StoreFileInfo> getStoreFiles(String familyName) throws IOException {
            if (this.fail) {
                throw new IOException("simulating FS failure");
            }
            return super.getStoreFiles(familyName);
        }
    }
}

