/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.List;
import java.util.SortedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.zookeeper.KeeperException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class TestReplicationStateBasic {
    protected ReplicationQueues rq1;
    protected ReplicationQueues rq2;
    protected ReplicationQueues rq3;
    protected ReplicationQueuesClient rqc;
    protected String server1 = ServerName.valueOf((String)"hostname1.example.org", (int)1234, (long)-1L).toString();
    protected String server2 = ServerName.valueOf((String)"hostname2.example.org", (int)1234, (long)-1L).toString();
    protected String server3 = ServerName.valueOf((String)"hostname3.example.org", (int)1234, (long)-1L).toString();
    protected ReplicationPeers rp;
    protected static final String ID_ONE = "1";
    protected static final String ID_TWO = "2";
    protected static String KEY_ONE;
    protected static String KEY_TWO;
    protected String OUR_ID = "3";
    protected String OUR_KEY;
    protected static int zkTimeoutCount;
    protected static final int ZK_MAX_COUNT = 300;
    protected static final int ZK_SLEEP_INTERVAL = 100;
    private static final Log LOG;

    @Before
    public void setUp() {
        zkTimeoutCount = 0;
    }

    @Test
    public void testReplicationQueuesClient() throws ReplicationException, KeeperException {
        this.rqc.init();
        Assert.assertEquals((long)0L, (long)this.rqc.getListOfReplicators().size());
        Assert.assertNull((Object)this.rqc.getLogsInQueue(this.server1, "qId1"));
        Assert.assertNull((Object)this.rqc.getAllQueues(this.server1));
        this.rq1.init(this.server1);
        this.rq2.init(this.server2);
        this.rq1.addLog("qId1", "trash");
        this.rq1.removeLog("qId1", "trash");
        this.rq1.addLog("qId2", "filename1");
        this.rq1.addLog("qId3", "filename2");
        this.rq1.addLog("qId3", "filename3");
        this.rq2.addLog("trash", "trash");
        this.rq2.removeQueue("trash");
        List reps = this.rqc.getListOfReplicators();
        Assert.assertEquals((long)2L, (long)reps.size());
        Assert.assertTrue((String)this.server1, (boolean)reps.contains(this.server1));
        Assert.assertTrue((String)this.server2, (boolean)reps.contains(this.server2));
        Assert.assertNull((Object)this.rqc.getLogsInQueue("bogus", "bogus"));
        Assert.assertNull((Object)this.rqc.getLogsInQueue(this.server1, "bogus"));
        Assert.assertEquals((long)0L, (long)this.rqc.getLogsInQueue(this.server1, "qId1").size());
        Assert.assertEquals((long)1L, (long)this.rqc.getLogsInQueue(this.server1, "qId2").size());
        Assert.assertEquals((Object)"filename1", this.rqc.getLogsInQueue(this.server1, "qId2").get(0));
        Assert.assertNull((Object)this.rqc.getAllQueues("bogus"));
        Assert.assertEquals((long)0L, (long)this.rqc.getAllQueues(this.server2).size());
        List list = this.rqc.getAllQueues(this.server1);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("qId2"));
        Assert.assertTrue((boolean)list.contains("qId3"));
    }

    @Test
    public void testReplicationQueues() throws ReplicationException {
        this.rq1.init(this.server1);
        this.rq2.init(this.server2);
        this.rq3.init(this.server3);
        this.rp.init();
        Assert.assertEquals((long)3L, (long)this.rq1.getListOfReplicators().size());
        this.rq1.removeQueue("bogus");
        this.rq1.removeLog("bogus", "bogus");
        this.rq1.removeAllQueues();
        Assert.assertNull((Object)this.rq1.getAllQueues());
        Assert.assertEquals((long)0L, (long)this.rq1.getLogPosition("bogus", "bogus"));
        Assert.assertNull((Object)this.rq1.getLogsInQueue("bogus"));
        Assert.assertEquals((long)0L, (long)this.rq1.claimQueues(ServerName.valueOf((String)"bogus", (int)1234, (long)-1L).toString()).size());
        this.rq1.setLogPosition("bogus", "bogus", 5L);
        this.populateQueues();
        Assert.assertEquals((long)3L, (long)this.rq1.getListOfReplicators().size());
        Assert.assertEquals((long)0L, (long)this.rq2.getLogsInQueue("qId1").size());
        Assert.assertEquals((long)5L, (long)this.rq3.getLogsInQueue("qId5").size());
        Assert.assertEquals((long)0L, (long)this.rq3.getLogPosition("qId1", "filename0"));
        this.rq3.setLogPosition("qId5", "filename4", 354L);
        Assert.assertEquals((long)354L, (long)this.rq3.getLogPosition("qId5", "filename4"));
        Assert.assertEquals((long)5L, (long)this.rq3.getLogsInQueue("qId5").size());
        Assert.assertEquals((long)0L, (long)this.rq2.getLogsInQueue("qId1").size());
        Assert.assertEquals((long)0L, (long)this.rq1.getAllQueues().size());
        Assert.assertEquals((long)1L, (long)this.rq2.getAllQueues().size());
        Assert.assertEquals((long)5L, (long)this.rq3.getAllQueues().size());
        Assert.assertEquals((long)0L, (long)this.rq3.claimQueues(this.server1).size());
        Assert.assertEquals((long)2L, (long)this.rq3.getListOfReplicators().size());
        SortedMap queues = this.rq2.claimQueues(this.server3);
        Assert.assertEquals((long)5L, (long)queues.size());
        Assert.assertEquals((long)1L, (long)this.rq2.getListOfReplicators().size());
        Assert.assertEquals((long)0L, (long)this.rq2.claimQueues(this.server2).size());
        Assert.assertEquals((long)6L, (long)this.rq2.getAllQueues().size());
        this.rq2.removeAllQueues();
        Assert.assertEquals((long)0L, (long)this.rq2.getListOfReplicators().size());
    }

    @Test
    public void testReplicationPeers() throws Exception {
        this.rp.init();
        try {
            this.rp.removePeer("bogus");
            Assert.fail((String)"Should have thrown an IllegalArgumentException when passed a bogus peerId");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.rp.enablePeer("bogus");
            Assert.fail((String)"Should have thrown an IllegalArgumentException when passed a bogus peerId");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.rp.disablePeer("bogus");
            Assert.fail((String)"Should have thrown an IllegalArgumentException when passed a bogus peerId");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.rp.getStatusOfPeer("bogus");
            Assert.fail((String)"Should have thrown an IllegalArgumentException when passed a bogus peerId");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.rp.peerAdded("bogus"));
        this.rp.peerRemoved("bogus");
        Assert.assertNull((Object)this.rp.getPeerConf("bogus"));
        this.assertNumberOfPeers(0);
        this.rp.addPeer(ID_ONE, new ReplicationPeerConfig().setClusterKey(KEY_ONE), null);
        this.assertNumberOfPeers(1);
        this.rp.addPeer(ID_TWO, new ReplicationPeerConfig().setClusterKey(KEY_TWO), null);
        this.assertNumberOfPeers(2);
        try {
            this.rp.getStatusOfPeer(ID_ONE);
            Assert.fail((String)"There are no connected peers, should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)KEY_ONE, (Object)ZKUtil.getZooKeeperClusterKey((Configuration)((Configuration)this.rp.getPeerConf(ID_ONE).getSecond())));
        this.rp.removePeer(ID_ONE);
        this.rp.peerRemoved(ID_ONE);
        this.assertNumberOfPeers(1);
        this.rp.addPeer(ID_ONE, new ReplicationPeerConfig().setClusterKey(KEY_ONE), null);
        this.rp.peerAdded(ID_ONE);
        this.assertNumberOfPeers(2);
        Assert.assertTrue((boolean)this.rp.getStatusOfPeer(ID_ONE));
        this.rp.disablePeer(ID_ONE);
        this.assertConnectedPeerStatus(false, ID_ONE);
        this.rp.enablePeer(ID_ONE);
        this.assertConnectedPeerStatus(true, ID_ONE);
        this.rp.peerRemoved(ID_ONE);
        this.assertNumberOfPeers(2);
        try {
            this.rp.getStatusOfPeer(ID_ONE);
            Assert.fail((String)"There are no connected peers, should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void assertConnectedPeerStatus(boolean status, String peerId) throws Exception {
        if (status != this.rp.getStatusOfPeerFromBackingStore(peerId)) {
            Assert.fail((String)("ConnectedPeerStatus was " + !status + " but expected " + status + " in ZK"));
        }
        while (status != this.rp.getStatusOfPeer(peerId)) {
            if (zkTimeoutCount < 300) {
                LOG.debug((Object)("ConnectedPeerStatus was " + !status + " but expected " + status + ", sleeping and trying again."));
                Thread.sleep(100L);
                continue;
            }
            Assert.fail((String)("Timed out waiting for ConnectedPeerStatus to be " + status));
        }
        return;
    }

    protected void assertNumberOfPeers(int total) {
        Assert.assertEquals((long)total, (long)this.rp.getAllPeerConfigs().size());
        Assert.assertEquals((long)total, (long)this.rp.getAllPeerIds().size());
        Assert.assertEquals((long)total, (long)this.rp.getAllPeerIds().size());
    }

    protected void populateQueues() throws ReplicationException {
        this.rq1.addLog("trash", "trash");
        this.rq1.removeQueue("trash");
        this.rq2.addLog("qId1", "trash");
        this.rq2.removeLog("qId1", "trash");
        for (int i = 1; i < 6; ++i) {
            for (int j = 0; j < i; ++j) {
                this.rq3.addLog("qId" + i, "filename" + j);
            }
            this.rp.addPeer("qId" + i, new ReplicationPeerConfig().setClusterKey("bogus" + i), null);
        }
    }

    static {
        LOG = LogFactory.getLog(TestReplicationStateBasic.class);
    }
}

