/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.common.collect.ListMultimap;
import com.google.protobuf.BlockingRpcChannel;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestNamespaceCommands
extends SecureTestUtil {
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final Log LOG = LogFactory.getLog(TestNamespaceCommands.class);
    private static String TEST_NAMESPACE = "ns1";
    private static String TEST_NAMESPACE2 = "ns2";
    private static Configuration conf;
    private static MasterCoprocessorEnvironment CP_ENV;
    private static AccessController ACCESS_CONTROLLER;
    private static User SUPERUSER;
    private static User USER_GLOBAL_ADMIN;
    private static User USER_GLOBAL_CREATE;
    private static User USER_GLOBAL_WRITE;
    private static User USER_GLOBAL_READ;
    private static User USER_GLOBAL_EXEC;
    private static User USER_NS_ADMIN;
    private static User USER_NS_CREATE;
    private static User USER_NS_WRITE;
    private static User USER_NS_READ;
    private static User USER_NS_EXEC;
    private static User USER_TABLE_WRITE;
    private static User USER_TABLE_CREATE;
    private static final String GROUP_ADMIN = "group_admin";
    private static final String GROUP_NS_ADMIN = "group_ns_admin";
    private static final String GROUP_CREATE = "group_create";
    private static final String GROUP_READ = "group_read";
    private static final String GROUP_WRITE = "group_write";
    private static User USER_GROUP_ADMIN;
    private static User USER_GROUP_NS_ADMIN;
    private static User USER_GROUP_CREATE;
    private static User USER_GROUP_READ;
    private static User USER_GROUP_WRITE;
    private static String TEST_TABLE;
    private static byte[] TEST_FAMILY;

    @BeforeClass
    public static void beforeClass() throws Exception {
        conf = UTIL.getConfiguration();
        TestNamespaceCommands.enableSecurity(conf);
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        USER_GLOBAL_ADMIN = User.createUserForTesting((Configuration)conf, (String)"global_admin", (String[])new String[0]);
        USER_GLOBAL_CREATE = User.createUserForTesting((Configuration)conf, (String)"global_create", (String[])new String[0]);
        USER_GLOBAL_WRITE = User.createUserForTesting((Configuration)conf, (String)"global_write", (String[])new String[0]);
        USER_GLOBAL_READ = User.createUserForTesting((Configuration)conf, (String)"global_read", (String[])new String[0]);
        USER_GLOBAL_EXEC = User.createUserForTesting((Configuration)conf, (String)"global_exec", (String[])new String[0]);
        USER_NS_ADMIN = User.createUserForTesting((Configuration)conf, (String)"namespace_admin", (String[])new String[0]);
        USER_NS_CREATE = User.createUserForTesting((Configuration)conf, (String)"namespace_create", (String[])new String[0]);
        USER_NS_WRITE = User.createUserForTesting((Configuration)conf, (String)"namespace_write", (String[])new String[0]);
        USER_NS_READ = User.createUserForTesting((Configuration)conf, (String)"namespace_read", (String[])new String[0]);
        USER_NS_EXEC = User.createUserForTesting((Configuration)conf, (String)"namespace_exec", (String[])new String[0]);
        USER_TABLE_CREATE = User.createUserForTesting((Configuration)conf, (String)"table_create", (String[])new String[0]);
        USER_TABLE_WRITE = User.createUserForTesting((Configuration)conf, (String)"table_write", (String[])new String[0]);
        USER_GROUP_ADMIN = User.createUserForTesting((Configuration)conf, (String)"user_group_admin", (String[])new String[]{GROUP_ADMIN});
        USER_GROUP_NS_ADMIN = User.createUserForTesting((Configuration)conf, (String)"user_group_ns_admin", (String[])new String[]{GROUP_NS_ADMIN});
        USER_GROUP_CREATE = User.createUserForTesting((Configuration)conf, (String)"user_group_create", (String[])new String[]{GROUP_CREATE});
        USER_GROUP_READ = User.createUserForTesting((Configuration)conf, (String)"user_group_read", (String[])new String[]{GROUP_READ});
        USER_GROUP_WRITE = User.createUserForTesting((Configuration)conf, (String)"user_group_write", (String[])new String[]{GROUP_WRITE});
        UTIL.startMiniCluster();
        UTIL.waitTableAvailable(AccessControlLists.ACL_TABLE_NAME.getName(), 30000L);
        ACCESS_CONTROLLER = (AccessController)UTIL.getMiniHBaseCluster().getMaster().getMasterCoprocessorHost().findCoprocessor(AccessController.class.getName());
        UTIL.getHBaseAdmin().createNamespace(NamespaceDescriptor.create((String)TEST_NAMESPACE).build());
        UTIL.getHBaseAdmin().createNamespace(NamespaceDescriptor.create((String)TEST_NAMESPACE2).build());
        TestNamespaceCommands.grantGlobal(UTIL, USER_GLOBAL_ADMIN.getShortName(), Permission.Action.ADMIN);
        TestNamespaceCommands.grantGlobal(UTIL, USER_GLOBAL_CREATE.getShortName(), Permission.Action.CREATE);
        TestNamespaceCommands.grantGlobal(UTIL, USER_GLOBAL_WRITE.getShortName(), Permission.Action.WRITE);
        TestNamespaceCommands.grantGlobal(UTIL, USER_GLOBAL_READ.getShortName(), Permission.Action.READ);
        TestNamespaceCommands.grantGlobal(UTIL, USER_GLOBAL_EXEC.getShortName(), Permission.Action.EXEC);
        TestNamespaceCommands.grantOnNamespace(UTIL, USER_NS_ADMIN.getShortName(), TEST_NAMESPACE, Permission.Action.ADMIN);
        TestNamespaceCommands.grantOnNamespace(UTIL, USER_NS_CREATE.getShortName(), TEST_NAMESPACE, Permission.Action.CREATE);
        TestNamespaceCommands.grantOnNamespace(UTIL, USER_NS_WRITE.getShortName(), TEST_NAMESPACE, Permission.Action.WRITE);
        TestNamespaceCommands.grantOnNamespace(UTIL, USER_NS_READ.getShortName(), TEST_NAMESPACE, Permission.Action.READ);
        TestNamespaceCommands.grantOnNamespace(UTIL, USER_NS_EXEC.getShortName(), TEST_NAMESPACE, Permission.Action.EXEC);
        TestNamespaceCommands.grantOnNamespace(UTIL, AuthUtil.toGroupEntry((String)GROUP_NS_ADMIN), TEST_NAMESPACE, Permission.Action.ADMIN);
        TestNamespaceCommands.grantOnNamespace(UTIL, USER_NS_ADMIN.getShortName(), TEST_NAMESPACE2, Permission.Action.ADMIN);
        TestNamespaceCommands.grantGlobal(UTIL, AuthUtil.toGroupEntry((String)GROUP_ADMIN), Permission.Action.ADMIN);
        TestNamespaceCommands.grantGlobal(UTIL, AuthUtil.toGroupEntry((String)GROUP_CREATE), Permission.Action.CREATE);
        TestNamespaceCommands.grantGlobal(UTIL, AuthUtil.toGroupEntry((String)GROUP_READ), Permission.Action.READ);
        TestNamespaceCommands.grantGlobal(UTIL, AuthUtil.toGroupEntry((String)GROUP_WRITE), Permission.Action.WRITE);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.getHBaseAdmin().deleteNamespace(TEST_NAMESPACE);
        UTIL.getHBaseAdmin().deleteNamespace(TEST_NAMESPACE2);
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testAclTableEntries() throws Exception {
        String userTestNamespace = "userTestNsp";
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
             Table acl = conn.getTable(AccessControlLists.ACL_TABLE_NAME);){
            ListMultimap perms = AccessControlLists.getNamespacePermissions((Configuration)conf, (String)TEST_NAMESPACE);
            perms = AccessControlLists.getNamespacePermissions((Configuration)conf, (String)TEST_NAMESPACE);
            for (Map.Entry entry : perms.entries()) {
                LOG.debug((Object)entry);
            }
            Assert.assertEquals((long)6L, (long)perms.size());
            TestNamespaceCommands.grantOnNamespace(UTIL, userTestNamespace, TEST_NAMESPACE, Permission.Action.WRITE);
            Result result = acl.get(new Get(Bytes.toBytes((String)userTestNamespace)));
            Assert.assertTrue((result != null ? 1 : 0) != 0);
            perms = AccessControlLists.getNamespacePermissions((Configuration)conf, (String)TEST_NAMESPACE);
            Assert.assertEquals((long)7L, (long)perms.size());
            List namespacePerms = perms.get((Object)userTestNamespace);
            Assert.assertTrue((boolean)perms.containsKey((Object)userTestNamespace));
            Assert.assertEquals((long)1L, (long)namespacePerms.size());
            Assert.assertEquals((Object)TEST_NAMESPACE, (Object)((TablePermission)namespacePerms.get(0)).getNamespace());
            Assert.assertEquals(null, (Object)((TablePermission)namespacePerms.get(0)).getFamily());
            Assert.assertEquals(null, (Object)((TablePermission)namespacePerms.get(0)).getQualifier());
            Assert.assertEquals((long)1L, (long)((TablePermission)namespacePerms.get(0)).getActions().length);
            Assert.assertEquals((Object)Permission.Action.WRITE, (Object)((TablePermission)namespacePerms.get(0)).getActions()[0]);
            TestNamespaceCommands.revokeFromNamespace(UTIL, userTestNamespace, TEST_NAMESPACE, Permission.Action.WRITE);
            perms = AccessControlLists.getNamespacePermissions((Configuration)conf, (String)TEST_NAMESPACE);
            Assert.assertEquals((long)6L, (long)perms.size());
        }
    }

    @Test
    public void testModifyNamespace() throws Exception {
        SecureTestUtil.AccessTestAction modifyNamespace = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preModifyNamespace(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), NamespaceDescriptor.create((String)TEST_NAMESPACE).addConfiguration("abc", "156").build());
                return null;
            }
        };
        TestNamespaceCommands.verifyAllowed(modifyNamespace, SUPERUSER, USER_GLOBAL_ADMIN, USER_GROUP_ADMIN);
        TestNamespaceCommands.verifyDenied(modifyNamespace, USER_GLOBAL_CREATE, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_ADMIN, USER_NS_CREATE, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test
    public void testCreateAndDeleteNamespace() throws Exception {
        SecureTestUtil.AccessTestAction createNamespace = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preCreateNamespace(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), NamespaceDescriptor.create((String)TEST_NAMESPACE2).build());
                return null;
            }
        };
        SecureTestUtil.AccessTestAction deleteNamespace = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDeleteNamespace(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TEST_NAMESPACE2);
                return null;
            }
        };
        TestNamespaceCommands.verifyAllowed(createNamespace, SUPERUSER, USER_GLOBAL_ADMIN, USER_GROUP_ADMIN);
        TestNamespaceCommands.verifyDenied(createNamespace, USER_GLOBAL_CREATE, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_ADMIN, USER_NS_CREATE, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_TABLE_CREATE, USER_TABLE_WRITE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestNamespaceCommands.verifyAllowed(deleteNamespace, SUPERUSER, USER_GLOBAL_ADMIN, USER_GROUP_ADMIN);
        TestNamespaceCommands.verifyDenied(deleteNamespace, USER_GLOBAL_CREATE, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_ADMIN, USER_NS_CREATE, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_TABLE_CREATE, USER_TABLE_WRITE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test
    public void testGetNamespaceDescriptor() throws Exception {
        SecureTestUtil.AccessTestAction getNamespaceAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preGetNamespaceDescriptor(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TEST_NAMESPACE);
                return null;
            }
        };
        TestNamespaceCommands.verifyAllowed(getNamespaceAction, SUPERUSER, USER_GLOBAL_ADMIN, USER_NS_ADMIN, USER_GROUP_ADMIN);
        TestNamespaceCommands.verifyDenied(getNamespaceAction, USER_GLOBAL_CREATE, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_CREATE, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_TABLE_CREATE, USER_TABLE_WRITE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test
    public void testListNamespaces() throws Exception {
        SecureTestUtil.AccessTestAction listAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Connection unmanagedConnection = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
                Admin admin = unmanagedConnection.getAdmin();
                try {
                    List<NamespaceDescriptor> list = Arrays.asList(admin.listNamespaceDescriptors());
                    return list;
                }
                finally {
                    admin.close();
                    unmanagedConnection.close();
                }
            }
        };
        TestNamespaceCommands.verifyAllowed(listAction, SUPERUSER, USER_GLOBAL_ADMIN, USER_NS_ADMIN, USER_GROUP_ADMIN);
        Assert.assertEquals((long)4L, (long)((List)SUPERUSER.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)4L, (long)((List)USER_GLOBAL_ADMIN.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)4L, (long)((List)USER_GROUP_ADMIN.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)2L, (long)((List)USER_NS_ADMIN.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_GLOBAL_CREATE.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_GLOBAL_WRITE.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_GLOBAL_READ.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_GLOBAL_EXEC.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_NS_CREATE.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_NS_WRITE.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_NS_READ.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_NS_EXEC.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_TABLE_CREATE.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_TABLE_WRITE.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_GROUP_CREATE.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_GROUP_READ.runAs((PrivilegedExceptionAction)listAction)).size());
        Assert.assertEquals((long)0L, (long)((List)USER_GROUP_WRITE.runAs((PrivilegedExceptionAction)listAction)).size());
    }

    @Test
    public void testGrantRevoke() throws Exception {
        String testUser = "testUser";
        SecureTestUtil.AccessTestAction grantAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                     Table acl = conn.getTable(AccessControlLists.ACL_TABLE_NAME);){
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    ProtobufUtil.grant(null, (AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)"testUser", (String)TEST_NAMESPACE, (Permission.Action[])new Permission.Action[]{Permission.Action.WRITE});
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction grantNamespaceAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                     Table acl = conn.getTable(AccessControlLists.ACL_TABLE_NAME);){
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    ProtobufUtil.grant(null, (AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)USER_GROUP_NS_ADMIN.getShortName(), (String)TEST_NAMESPACE, (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction revokeAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                     Table acl = conn.getTable(AccessControlLists.ACL_TABLE_NAME);){
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    ProtobufUtil.revoke(null, (AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)"testUser", (String)TEST_NAMESPACE, (Permission.Action[])new Permission.Action[]{Permission.Action.WRITE});
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction revokeNamespaceAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                Table acl = connection.getTable(AccessControlLists.ACL_TABLE_NAME);
                try {
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    ProtobufUtil.revoke(null, (AccessControlProtos.AccessControlService.BlockingInterface)protocol, (String)USER_GROUP_NS_ADMIN.getShortName(), (String)TEST_NAMESPACE, (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
                }
                finally {
                    acl.close();
                    connection.close();
                }
                return null;
            }
        };
        SecureTestUtil.AccessTestAction getPermissionsAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                     Table acl = conn.getTable(AccessControlLists.ACL_TABLE_NAME);){
                    CoprocessorRpcChannel service = acl.coprocessorService(HConstants.EMPTY_START_ROW);
                    AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
                    ProtobufUtil.getUserPermissions(null, (AccessControlProtos.AccessControlService.BlockingInterface)protocol, (byte[])Bytes.toBytes((String)TEST_NAMESPACE));
                }
                return null;
            }
        };
        TestNamespaceCommands.verifyAllowed(grantAction, SUPERUSER, USER_GLOBAL_ADMIN, USER_GROUP_ADMIN, USER_NS_ADMIN);
        TestNamespaceCommands.verifyDenied(grantAction, USER_GLOBAL_CREATE, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_CREATE, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_TABLE_CREATE, USER_TABLE_WRITE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestNamespaceCommands.verifyAllowed(grantNamespaceAction, SUPERUSER, USER_GLOBAL_ADMIN, USER_GROUP_ADMIN, USER_NS_ADMIN, USER_GROUP_NS_ADMIN);
        TestNamespaceCommands.verifyDenied(grantNamespaceAction, USER_GLOBAL_CREATE, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_CREATE, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_TABLE_CREATE, USER_TABLE_WRITE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestNamespaceCommands.verifyAllowed(revokeAction, SUPERUSER, USER_GLOBAL_ADMIN, USER_GROUP_ADMIN, USER_NS_ADMIN);
        TestNamespaceCommands.verifyDenied(revokeAction, USER_GLOBAL_CREATE, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_CREATE, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_TABLE_CREATE, USER_TABLE_WRITE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestNamespaceCommands.verifyAllowed(revokeNamespaceAction, SUPERUSER, USER_GLOBAL_ADMIN, USER_GROUP_ADMIN, USER_NS_ADMIN, USER_GROUP_NS_ADMIN);
        TestNamespaceCommands.verifyDenied(revokeNamespaceAction, USER_GLOBAL_CREATE, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_CREATE, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_TABLE_CREATE, USER_TABLE_WRITE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
        TestNamespaceCommands.verifyAllowed(getPermissionsAction, SUPERUSER, USER_GLOBAL_ADMIN, USER_NS_ADMIN, USER_GROUP_ADMIN);
        TestNamespaceCommands.verifyDenied(getPermissionsAction, USER_GLOBAL_CREATE, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_CREATE, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_TABLE_CREATE, USER_TABLE_WRITE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_CREATE);
    }

    @Test
    public void testCreateTableWithNamespace() throws Exception {
        SecureTestUtil.AccessTestAction createTable = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)TEST_TABLE));
                htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
                ACCESS_CONTROLLER.preCreateTable(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), htd, null);
                return null;
            }
        };
        TestNamespaceCommands.verifyAllowed(createTable, SUPERUSER, USER_GLOBAL_CREATE, USER_NS_CREATE, USER_GROUP_CREATE);
        TestNamespaceCommands.verifyDenied(createTable, USER_GLOBAL_ADMIN, USER_GLOBAL_WRITE, USER_GLOBAL_READ, USER_GLOBAL_EXEC, USER_NS_ADMIN, USER_NS_WRITE, USER_NS_READ, USER_NS_EXEC, USER_TABLE_CREATE, USER_TABLE_WRITE, USER_GROUP_READ, USER_GROUP_WRITE, USER_GROUP_ADMIN);
    }

    static {
        TEST_TABLE = TEST_NAMESPACE + ":testtable";
        TEST_FAMILY = Bytes.toBytes((String)"f1");
    }
}

