/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.BlockingService;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import com.google.protobuf.TextFormat;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hadoop.hbase.io.BoundedByteBufferPool;
import org.apache.hadoop.hbase.io.ByteBufferOutputStream;
import org.apache.hadoop.hbase.ipc.BadAuthException;
import org.apache.hadoop.hbase.ipc.BufferChain;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.EmptyServiceNameException;
import org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hadoop.hbase.ipc.HBaseRPCErrorHandler;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServer;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapperImpl;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RpcCallContext;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcSchedulerContext;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.UnknownServiceException;
import org.apache.hadoop.hbase.ipc.UnsupportedCellCodecException;
import org.apache.hadoop.hbase.ipc.UnsupportedCompressionCodecException;
import org.apache.hadoop.hbase.ipc.WrongVersionException;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.AuthMethod;
import org.apache.hadoop.hbase.security.HBasePolicyProvider;
import org.apache.hadoop.hbase.security.HBaseSaslRpcServer;
import org.apache.hadoop.hbase.security.SaslStatus;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSecretManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Counter;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.authorize.ServiceAuthorizationManager;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.StringUtils;
import org.apache.htrace.TraceInfo;
import org.codehaus.jackson.map.ObjectMapper;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix"})
@InterfaceStability.Evolving
public class RpcServer
implements RpcServerInterface {
    public static final Log LOG = LogFactory.getLog(RpcServer.class);
    private static final CallQueueTooBigException CALL_QUEUE_TOO_BIG_EXCEPTION = new CallQueueTooBigException();
    private final boolean authorize;
    private boolean isSecurityEnabled;
    public static final byte CURRENT_VERSION = 0;
    static final int DEFAULT_MAX_CALLQUEUE_LENGTH_PER_HANDLER = 10;
    private static final int DEFAULT_MAX_CALLQUEUE_SIZE = 0x40000000;
    private static final String WARN_DELAYED_CALLS = "hbase.ipc.warn.delayedrpc.number";
    private static final int DEFAULT_WARN_DELAYED_CALLS = 1000;
    private final int warnDelayedCalls;
    private AtomicInteger delayedCalls;
    private final IPCUtil ipcUtil;
    private static final String AUTH_FAILED_FOR = "Auth failed for ";
    private static final String AUTH_SUCCESSFUL_FOR = "Auth successful for ";
    private static final Log AUDITLOG = LogFactory.getLog((String)("SecurityLogger." + Server.class.getName()));
    protected SecretManager<TokenIdentifier> secretManager;
    protected ServiceAuthorizationManager authManager;
    protected static final ThreadLocal<Call> CurCall = new ThreadLocal();
    static final ThreadLocal<MonitoredRPCHandler> MONITORED_RPC = new ThreadLocal();
    protected final InetSocketAddress bindAddress;
    protected int port;
    private int readThreads;
    protected int maxIdleTime;
    protected int thresholdIdleConnections;
    int maxConnectionsToNuke;
    protected MetricsHBaseServer metrics;
    protected final Configuration conf;
    private int maxQueueSize;
    protected int socketSendBufferSize;
    protected final boolean tcpNoDelay;
    protected final boolean tcpKeepAlive;
    protected final long purgeTimeout;
    volatile boolean running = true;
    volatile boolean started = false;
    protected final Counter callQueueSize = new Counter();
    protected final List<Connection> connectionList = Collections.synchronizedList(new LinkedList());
    private Listener listener = null;
    protected Responder responder = null;
    protected AuthenticationTokenSecretManager authTokenSecretMgr = null;
    protected int numConnections = 0;
    protected HBaseRPCErrorHandler errorHandler = null;
    private static final String WARN_RESPONSE_TIME = "hbase.ipc.warn.response.time";
    private static final String WARN_RESPONSE_SIZE = "hbase.ipc.warn.response.size";
    private static final int DEFAULT_WARN_RESPONSE_TIME = 10000;
    private static final int DEFAULT_WARN_RESPONSE_SIZE = 0x6400000;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final int warnResponseTime;
    private final int warnResponseSize;
    private final Server server;
    private final List<BlockingServiceAndInterface> services;
    private final RpcScheduler scheduler;
    private UserProvider userProvider;
    private final BoundedByteBufferPool reservoir;
    private RSRpcServices rsRpcServices;
    private static int NIO_BUFFER_LIMIT = 65536;

    public RpcServer(Server server, String name, List<BlockingServiceAndInterface> services, InetSocketAddress bindAddress, Configuration conf, RpcScheduler scheduler) throws IOException {
        this.reservoir = new BoundedByteBufferPool(conf.getInt("hbase.ipc.server.reservoir.max.buffer.size", 0x100000), conf.getInt("hbase.ipc.server.reservoir.initial.buffer.size", 16384), conf.getInt("hbase.ipc.server.reservoir.initial.max", conf.getInt("hbase.regionserver.handler.count", 30) * 2));
        this.server = server;
        this.services = services;
        this.bindAddress = bindAddress;
        this.conf = conf;
        this.socketSendBufferSize = 0;
        this.maxQueueSize = this.conf.getInt("hbase.ipc.server.max.callqueue.size", 0x40000000);
        this.readThreads = conf.getInt("hbase.ipc.server.read.threadpool.size", 10);
        this.maxIdleTime = 2 * conf.getInt("hbase.ipc.client.connection.maxidletime", 1000);
        this.maxConnectionsToNuke = conf.getInt("hbase.ipc.client.kill.max", 10);
        this.thresholdIdleConnections = conf.getInt("hbase.ipc.client.idlethreshold", 4000);
        this.purgeTimeout = conf.getLong("hbase.ipc.client.call.purge.timeout", 120000L);
        this.warnResponseTime = conf.getInt(WARN_RESPONSE_TIME, 10000);
        this.warnResponseSize = conf.getInt(WARN_RESPONSE_SIZE, 0x6400000);
        this.listener = new Listener(name);
        this.port = this.listener.getAddress().getPort();
        this.metrics = new MetricsHBaseServer(name, new MetricsHBaseServerWrapperImpl(this));
        this.tcpNoDelay = conf.getBoolean("hbase.ipc.server.tcpnodelay", true);
        this.tcpKeepAlive = conf.getBoolean("hbase.ipc.server.tcpkeepalive", true);
        this.warnDelayedCalls = conf.getInt(WARN_DELAYED_CALLS, 1000);
        this.delayedCalls = new AtomicInteger(0);
        this.ipcUtil = new IPCUtil(conf);
        this.responder = new Responder();
        this.authorize = conf.getBoolean("hadoop.security.authorization", false);
        this.userProvider = UserProvider.instantiate((Configuration)conf);
        this.isSecurityEnabled = this.userProvider.isHBaseSecurityEnabled();
        if (this.isSecurityEnabled) {
            HBaseSaslRpcServer.init(conf);
        }
        this.scheduler = scheduler;
        this.scheduler.init(new RpcSchedulerContext(this));
    }

    protected Connection getConnection(SocketChannel channel, long time) {
        return new Connection(channel, time);
    }

    private void setupResponse(ByteArrayOutputStream response, Call call, Throwable t, String error) throws IOException {
        if (response != null) {
            response.reset();
        }
        call.setResponse(null, null, t, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection(Connection connection) {
        List<Connection> list = this.connectionList;
        synchronized (list) {
            if (this.connectionList.remove(connection)) {
                --this.numConnections;
            }
        }
        connection.close();
    }

    Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setSocketSendBufSize(int size) {
        this.socketSendBufferSize = size;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.authTokenSecretMgr = this.createSecretManager();
        if (this.authTokenSecretMgr != null) {
            this.setSecretManager(this.authTokenSecretMgr);
            this.authTokenSecretMgr.start();
        }
        this.authManager = new ServiceAuthorizationManager();
        HBasePolicyProvider.init(this.conf, this.authManager);
        this.responder.start();
        this.listener.start();
        this.scheduler.start();
        this.started = true;
    }

    @Override
    public void refreshAuthManager(PolicyProvider pp) {
        this.authManager.refresh(this.conf, pp);
    }

    private AuthenticationTokenSecretManager createSecretManager() {
        if (!this.isSecurityEnabled) {
            return null;
        }
        if (this.server == null) {
            return null;
        }
        Configuration conf = this.server.getConfiguration();
        long keyUpdateInterval = conf.getLong("hbase.auth.key.update.interval", 86400000L);
        long maxAge = conf.getLong("hbase.auth.token.max.lifetime", 604800000L);
        return new AuthenticationTokenSecretManager(conf, this.server.getZooKeeper(), this.server.getServerName().toString(), keyUpdateInterval, maxAge);
    }

    public SecretManager<? extends TokenIdentifier> getSecretManager() {
        return this.secretManager;
    }

    public void setSecretManager(SecretManager<? extends TokenIdentifier> secretManager) {
        this.secretManager = secretManager;
    }

    @Override
    public Pair<Message, CellScanner> call(BlockingService service, Descriptors.MethodDescriptor md, Message param, CellScanner cellScanner, long receiveTime, MonitoredRPCHandler status) throws IOException {
        try {
            boolean tooLarge;
            status.setRPC(md.getName(), new Object[]{param}, receiveTime);
            status.setRPCPacket(param);
            status.resume("Servicing call");
            long startTime = System.currentTimeMillis();
            PayloadCarryingRpcController controller = new PayloadCarryingRpcController(cellScanner);
            Message result = service.callBlockingMethod(md, (RpcController)controller, param);
            long endTime = System.currentTimeMillis();
            int processingTime = (int)(endTime - startTime);
            int qTime = (int)(startTime - receiveTime);
            int totalTime = (int)(endTime - receiveTime);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(CurCall.get().toString() + ", response " + TextFormat.shortDebugString((MessageOrBuilder)result) + " queueTime: " + qTime + " processingTime: " + processingTime + " totalTime: " + totalTime));
            }
            this.metrics.dequeuedCall(qTime);
            this.metrics.processedCall(processingTime);
            this.metrics.totalCall(totalTime);
            long responseSize = result.getSerializedSize();
            boolean tooSlow = processingTime > this.warnResponseTime && this.warnResponseTime > -1;
            boolean bl = tooLarge = responseSize > (long)this.warnResponseSize && this.warnResponseSize > -1;
            if (tooSlow || tooLarge) {
                this.logResponse(param, md.getName(), md.getName() + "(" + param.getClass().getName() + ")", tooLarge ? "TooLarge" : "TooSlow", status.getClient(), startTime, processingTime, qTime, responseSize);
            }
            return new Pair((Object)result, (Object)controller.cellScanner());
        }
        catch (Throwable e) {
            if (e instanceof ServiceException) {
                if (e.getCause() == null) {
                    LOG.debug((Object)"Caught a ServiceException with null cause", e);
                } else {
                    e = e.getCause();
                }
            }
            this.metrics.exception(e);
            if (e instanceof LinkageError) {
                throw new DoNotRetryIOException(e);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            LOG.error((Object)"Unexpected throwable object ", e);
            throw new IOException(e.getMessage(), e);
        }
    }

    void logResponse(Message param, String methodName, String call, String tag, String clientAddress, long startTime, int processingTime, int qTime, long responseSize) throws IOException {
        long scannerId;
        String scanDetails;
        ClientProtos.ScanRequest request;
        HashMap<String, Object> responseInfo = new HashMap<String, Object>();
        responseInfo.put("starttimems", startTime);
        responseInfo.put("processingtimems", processingTime);
        responseInfo.put("queuetimems", qTime);
        responseInfo.put("responsesize", responseSize);
        responseInfo.put("client", clientAddress);
        responseInfo.put("class", this.server == null ? "" : this.server.getClass().getSimpleName());
        responseInfo.put("method", methodName);
        responseInfo.put("call", call);
        responseInfo.put("param", ProtobufUtil.getShortTextFormat((Message)param));
        if (param instanceof ClientProtos.ScanRequest && this.rsRpcServices != null && (request = (ClientProtos.ScanRequest)param).hasScannerId() && (scanDetails = this.rsRpcServices.getScanDetailsWithId(scannerId = request.getScannerId())) != null) {
            responseInfo.put("scandetails", scanDetails);
        }
        LOG.warn((Object)("(response" + tag + "): " + MAPPER.writeValueAsString(responseInfo)));
    }

    @Override
    public synchronized void stop() {
        LOG.info((Object)("Stopping server on " + this.port));
        this.running = false;
        if (this.authTokenSecretMgr != null) {
            this.authTokenSecretMgr.stop();
            this.authTokenSecretMgr = null;
        }
        this.listener.interrupt();
        this.listener.doStop();
        this.responder.interrupt();
        this.scheduler.stop();
        this.notifyAll();
    }

    @Override
    public synchronized void join() throws InterruptedException {
        while (this.running) {
            this.wait();
        }
    }

    @Override
    public synchronized InetSocketAddress getListenerAddress() {
        if (this.listener == null) {
            return null;
        }
        return this.listener.getAddress();
    }

    @Override
    public void setErrorHandler(HBaseRPCErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public HBaseRPCErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public MetricsHBaseServer getMetrics() {
        return this.metrics;
    }

    @Override
    public void addCallSize(long diff) {
        this.callQueueSize.add(diff);
    }

    public void authorize(UserGroupInformation user, RPCProtos.ConnectionHeader connection, InetAddress addr) throws AuthorizationException {
        if (this.authorize) {
            Class<?> c = RpcServer.getServiceInterface(this.services, connection.getServiceName());
            this.authManager.authorize((UserGroupInformation)(user != null ? user : null), c, this.getConf(), addr);
        }
    }

    protected long channelWrite(GatheringByteChannel channel, BufferChain bufferChain) throws IOException {
        long count = bufferChain.write(channel, NIO_BUFFER_LIMIT);
        if (count > 0L) {
            this.metrics.sentBytes(count);
        }
        return count;
    }

    protected int channelRead(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        int count;
        int n = count = buffer.remaining() <= NIO_BUFFER_LIMIT ? channel.read(buffer) : RpcServer.channelIO(channel, null, buffer);
        if (count > 0) {
            this.metrics.receivedBytes(count);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int channelIO(ReadableByteChannel readCh, WritableByteChannel writeCh, ByteBuffer buf) throws IOException {
        int nBytes;
        int originalLimit = buf.limit();
        int initialRemaining = buf.remaining();
        int ret = 0;
        while (buf.remaining() > 0) {
            try {
                int ioSize = Math.min(buf.remaining(), NIO_BUFFER_LIMIT);
                buf.limit(buf.position() + ioSize);
                ret = readCh == null ? writeCh.write(buf) : readCh.read(buf);
                if (ret >= ioSize) continue;
                break;
            }
            finally {
                buf.limit(originalLimit);
            }
        }
        return (nBytes = initialRemaining - buf.remaining()) > 0 ? nBytes : ret;
    }

    public static RpcCallContext getCurrentCall() {
        return CurCall.get();
    }

    public static boolean isInRpcCallContext() {
        return CurCall.get() != null;
    }

    public static User getRequestUser() {
        RpcCallContext ctx = RpcServer.getCurrentCall();
        return ctx == null ? null : ctx.getRequestUser();
    }

    public static String getRequestUserName() {
        User user = RpcServer.getRequestUser();
        return user == null ? null : user.getShortName();
    }

    public static InetAddress getRemoteAddress() {
        RpcCallContext ctx = RpcServer.getCurrentCall();
        return ctx == null ? null : ctx.getRemoteAddress();
    }

    static BlockingServiceAndInterface getServiceAndInterface(List<BlockingServiceAndInterface> services, String serviceName) {
        for (BlockingServiceAndInterface bs : services) {
            if (!bs.getBlockingService().getDescriptorForType().getName().equals(serviceName)) continue;
            return bs;
        }
        return null;
    }

    static Class<?> getServiceInterface(List<BlockingServiceAndInterface> services, String serviceName) {
        BlockingServiceAndInterface bsasi = RpcServer.getServiceAndInterface(services, serviceName);
        return bsasi == null ? null : bsasi.getServiceInterface();
    }

    static BlockingService getService(List<BlockingServiceAndInterface> services, String serviceName) {
        BlockingServiceAndInterface bsasi = RpcServer.getServiceAndInterface(services, serviceName);
        return bsasi == null ? null : bsasi.getBlockingService();
    }

    static MonitoredRPCHandler getStatus() {
        MonitoredRPCHandler status = MONITORED_RPC.get();
        if (status != null) {
            return status;
        }
        status = TaskMonitor.get().createRPCStatus(Thread.currentThread().getName());
        status.pause("Waiting for a call");
        MONITORED_RPC.set(status);
        return status;
    }

    public static InetAddress getRemoteIp() {
        Call call = CurCall.get();
        if (call != null && call.connection.socket != null) {
            return call.connection.socket.getInetAddress();
        }
        return null;
    }

    public static void bind(ServerSocket socket, InetSocketAddress address, int backlog) throws IOException {
        try {
            socket.bind(address, backlog);
        }
        catch (BindException e) {
            BindException bindException = new BindException("Problem binding to " + address + " : " + e.getMessage());
            bindException.initCause(e);
            throw bindException;
        }
        catch (SocketException e) {
            if ("Unresolved address".equals(e.getMessage())) {
                throw new UnknownHostException("Invalid hostname for server: " + address.getHostName());
            }
            throw e;
        }
    }

    @Override
    public RpcScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public void setRsRpcServices(RSRpcServices rsRpcServices) {
        this.rsRpcServices = rsRpcServices;
    }

    public static class BlockingServiceAndInterface {
        private final BlockingService service;
        private final Class<?> serviceInterface;

        public BlockingServiceAndInterface(BlockingService service, Class<?> serviceInterface) {
            this.service = service;
            this.serviceInterface = serviceInterface;
        }

        public Class<?> getServiceInterface() {
            return this.serviceInterface;
        }

        public BlockingService getBlockingService() {
            return this.service;
        }
    }

    @SuppressWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="False positive according to http://sourceforge.net/p/findbugs/bugs/1032/")
    public class Connection {
        private boolean connectionPreambleRead = false;
        private boolean connectionHeaderRead = false;
        protected SocketChannel channel;
        private ByteBuffer data;
        private ByteBuffer dataLengthBuffer;
        protected final ConcurrentLinkedDeque<Call> responseQueue = new ConcurrentLinkedDeque();
        private final Lock responseWriteLock = new ReentrantLock();
        private Counter rpcCount = new Counter();
        private long lastContact;
        private InetAddress addr;
        protected Socket socket;
        protected String hostAddress;
        protected int remotePort;
        RPCProtos.ConnectionHeader connectionHeader;
        private Codec codec;
        private CompressionCodec compressionCodec;
        BlockingService service;
        protected UserGroupInformation user = null;
        private AuthMethod authMethod;
        private boolean saslContextEstablished;
        private boolean skipInitialSaslHandshake;
        private ByteBuffer unwrappedData;
        private ByteBuffer unwrappedDataLengthBuffer = ByteBuffer.allocate(4);
        boolean useSasl;
        SaslServer saslServer;
        private boolean useWrap = false;
        private static final int AUTHORIZATION_FAILED_CALLID = -1;
        private final Call authFailedCall = new Call(-1, null, null, null, null, null, this, null, 0L, null, null);
        private ByteArrayOutputStream authFailedResponse = new ByteArrayOutputStream();
        private static final int SASL_CALLID = -33;
        private final Call saslCall = new Call(-33, this.service, null, null, null, null, this, null, 0L, null, null);
        public UserGroupInformation attemptingUser = null;

        public Connection(SocketChannel channel, long lastContact) {
            this.channel = channel;
            this.lastContact = lastContact;
            this.data = null;
            this.dataLengthBuffer = ByteBuffer.allocate(4);
            this.socket = channel.socket();
            this.addr = this.socket.getInetAddress();
            this.hostAddress = this.addr == null ? "*Unknown*" : this.addr.getHostAddress();
            this.remotePort = this.socket.getPort();
            if (RpcServer.this.socketSendBufferSize != 0) {
                try {
                    this.socket.setSendBufferSize(RpcServer.this.socketSendBufferSize);
                }
                catch (IOException e) {
                    LOG.warn((Object)("Connection: unable to set socket send buffer size to " + RpcServer.this.socketSendBufferSize));
                }
            }
        }

        public String toString() {
            return this.getHostAddress() + ":" + this.remotePort;
        }

        public String getHostAddress() {
            return this.hostAddress;
        }

        public InetAddress getHostInetAddress() {
            return this.addr;
        }

        public int getRemotePort() {
            return this.remotePort;
        }

        public void setLastContact(long lastContact) {
            this.lastContact = lastContact;
        }

        public RPCProtos.VersionInfo getVersionInfo() {
            if (this.connectionHeader.hasVersionInfo()) {
                return this.connectionHeader.getVersionInfo();
            }
            return null;
        }

        private boolean isIdle() {
            return this.rpcCount.get() == 0L;
        }

        protected void decRpcCount() {
            this.rpcCount.decrement();
        }

        protected void incRpcCount() {
            this.rpcCount.increment();
        }

        protected boolean timedOut(long currentTime) {
            return this.isIdle() && currentTime - this.lastContact > (long)RpcServer.this.maxIdleTime;
        }

        private UserGroupInformation getAuthorizedUgi(String authorizedId) throws IOException {
            if (this.authMethod == AuthMethod.DIGEST) {
                TokenIdentifier tokenId = HBaseSaslRpcServer.getIdentifier(authorizedId, RpcServer.this.secretManager);
                UserGroupInformation ugi = tokenId.getUser();
                if (ugi == null) {
                    throw new AccessDeniedException("Can't retrieve username from tokenIdentifier.");
                }
                ugi.addTokenIdentifier(tokenId);
                return ugi;
            }
            return UserGroupInformation.createRemoteUser((String)authorizedId);
        }

        private void saslReadAndProcess(byte[] saslToken) throws IOException, InterruptedException {
            if (this.saslContextEstablished) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Have read input token of size " + saslToken.length + " for processing by saslServer.unwrap()"));
                }
                if (!this.useWrap) {
                    this.processOneRpc(saslToken);
                } else {
                    byte[] plaintextData = this.saslServer.unwrap(saslToken, 0, saslToken.length);
                    this.processUnwrappedData(plaintextData);
                }
            } else {
                byte[] replyToken;
                try {
                    if (this.saslServer == null) {
                        switch (this.authMethod) {
                            case DIGEST: {
                                if (RpcServer.this.secretManager == null) {
                                    throw new AccessDeniedException("Server is not configured to do DIGEST authentication.");
                                }
                                this.saslServer = Sasl.createSaslServer(AuthMethod.DIGEST.getMechanismName(), null, "default", SaslUtil.SASL_PROPS, new HBaseSaslRpcServer.SaslDigestCallbackHandler(RpcServer.this.secretManager, this));
                                break;
                            }
                            default: {
                                String[] names;
                                UserGroupInformation current = UserGroupInformation.getCurrentUser();
                                String fullName = current.getUserName();
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("Kerberos principal name is " + fullName));
                                }
                                if ((names = SaslUtil.splitKerberosName((String)fullName)).length != 3) {
                                    throw new AccessDeniedException("Kerberos principal name does NOT have the expected hostname part: " + fullName);
                                }
                                current.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                                    @Override
                                    public Object run() throws SaslException {
                                        Connection.this.saslServer = Sasl.createSaslServer(AuthMethod.KERBEROS.getMechanismName(), names[0], names[1], SaslUtil.SASL_PROPS, new HBaseSaslRpcServer.SaslGssCallbackHandler());
                                        return null;
                                    }
                                });
                            }
                        }
                        if (this.saslServer == null) {
                            throw new AccessDeniedException("Unable to find SASL server implementation for " + this.authMethod.getMechanismName());
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Created SASL server with mechanism = " + this.authMethod.getMechanismName()));
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Have read input token of size " + saslToken.length + " for processing by saslServer.evaluateResponse()"));
                    }
                    replyToken = this.saslServer.evaluateResponse(saslToken);
                }
                catch (IOException e) {
                    IOException sendToClient = e;
                    for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                        if (!(cause instanceof SecretManager.InvalidToken)) continue;
                        sendToClient = (SecretManager.InvalidToken)cause;
                        break;
                    }
                    this.doRawSaslReply(SaslStatus.ERROR, null, sendToClient.getClass().getName(), sendToClient.getLocalizedMessage());
                    RpcServer.this.metrics.authenticationFailure();
                    String clientIP = this.toString();
                    AUDITLOG.warn((Object)(RpcServer.AUTH_FAILED_FOR + clientIP + ":" + this.attemptingUser));
                    throw e;
                }
                if (replyToken != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Will send token of size " + replyToken.length + " from saslServer."));
                    }
                    this.doRawSaslReply(SaslStatus.SUCCESS, (Writable)new BytesWritable(replyToken), null, null);
                }
                if (this.saslServer.isComplete()) {
                    String qop = (String)this.saslServer.getNegotiatedProperty("javax.security.sasl.qop");
                    this.useWrap = qop != null && !"auth".equalsIgnoreCase(qop);
                    this.user = this.getAuthorizedUgi(this.saslServer.getAuthorizationID());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("SASL server context established. Authenticated client: " + this.user + ". Negotiated QoP is " + this.saslServer.getNegotiatedProperty("javax.security.sasl.qop")));
                    }
                    RpcServer.this.metrics.authenticationSuccess();
                    AUDITLOG.info((Object)(RpcServer.AUTH_SUCCESSFUL_FOR + this.user));
                    this.saslContextEstablished = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRawSaslReply(SaslStatus status, Writable rv, String errorClass, String error) throws IOException {
            ByteBufferOutputStream saslResponse = null;
            FilterOutputStream out = null;
            try {
                saslResponse = new ByteBufferOutputStream(256);
                out = new DataOutputStream((OutputStream)saslResponse);
                ((DataOutputStream)out).writeInt(status.state);
                if (status == SaslStatus.SUCCESS) {
                    rv.write((DataOutput)((Object)out));
                } else {
                    WritableUtils.writeString((DataOutput)((Object)out), (String)errorClass);
                    WritableUtils.writeString((DataOutput)((Object)out), (String)error);
                }
                this.saslCall.setSaslTokenResponse(saslResponse.getByteBuffer());
                this.saslCall.responder = RpcServer.this.responder;
                this.saslCall.sendResponseIfReady();
            }
            finally {
                if (saslResponse != null) {
                    saslResponse.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }

        private void disposeSasl() {
            if (this.saslServer != null) {
                try {
                    this.saslServer.dispose();
                    this.saslServer = null;
                }
                catch (SaslException saslException) {
                    // empty catch block
                }
            }
        }

        private int readPreamble() throws IOException {
            this.dataLengthBuffer.flip();
            if (!Arrays.equals(HConstants.RPC_HEADER, this.dataLengthBuffer.array())) {
                return this.doBadPreambleHandling("Expected HEADER=" + Bytes.toStringBinary((byte[])HConstants.RPC_HEADER) + " but received HEADER=" + Bytes.toStringBinary((byte[])this.dataLengthBuffer.array()) + " from " + this.toString());
            }
            ByteBuffer versionAndAuthBytes = ByteBuffer.allocate(2);
            int count = RpcServer.this.channelRead(this.channel, versionAndAuthBytes);
            if (count < 0 || versionAndAuthBytes.remaining() > 0) {
                return count;
            }
            byte version = versionAndAuthBytes.get(0);
            byte authbyte = versionAndAuthBytes.get(1);
            this.authMethod = AuthMethod.valueOf((byte)authbyte);
            if (version != 0) {
                String msg = this.getFatalConnectionString(version, authbyte);
                return this.doBadPreambleHandling(msg, (Exception)new WrongVersionException(msg));
            }
            if (this.authMethod == null) {
                String msg = this.getFatalConnectionString(version, authbyte);
                return this.doBadPreambleHandling(msg, (Exception)new BadAuthException(msg));
            }
            if (RpcServer.this.isSecurityEnabled && this.authMethod == AuthMethod.SIMPLE) {
                AccessDeniedException ae = new AccessDeniedException("Authentication is required");
                RpcServer.this.setupResponse(this.authFailedResponse, this.authFailedCall, (Throwable)ae, ae.getMessage());
                RpcServer.this.responder.doRespond(this.authFailedCall);
                throw ae;
            }
            if (!RpcServer.this.isSecurityEnabled && this.authMethod != AuthMethod.SIMPLE) {
                this.doRawSaslReply(SaslStatus.SUCCESS, (Writable)new IntWritable(-88), null, null);
                this.authMethod = AuthMethod.SIMPLE;
                this.skipInitialSaslHandshake = true;
            }
            if (this.authMethod != AuthMethod.SIMPLE) {
                this.useSasl = true;
            }
            this.dataLengthBuffer.clear();
            this.connectionPreambleRead = true;
            return count;
        }

        private int read4Bytes() throws IOException {
            if (this.dataLengthBuffer.remaining() > 0) {
                return RpcServer.this.channelRead(this.channel, this.dataLengthBuffer);
            }
            return 0;
        }

        public int readAndProcess() throws IOException, InterruptedException {
            int count = this.read4Bytes();
            if (count < 0 || this.dataLengthBuffer.remaining() > 0) {
                return count;
            }
            if (!this.connectionPreambleRead) {
                count = this.readPreamble();
                if (!this.connectionPreambleRead) {
                    return count;
                }
                count = this.read4Bytes();
                if (count < 0 || this.dataLengthBuffer.remaining() > 0) {
                    return count;
                }
            }
            if (this.data == null) {
                this.dataLengthBuffer.flip();
                int dataLength = this.dataLengthBuffer.getInt();
                if (dataLength == -1 && !this.useWrap) {
                    this.dataLengthBuffer.clear();
                    return 0;
                }
                if (dataLength < 0) {
                    throw new IllegalArgumentException("Unexpected data length " + dataLength + "!! from " + this.getHostAddress());
                }
                this.data = ByteBuffer.allocate(dataLength);
                this.incRpcCount();
            }
            if ((count = RpcServer.this.channelRead(this.channel, this.data)) >= 0 && this.data.remaining() == 0) {
                this.process();
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void process() throws IOException, InterruptedException {
            this.data.flip();
            try {
                if (this.skipInitialSaslHandshake) {
                    this.skipInitialSaslHandshake = false;
                    return;
                }
                if (this.useSasl) {
                    this.saslReadAndProcess(this.data.array());
                } else {
                    this.processOneRpc(this.data.array());
                }
            }
            finally {
                this.dataLengthBuffer.clear();
                this.data = null;
            }
        }

        private String getFatalConnectionString(int version, byte authByte) {
            return "serverVersion=0, clientVersion=" + version + ", authMethod=" + authByte + ", authSupported=" + (this.authMethod != null) + " from " + this.toString();
        }

        private int doBadPreambleHandling(String msg) throws IOException {
            return this.doBadPreambleHandling(msg, (Exception)new FatalConnectionException(msg));
        }

        private int doBadPreambleHandling(String msg, Exception e) throws IOException {
            LOG.warn((Object)msg);
            Call fakeCall = new Call(-1, null, null, null, null, null, this, RpcServer.this.responder, -1L, null, null);
            RpcServer.this.setupResponse(null, fakeCall, e, msg);
            RpcServer.this.responder.doRespond(fakeCall);
            return -1;
        }

        private void processConnectionHeader(byte[] buf) throws IOException {
            this.connectionHeader = RPCProtos.ConnectionHeader.parseFrom((byte[])buf);
            String serviceName = this.connectionHeader.getServiceName();
            if (serviceName == null) {
                throw new EmptyServiceNameException();
            }
            this.service = RpcServer.getService(RpcServer.this.services, serviceName);
            if (this.service == null) {
                throw new UnknownServiceException(serviceName);
            }
            this.setupCellBlockCodecs(this.connectionHeader);
            UserGroupInformation protocolUser = this.createUser(this.connectionHeader);
            if (!this.useSasl) {
                this.user = protocolUser;
                if (this.user != null) {
                    this.user.setAuthenticationMethod(AuthMethod.SIMPLE.authenticationMethod);
                }
            } else {
                this.user.setAuthenticationMethod(this.authMethod.authenticationMethod);
                if (protocolUser != null && !protocolUser.getUserName().equals(this.user.getUserName())) {
                    if (this.authMethod == AuthMethod.DIGEST) {
                        throw new AccessDeniedException("Authenticated user (" + this.user + ") doesn't match what the client claims to be (" + protocolUser + ")");
                    }
                    UserGroupInformation realUser = this.user;
                    this.user = UserGroupInformation.createProxyUser((String)protocolUser.getUserName(), (UserGroupInformation)realUser);
                    this.user.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.PROXY);
                }
            }
            if (this.connectionHeader.hasVersionInfo()) {
                AUDITLOG.info((Object)("Connection from " + this.hostAddress + " port: " + this.remotePort + " with version info: " + TextFormat.shortDebugString((MessageOrBuilder)this.connectionHeader.getVersionInfo())));
            } else {
                AUDITLOG.info((Object)("Connection from " + this.hostAddress + " port: " + this.remotePort + " with unknown version info"));
            }
        }

        private void setupCellBlockCodecs(RPCProtos.ConnectionHeader header) throws FatalConnectionException {
            if (!header.hasCellBlockCodecClass()) {
                return;
            }
            String className = header.getCellBlockCodecClass();
            if (className == null || className.length() == 0) {
                return;
            }
            try {
                this.codec = (Codec)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                throw new UnsupportedCellCodecException(className, (Throwable)e);
            }
            if (!header.hasCellBlockCompressorClass()) {
                return;
            }
            className = header.getCellBlockCompressorClass();
            try {
                this.compressionCodec = (CompressionCodec)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                throw new UnsupportedCompressionCodecException(className, (Throwable)e);
            }
        }

        private void processUnwrappedData(byte[] inBuf) throws IOException, InterruptedException {
            ReadableByteChannel ch = Channels.newChannel(new ByteArrayInputStream(inBuf));
            int count;
            while (this.unwrappedDataLengthBuffer.remaining() <= 0 || (count = RpcServer.this.channelRead(ch, this.unwrappedDataLengthBuffer)) > 0 && this.unwrappedDataLengthBuffer.remaining() <= 0) {
                if (this.unwrappedData == null) {
                    this.unwrappedDataLengthBuffer.flip();
                    int unwrappedDataLength = this.unwrappedDataLengthBuffer.getInt();
                    if (unwrappedDataLength == -1) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Received ping message");
                        }
                        this.unwrappedDataLengthBuffer.clear();
                        continue;
                    }
                    this.unwrappedData = ByteBuffer.allocate(unwrappedDataLength);
                }
                if ((count = RpcServer.this.channelRead(ch, this.unwrappedData)) <= 0 || this.unwrappedData.remaining() > 0) {
                    return;
                }
                if (this.unwrappedData.remaining() != 0) continue;
                this.unwrappedDataLengthBuffer.clear();
                this.unwrappedData.flip();
                this.processOneRpc(this.unwrappedData.array());
                this.unwrappedData = null;
            }
            return;
        }

        private void processOneRpc(byte[] buf) throws IOException, InterruptedException {
            if (this.connectionHeaderRead) {
                this.processRequest(buf);
            } else {
                this.processConnectionHeader(buf);
                this.connectionHeaderRead = true;
                if (!this.authorizeConnection()) {
                    throw new AccessDeniedException("Connection from " + this + " for service " + this.connectionHeader.getServiceName() + " is unauthorized for user: " + this.user);
                }
            }
        }

        protected void processRequest(byte[] buf) throws IOException, InterruptedException {
            long totalRequestSize = buf.length;
            int offset = 0;
            CodedInputStream cis = CodedInputStream.newInstance((byte[])buf, (int)offset, (int)buf.length);
            int headerSize = cis.readRawVarint32();
            offset = cis.getTotalBytesRead();
            RPCProtos.RequestHeader.Builder builder = RPCProtos.RequestHeader.newBuilder();
            ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])buf, (int)offset, (int)headerSize);
            RPCProtos.RequestHeader header = (RPCProtos.RequestHeader)builder.build();
            offset += headerSize;
            int id = header.getCallId();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("RequestHeader " + TextFormat.shortDebugString((MessageOrBuilder)header) + " totalRequestSize: " + totalRequestSize + " bytes"));
            }
            if (totalRequestSize + RpcServer.this.callQueueSize.get() > (long)RpcServer.this.maxQueueSize) {
                Call callTooBig = new Call(id, this.service, null, null, null, null, this, RpcServer.this.responder, totalRequestSize, null, null);
                ByteArrayOutputStream responseBuffer = new ByteArrayOutputStream();
                RpcServer.this.metrics.exception(CALL_QUEUE_TOO_BIG_EXCEPTION);
                InetSocketAddress address = RpcServer.this.getListenerAddress();
                RpcServer.this.setupResponse(responseBuffer, callTooBig, CALL_QUEUE_TOO_BIG_EXCEPTION, "Call queue is full on " + (address != null ? address : "(channel closed)") + ", is hbase.ipc.server.max.callqueue.size too small?");
                RpcServer.this.responder.doRespond(callTooBig);
                return;
            }
            Descriptors.MethodDescriptor md = null;
            Message param = null;
            CellScanner cellScanner = null;
            try {
                if (header.hasRequestParam() && header.getRequestParam()) {
                    md = this.service.getDescriptorForType().findMethodByName(header.getMethodName());
                    if (md == null) {
                        throw new UnsupportedOperationException(header.getMethodName());
                    }
                    builder = this.service.getRequestPrototype(md).newBuilderForType();
                    cis = CodedInputStream.newInstance((byte[])buf, (int)offset, (int)buf.length);
                    int paramSize = cis.readRawVarint32();
                    offset += cis.getTotalBytesRead();
                    if (builder != null) {
                        ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])buf, (int)offset, (int)paramSize);
                        param = builder.build();
                    }
                    offset += paramSize;
                }
                if (header.hasCellBlockMeta()) {
                    cellScanner = RpcServer.this.ipcUtil.createCellScanner(this.codec, this.compressionCodec, buf, offset, buf.length);
                }
            }
            catch (Throwable t2) {
                DoNotRetryIOException t2;
                InetSocketAddress address = RpcServer.this.getListenerAddress();
                String msg = (address != null ? address : "(channel closed)") + " is unable to read call parameter from client " + this.getHostAddress();
                LOG.warn((Object)msg, t2);
                RpcServer.this.metrics.exception(t2);
                if (t2 instanceof LinkageError) {
                    t2 = new DoNotRetryIOException(t2);
                }
                if (t2 instanceof UnsupportedOperationException) {
                    t2 = new DoNotRetryIOException((Throwable)t2);
                }
                Call readParamsFailedCall = new Call(id, this.service, null, null, null, null, this, RpcServer.this.responder, totalRequestSize, null, null);
                ByteArrayOutputStream responseBuffer = new ByteArrayOutputStream();
                RpcServer.this.setupResponse(responseBuffer, readParamsFailedCall, (Throwable)t2, msg + "; " + t2.getMessage());
                RpcServer.this.responder.doRespond(readParamsFailedCall);
                return;
            }
            TraceInfo traceInfo = header.hasTraceInfo() ? new TraceInfo(header.getTraceInfo().getTraceId(), header.getTraceInfo().getParentId()) : null;
            Call call = new Call(id, this.service, md, header, param, cellScanner, this, RpcServer.this.responder, totalRequestSize, traceInfo, RpcServer.getRemoteIp());
            RpcServer.this.scheduler.dispatch(new CallRunner(RpcServer.this, call));
        }

        private boolean authorizeConnection() throws IOException {
            try {
                if (this.user != null && this.user.getRealUser() != null && this.authMethod != AuthMethod.DIGEST) {
                    ProxyUsers.authorize((UserGroupInformation)this.user, (String)this.getHostAddress(), (Configuration)RpcServer.this.conf);
                }
                RpcServer.this.authorize(this.user, this.connectionHeader, this.getHostInetAddress());
                RpcServer.this.metrics.authorizationSuccess();
            }
            catch (AuthorizationException ae) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Connection authorization failed: " + ae.getMessage()), (Throwable)ae);
                }
                RpcServer.this.metrics.authorizationFailure();
                RpcServer.this.setupResponse(this.authFailedResponse, this.authFailedCall, (Throwable)new AccessDeniedException((Throwable)ae), ae.getMessage());
                RpcServer.this.responder.doRespond(this.authFailedCall);
                return false;
            }
            return true;
        }

        protected synchronized void close() {
            this.disposeSasl();
            this.data = null;
            if (!this.channel.isOpen()) {
                return;
            }
            try {
                this.socket.shutdownOutput();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.channel.isOpen()) {
                try {
                    this.channel.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private UserGroupInformation createUser(RPCProtos.ConnectionHeader head) {
            UserGroupInformation ugi = null;
            if (!head.hasUserInfo()) {
                return null;
            }
            RPCProtos.UserInformation userInfoProto = head.getUserInfo();
            String effectiveUser = null;
            if (userInfoProto.hasEffectiveUser()) {
                effectiveUser = userInfoProto.getEffectiveUser();
            }
            String realUser = null;
            if (userInfoProto.hasRealUser()) {
                realUser = userInfoProto.getRealUser();
            }
            if (effectiveUser != null) {
                if (realUser != null) {
                    UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)realUser);
                    ugi = UserGroupInformation.createProxyUser((String)effectiveUser, (UserGroupInformation)realUserUgi);
                } else {
                    ugi = UserGroupInformation.createRemoteUser((String)effectiveUser);
                }
            }
            return ugi;
        }
    }

    public static class CallQueueTooBigException
    extends IOException {
        CallQueueTooBigException() {
        }
    }

    protected class Responder
    extends Thread {
        private final Selector writeSelector;
        private final Set<Connection> writingCons = Collections.newSetFromMap(new ConcurrentHashMap());

        Responder() throws IOException {
            this.setName("RpcServer.responder");
            this.setDaemon(true);
            this.writeSelector = Selector.open();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)(this.getName() + ": starting"));
            try {
                this.doRunLoop();
            }
            finally {
                LOG.info((Object)(this.getName() + ": stopping"));
                try {
                    this.writeSelector.close();
                }
                catch (IOException ioe) {
                    LOG.error((Object)(this.getName() + ": couldn't close write selector"), (Throwable)ioe);
                }
            }
        }

        private void registerWrites() {
            Iterator<Connection> it = this.writingCons.iterator();
            while (it.hasNext()) {
                Connection c = it.next();
                it.remove();
                SelectionKey sk = c.channel.keyFor(this.writeSelector);
                try {
                    if (sk == null) {
                        try {
                            c.channel.register(this.writeSelector, 4, c);
                        }
                        catch (ClosedChannelException e) {
                            if (!LOG.isTraceEnabled()) continue;
                            LOG.trace((Object)"ignored", (Throwable)e);
                        }
                        continue;
                    }
                    sk.interestOps(4);
                }
                catch (CancelledKeyException e) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)"ignored", (Throwable)e);
                }
            }
        }

        public void registerForWrite(Connection c) {
            if (this.writingCons.add(c)) {
                this.writeSelector.wakeup();
            }
        }

        private void doRunLoop() {
            long lastPurgeTime = 0L;
            while (RpcServer.this.running) {
                try {
                    this.registerWrites();
                    int keyCt = this.writeSelector.select(RpcServer.this.purgeTimeout);
                    if (keyCt == 0) continue;
                    Set<SelectionKey> keys = this.writeSelector.selectedKeys();
                    Iterator<SelectionKey> iter = keys.iterator();
                    while (iter.hasNext()) {
                        SelectionKey key = iter.next();
                        iter.remove();
                        try {
                            if (!key.isValid() || !key.isWritable()) continue;
                            this.doAsyncWrite(key);
                        }
                        catch (IOException e) {
                            LOG.debug((Object)(this.getName() + ": asyncWrite"), (Throwable)e);
                        }
                    }
                    lastPurgeTime = this.purge(lastPurgeTime);
                }
                catch (OutOfMemoryError e) {
                    if (RpcServer.this.errorHandler != null) {
                        if (!RpcServer.this.errorHandler.checkOOME(e)) continue;
                        LOG.info((Object)(this.getName() + ": exiting on OutOfMemoryError"));
                        return;
                    }
                    LOG.warn((Object)(this.getName() + ": OutOfMemoryError in server select"), (Throwable)e);
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException ex) {
                        LOG.debug((Object)"Interrupted while sleeping");
                        return;
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)(this.getName() + ": exception in Responder " + StringUtils.stringifyException((Throwable)e)), (Throwable)e);
                }
            }
            LOG.info((Object)(this.getName() + ": stopped"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long purge(long lastPurgeTime) {
            long now = System.currentTimeMillis();
            if (now < lastPurgeTime + RpcServer.this.purgeTimeout) {
                return lastPurgeTime;
            }
            ArrayList<Connection> conWithOldCalls = new ArrayList<Connection>();
            Set<SelectionKey> set = this.writeSelector.keys();
            synchronized (set) {
                for (SelectionKey key : this.writeSelector.keys()) {
                    Connection connection = (Connection)key.attachment();
                    if (connection == null) {
                        throw new IllegalStateException("Coding error: SelectionKey key without attachment.");
                    }
                    Call call = connection.responseQueue.peekFirst();
                    if (call == null || now <= call.timestamp + RpcServer.this.purgeTimeout) continue;
                    conWithOldCalls.add(call.connection);
                }
            }
            for (Connection connection : conWithOldCalls) {
                RpcServer.this.closeConnection(connection);
            }
            return now;
        }

        private void doAsyncWrite(SelectionKey key) throws IOException {
            Connection connection = (Connection)key.attachment();
            if (connection == null) {
                throw new IOException("doAsyncWrite: no connection");
            }
            if (key.channel() != connection.channel) {
                throw new IOException("doAsyncWrite: bad channel");
            }
            if (this.processAllResponses(connection)) {
                try {
                    key.interestOps(0);
                }
                catch (CancelledKeyException e) {
                    LOG.warn((Object)("Exception while changing ops : " + e));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean processResponse(Call call) throws IOException {
            boolean error = true;
            try {
                long numBytes = RpcServer.this.channelWrite(call.connection.channel, call.response);
                if (numBytes < 0L) {
                    throw new HBaseIOException("Error writing on the socket for the call:" + call.toShortString());
                }
                error = false;
            }
            finally {
                if (error) {
                    LOG.debug((Object)(this.getName() + call.toShortString() + ": output error -- closing"));
                    RpcServer.this.closeConnection(call.connection);
                }
            }
            if (!call.response.hasRemaining()) {
                call.done();
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean processAllResponses(Connection connection) throws IOException {
            connection.responseWriteLock.lock();
            try {
                for (int i = 0; i < 20; ++i) {
                    Call call = connection.responseQueue.pollFirst();
                    if (call == null) {
                        boolean bl = true;
                        return bl;
                    }
                    if (this.processResponse(call)) continue;
                    connection.responseQueue.addFirst(call);
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                connection.responseWriteLock.unlock();
            }
            return connection.responseQueue.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doRespond(Call call) throws IOException {
            boolean added = false;
            if (call.connection.responseQueue.isEmpty() && call.connection.responseWriteLock.tryLock()) {
                try {
                    if (call.connection.responseQueue.isEmpty()) {
                        if (this.processResponse(call)) {
                            return;
                        }
                        call.connection.responseQueue.addFirst(call);
                        added = true;
                    }
                }
                finally {
                    call.connection.responseWriteLock.unlock();
                }
            }
            if (!added) {
                call.connection.responseQueue.addLast(call);
            }
            call.responder.registerForWrite(call.connection);
            call.timestamp = System.currentTimeMillis();
        }
    }

    private class Listener
    extends Thread {
        private ServerSocketChannel acceptChannel;
        private Selector selector;
        private Reader[] readers;
        private int currentReader;
        private Random rand;
        private long lastCleanupRunTime;
        private long cleanupInterval;
        private int backlogLength;
        private ExecutorService readPool;

        public Listener(String name) throws IOException {
            super(name);
            this.acceptChannel = null;
            this.selector = null;
            this.readers = null;
            this.currentReader = 0;
            this.rand = new Random();
            this.lastCleanupRunTime = 0L;
            this.cleanupInterval = 10000L;
            this.backlogLength = RpcServer.this.conf.getInt("hbase.ipc.server.listen.queue.size", 128);
            this.acceptChannel = ServerSocketChannel.open();
            this.acceptChannel.configureBlocking(false);
            RpcServer.bind(this.acceptChannel.socket(), RpcServer.this.bindAddress, this.backlogLength);
            RpcServer.this.port = this.acceptChannel.socket().getLocalPort();
            this.selector = Selector.open();
            this.readers = new Reader[RpcServer.this.readThreads];
            this.readPool = Executors.newFixedThreadPool(RpcServer.this.readThreads, new ThreadFactoryBuilder().setNameFormat("RpcServer.reader=%d,bindAddress=" + RpcServer.this.bindAddress.getHostName() + ",port=" + RpcServer.this.port).setDaemon(true).build());
            for (int i = 0; i < RpcServer.this.readThreads; ++i) {
                Reader reader;
                this.readers[i] = reader = new Reader();
                this.readPool.execute(reader);
            }
            LOG.info((Object)(this.getName() + ": started " + RpcServer.this.readThreads + " reader(s) listening on port=" + RpcServer.this.port));
            this.acceptChannel.register(this.selector, 16);
            this.setName("RpcServer.listener,port=" + RpcServer.this.port);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanupConnections(boolean force) {
            if (force || RpcServer.this.numConnections > RpcServer.this.thresholdIdleConnections) {
                long currentTime = System.currentTimeMillis();
                if (!force && currentTime - this.lastCleanupRunTime < this.cleanupInterval) {
                    return;
                }
                int start = 0;
                int end = RpcServer.this.numConnections - 1;
                if (!force) {
                    start = this.rand.nextInt() % RpcServer.this.numConnections;
                    end = this.rand.nextInt() % RpcServer.this.numConnections;
                    if (end < start) {
                        int temp = start;
                        start = end;
                        end = temp;
                    }
                }
                int i = start;
                int numNuked = 0;
                while (i <= end) {
                    Connection c;
                    List<Connection> list = RpcServer.this.connectionList;
                    synchronized (list) {
                        try {
                            c = RpcServer.this.connectionList.get(i);
                        }
                        catch (Exception e) {
                            return;
                        }
                    }
                    if (c.timedOut(currentTime)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(this.getName() + ": disconnecting client " + c.getHostAddress()));
                        }
                        RpcServer.this.closeConnection(c);
                        --end;
                        c = null;
                        if (force || ++numNuked != RpcServer.this.maxConnectionsToNuke) continue;
                        break;
                    }
                    ++i;
                }
                this.lastCleanupRunTime = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)(this.getName() + ": starting"));
            while (RpcServer.this.running) {
                SelectionKey key = null;
                try {
                    this.selector.select();
                    Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        block18: {
                            key = iter.next();
                            iter.remove();
                            try {
                                if (key.isValid() && key.isAcceptable()) {
                                    this.doAccept(key);
                                }
                            }
                            catch (IOException ignored) {
                                if (!LOG.isTraceEnabled()) break block18;
                                LOG.trace((Object)"ignored", (Throwable)ignored);
                            }
                        }
                        key = null;
                    }
                }
                catch (OutOfMemoryError e) {
                    if (RpcServer.this.errorHandler != null) {
                        if (RpcServer.this.errorHandler.checkOOME(e)) {
                            LOG.info((Object)(this.getName() + ": exiting on OutOfMemoryError"));
                            this.closeCurrentConnection(key, e);
                            this.cleanupConnections(true);
                            return;
                        }
                    }
                    LOG.warn((Object)(this.getName() + ": OutOfMemoryError in server select"), (Throwable)e);
                    this.closeCurrentConnection(key, e);
                    this.cleanupConnections(true);
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException ex) {
                        LOG.debug((Object)"Interrupted while sleeping");
                        return;
                    }
                }
                catch (Exception e) {
                    this.closeCurrentConnection(key, e);
                }
                this.cleanupConnections(false);
            }
            LOG.info((Object)(this.getName() + ": stopping"));
            Listener listener = this;
            synchronized (listener) {
                block19: {
                    try {
                        this.acceptChannel.close();
                        this.selector.close();
                    }
                    catch (IOException ignored) {
                        if (!LOG.isTraceEnabled()) break block19;
                        LOG.trace((Object)"ignored", (Throwable)ignored);
                    }
                }
                this.selector = null;
                this.acceptChannel = null;
                while (!RpcServer.this.connectionList.isEmpty()) {
                    RpcServer.this.closeConnection(RpcServer.this.connectionList.remove(0));
                }
            }
        }

        private void closeCurrentConnection(SelectionKey key, Throwable e) {
            Connection c;
            if (key != null && (c = (Connection)key.attachment()) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + ": disconnecting client " + c.getHostAddress() + (e != null ? " on error " + e.getMessage() : "")));
                }
                RpcServer.this.closeConnection(c);
                key.attach(null);
            }
        }

        InetSocketAddress getAddress() {
            return (InetSocketAddress)this.acceptChannel.socket().getLocalSocketAddress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doAccept(SelectionKey key) throws IOException, OutOfMemoryError {
            SocketChannel channel;
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            while ((channel = server.accept()) != null) {
                try {
                    channel.configureBlocking(false);
                    channel.socket().setTcpNoDelay(RpcServer.this.tcpNoDelay);
                    channel.socket().setKeepAlive(RpcServer.this.tcpKeepAlive);
                }
                catch (IOException ioe) {
                    channel.close();
                    throw ioe;
                }
                Reader reader = this.getReader();
                try {
                    reader.startAdd();
                    SelectionKey readKey = reader.registerChannel(channel);
                    Connection c = RpcServer.this.getConnection(channel, System.currentTimeMillis());
                    readKey.attach(c);
                    List<Connection> list = RpcServer.this.connectionList;
                    synchronized (list) {
                        RpcServer.this.connectionList.add(RpcServer.this.numConnections, c);
                        ++RpcServer.this.numConnections;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)(this.getName() + ": connection from " + c.toString() + "; # active connections: " + RpcServer.this.numConnections));
                }
                finally {
                    reader.finishAdd();
                }
            }
        }

        void doRead(SelectionKey key) throws InterruptedException {
            int count;
            Connection c = (Connection)key.attachment();
            if (c == null) {
                return;
            }
            c.setLastContact(System.currentTimeMillis());
            try {
                count = c.readAndProcess();
                if (count > 0) {
                    c.setLastContact(System.currentTimeMillis());
                }
            }
            catch (InterruptedException ieo) {
                throw ieo;
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + ": Caught exception while reading:" + e.getMessage()));
                }
                count = -1;
            }
            if (count < 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + ": DISCONNECTING client " + c.toString() + " because read count=" + count + ". Number of active connections: " + RpcServer.this.numConnections));
                }
                RpcServer.this.closeConnection(c);
            }
        }

        synchronized void doStop() {
            if (this.selector != null) {
                this.selector.wakeup();
                Thread.yield();
            }
            if (this.acceptChannel != null) {
                try {
                    this.acceptChannel.socket().close();
                }
                catch (IOException e) {
                    LOG.info((Object)(this.getName() + ": exception in closing listener socket. " + e));
                }
            }
            this.readPool.shutdownNow();
        }

        Reader getReader() {
            this.currentReader = (this.currentReader + 1) % this.readers.length;
            return this.readers[this.currentReader];
        }

        private class Reader
        implements Runnable {
            private volatile boolean adding = false;
            private final Selector readSelector = Selector.open();

            Reader() throws IOException {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    this.doRunLoop();
                }
                finally {
                    try {
                        this.readSelector.close();
                    }
                    catch (IOException ioe) {
                        LOG.error((Object)(Listener.this.getName() + ": error closing read selector in " + Listener.this.getName()), (Throwable)ioe);
                    }
                }
            }

            private synchronized void doRunLoop() {
                while (RpcServer.this.running) {
                    try {
                        this.readSelector.select();
                        while (this.adding) {
                            this.wait(1000L);
                        }
                        Iterator<SelectionKey> iter = this.readSelector.selectedKeys().iterator();
                        while (iter.hasNext()) {
                            SelectionKey key = iter.next();
                            iter.remove();
                            if (!key.isValid() || !key.isReadable()) continue;
                            Listener.this.doRead(key);
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.debug((Object)"Interrupted while sleeping");
                        return;
                    }
                    catch (IOException ex) {
                        LOG.info((Object)(Listener.this.getName() + ": IOException in Reader"), (Throwable)ex);
                    }
                }
            }

            public void startAdd() {
                this.adding = true;
                this.readSelector.wakeup();
            }

            public synchronized SelectionKey registerChannel(SocketChannel channel) throws IOException {
                return channel.register(this.readSelector, 1);
            }

            public synchronized void finishAdd() {
                this.adding = false;
                this.notify();
            }
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix"})
    @InterfaceStability.Evolving
    public class Call
    implements RpcCallContext {
        protected int id;
        protected BlockingService service;
        protected Descriptors.MethodDescriptor md;
        protected RPCProtos.RequestHeader header;
        protected Message param;
        protected CellScanner cellScanner;
        protected Connection connection;
        protected long timestamp;
        protected BufferChain response;
        protected boolean delayResponse;
        protected Responder responder;
        protected boolean delayReturnValue;
        protected long size;
        protected boolean isError;
        protected TraceInfo tinfo;
        private ByteBuffer cellBlock = null;
        private User user;
        private InetAddress remoteAddress;

        Call(int id, BlockingService service, Descriptors.MethodDescriptor md, RPCProtos.RequestHeader header, Message param, CellScanner cellScanner, Connection connection, Responder responder, long size, TraceInfo tinfo, InetAddress remoteAddress) {
            this.id = id;
            this.service = service;
            this.md = md;
            this.header = header;
            this.param = param;
            this.cellScanner = cellScanner;
            this.connection = connection;
            this.timestamp = System.currentTimeMillis();
            this.response = null;
            this.delayResponse = false;
            this.responder = responder;
            this.isError = false;
            this.size = size;
            this.tinfo = tinfo;
            this.user = connection.user == null ? null : RpcServer.this.userProvider.create(connection.user);
            this.remoteAddress = remoteAddress;
        }

        void done() {
            if (this.cellBlock != null) {
                RpcServer.this.reservoir.putBuffer(this.cellBlock);
                this.cellBlock = null;
            }
            this.connection.decRpcCount();
        }

        public String toString() {
            return this.toShortString() + " param: " + (this.param != null ? ProtobufUtil.getShortTextFormat((Message)this.param) : "") + " connection: " + this.connection.toString();
        }

        protected RPCProtos.RequestHeader getHeader() {
            return this.header;
        }

        public boolean hasPriority() {
            return this.header.hasPriority();
        }

        public int getPriority() {
            return this.header.getPriority();
        }

        String toShortString() {
            String serviceName = this.connection.service != null ? this.connection.service.getDescriptorForType().getName() : "null";
            return "callId: " + this.id + " service: " + serviceName + " methodName: " + (this.md != null ? this.md.getName() : "n/a") + " size: " + StringUtils.TraditionalBinaryPrefix.long2String((long)this.size, (String)"", (int)1) + " connection: " + this.connection.toString();
        }

        String toTraceString() {
            String serviceName = this.connection.service != null ? this.connection.service.getDescriptorForType().getName() : "";
            String methodName = this.md != null ? this.md.getName() : "";
            return serviceName + "." + methodName;
        }

        protected synchronized void setSaslTokenResponse(ByteBuffer response) {
            this.response = new BufferChain(response);
        }

        protected synchronized void setResponse(Object m, CellScanner cells, Throwable t, String errorMsg) {
            if (this.isError) {
                return;
            }
            if (t != null) {
                this.isError = true;
            }
            BufferChain bc = null;
            try {
                RPCProtos.ResponseHeader.Builder headerBuilder = RPCProtos.ResponseHeader.newBuilder();
                Message result = (Message)m;
                headerBuilder.setCallId(this.id);
                if (t != null) {
                    RPCProtos.ExceptionResponse.Builder exceptionBuilder = RPCProtos.ExceptionResponse.newBuilder();
                    exceptionBuilder.setExceptionClassName(t.getClass().getName());
                    exceptionBuilder.setStackTrace(errorMsg);
                    exceptionBuilder.setDoNotRetry(t instanceof DoNotRetryIOException);
                    if (t instanceof RegionMovedException) {
                        RegionMovedException rme = (RegionMovedException)t;
                        exceptionBuilder.setHostname(rme.getHostname());
                        exceptionBuilder.setPort(rme.getPort());
                    }
                    headerBuilder.setException(exceptionBuilder.build());
                }
                this.cellBlock = RpcServer.this.ipcUtil.buildCellBlock(this.connection.codec, this.connection.compressionCodec, cells, RpcServer.this.reservoir);
                if (this.cellBlock != null) {
                    RPCProtos.CellBlockMeta.Builder cellBlockBuilder = RPCProtos.CellBlockMeta.newBuilder();
                    cellBlockBuilder.setLength(this.cellBlock.limit());
                    headerBuilder.setCellBlockMeta(cellBlockBuilder.build());
                }
                RPCProtos.ResponseHeader header = headerBuilder.build();
                ByteBuffer bbHeader = IPCUtil.getDelimitedMessageAsByteBuffer((Message)header);
                ByteBuffer bbResult = IPCUtil.getDelimitedMessageAsByteBuffer((Message)result);
                int totalSize = bbHeader.capacity() + (bbResult == null ? 0 : bbResult.limit()) + (this.cellBlock == null ? 0 : this.cellBlock.limit());
                ByteBuffer bbTotalSize = ByteBuffer.wrap(Bytes.toBytes((int)totalSize));
                bc = new BufferChain(bbTotalSize, bbHeader, bbResult, this.cellBlock);
                if (this.connection.useWrap) {
                    bc = this.wrapWithSasl(bc);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("Exception while creating response " + e));
            }
            this.response = bc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BufferChain wrapWithSasl(BufferChain bc) throws IOException {
            byte[] token;
            if (!this.connection.useSasl) {
                return bc;
            }
            byte[] responseBytes = bc.getBytes();
            SaslServer saslServer = this.connection.saslServer;
            synchronized (saslServer) {
                token = this.connection.saslServer.wrap(responseBytes, 0, responseBytes.length);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Adding saslServer wrapped token of size " + token.length + " as call response."));
            }
            ByteBuffer bbTokenLength = ByteBuffer.wrap(Bytes.toBytes((int)token.length));
            ByteBuffer bbTokenBytes = ByteBuffer.wrap(token);
            return new BufferChain(bbTokenLength, bbTokenBytes);
        }

        @Override
        public synchronized void endDelay(Object result) throws IOException {
            assert (this.delayResponse);
            assert (this.delayReturnValue || result == null);
            this.delayResponse = false;
            RpcServer.this.delayedCalls.decrementAndGet();
            if (this.delayReturnValue) {
                this.setResponse(result, null, null, null);
            }
            this.responder.doRespond(this);
        }

        @Override
        public synchronized void endDelay() throws IOException {
            this.endDelay(null);
        }

        @Override
        public synchronized void startDelay(boolean delayReturnValue) {
            assert (!this.delayResponse);
            this.delayResponse = true;
            this.delayReturnValue = delayReturnValue;
            int numDelayed = RpcServer.this.delayedCalls.incrementAndGet();
            if (numDelayed > RpcServer.this.warnDelayedCalls) {
                LOG.warn((Object)("Too many delayed calls: limit " + RpcServer.this.warnDelayedCalls + " current " + numDelayed));
            }
        }

        @Override
        public synchronized void endDelayThrowing(Throwable t) throws IOException {
            this.setResponse(null, null, t, StringUtils.stringifyException((Throwable)t));
            this.delayResponse = false;
            this.sendResponseIfReady();
        }

        @Override
        public synchronized boolean isDelayed() {
            return this.delayResponse;
        }

        @Override
        public synchronized boolean isReturnValueDelayed() {
            return this.delayReturnValue;
        }

        @Override
        public boolean isClientCellBlockSupport() {
            return this.connection != null && this.connection.codec != null;
        }

        @Override
        public long disconnectSince() {
            if (!this.connection.channel.isOpen()) {
                return System.currentTimeMillis() - this.timestamp;
            }
            return -1L;
        }

        public long getSize() {
            return this.size;
        }

        public synchronized void sendResponseIfReady() throws IOException {
            this.param = null;
            if (!this.delayResponse) {
                this.responder.doRespond(this);
            }
        }

        public UserGroupInformation getRemoteUser() {
            return this.connection.user;
        }

        @Override
        public User getRequestUser() {
            return this.user;
        }

        @Override
        public String getRequestUserName() {
            User user = this.getRequestUser();
            return user == null ? null : user.getShortName();
        }

        @Override
        public InetAddress getRemoteAddress() {
            return this.remoteAddress;
        }

        @Override
        public RPCProtos.VersionInfo getClientVersionInfo() {
            return this.connection.getVersionInfo();
        }
    }
}

