/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.regionserver.HRegion;

class RegionLocationFinder {
    private static Log LOG = LogFactory.getLog(RegionLocationFinder.class);
    private Configuration conf;
    private ClusterStatus status;
    private MasterServices services;
    private CacheLoader<HRegionInfo, List<ServerName>> loader = new CacheLoader<HRegionInfo, List<ServerName>>(){

        public List<ServerName> load(HRegionInfo key) throws Exception {
            List<ServerName> servers = RegionLocationFinder.this.internalGetTopBlockLocation(key);
            if (servers == null) {
                return new LinkedList<ServerName>();
            }
            return servers;
        }
    };
    private LoadingCache<HRegionInfo, List<ServerName>> cache = null;

    RegionLocationFinder() {
    }

    private LoadingCache<HRegionInfo, List<ServerName>> createCache(int mins) {
        return CacheBuilder.newBuilder().expireAfterAccess((long)mins, TimeUnit.MINUTES).build(this.loader);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.cache = this.createCache(conf.getInt("hbase.master.balancer.regionLocationCacheTime", 30));
    }

    public void setServices(MasterServices services) {
        this.services = services;
    }

    public void setClusterStatus(ClusterStatus status) {
        this.status = status;
    }

    protected List<ServerName> getTopBlockLocations(HRegionInfo region) {
        LinkedList<ServerName> servers = null;
        try {
            servers = (LinkedList<ServerName>)this.cache.get((Object)region);
        }
        catch (ExecutionException ex) {
            servers = new LinkedList<ServerName>();
        }
        return servers;
    }

    protected List<ServerName> internalGetTopBlockLocation(HRegionInfo region) {
        List<ServerName> topServerNames = null;
        try {
            HTableDescriptor tableDescriptor = this.getTableDescriptor(region.getTable());
            if (tableDescriptor != null) {
                HDFSBlocksDistribution blocksDistribution = HRegion.computeHDFSBlocksDistribution(this.getConf(), tableDescriptor, region);
                List<String> topHosts = blocksDistribution.getTopHosts();
                topServerNames = this.mapHostNameToServerName(topHosts);
            }
        }
        catch (IOException ioe) {
            LOG.debug((Object)("IOException during HDFSBlocksDistribution computation. for region = " + region.getEncodedName()), (Throwable)ioe);
        }
        return topServerNames;
    }

    protected HTableDescriptor getTableDescriptor(TableName tableName) throws IOException {
        HTableDescriptor tableDescriptor = null;
        try {
            if (this.services != null && this.services.getTableDescriptors() != null) {
                tableDescriptor = this.services.getTableDescriptors().get(tableName);
            }
        }
        catch (FileNotFoundException fnfe) {
            LOG.debug((Object)("FileNotFoundException during getTableDescriptors. Current table name = " + tableName), (Throwable)fnfe);
        }
        return tableDescriptor;
    }

    protected List<ServerName> mapHostNameToServerName(List<String> hosts) {
        if (hosts == null || this.status == null) {
            return null;
        }
        ArrayList<ServerName> topServerNames = new ArrayList<ServerName>();
        Collection regionServers = this.status.getServers();
        HashMap hostToServerName = new HashMap();
        for (ServerName sn : regionServers) {
            String host = sn.getHostname();
            if (!hostToServerName.containsKey(host)) {
                hostToServerName.put(host, new ArrayList());
            }
            ((List)hostToServerName.get(host)).add(sn);
        }
        for (String host : hosts) {
            if (!hostToServerName.containsKey(host)) continue;
            for (ServerName sn : (List)hostToServerName.get(host)) {
                if (sn == null) continue;
                topServerNames.add(sn);
            }
        }
        return topServerNames;
    }
}

