/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.ipc.RpcCallContext;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class ProcedurePrepareLatch {
    private static final NoopLatch noopLatch = new NoopLatch();

    public static ProcedurePrepareLatch createLatch() {
        return ProcedurePrepareLatch.hasProcedureSupport() ? noopLatch : new CompatibilityLatch();
    }

    public static boolean hasProcedureSupport() {
        return ProcedurePrepareLatch.currentClientHasMinimumVersion(1, 1);
    }

    private static boolean currentClientHasMinimumVersion(int major, int minor) {
        RPCProtos.VersionInfo versionInfo;
        RpcCallContext call = RpcServer.getCurrentCall();
        RPCProtos.VersionInfo versionInfo2 = versionInfo = call != null ? call.getClientVersionInfo() : null;
        if (versionInfo != null) {
            int clientMajor;
            String[] components = versionInfo.getVersion().split("\\.");
            int n = clientMajor = components.length > 0 ? Integer.parseInt(components[0]) : 0;
            if (clientMajor != major) {
                return clientMajor > major;
            }
            int clientMinor = components.length > 1 ? Integer.parseInt(components[1]) : 0;
            return clientMinor >= minor;
        }
        return false;
    }

    protected abstract void countDown(Procedure var1);

    public abstract void await() throws IOException;

    protected static void releaseLatch(ProcedurePrepareLatch latch, Procedure proc) {
        if (latch != null) {
            latch.countDown(proc);
        }
    }

    protected static class CompatibilityLatch
    extends ProcedurePrepareLatch {
        private final CountDownLatch latch = new CountDownLatch(1);
        private IOException exception = null;

        protected CompatibilityLatch() {
        }

        @Override
        protected void countDown(Procedure proc) {
            if (proc.hasException()) {
                this.exception = proc.getException().unwrapRemoteException();
            }
            this.latch.countDown();
        }

        @Override
        public void await() throws IOException {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }

    private static class NoopLatch
    extends ProcedurePrepareLatch {
        private NoopLatch() {
        }

        @Override
        protected void countDown(Procedure proc) {
        }

        @Override
        public void await() throws IOException {
        }
    }
}

