// Autogenerated Jamon implementation
// /home/zhangduo/hbase/code/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/MasterStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 32, 1
import java.util.*;
// 33, 1
import org.apache.hadoop.util.StringUtils;
// 34, 1
import org.apache.hadoop.hbase.util.Bytes;
// 35, 1
import org.apache.hadoop.hbase.util.JvmVersion;
// 36, 1
import org.apache.hadoop.hbase.util.FSUtils;
// 37, 1
import org.apache.hadoop.hbase.master.HMaster;
// 38, 1
import org.apache.hadoop.hbase.master.AssignmentManager;
// 39, 1
import org.apache.hadoop.hbase.master.ServerManager;
// 40, 1
import org.apache.hadoop.hbase.HConstants;
// 41, 1
import org.apache.hadoop.hbase.NamespaceDescriptor;
// 42, 1
import org.apache.hadoop.hbase.ServerLoad;
// 43, 1
import org.apache.hadoop.hbase.ServerName;
// 44, 1
import org.apache.hadoop.hbase.client.Admin;
// 45, 1
import org.apache.hadoop.hbase.client.HConnectionManager;
// 46, 1
import org.apache.hadoop.hbase.HRegionInfo;
// 47, 1
import org.apache.hadoop.hbase.master.RegionState;
// 48, 1
import org.apache.hadoop.hbase.HTableDescriptor;
// 49, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 50, 1
import org.apache.hadoop.hbase.TableName;
// 51, 1
import org.apache.hadoop.hbase.tool.CanaryTool;
// 52, 1
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos.SnapshotDescription;
// 53, 1
import org.apache.hadoop.hbase.master.DeadServer;
// 54, 1
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
// 55, 1
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
// 56, 1
import org.apache.hadoop.hbase.security.access.AccessControlLists;
// 57, 1
import org.apache.hadoop.hbase.quotas.QuotaUtil;

public class MasterStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.Intf

{
  private final HMaster master;
  private final ServerName metaLocation;
  private final List<ServerName> servers;
  private final String filter;
  private final Set<ServerName> deadServers;
  private final AssignmentManager assignmentManager;
  private final Map<String,Integer> frags;
  private final String format;
  private final ServerManager serverManager;
  private final boolean catalogJanitorEnabled;
  // 69, 1
  
  public String formatZKString() {
    StringBuilder quorums = new StringBuilder();
    String zkQuorum = master.getZooKeeper().getQuorum();

    if (null == zkQuorum) {
      return quorums.toString();
    }

    String[] zks = zkQuorum.split(",");

    if (zks.length == 0) {
      return quorums.toString();
    }

    for(int i = 0; i < zks.length; ++i) {
      quorums.append(zks[i].trim());

      if (i != (zks.length - 1)) {
        quorums.append("<br/>");
      }
    }

    return quorums.toString();
  }

  protected static org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getMetaLocation__IsNotDefault())
    {
      p_implData.setMetaLocation(null);
    }
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    if(! p_implData.getDeadServers__IsNotDefault())
    {
      p_implData.setDeadServers(null);
    }
    if(! p_implData.getAssignmentManager__IsNotDefault())
    {
      p_implData.setAssignmentManager(null);
    }
    if(! p_implData.getFrags__IsNotDefault())
    {
      p_implData.setFrags(null);
    }
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    if(! p_implData.getServerManager__IsNotDefault())
    {
      p_implData.setServerManager(null);
    }
    if(! p_implData.getCatalogJanitorEnabled__IsNotDefault())
    {
      p_implData.setCatalogJanitorEnabled(true);
    }
    return p_implData;
  }
  public MasterStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    metaLocation = p_implData.getMetaLocation();
    servers = p_implData.getServers();
    filter = p_implData.getFilter();
    deadServers = p_implData.getDeadServers();
    assignmentManager = p_implData.getAssignmentManager();
    frags = p_implData.getFrags();
    format = p_implData.getFormat();
    serverManager = p_implData.getServerManager();
    catalogJanitorEnabled = p_implData.getCatalogJanitorEnabled();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 60, 1
    if (format.equals("json") )
    {
      // 60, 30
      jamonWriter.write("\n  ");
      // 61, 3
      {
        org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_6 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_6.setFormat("json" );
        __jamon__var_6.setFilter(filter);
        __jamon__var_6.renderNoFlush(jamonWriter);
      }
      // 61, 68
      jamonWriter.write("\n  ");
      // 62, 3
      return; 
    }
    // 63, 7
    jamonWriter.write("\n");
    // 64, 1
    
ServerManager serverManager = master.getServerManager();
AssignmentManager assignmentManager = master.getAssignmentManager();

    // 96, 1
    jamonWriter.write("<!--[if IE]>\n<!DOCTYPE html>\n<![endif]-->\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>");
    // 103, 12
    if (master.isActiveMaster() )
    {
      // 103, 43
      jamonWriter.write("Master: ");
    }
    // 103, 51
    else
    {
      // 103, 58
      jamonWriter.write("Backup Master: ");
    }
    // 103, 79
    jamonWriter.write("\n    ");
    // 104, 5
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
    // 104, 47
    jamonWriter.write("</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n  </head>\n\n  <body>\n\n    <div class=\"navbar  navbar-fixed-top navbar-default\">\n        <div class=\"container-fluid\">\n            <div class=\"navbar-header\">\n                <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                </button>\n                <a class=\"navbar-brand\" href=\"/master-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n            </div>\n            <div class=\"collapse navbar-collapse\">\n                <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/\">Home</a></li>\n                <li><a href=\"/tablesDetailed.jsp\">Table Details</a></li>\n                <li><a href=\"/procedures.jsp\">Procedures</a></li>\n                <li><a href=\"/logs/\">Local Logs</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug Dump</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                <li><a href=\"/prof\">Profiler</a></li>\n                ");
    // 134, 17
    if (HBaseConfiguration.isShowConfInServlet())
    {
      // 134, 64
      jamonWriter.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
    }
    // 136, 23
    jamonWriter.write("\n               </ul>\n            </div><!--/.nav-collapse -->\n        </div>\n    </div>\n\n    <div class=\"container-fluid content\">\n\t");
    // 143, 2
    if (master.isActiveMaster() )
    {
      // 143, 33
      jamonWriter.write("\n        <div class=\"row inner_header\">\n            <div class=\"page-header\">\n                <h1>Master <small>");
      // 146, 35
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
      // 146, 77
      jamonWriter.write("</small></h1>\n            </div>\n        </div>\n\n        <div class=\"row\">\n        <!-- Various warnings that cluster admins should be aware of -->\n        ");
      // 152, 9
      if (JvmVersion.isBadJvmVersion() )
      {
        // 152, 45
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Your current JVM version ");
        // 154, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(System.getProperty("java.version")), jamonWriter);
        // 154, 76
        jamonWriter.write(" is known to be\n          unstable with HBase. Please see the\n          <a href=\"http://wiki.apache.org/hadoop/Hbase/Troubleshooting#A18\">HBase wiki</a>\n          for details.\n          </div>\n        ");
      }
      // 159, 15
      jamonWriter.write("\n        ");
      // 160, 9
      if (master.isInitialized() && !catalogJanitorEnabled )
      {
        // 160, 65
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Please note that your cluster is running with the CatalogJanitor disabled. It can be\n          re-enabled from the hbase shell by running the command 'catalogjanitor_switch true'\n          </div>\n        ");
      }
      // 165, 15
      jamonWriter.write("\n        ");
      // 166, 9
      if (master.isInMaintenanceMode() )
      {
        // 166, 45
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n          Your Master is in maintenance mode. This may be because of HBCK aborting while\n          running in repair mode. Please re-run HBCK in repair mode.\n          </div>\n        ");
      }
      // 171, 15
      jamonWriter.write("\n        ");
      // 172, 9
      if (!master.isBalancerOn() )
      {
        // 172, 39
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            The Load Balancer is not enabled which will eventually cause performance degradation\n            in HBase as Regions will not be distributed across all RegionServers. The balancer\n            is only expected to be disabled during rolling upgrade scenarios.\n          </div>\n        ");
      }
      // 178, 15
      jamonWriter.write("\n        ");
      // 179, 9
      if (!master.isSplitOrMergeEnabled(Admin.MasterSwitchType.SPLIT) )
      {
        // 179, 76
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            Region splits are disabled. This may be the result of HBCK aborting while\n            running in repair mode. Manually enable splits from the HBase shell,\n            or re-run HBCK in repair mode.\n          </div>\n        ");
      }
      // 185, 15
      jamonWriter.write("\n        ");
      // 186, 9
      if (!master.isSplitOrMergeEnabled(Admin.MasterSwitchType.MERGE) )
      {
        // 186, 76
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            Region merges are disabled. This may be the result of HBCK aborting while\n            running in repair mode. Manually enable merges from the HBase shell,\n            or re-run HBCK in repair mode.\n          </div>\n        ");
      }
      // 192, 15
      jamonWriter.write("\n\n        <section>\n            <h2>Region Servers</h2>\n            ");
      // 196, 13
      {
        org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl __jamon__var_7 = new org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl(this.getTemplateManager());
        __jamon__var_7.setServers(servers );
        __jamon__var_7.renderNoFlush(jamonWriter, master);
      }
      // 196, 74
      jamonWriter.write("\n\n            ");
      // 198, 13
      if ((deadServers != null) )
      {
        // 198, 42
        jamonWriter.write("\n                ");
        // 199, 17
        {
          // 199, 17
          __jamon_innerUnit__deadRegionServers(jamonWriter);
        }
        // 199, 40
        jamonWriter.write("\n            ");
      }
      // 200, 19
      jamonWriter.write("\n        </section>\n        <section>\n            ");
      // 203, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_8 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_8.renderNoFlush(jamonWriter, master );
      }
      // 203, 58
      jamonWriter.write("\n        </section>\n        <section>\n            <h2>Tables</h2>\n            <div class=\"tabbable\">\n                <ul class=\"nav nav-pills\">\n                    <li class=\"active\">\n                        <a href=\"#tab_userTables\" data-toggle=\"tab\">User Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_catalogTables\" data-toggle=\"tab\">System Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_userSnapshots\" data-toggle=\"tab\">Snapshots</a>\n                    </li>\n                </ul>\n                <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n                    <div class=\"tab-pane active\" id=\"tab_userTables\">\n                        ");
      // 221, 25
      if ((metaLocation != null) )
      {
        // 221, 55
        jamonWriter.write("\n                            ");
        // 222, 29
        {
          // 222, 29
          __jamon_innerUnit__userTables(jamonWriter);
        }
        // 222, 45
        jamonWriter.write("\n                        ");
      }
      // 223, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_catalogTables\">\n                        ");
      // 226, 25
      if ((metaLocation != null) )
      {
        // 226, 55
        jamonWriter.write("\n                            ");
        // 227, 29
        {
          // 227, 29
          __jamon_innerUnit__catalogTables(jamonWriter);
        }
        // 227, 48
        jamonWriter.write("\n                        ");
      }
      // 228, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_userSnapshots\">\n                        ");
      // 231, 25
      {
        // 231, 25
        __jamon_innerUnit__userSnapshots(jamonWriter);
      }
      // 231, 44
      jamonWriter.write("\n                    </div>\n                </div>\n            </div>\n        </section>\n        ");
      // 236, 9
      if (master.getAssignmentManager() != null )
      {
        // 236, 54
        jamonWriter.write("\n        ");
        // 237, 9
        {
          org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl __jamon__var_9 = new org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl(this.getTemplateManager());
          __jamon__var_9.renderNoFlush(jamonWriter, master.getAssignmentManager());
        }
        // 237, 90
        jamonWriter.write("\n        ");
      }
      // 238, 15
      jamonWriter.write("\n\t");
    }
    // 239, 2
    else
    {
      // 239, 9
      jamonWriter.write("\n        <section>\n            ");
      // 241, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_10 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_10.renderNoFlush(jamonWriter, master );
      }
      // 241, 58
      jamonWriter.write("\n        </section>\n\t");
    }
    // 243, 8
    jamonWriter.write("\n\n\n        <section>\n            ");
    // 247, 13
    {
      org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_11 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
      __jamon__var_11.setFilter(filter );
      __jamon__var_11.renderNoFlush(jamonWriter);
    }
    // 247, 61
    jamonWriter.write("\n        </section>\n\n        <section>\n            <h2>Software Attributes</h2>\n            <table id=\"attributes_table\" class=\"table table-striped\">\n                <tr>\n                    <th>Attribute Name</th>\n                    <th>Value</th>\n                    <th>Description</th>\n                </tr>\n                <tr>\n                    <td>HBase Version</td>\n                    <td>");
    // 260, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getVersion()), jamonWriter);
    // 260, 84
    jamonWriter.write(", revision=");
    // 260, 95
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getRevision()), jamonWriter);
    // 260, 155
    jamonWriter.write("</td><td>HBase version and revision</td>\n                </tr>\n                <tr>\n                    <td>HBase Compiled</td>\n                    <td>");
    // 264, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getDate()), jamonWriter);
    // 264, 81
    jamonWriter.write(", ");
    // 264, 83
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getUser()), jamonWriter);
    // 264, 139
    jamonWriter.write("</td>\n                    <td>When HBase version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>HBase Source Checksum</td>\n                    <td>");
    // 269, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 269, 88
    jamonWriter.write("</td>\n                    <td>HBase source MD5 checksum</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Version</td>\n                    <td>");
    // 274, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getVersion()), jamonWriter);
    // 274, 78
    jamonWriter.write(", revision=");
    // 274, 89
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getRevision()), jamonWriter);
    // 274, 143
    jamonWriter.write("</td>\n                    <td>Hadoop version and revision</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Compiled</td>\n                    <td>");
    // 279, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getDate()), jamonWriter);
    // 279, 75
    jamonWriter.write(", ");
    // 279, 77
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getUser()), jamonWriter);
    // 279, 127
    jamonWriter.write("</td>\n                    <td>When Hadoop version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Source Checksum</td>\n                    <td>");
    // 284, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 284, 82
    jamonWriter.write("</td>\n                    <td>Hadoop source MD5 checksum</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Client Version</td>\n                    <td>");
    // 289, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getVersion()), jamonWriter);
    // 289, 72
    jamonWriter.write(", revision=");
    // 289, 83
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getRevision()), jamonWriter);
    // 289, 131
    jamonWriter.write("</td>\n                    <td>ZooKeeper client version and revision</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Client Compiled</td>\n                    <td>");
    // 294, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getBuildDate()), jamonWriter);
    // 294, 74
    jamonWriter.write("</td>\n                    <td>When ZooKeeper client version was compiled</td>\n                </tr>\n                <tr>\n                    <td>Zookeeper Quorum</td>\n                    <td> ");
    // 300, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(formatZKString()), jamonWriter);
    // 300, 48
    jamonWriter.write(" </td>\n                    <td>Addresses of all registered ZK servers. For more, see <a href=\"/zk.jsp\">zk dump</a>.</td>\n                </tr>\n                <tr>\n                    <td>Zookeeper Base Path</td>\n                    <td> ");
    // 305, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getZooKeeper().getBaseZNode()), jamonWriter);
    // 305, 68
    jamonWriter.write("</td>\n                    <td>Root node of this cluster in ZK.</td>\n                </tr>\n                <tr>\n                    <td>HBase Root Directory</td>\n                    <td>");
    // 310, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(FSUtils.getRootDir(master.getConfiguration()).toString()), jamonWriter);
    // 310, 87
    jamonWriter.write("</td>\n                    <td>Location of HBase home directory</td>\n                </tr>\n                <tr>\n                    <td>HMaster Start Time</td>\n                    <td>");
    // 315, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterStartTime())), jamonWriter);
    // 315, 68
    jamonWriter.write("</td>\n                    <td>Date stamp of when this HMaster was started</td>\n                </tr>\n                ");
    // 318, 17
    if (master.isActiveMaster() )
    {
      // 318, 48
      jamonWriter.write("\n\t                <tr>\n\t                    <td>HMaster Active Time</td>\n\t                    <td>");
      // 321, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterActiveTime())), jamonWriter);
      // 321, 70
      jamonWriter.write("</td>\n\t                    <td>Date stamp of when this HMaster became active</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>HBase Cluster ID</td>\n\t                    <td>");
      // 326, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getClusterId() != null ? master.getClusterId() : "Not set"), jamonWriter);
      // 326, 97
      jamonWriter.write("</td>\n\t                    <td>Unique identifier generated for each HBase cluster</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>Load average</td>\n\t                    <td>");
      // 331, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerManager() == null ? "0.00" :
	                      StringUtils.limitDecimalTo2(master.getServerManager().getAverageLoad())), jamonWriter);
      // 332, 98
      jamonWriter.write("</td>\n\t                    <td>Average number of regions per regionserver. Naive computation.</td>\n\t                </tr>\n\t                ");
      // 335, 18
      if (frags != null )
      {
        // 335, 39
        jamonWriter.write("\n\t                <tr>\n\t                    <td>Fragmentation</td>\n\t                    <td>");
        // 338, 26
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get("-TOTAL-") != null ? frags.get("-TOTAL-").intValue() + "%" : "n/a"), jamonWriter);
        // 338, 108
        jamonWriter.write("</td>\n\t                    <td>Overall fragmentation of all tables, including hbase:meta</td>\n\t                </tr>\n\t                ");
      }
      // 341, 24
      jamonWriter.write("\n\t                <tr>\n\t                    <td>Coprocessors</td>\n\t                    <td>");
      // 344, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getMasterCoprocessorHost() == null ? "[]" :
	                      java.util.Arrays.toString(master.getMasterCoprocessors())), jamonWriter);
      // 345, 84
      jamonWriter.write("</td>\n\t                    <td>Coprocessors currently loaded by the master</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>LoadBalancer</td>\n\t                    <td>");
      // 350, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getLoadBalancerClassName()), jamonWriter);
      // 350, 65
      jamonWriter.write("</td>\n\t                    <td>LoadBalancer to be used in the Master</td>\n\t                </tr>\n                ");
    }
    // 353, 23
    jamonWriter.write("\n            </table>\n        </section>\n        </div>\n    </div> <!-- /container -->\n\n    <script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/jquery.tablesorter.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n    <script>\n        $(document).ready(function() \n            { \n                $(\"#baseStatsTable\").tablesorter();\n                $(\"#memoryStatsTable\").tablesorter();\n                $(\"#requestStatsTable\").tablesorter();\n                $(\"#storeStatsTable\").tablesorter();\n                $(\"#compactionStatsTable\").tablesorter();\n                \n                $(\"#userTables\").tablesorter();\n            } \n        );\n        </script>\n  </body>\n</html>\n\n");
  }
  
  
  // 495, 1
  private void __jamon_innerUnit__userSnapshots(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 496, 1
    
   List<SnapshotDescription> snapshots = null;
   try (Admin admin = master.getConnection().getAdmin()) {
     snapshots = master.isInitialized() ? admin.listSnapshots() : null;
   }

    // 502, 1
    if ((snapshots != null && snapshots.size() > 0))
    {
      // 502, 51
      jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Snapshot Name</th>\n        <th>Table</th>\n        <th>Creation Time</th>\n    </tr>\n    ");
      // 509, 5
      for (SnapshotDescription snapshotDesc : snapshots)
      {
        // 509, 57
        jamonWriter.write("\n    ");
        // 510, 5
        
        TableName snapshotTable = TableName.valueOf(snapshotDesc.getTable());
    
        // 513, 5
        jamonWriter.write("<tr>\n        <td><a href=\"snapshot.jsp?name=");
        // 514, 40
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
        // 514, 68
        jamonWriter.write("\">");
        // 514, 70
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
        // 514, 98
        jamonWriter.write("</a> </td>\n        <td><a href=\"table.jsp?name=");
        // 515, 37
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotTable.getNameAsString()), jamonWriter);
        // 515, 74
        jamonWriter.write("\">");
        // 515, 76
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotTable.getNameAsString()), jamonWriter);
        // 515, 113
        jamonWriter.write("</a>\n        </td>\n        <td>");
        // 517, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(snapshotDesc.getCreationTime())), jamonWriter);
        // 517, 59
        jamonWriter.write("</td>\n    </tr>\n    ");
      }
      // 519, 12
      jamonWriter.write("\n    <p>");
      // 520, 8
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshots.size()), jamonWriter);
      // 520, 30
      jamonWriter.write(" snapshot(s) in set. [<a href=\"/snapshotsStats.jsp\">Snapshot Storefile stats</a>]</p>\n</table>\n");
    }
    // 522, 7
    jamonWriter.write("\n");
  }
  
  
  // 379, 1
  private void __jamon_innerUnit__catalogTables(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 380, 1
    
 HTableDescriptor[] sysTables = null;
 try (Admin admin = master.getConnection().getAdmin()) {
   sysTables = master.isInitialized() ? admin.listTableDescriptorsByNamespace(
     NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR) : null;
 }

    // 387, 1
    if ((sysTables != null && sysTables.length > 0))
    {
      // 387, 51
      jamonWriter.write("\n<table class=\"table table-striped\">\n<tr>\n    <th>Table Name</th>\n    ");
      // 391, 5
      if ((frags != null) )
      {
        // 391, 28
        jamonWriter.write("\n        <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n    ");
      }
      // 393, 11
      jamonWriter.write("\n    <th>Description</th>\n</tr>\n");
      // 396, 1
      for (HTableDescriptor systemTable : sysTables)
      {
        // 396, 49
        jamonWriter.write("\n<tr>\n");
        // 398, 1
        TableName tableName = systemTable.getTableName();
        // 399, 5
        jamonWriter.write("<td><a href=\"table.jsp?name=");
        // 399, 33
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
        // 399, 48
        jamonWriter.write("\">");
        // 399, 50
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
        // 399, 65
        jamonWriter.write("</a></td>\n    ");
        // 400, 5
        if ((frags != null))
        {
          // 400, 27
          jamonWriter.write("\n        <td align=\"center\">");
          // 401, 28
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(tableName.getNameAsString()) != null ? frags.get(tableName.getNameAsString())
        .intValue() + "%" : "n/a"), jamonWriter);
          // 402, 37
          jamonWriter.write("</td>\n    ");
        }
        // 403, 11
        jamonWriter.write("\n    ");
        // 404, 5
        String description = null;
        if (tableName.equals(TableName.META_TABLE_NAME)){
            description = "The hbase:meta table holds references to all User Table regions.";
        } else if (tableName.equals(CanaryTool.DEFAULT_WRITE_TABLE_NAME)){
            description = "The hbase:canary table is used to sniff the write availbility of"
              + " each regionserver.";
        } else if (tableName.equals(AccessControlLists.ACL_TABLE_NAME)){
            description = "The hbase:acl table holds information about acl";
        } else if (tableName.equals(VisibilityConstants.LABELS_TABLE_NAME)){
            description = "The hbase:labels table holds information about visibility labels.";
        } else if (tableName.equals(TableName.NAMESPACE_TABLE_NAME)){
            description = "The hbase:namespace table holds information about namespaces.";
        } else if (tableName.equals(QuotaUtil.QUOTA_TABLE_NAME)){
            description = "The hbase:quota table holds quota information about number" +
            " or size of requests in a given time frame.";
        } else if (tableName.equals(TableName.valueOf("hbase:rsgroup"))){
            description = "The hbase:rsgroup table holds information about regionserver groups";
        }
    
        // 423, 5
        jamonWriter.write("<td>");
        // 423, 9
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(description), jamonWriter);
        // 423, 26
        jamonWriter.write("</td>\n</tr>\n");
      }
      // 425, 8
      jamonWriter.write("\n</table>\n");
    }
    // 427, 7
    jamonWriter.write("\n");
  }
  
  
  // 430, 1
  private void __jamon_innerUnit__userTables(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 431, 1
    
   HTableDescriptor[] tables = null;
   try (Admin admin = master.getConnection().getAdmin()) {
     tables = master.isInitialized() ? admin.listTables() : null;
   }

    // 437, 1
    if ((tables != null && tables.length > 0))
    {
      // 437, 45
      jamonWriter.write("\n<table id=\"userTables\" class=\"tablesorter table table-striped\">\n<thead>\n    <tr>\n        <th>Namespace</th>\n        <th>Table Name</th>\n        ");
      // 443, 9
      if ((frags != null) )
      {
        // 443, 32
        jamonWriter.write("\n            <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n        ");
      }
      // 445, 15
      jamonWriter.write("\n        <th>Online Regions</th>\n        <th>Offline Regions</th>\n        <th>Failed Regions</th>\n        <th>Split Regions</th>\n        <th>Other Regions</th>\n        <th>Description</th>\n    </tr>\n</thead>\n<tbody>\n    ");
      // 455, 5
      for (HTableDescriptor htDesc : tables)
      {
        // 455, 45
        jamonWriter.write("\n    ");
        // 456, 5
        
      TableName tableName = htDesc.getTableName();
      Map<RegionState.State, List<HRegionInfo>> tableRegions =
          master.getAssignmentManager().getRegionStates()
            .getRegionByStateOfTable(tableName);
      int openRegionsCount = tableRegions.get(RegionState.State.OPEN).size();
      int offlineRegionsCount = tableRegions.get(RegionState.State.OFFLINE).size();
      int splitRegionsCount = tableRegions.get(RegionState.State.SPLIT).size();
      int failedRegionsCount = tableRegions.get(RegionState.State.FAILED_OPEN).size()
             + tableRegions.get(RegionState.State.FAILED_CLOSE).size();
      int otherRegionsCount = 0;
      for (List<HRegionInfo> list: tableRegions.values()) {
         otherRegionsCount += list.size();
      }
      // now subtract known states
      otherRegionsCount = otherRegionsCount - openRegionsCount
                     - failedRegionsCount - offlineRegionsCount
                     - splitRegionsCount;
    
        // 475, 5
        jamonWriter.write("<tr>\n        <td>");
        // 476, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getNamespaceAsString()), jamonWriter);
        // 476, 51
        jamonWriter.write("</td>\n        <td><a href=table.jsp?name=");
        // 477, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getNameAsString()), jamonWriter);
        // 477, 69
        jamonWriter.write(">");
        // 477, 70
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName.getQualifierAsString()), jamonWriter);
        // 477, 108
        jamonWriter.write("</a> </td>\n        ");
        // 478, 9
        if ((frags != null) )
        {
          // 478, 32
          jamonWriter.write("\n            <td align=\"center\">");
          // 479, 32
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(tableName.getNameAsString()) != null ? frags.get(tableName.getNameAsString()).intValue() + "%" : "n/a"), jamonWriter);
          // 479, 150
          jamonWriter.write("</td>\n        ");
        }
        // 480, 15
        jamonWriter.write("\n        <td>");
        // 481, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(openRegionsCount), jamonWriter);
        // 481, 35
        jamonWriter.write("</td>\n        <td>");
        // 482, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(offlineRegionsCount), jamonWriter);
        // 482, 38
        jamonWriter.write("</td>\n        <td>");
        // 483, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(failedRegionsCount), jamonWriter);
        // 483, 37
        jamonWriter.write("</td>\n        <td>");
        // 484, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(splitRegionsCount), jamonWriter);
        // 484, 36
        jamonWriter.write("</td>\n        <td>");
        // 485, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(otherRegionsCount), jamonWriter);
        // 485, 36
        jamonWriter.write("</td>\n        <td>");
        // 486, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.toStringCustomizedValues()), jamonWriter);
        // 486, 52
        jamonWriter.write("</td>\n    </tr>\n    ");
      }
      // 488, 12
      jamonWriter.write("\n    <p>");
      // 489, 8
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tables.length), jamonWriter);
      // 489, 27
      jamonWriter.write(" table(s) in set. [<a href=tablesDetailed.jsp>Details</a>]</p>\n</tbody>\n</table>\n");
    }
    // 492, 7
    jamonWriter.write("\n");
  }
  
  
  // 526, 1
  private void __jamon_innerUnit__deadRegionServers(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 528, 1
    if ((deadServers != null && deadServers.size() > 0))
    {
      // 528, 55
      jamonWriter.write("\n<h2>Dead Region Servers</h2>\n<table class=\"table table-striped\">\n    <tr>\n        <th></th>\n        <th>ServerName</th>\n        <th>Stop time</th>\n    </tr>\n    ");
      // 536, 5
      
       DeadServer deadServerUtil = master.getServerManager().getDeadServers();
       ServerName [] deadServerNames = deadServers.toArray(new ServerName[deadServers.size()]);
         Arrays.sort(deadServerNames);
         for (ServerName deadServerName: deadServerNames) {
    
      // 542, 5
      jamonWriter.write("<tr>\n    \t<th></th>\n        <td>");
      // 544, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerName), jamonWriter);
      // 544, 33
      jamonWriter.write("</td>\n        <td>");
      // 545, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerUtil.getTimeOfDeath(deadServerName)), jamonWriter);
      // 545, 64
      jamonWriter.write("</td>\n    </tr>\n    ");
      // 547, 5
      
        }
    
      // 550, 5
      jamonWriter.write("<tr>\n        <th>Total: </th>\n        <td>servers: ");
      // 552, 22
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServers.size()), jamonWriter);
      // 552, 46
      jamonWriter.write("</td>\n        <th></th>\n    </tr>\n</table>\n");
    }
    // 556, 7
    jamonWriter.write("\n");
  }
  
  
}
