/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coordination.ZkCoordinatedStateManager;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStateStore;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConfigUtil;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestAssignmentManagerOnCluster {
    private static final byte[] FAMILY = Bytes.toBytes((String)"FAMILY");
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    static final Configuration conf = TEST_UTIL.getConfiguration();
    private static HBaseAdmin admin;

    static void setupOnce() throws Exception {
        conf.setClass("hbase.master.loadbalancer.class", MyLoadBalancer.class, LoadBalancer.class);
        conf.setClass("hbase.coprocessor.region.classes", MyRegionObserver.class, RegionObserver.class);
        conf.setInt("hbase.assignment.maximum.attempts", 3);
        conf.set("hbase.balancer.tablesOnMaster", "hbase:meta");
        conf.setInt("hbase.master.maximum.ping.server.attempts", 3);
        conf.setInt("hbase.master.ping.server.retry.sleep.interval", 1);
        TEST_UTIL.startMiniCluster(1, 4, null, MyMaster.class, MyRegionServer.class);
        admin = TEST_UTIL.getHBaseAdmin();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf.setBoolean("hbase.assignment.usezk", true);
        TestAssignmentManagerOnCluster.setupOnce();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testRestartMetaRegionServer() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        boolean stoppedARegionServer = false;
        try {
            HMaster master = cluster.getMaster();
            RegionStates regionStates = master.getAssignmentManager().getRegionStates();
            ServerName metaServerName = regionStates.getRegionServerOfRegion(HRegionInfo.FIRST_META_REGIONINFO);
            if (master.getServerName().equals((Object)metaServerName) || metaServerName == null || !metaServerName.equals((Object)cluster.getServerHoldingMeta())) {
                metaServerName = cluster.getLiveRegionServerThreads().get(0).getRegionServer().getServerName();
                master.move(HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes(), Bytes.toBytes((String)metaServerName.getServerName()));
                master.assignmentManager.waitUntilNoRegionsInTransition(60000L);
            }
            RegionState metaState = MetaTableLocator.getMetaRegionState((ZooKeeperWatcher)master.getZooKeeper());
            Assert.assertEquals((String)"Meta should be not in transition", (Object)metaState.getState(), (Object)RegionState.State.OPEN);
            Assert.assertNotEquals((String)"Meta should be moved off master", (Object)metaServerName, (Object)master.getServerName());
            cluster.killRegionServer(metaServerName);
            stoppedARegionServer = true;
            cluster.waitForRegionServerToStop(metaServerName, 60000L);
            final ServerManager serverManager = master.getServerManager();
            TEST_UTIL.waitFor(120000L, 200L, new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return !serverManager.areDeadServersInProgress();
                }
            });
            Assert.assertTrue((String)"Meta should be assigned", (boolean)regionStates.isRegionOnline(HRegionInfo.FIRST_META_REGIONINFO));
            metaState = MetaTableLocator.getMetaRegionState((ZooKeeperWatcher)master.getZooKeeper());
            Assert.assertEquals((String)"Meta should be not in transition", (Object)metaState.getState(), (Object)RegionState.State.OPEN);
            Assert.assertEquals((String)"Meta should be assigned", (Object)metaState.getServerName(), (Object)regionStates.getRegionServerOfRegion(HRegionInfo.FIRST_META_REGIONINFO));
            Assert.assertNotEquals((String)"Meta should be assigned on a different server", (Object)metaState.getServerName(), (Object)metaServerName);
        }
        finally {
            if (stoppedARegionServer) {
                cluster.startRegionServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAssignRegion() throws Exception {
        String table = "testAssignRegion";
        try {
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)table));
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaTableAccessor.addRegionToMeta((Table)meta, (HRegionInfo)hri);
            HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
            AssignmentManager am = master.getAssignmentManager();
            TEST_UTIL.assignRegion(hri);
            RegionStates regionStates = am.getRegionStates();
            ServerName serverName = regionStates.getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnServer(hri, serverName, 6000L);
            RegionState oldState = regionStates.getRegionState(hri);
            TEST_UTIL.getHBaseAdmin().assign(hri.getRegionName());
            master.getAssignmentManager().waitForAssignment(hri);
            RegionState newState = regionStates.getRegionState(hri);
            Assert.assertTrue((newState.isOpened() && newState.getStamp() != oldState.getStamp() ? 1 : 0) != 0);
        }
        finally {
            TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAssignRegionBySSH() throws Exception {
        if (!conf.getBoolean("hbase.assignment.usezk", true)) {
            return;
        }
        String table = "testAssignRegionBySSH";
        MyMaster master = (MyMaster)TEST_UTIL.getHBaseCluster().getMaster();
        try {
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)table));
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaTableAccessor.addRegionToMeta((Table)meta, (HRegionInfo)hri);
            MetaTableAccessor.updateRegionLocation((Connection)TEST_UTIL.getHBaseCluster().getMaster().getConnection(), (HRegionInfo)hri, (ServerName)ServerName.valueOf((String)"example.org", (int)1234, (long)System.currentTimeMillis()), (long)0L, (long)-1L);
            RegionStates regionStates = master.getAssignmentManager().getRegionStates();
            int i = TEST_UTIL.getHBaseCluster().getServerWithMeta();
            HRegionServer rs = TEST_UTIL.getHBaseCluster().getRegionServer(i == 0 ? 1 : 0);
            ServerName controlledServer = rs.getServerName();
            master.enableSSH(false);
            TEST_UTIL.getHBaseCluster().killRegionServer(controlledServer);
            TEST_UTIL.getHBaseCluster().waitForRegionServerToStop(controlledServer, -1L);
            AssignmentManager am = master.getAssignmentManager();
            regionStates.createRegionState(hri, RegionState.State.OFFLINE, controlledServer, null);
            am.assign(hri, true, true);
            Assert.assertEquals((Object)RegionState.State.OFFLINE, (Object)regionStates.getRegionState(hri).getState());
            Assert.assertTrue((boolean)regionStates.isRegionInTransition(hri));
            master.enableSSH(true);
            am.waitForAssignment(hri);
            Assert.assertTrue((boolean)regionStates.getRegionState(hri).isOpened());
            ServerName serverName = regionStates.getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnlyOnServer(hri, serverName, 6000L);
        }
        finally {
            if (master != null) {
                master.enableSSH(true);
            }
            TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
            TEST_UTIL.getHBaseCluster().startRegionServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testAssignRegionOnRestartedServer() throws Exception {
        String table;
        block5: {
            table = "testAssignRegionOnRestartedServer";
            TEST_UTIL.getMiniHBaseCluster().getConf().setInt("hbase.assignment.maximum.attempts", 20);
            TEST_UTIL.getMiniHBaseCluster().stopMaster(0);
            TEST_UTIL.getMiniHBaseCluster().startMaster();
            ServerName deadServer = null;
            HMaster master = null;
            try {
                HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)table));
                desc.addFamily(new HColumnDescriptor(FAMILY));
                admin.createTable(desc);
                HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
                final HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
                MetaTableAccessor.addRegionToMeta((Table)meta, (HRegionInfo)hri);
                master = TEST_UTIL.getHBaseCluster().getMaster();
                Set onlineServers = master.serverManager.getOnlineServers().keySet();
                Assert.assertFalse((String)"There should be some servers online", (boolean)onlineServers.isEmpty());
                ServerName destServer = (ServerName)onlineServers.iterator().next();
                deadServer = ServerName.valueOf((String)destServer.getHostname(), (int)destServer.getPort(), (long)(destServer.getStartcode() - 100L));
                master.serverManager.recordNewServerWithLock(deadServer, ServerLoad.EMPTY_SERVERLOAD);
                final AssignmentManager am = master.getAssignmentManager();
                RegionPlan plan = new RegionPlan(hri, null, deadServer);
                am.addPlan(hri.getEncodedName(), plan);
                TEST_UTIL.assignRegion(hri);
                int version = ZKAssign.transitionNode((ZooKeeperWatcher)master.getZooKeeper(), (HRegionInfo)hri, (ServerName)destServer, (EventType)EventType.M_ZK_REGION_OFFLINE, (EventType)EventType.RS_ZK_REGION_OPENING, (int)0);
                Assert.assertEquals((String)"TansitionNode should fail", (long)-1L, (long)version);
                TEST_UTIL.waitFor(60000L, new Waiter.Predicate<Exception>(){

                    public boolean evaluate() throws Exception {
                        return !am.getRegionStates().isRegionInTransition(hri);
                    }
                });
                Assert.assertFalse((String)"Region should be assigned", (boolean)am.getRegionStates().isRegionInTransition(hri));
                if (deadServer == null) break block5;
            }
            catch (Throwable throwable) {
                if (deadServer != null) {
                    master.serverManager.expireServer(deadServer);
                }
                TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
                TEST_UTIL.getMiniHBaseCluster().getConf().setInt("hbase.assignment.maximum.attempts", 3);
                ServerName masterServerName = TEST_UTIL.getMiniHBaseCluster().getMaster().getServerName();
                TEST_UTIL.getMiniHBaseCluster().stopMaster(masterServerName);
                TEST_UTIL.getMiniHBaseCluster().startMaster();
                while (TEST_UTIL.getMiniHBaseCluster().getMaster() == null || !TEST_UTIL.getMiniHBaseCluster().getMaster().isInitialized()) {
                    Threads.sleep((long)1L);
                }
                throw throwable;
            }
            master.serverManager.expireServer(deadServer);
        }
        TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
        TEST_UTIL.getMiniHBaseCluster().getConf().setInt("hbase.assignment.maximum.attempts", 3);
        ServerName masterServerName = TEST_UTIL.getMiniHBaseCluster().getMaster().getServerName();
        TEST_UTIL.getMiniHBaseCluster().stopMaster(masterServerName);
        TEST_UTIL.getMiniHBaseCluster().startMaster();
        while (TEST_UTIL.getMiniHBaseCluster().getMaster() == null || !TEST_UTIL.getMiniHBaseCluster().getMaster().isInitialized()) {
            Threads.sleep((long)1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testOfflineRegion() throws Exception {
        TableName table = TableName.valueOf((String)"testOfflineRegion");
        try {
            HRegionInfo hri = this.createTableAndGetOneRegion(table);
            RegionStates regionStates = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates();
            ServerName serverName = regionStates.getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnServer(hri, serverName, 6000L);
            admin.offline(hri.getRegionName());
            long timeoutTime = System.currentTimeMillis() + 800L;
            while (!((List)regionStates.getRegionByStateOfTable(table).get(RegionState.State.OFFLINE)).contains(hri)) {
                long now = System.currentTimeMillis();
                if (now > timeoutTime) {
                    Assert.fail((String)"Failed to offline the region in time");
                    break;
                }
                Thread.sleep(10L);
            }
            RegionState regionState = regionStates.getRegionState(hri);
            Assert.assertTrue((boolean)regionState.isOffline());
        }
        finally {
            TEST_UTIL.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=50000L)
    public void testMoveRegion() throws Exception {
        TableName table = TableName.valueOf((String)"testMoveRegion");
        try {
            JVMClusterUtil.RegionServerThread regionServer;
            HRegionServer destServer;
            HRegionInfo hri = this.createTableAndGetOneRegion(table);
            HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
            RegionStates regionStates = master.getAssignmentManager().getRegionStates();
            ServerName serverName = regionStates.getRegionServerOfRegion(hri);
            ServerManager serverManager = master.getServerManager();
            ServerName destServerName = null;
            List<JVMClusterUtil.RegionServerThread> regionServers = TEST_UTIL.getHBaseCluster().getLiveRegionServerThreads();
            Iterator<JVMClusterUtil.RegionServerThread> i$ = regionServers.iterator();
            while (i$.hasNext() && ((destServerName = (destServer = (regionServer = i$.next()).getRegionServer()).getServerName()).equals((Object)serverName) || !serverManager.isServerOnline(destServerName))) {
            }
            Assert.assertTrue((destServerName != null && !destServerName.equals((Object)serverName) ? 1 : 0) != 0);
            TEST_UTIL.getHBaseAdmin().move(hri.getEncodedNameAsBytes(), Bytes.toBytes((String)destServerName.getServerName()));
            long timeoutTime = System.currentTimeMillis() + 30000L;
            while (true) {
                ServerName sn;
                if ((sn = regionStates.getRegionServerOfRegion(hri)) != null && sn.equals((Object)destServerName)) {
                    TEST_UTIL.assertRegionOnServer(hri, sn, 6000L);
                    break;
                }
                long now = System.currentTimeMillis();
                if (now > timeoutTime) {
                    Assert.fail((String)("Failed to move the region in time: " + regionStates.getRegionState(hri)));
                }
                regionStates.waitForUpdate(50L);
            }
        }
        finally {
            TEST_UTIL.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=50000L)
    public void testMoveRegionOfDeletedTable() throws Exception {
        TableName table = TableName.valueOf((String)"testMoveRegionOfDeletedTable");
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        try {
            HRegionInfo hri = this.createTableAndGetOneRegion(table);
            HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
            AssignmentManager am = master.getAssignmentManager();
            RegionStates regionStates = am.getRegionStates();
            ServerName serverName = regionStates.getRegionServerOfRegion(hri);
            ServerName destServerName = null;
            for (int i = 0; i < 3; ++i) {
                HRegionServer destServer = TEST_UTIL.getHBaseCluster().getRegionServer(i);
                if (destServer.getServerName().equals((Object)serverName)) continue;
                destServerName = destServer.getServerName();
                break;
            }
            Assert.assertTrue((destServerName != null && !destServerName.equals((Object)serverName) ? 1 : 0) != 0);
            TEST_UTIL.deleteTable(table);
            try {
                admin.move(hri.getEncodedNameAsBytes(), Bytes.toBytes((String)destServerName.getServerName()));
                Assert.fail((String)"We should not find the region");
            }
            catch (IOException ioe) {
                Assert.assertTrue((boolean)(ioe instanceof UnknownRegionException));
            }
            am.balance(new RegionPlan(hri, serverName, destServerName));
            Assert.assertFalse((String)"The region should not be in transition", (boolean)regionStates.isRegionInTransition(hri));
        }
        finally {
            if (admin.tableExists(table)) {
                TEST_UTIL.deleteTable(table);
            }
        }
    }

    HRegionInfo createTableAndGetOneRegion(TableName tableName) throws IOException, InterruptedException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILY));
        admin.createTable(desc, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"), 5);
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        long timeoutTime = System.currentTimeMillis() + 1000L;
        List regions;
        while ((regions = master.getAssignmentManager().getRegionStates().getRegionsOfTable(tableName)).size() <= 3) {
            long now = System.currentTimeMillis();
            if (now > timeoutTime) {
                Assert.fail((String)"Could not find an online region");
            }
            Thread.sleep(10L);
        }
        return (HRegionInfo)regions.get(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testForceAssignWhileClosing() throws Exception {
        String table = "testForceAssignWhileClosing";
        try {
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)table));
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaTableAccessor.addRegionToMeta((Table)meta, (HRegionInfo)hri);
            HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
            AssignmentManager am = master.getAssignmentManager();
            Assert.assertTrue((boolean)TEST_UTIL.assignRegion(hri));
            ServerName sn = am.getRegionStates().getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnServer(hri, sn, 6000L);
            MyRegionObserver.preCloseEnabled.set(true);
            am.unassign(hri);
            RegionState state = am.getRegionStates().getRegionState(hri);
            Assert.assertEquals((Object)RegionState.State.FAILED_CLOSE, (Object)state.getState());
            MyRegionObserver.preCloseEnabled.set(false);
            am.unassign(hri, true);
            am.assign(hri, true, true);
            am.waitOnRegionToClearRegionsInTransition(hri);
            Assert.assertTrue((boolean)am.waitForAssignment(hri));
            ServerName serverName = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnlyOnServer(hri, serverName, 200L);
        }
        finally {
            MyRegionObserver.preCloseEnabled.set(false);
            TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testCloseFailed() throws Exception {
        String table = "testCloseFailed";
        try {
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)table));
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaTableAccessor.addRegionToMeta((Table)meta, (HRegionInfo)hri);
            HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
            AssignmentManager am = master.getAssignmentManager();
            Assert.assertTrue((boolean)TEST_UTIL.assignRegion(hri));
            ServerName sn = am.getRegionStates().getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnServer(hri, sn, 6000L);
            MyRegionObserver.preCloseEnabled.set(true);
            am.unassign(hri);
            RegionState state = am.getRegionStates().getRegionState(hri);
            Assert.assertEquals((Object)RegionState.State.FAILED_CLOSE, (Object)state.getState());
            MyRegionObserver.preCloseEnabled.set(false);
            am.unassign(hri, true);
            am.waitOnRegionToClearRegionsInTransition(hri);
            Assert.assertTrue((boolean)am.waitForAssignment(hri));
            ServerName serverName = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnServer(hri, serverName, 6000L);
        }
        finally {
            MyRegionObserver.preCloseEnabled.set(false);
            TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testOpenFailed() throws Exception {
        String table = "testOpenFailed";
        try {
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)table));
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaTableAccessor.addRegionToMeta((Table)meta, (HRegionInfo)hri);
            MyLoadBalancer.controledRegion = hri;
            HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
            AssignmentManager am = master.getAssignmentManager();
            Assert.assertFalse((boolean)TEST_UTIL.assignRegion(hri));
            RegionState state = am.getRegionStates().getRegionState(hri);
            Assert.assertEquals((Object)RegionState.State.FAILED_OPEN, (Object)state.getState());
            Assert.assertNull((Object)state.getServerName());
            MyLoadBalancer.controledRegion = null;
            Assert.assertTrue((boolean)TEST_UTIL.assignRegion(hri));
            ServerName serverName = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnServer(hri, serverName, 6000L);
        }
        finally {
            MyLoadBalancer.controledRegion = null;
            TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testRoundRobinAssignmentFailed() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRoundRobinAssignmentFailed");
        try {
            HTableDescriptor desc = new HTableDescriptor(tableName);
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTableInterface meta = admin.getConnection().getTable(TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaTableAccessor.addRegionToMeta((Table)meta, (HRegionInfo)hri);
            MyLoadBalancer.controledRegion = hri;
            HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
            AssignmentManager am = master.getAssignmentManager();
            am.assign(Arrays.asList(hri));
            Assert.assertFalse((boolean)am.waitForAssignment(hri));
            RegionState state = am.getRegionStates().getRegionState(hri);
            Assert.assertEquals((Object)RegionState.State.FAILED_OPEN, (Object)state.getState());
            Assert.assertNull((Object)state.getServerName());
            MyLoadBalancer.controledRegion = null;
            am.assign(Arrays.asList(hri));
            Assert.assertTrue((boolean)am.waitForAssignment(hri));
            ServerName serverName = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnServer(hri, serverName, 200L);
        }
        finally {
            MyLoadBalancer.controledRegion = null;
            TEST_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testRetainAssignmentFailed() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRetainAssignmentFailed");
        try {
            HTableDescriptor desc = new HTableDescriptor(tableName);
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            Table meta = TEST_UTIL.getConnection().getTable(TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaTableAccessor.addRegionToMeta((Table)meta, (HRegionInfo)hri);
            MyLoadBalancer.controledRegion = hri;
            HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
            AssignmentManager am = master.getAssignmentManager();
            HashMap<HRegionInfo, ServerName> regions = new HashMap<HRegionInfo, ServerName>();
            ServerName dest = TEST_UTIL.getHBaseCluster().getRegionServer(0).getServerName();
            regions.put(hri, dest);
            am.assign(regions);
            Assert.assertFalse((boolean)am.waitForAssignment(hri));
            RegionState state = am.getRegionStates().getRegionState(hri);
            Assert.assertEquals((Object)RegionState.State.FAILED_OPEN, (Object)state.getState());
            Assert.assertNull((Object)state.getServerName());
            MyLoadBalancer.controledRegion = null;
            am.assign(regions);
            Assert.assertTrue((boolean)am.waitForAssignment(hri));
            ServerName serverName = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnServer(hri, serverName, 200L);
            Assert.assertEquals((Object)serverName, (Object)dest);
        }
        finally {
            MyLoadBalancer.controledRegion = null;
            TEST_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testOpenFailedUnrecoverable() throws Exception {
        TableName table = TableName.valueOf((String)"testOpenFailedUnrecoverable");
        try {
            HTableDescriptor desc = new HTableDescriptor(table);
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaTableAccessor.addRegionToMeta((Table)meta, (HRegionInfo)hri);
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path tableDir = FSUtils.getTableDir((Path)FSUtils.getRootDir((Configuration)conf), (TableName)table);
            Path regionDir = new Path(tableDir, hri.getEncodedName());
            fs.create(regionDir, true);
            HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
            AssignmentManager am = master.getAssignmentManager();
            Assert.assertFalse((boolean)TEST_UTIL.assignRegion(hri));
            RegionState state = am.getRegionStates().getRegionState(hri);
            Assert.assertEquals((Object)RegionState.State.FAILED_OPEN, (Object)state.getState());
            Assert.assertNotNull((Object)state.getServerName());
            fs.delete(regionDir, true);
            Assert.assertTrue((boolean)TEST_UTIL.assignRegion(hri));
            ServerName serverName = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnServer(hri, serverName, 6000L);
        }
        finally {
            TEST_UTIL.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSSHWhenDisablingTableRegionsInOpeningOrPendingOpenState() throws Exception {
        TableName table = TableName.valueOf((String)"testSSHWhenDisablingTableRegionsInOpeningOrPendingOpenState");
        AssignmentManager am = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager();
        HRegionInfo hri = null;
        ServerName serverName = null;
        try {
            hri = this.createTableAndGetOneRegion(table);
            serverName = am.getRegionStates().getRegionServerOfRegion(hri);
            ServerName destServerName = null;
            HRegionServer destServer = null;
            for (int i = 0; i < 3; ++i) {
                destServer = TEST_UTIL.getHBaseCluster().getRegionServer(i);
                if (destServer.getServerName().equals((Object)serverName)) continue;
                destServerName = destServer.getServerName();
                break;
            }
            am.regionOffline(hri);
            ZooKeeperWatcher zkw = TEST_UTIL.getHBaseCluster().getMaster().getZooKeeper();
            am.getRegionStates().updateRegionState(hri, RegionState.State.PENDING_OPEN, destServerName);
            if (ConfigUtil.useZKForAssignment((Configuration)conf)) {
                ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)hri, (ServerName)destServerName);
                ZKAssign.transitionNodeOpening((ZooKeeperWatcher)zkw, (HRegionInfo)hri, (ServerName)destServerName);
                long timeoutTime = System.currentTimeMillis() + 20000L;
                while (!am.getRegionStates().isRegionInTransition(hri)) {
                    Assert.assertTrue((String)"Failed to process ZK opening event in time", (System.currentTimeMillis() < timeoutTime ? 1 : 0) != 0);
                    Thread.sleep(100L);
                }
            }
            am.getTableStateManager().setTableState(table, ZooKeeperProtos.Table.State.DISABLING);
            List toAssignRegions = am.cleanOutCrashedServerReferences(destServerName);
            Assert.assertTrue((String)"Regions to be assigned should be empty.", (boolean)toAssignRegions.isEmpty());
            Assert.assertTrue((String)"Regions to be assigned should be empty.", (boolean)am.getRegionStates().getRegionState(hri).isOffline());
        }
        finally {
            if (hri != null && serverName != null) {
                am.regionOnline(hri, serverName);
            }
            am.getTableStateManager().setTableState(table, ZooKeeperProtos.Table.State.DISABLED);
            TEST_UTIL.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testCloseHang() throws Exception {
        String table = "testCloseHang";
        try {
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)table));
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaTableAccessor.addRegionToMeta((Table)meta, (HRegionInfo)hri);
            HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
            AssignmentManager am = master.getAssignmentManager();
            Assert.assertTrue((boolean)TEST_UTIL.assignRegion(hri));
            ServerName sn = am.getRegionStates().getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnServer(hri, sn, 6000L);
            MyRegionObserver.postCloseEnabled.set(true);
            am.unassign(hri);
            am.server.getConfiguration().setLong("hbase.assignment.already.intransition.waittime", 1000L);
            am.unassign(hri, true);
            RegionState state = am.getRegionStates().getRegionState(hri);
            Assert.assertEquals((Object)RegionState.State.FAILED_CLOSE, (Object)state.getState());
            MyRegionObserver.postCloseEnabled.set(false);
            am.waitOnRegionToClearRegionsInTransition(hri);
            Assert.assertTrue((boolean)am.waitForAssignment(hri));
            ServerName serverName = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnServer(hri, serverName, 6000L);
        }
        finally {
            MyRegionObserver.postCloseEnabled.set(false);
            TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testOpenCloseRacing() throws Exception {
        String table = "testOpenCloseRacing";
        try {
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)table));
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaTableAccessor.addRegionToMeta((Table)meta, (HRegionInfo)hri);
            meta.close();
            MyRegionObserver.postOpenEnabled.set(true);
            MyRegionObserver.postOpenCalled = false;
            HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
            AssignmentManager am = master.getAssignmentManager();
            am.assign(hri, true);
            long end = EnvironmentEdgeManager.currentTime() + 20000L;
            while (!MyRegionObserver.postOpenCalled) {
                Assert.assertFalse((String)"Timed out waiting for postOpen to be called", (EnvironmentEdgeManager.currentTime() > end ? 1 : 0) != 0);
                Thread.sleep(300L);
            }
            am.unassign(hri);
            RegionState state = am.getRegionStates().getRegionState(hri);
            ServerName oldServerName = state.getServerName();
            Assert.assertTrue((state.isPendingOpenOrOpening() && oldServerName != null ? 1 : 0) != 0);
            ServerName destServerName = null;
            int numRS = TEST_UTIL.getHBaseCluster().getLiveRegionServerThreads().size();
            for (int i = 0; i < numRS; ++i) {
                HRegionServer destServer = TEST_UTIL.getHBaseCluster().getRegionServer(i);
                if (destServer.getServerName().equals((Object)oldServerName)) continue;
                destServerName = destServer.getServerName();
                break;
            }
            Assert.assertNotNull(destServerName);
            Assert.assertFalse((String)"Region should be assigned on a new region server", (boolean)oldServerName.equals(destServerName));
            ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>();
            regions.add(hri);
            am.assign(destServerName, regions);
            MyRegionObserver.postOpenEnabled.set(false);
            am.waitOnRegionToClearRegionsInTransition(hri);
            Assert.assertTrue((boolean)am.waitForAssignment(hri));
            ServerName serverName = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnlyOnServer(hri, serverName, 6000L);
        }
        finally {
            MyRegionObserver.postOpenEnabled.set(false);
            TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAssignRacingWithSSH() throws Exception {
        String table = "testAssignRacingWithSSH";
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        MyMaster master = null;
        try {
            ServerName oldServerName;
            RegionState state;
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)table));
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaTableAccessor.addRegionToMeta((Table)meta, (HRegionInfo)hri);
            master = (MyMaster)cluster.getMaster();
            AssignmentManager am = master.getAssignmentManager();
            am.assign(hri, true);
            master.enableSSH(false);
            RegionStates regionStates = am.getRegionStates();
            ServerName metaServer = regionStates.getRegionServerOfRegion(HRegionInfo.FIRST_META_REGIONINFO);
            while (true) {
                Assert.assertTrue((boolean)am.waitForAssignment(hri));
                state = regionStates.getRegionState(hri);
                oldServerName = state.getServerName();
                if (!ServerName.isSameHostnameAndPort((ServerName)oldServerName, (ServerName)metaServer)) break;
                int i = cluster.getServerWithMeta();
                HRegionServer rs = cluster.getRegionServer(i == 0 ? 1 : 0);
                oldServerName = rs.getServerName();
                master.move(hri.getEncodedNameAsBytes(), Bytes.toBytes((String)oldServerName.getServerName()));
            }
            cluster.killRegionServer(oldServerName);
            cluster.waitForRegionServerToStop(oldServerName, -1L);
            am.assign(hri, true, true);
            state = regionStates.getRegionState(hri);
            Assert.assertTrue((boolean)state.isFailedClose());
            am.unassign(hri, true);
            Assert.assertTrue((boolean)state.isFailedClose());
            master.enableSSH(true);
            am.waitOnRegionToClearRegionsInTransition(hri);
            Assert.assertTrue((boolean)am.waitForAssignment(hri));
            ServerName serverName = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnlyOnServer(hri, serverName, 6000L);
        }
        finally {
            if (master != null) {
                master.enableSSH(true);
            }
            TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
            cluster.startRegionServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAssignDisabledRegion() throws Exception {
        TableName table = TableName.valueOf((String)"testAssignDisabledRegion");
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        MyMaster master = null;
        try {
            HTableDescriptor desc = new HTableDescriptor(table);
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaTableAccessor.addRegionToMeta((Table)meta, (HRegionInfo)hri);
            master = (MyMaster)cluster.getMaster();
            AssignmentManager am = master.getAssignmentManager();
            RegionStates regionStates = am.getRegionStates();
            Assert.assertTrue((boolean)TEST_UTIL.assignRegion(hri));
            admin.disableTable(table);
            Assert.assertTrue((boolean)regionStates.isRegionOffline(hri));
            am.assign(hri, true, true);
            Assert.assertTrue((boolean)regionStates.isRegionOffline(hri));
            am.unassign(hri, true);
            Assert.assertTrue((boolean)regionStates.isRegionOffline(hri));
        }
        finally {
            TEST_UTIL.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAssignOfflinedRegionBySSH() throws Exception {
        String table = "testAssignOfflinedRegionBySSH";
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        MyMaster master = null;
        try {
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)table));
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaTableAccessor.addRegionToMeta((Table)meta, (HRegionInfo)hri);
            master = (MyMaster)cluster.getMaster();
            AssignmentManager am = master.getAssignmentManager();
            am.assign(hri, true);
            RegionStates regionStates = am.getRegionStates();
            ServerName metaServer = regionStates.getRegionServerOfRegion(HRegionInfo.FIRST_META_REGIONINFO);
            ServerName oldServerName = null;
            while (true) {
                Assert.assertTrue((boolean)am.waitForAssignment(hri));
                RegionState state = regionStates.getRegionState(hri);
                oldServerName = state.getServerName();
                if (!ServerName.isSameHostnameAndPort((ServerName)oldServerName, (ServerName)metaServer)) break;
                int i = cluster.getServerWithMeta();
                HRegionServer rs = cluster.getRegionServer(i == 0 ? 1 : 0);
                oldServerName = rs.getServerName();
                master.move(hri.getEncodedNameAsBytes(), Bytes.toBytes((String)oldServerName.getServerName()));
            }
            MyRegionServer.abortedServer = oldServerName;
            Assert.assertTrue((boolean)regionStates.isRegionOnline(hri));
            Assert.assertEquals((Object)oldServerName, (Object)regionStates.getRegionServerOfRegion(hri));
            cluster.killRegionServer(oldServerName);
            cluster.waitForRegionServerToStop(oldServerName, -1L);
            ServerManager serverManager = master.getServerManager();
            while (!serverManager.isServerDead(oldServerName) || serverManager.getDeadServers().areDeadServersInProgress()) {
                Thread.sleep(100L);
            }
            am.waitOnRegionToClearRegionsInTransition(hri);
            Assert.assertTrue((boolean)am.waitForAssignment(hri));
            ServerName serverName = master.getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnlyOnServer(hri, serverName, 200L);
        }
        finally {
            MyRegionServer.abortedServer = null;
            TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
            cluster.startRegionServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testSSHWaitForServerToAssignRegion() throws Exception {
        TableName table = TableName.valueOf((String)"testSSHWaitForServerToAssignRegion");
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        boolean startAServer = false;
        try {
            HTableDescriptor desc = new HTableDescriptor(table);
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HMaster master = cluster.getMaster();
            final ServerManager serverManager = master.getServerManager();
            MyLoadBalancer.countRegionServers = serverManager.countOfRegionServers();
            HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(table);
            Assert.assertNotNull((String)"First region should be assigned", (Object)rs);
            final ServerName serverName = rs.getServerName();
            int counter = MyLoadBalancer.counter.get() + 5;
            cluster.killRegionServer(serverName);
            startAServer = true;
            cluster.waitForRegionServerToStop(serverName, -1L);
            while (counter > MyLoadBalancer.counter.get()) {
                Thread.sleep(1000L);
            }
            cluster.startRegionServer();
            startAServer = false;
            TEST_UTIL.waitFor(120000L, 1000L, new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return serverManager.isServerDead(serverName) && !serverManager.areDeadServersInProgress();
                }
            });
            TEST_UTIL.waitUntilAllRegionsAssigned(table, 300000L);
            rs = TEST_UTIL.getRSForFirstRegionInTable(table);
            Assert.assertTrue((String)"First region should be re-assigned to a different server", (rs != null && !serverName.equals((Object)rs.getServerName()) ? 1 : 0) != 0);
        }
        finally {
            MyLoadBalancer.countRegionServers = null;
            TEST_UTIL.deleteTable(table);
            if (startAServer) {
                cluster.startRegionServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAssignDisabledRegionBySSH() throws Exception {
        String table = "testAssignDisabledRegionBySSH";
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        MyMaster master = null;
        try {
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)table));
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaTableAccessor.addRegionToMeta((Table)meta, (HRegionInfo)hri);
            master = (MyMaster)cluster.getMaster();
            AssignmentManager am = master.getAssignmentManager();
            am.assign(hri, true);
            RegionStates regionStates = am.getRegionStates();
            ServerName metaServer = regionStates.getRegionServerOfRegion(HRegionInfo.FIRST_META_REGIONINFO);
            ServerName oldServerName = null;
            while (true) {
                Assert.assertTrue((boolean)am.waitForAssignment(hri));
                RegionState state = regionStates.getRegionState(hri);
                oldServerName = state.getServerName();
                if (!ServerName.isSameHostnameAndPort((ServerName)oldServerName, (ServerName)metaServer)) break;
                int i = cluster.getServerWithMeta();
                HRegionServer rs = cluster.getRegionServer(i == 0 ? 1 : 0);
                oldServerName = rs.getServerName();
                master.move(hri.getEncodedNameAsBytes(), Bytes.toBytes((String)oldServerName.getServerName()));
            }
            MyRegionServer.abortedServer = oldServerName;
            Assert.assertTrue((boolean)regionStates.isRegionOnline(hri));
            Assert.assertEquals((Object)oldServerName, (Object)regionStates.getRegionServerOfRegion(hri));
            master.disableTable(hri.getTable(), 0L, 0L);
            cluster.killRegionServer(oldServerName);
            cluster.waitForRegionServerToStop(oldServerName, -1L);
            ServerManager serverManager = master.getServerManager();
            while (!serverManager.isServerDead(oldServerName) || serverManager.getDeadServers().areDeadServersInProgress()) {
                Thread.sleep(100L);
            }
            am.waitUntilNoRegionsInTransition(60000L);
            Assert.assertTrue((boolean)regionStates.isRegionOffline(hri));
        }
        finally {
            MyRegionServer.abortedServer = null;
            TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
            cluster.startRegionServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testReportRegionStateTransition() throws Exception {
        String table = "testReportRegionStateTransition";
        try {
            MyRegionServer.simulateRetry = true;
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)table));
            desc.addFamily(new HColumnDescriptor(FAMILY));
            admin.createTable(desc);
            HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
            HRegionInfo hri = new HRegionInfo(desc.getTableName(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            MetaTableAccessor.addRegionToMeta((Table)meta, (HRegionInfo)hri);
            HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
            AssignmentManager am = master.getAssignmentManager();
            TEST_UTIL.assignRegion(hri);
            RegionStates regionStates = am.getRegionStates();
            ServerName serverName = regionStates.getRegionServerOfRegion(hri);
            TEST_UTIL.assertRegionOnServer(hri, serverName, 6000L);
            admin.disableTable(TableName.valueOf((String)table));
            Assert.assertTrue((boolean)regionStates.isRegionOffline(hri));
            List regions = TEST_UTIL.getHBaseAdmin().getOnlineRegions(serverName);
            Assert.assertTrue((!regions.contains(hri) ? 1 : 0) != 0);
        }
        finally {
            MyRegionServer.simulateRetry = false;
            TEST_UTIL.deleteTable(Bytes.toBytes((String)table));
        }
    }

    @Test(timeout=30000L)
    public void testUpdatesRemoteMeta() throws Exception {
        Result result;
        int i;
        if (conf.getBoolean("hbase.assignment.usezk", true)) {
            return;
        }
        conf.setInt("hbase.regionstatestore.meta.connection", 3);
        final RegionStateStore rss = new RegionStateStore((Server)new MyRegionServer(conf, (CoordinatedStateManager)new ZkCoordinatedStateManager()));
        rss.start();
        Thread[] th = new Thread[10];
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<TableName> tableNameList = new ArrayList<TableName>();
        for (i = 0; i < th.length; ++i) {
            th[i] = new Thread(){

                @Override
                public void run() {
                    HRegionInfo[] hri = new HRegionInfo[10];
                    ServerName serverName = ServerName.valueOf((String)"dummyhost", (int)1000, (long)1234L);
                    for (int i = 0; i < 10; ++i) {
                        hri[i] = new HRegionInfo(TableName.valueOf((String)(Thread.currentThread().getName() + "_" + i)));
                        RegionState newState = new RegionState(hri[i], RegionState.State.OPEN, serverName);
                        RegionState oldState = new RegionState(hri[i], RegionState.State.PENDING_OPEN, serverName);
                        rss.updateRegionState(1L, newState, oldState);
                    }
                }
            };
            th[i].start();
            nameList.add(th[i].getName());
        }
        for (i = 0; i < th.length; ++i) {
            th[i].join();
        }
        for (String name : nameList) {
            for (int i2 = 0; i2 < 10; ++i2) {
                tableNameList.add(TableName.valueOf((String)(name + "_" + i2)));
            }
        }
        List metaRows = MetaTableAccessor.fullScanOfMeta((Connection)admin.getConnection());
        int count = 0;
        Iterator i$ = metaRows.iterator();
        while (i$.hasNext() && (!tableNameList.contains(HRegionInfo.getTable((byte[])(result = (Result)i$.next()).getRow())) || ++count != 100)) {
        }
        Assert.assertTrue((count == 100 ? 1 : 0) != 0);
        rss.stop();
    }

    public static class MyRegionObserver
    extends BaseRegionObserver {
        static AtomicBoolean preCloseEnabled = new AtomicBoolean(false);
        static AtomicBoolean postCloseEnabled = new AtomicBoolean(false);
        static AtomicBoolean postOpenEnabled = new AtomicBoolean(false);
        static volatile boolean postOpenCalled = false;

        public void preClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) throws IOException {
            if (preCloseEnabled.get()) {
                throw new IOException("fail preClose from coprocessor");
            }
        }

        public void postClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) {
            this.stallOnFlag(postCloseEnabled);
        }

        public void postOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
            postOpenCalled = true;
            this.stallOnFlag(postOpenEnabled);
        }

        private void stallOnFlag(AtomicBoolean flag) {
            try {
                while (flag.get()) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static class MyRegionServer
    extends MiniHBaseCluster.MiniHBaseClusterRegionServer {
        static volatile ServerName abortedServer = null;
        static volatile boolean simulateRetry = false;

        public MyRegionServer(Configuration conf, CoordinatedStateManager cp) throws IOException, KeeperException, InterruptedException {
            super(conf, cp);
        }

        public boolean reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode code, long openSeqNum, HRegionInfo ... hris) {
            if (simulateRetry) {
                super.reportRegionStateTransition(code, openSeqNum, hris);
                return super.reportRegionStateTransition(code, openSeqNum, hris);
            }
            return super.reportRegionStateTransition(code, openSeqNum, hris);
        }

        public boolean isAborted() {
            return this.getServerName().equals((Object)abortedServer) || super.isAborted();
        }
    }

    public static class MyMaster
    extends HMaster {
        AtomicBoolean enabled = new AtomicBoolean(true);

        public MyMaster(Configuration conf, CoordinatedStateManager cp) throws IOException, KeeperException, InterruptedException {
            super(conf, cp);
        }

        public boolean isServerCrashProcessingEnabled() {
            return this.enabled.get() && super.isServerCrashProcessingEnabled();
        }

        public void enableSSH(boolean enabled) {
            this.enabled.set(enabled);
            if (enabled) {
                this.serverManager.processQueuedDeadServers();
            }
        }
    }

    static class MyLoadBalancer
    extends StochasticLoadBalancer {
        static volatile HRegionInfo controledRegion = null;
        static volatile Integer countRegionServers = null;
        static AtomicInteger counter = new AtomicInteger(0);

        MyLoadBalancer() {
        }

        public ServerName randomAssignment(HRegionInfo regionInfo, List<ServerName> servers) {
            if (regionInfo.equals((Object)controledRegion)) {
                return null;
            }
            return super.randomAssignment(regionInfo, servers);
        }

        public Map<ServerName, List<HRegionInfo>> roundRobinAssignment(List<HRegionInfo> regions, List<ServerName> servers) {
            int regionServers;
            if (countRegionServers != null && this.services != null && (regionServers = this.services.getServerManager().countOfRegionServers()) < countRegionServers) {
                counter.incrementAndGet();
                return null;
            }
            if (regions.get(0).equals((Object)controledRegion)) {
                HashMap m = Maps.newHashMap();
                m.put(LoadBalancer.BOGUS_SERVER_NAME, regions);
                return m;
            }
            return super.roundRobinAssignment(regions, servers);
        }

        public Map<ServerName, List<HRegionInfo>> retainAssignment(Map<HRegionInfo, ServerName> regions, List<ServerName> servers) {
            for (HRegionInfo hri : regions.keySet()) {
                if (!hri.equals((Object)controledRegion)) continue;
                HashMap m = Maps.newHashMap();
                m.put(LoadBalancer.BOGUS_SERVER_NAME, Lists.newArrayList(regions.keySet()));
                return m;
            }
            return super.retainAssignment(regions, servers);
        }
    }
}

