/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RpcHandler
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(RpcHandler.class);
    final BlockingQueue<CallRunner> q;
    final int handlerCount;
    final double handlerFailureThreshhold;
    final AtomicInteger activeHandlerCount;
    final AtomicInteger failedHandlerCount;
    final Abortable abortable;
    private boolean running;

    RpcHandler(String name, double handlerFailureThreshhold, int handlerCount, BlockingQueue<CallRunner> q, AtomicInteger activeHandlerCount, AtomicInteger failedHandlerCount, Abortable abortable) {
        super(name);
        this.setDaemon(true);
        this.q = q;
        this.handlerFailureThreshhold = handlerFailureThreshhold;
        this.activeHandlerCount = activeHandlerCount;
        this.failedHandlerCount = failedHandlerCount;
        this.handlerCount = handlerCount;
        this.abortable = abortable;
    }

    protected CallRunner getCallRunner() throws InterruptedException {
        return this.q.take();
    }

    public void stopRunning() {
        this.running = false;
    }

    @Override
    public void run() {
        boolean interrupted = false;
        this.running = true;
        try {
            while (this.running) {
                try {
                    this.run(this.getCallRunner());
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        catch (Exception e) {
            LOG.warn(e.toString(), (Throwable)e);
            throw e;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void run(CallRunner cr) {
        MonitoredRPCHandler status = RpcServer.getStatus();
        cr.setStatus(status);
        try {
            this.activeHandlerCount.incrementAndGet();
            cr.run();
            return;
        }
        catch (Throwable e) {
            if (!(e instanceof Error)) {
                LOG.warn("Handler exception " + StringUtils.stringifyException((Throwable)e));
                return;
            }
            int failedCount = this.failedHandlerCount.incrementAndGet();
            if (this.handlerFailureThreshhold >= 0.0 && (double)failedCount > (double)this.handlerCount * this.handlerFailureThreshhold) {
                String message = "Number of failed RpcServer handler runs exceeded threshhold " + this.handlerFailureThreshhold + "; reason: " + StringUtils.stringifyException((Throwable)e);
                if (this.abortable != null) {
                    this.abortable.abort(message, e);
                    return;
                }
                LOG.error("Error but can't abort because abortable is null: " + StringUtils.stringifyException((Throwable)e));
                throw e;
            }
            LOG.warn("Handler errors " + StringUtils.stringifyException((Throwable)e));
            return;
        }
        finally {
            this.activeHandlerCount.decrementAndGet();
        }
    }
}

