/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues;

import com.google.common.base.Preconditions;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.namequeues.DisruptorExceptionHandler;
import org.apache.hadoop.hbase.namequeues.LogEventHandler;
import org.apache.hadoop.hbase.namequeues.NamedQueuePayload;
import org.apache.hadoop.hbase.namequeues.RingBufferEnvelope;
import org.apache.hadoop.hbase.namequeues.request.NamedQueueGetRequest;
import org.apache.hadoop.hbase.namequeues.response.NamedQueueGetResponse;
import org.apache.hadoop.hbase.util.Threads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class NamedQueueRecorder
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(NamedQueueRecorder.class);
    private final Disruptor<RingBufferEnvelope> disruptor;
    private final LogEventHandler logEventHandler;
    private final ExecutorService executorService;
    private static NamedQueueRecorder namedQueueRecorder;
    private static boolean isInit;
    private static final Object LOCK;
    private volatile boolean closed = false;

    private NamedQueueRecorder(Configuration conf) {
        String hostingThreadName = Thread.currentThread().getName();
        int eventCount = conf.getInt("hbase.namedqueue.ringbuffer.size", 1024);
        this.executorService = Executors.newSingleThreadExecutor(Threads.getNamedThreadFactory((String)(hostingThreadName + ".slowlog.append-pool")));
        this.disruptor = new Disruptor(this.getEventFactory(), this.getEventCount(eventCount), (Executor)this.executorService, ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        this.disruptor.handleExceptionsWith((ExceptionHandler)new DisruptorExceptionHandler());
        this.logEventHandler = new LogEventHandler(conf);
        this.disruptor.handleEventsWith((EventHandler[])new LogEventHandler[]{this.logEventHandler});
        this.disruptor.start();
    }

    private EventFactory<RingBufferEnvelope> getEventFactory() {
        return new EventFactory<RingBufferEnvelope>(){

            public RingBufferEnvelope newInstance() {
                return new RingBufferEnvelope();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NamedQueueRecorder getInstance(Configuration conf) {
        if (namedQueueRecorder != null) {
            return namedQueueRecorder;
        }
        Object object = LOCK;
        synchronized (object) {
            if (!isInit) {
                namedQueueRecorder = new NamedQueueRecorder(conf);
                isInit = true;
            }
        }
        return namedQueueRecorder;
    }

    private int getEventCount(int eventCount) {
        Preconditions.checkArgument((eventCount >= 0 ? 1 : 0) != 0, (Object)"hbase.namedqueue.ringbuffer.size must be > 0");
        int floor = Integer.highestOneBit(eventCount);
        if (floor == eventCount) {
            return floor;
        }
        if (floor >= 0x20000000) {
            return 0x40000000;
        }
        return floor << 1;
    }

    public NamedQueueGetResponse getNamedQueueRecords(NamedQueueGetRequest request) {
        return this.logEventHandler.getNamedQueueRecords(request);
    }

    public boolean clearNamedQueue(NamedQueuePayload.NamedQueueEvent namedQueueEvent) {
        return this.logEventHandler.clearNamedQueue(namedQueueEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(NamedQueuePayload namedQueuePayload) {
        if (!this.closed) {
            RingBuffer ringBuffer = this.disruptor.getRingBuffer();
            long seqId = ringBuffer.next();
            try {
                ((RingBufferEnvelope)ringBuffer.get(seqId)).load(namedQueuePayload);
            }
            finally {
                ringBuffer.publish(seqId);
            }
        }
    }

    public void persistAll(NamedQueuePayload.NamedQueueEvent namedQueueEvent) {
        if (this.logEventHandler != null) {
            this.logEventHandler.persistAll(namedQueueEvent);
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        LOG.info("Closing NamedQueueRecorder");
        if (this.disruptor != null) {
            long timeoutms = 5000L;
            try {
                this.disruptor.shutdown(timeoutms, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                LOG.warn("Timed out bringing down disruptor after " + timeoutms + " ms; forcing halt", (Throwable)e);
                this.disruptor.halt();
                this.disruptor.shutdown();
            }
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    static {
        isInit = false;
        LOCK = new Object();
    }
}

