/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SplitLogCounters;
import org.apache.hadoop.hbase.SplitLogTask;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.coordination.SplitLogWorkerCoordination;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.SplitLogWorker;
import org.apache.hadoop.hbase.util.CancelableProgressable;

@InterfaceAudience.Private
public class WALSplitterHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(WALSplitterHandler.class);
    private final ServerName serverName;
    private final CancelableProgressable reporter;
    private final AtomicInteger inProgressTasks;
    private final SplitLogWorker.TaskExecutor splitTaskExecutor;
    private final ZooKeeperProtos.SplitLogTask.RecoveryMode mode;
    private final SplitLogWorkerCoordination.SplitTaskDetails splitTaskDetails;
    private final SplitLogWorkerCoordination coordination;

    public WALSplitterHandler(Server server, SplitLogWorkerCoordination coordination, SplitLogWorkerCoordination.SplitTaskDetails splitDetails, CancelableProgressable reporter, AtomicInteger inProgressTasks, SplitLogWorker.TaskExecutor splitTaskExecutor, ZooKeeperProtos.SplitLogTask.RecoveryMode mode) {
        super(server, EventType.RS_LOG_REPLAY);
        this.splitTaskDetails = splitDetails;
        this.coordination = coordination;
        this.reporter = reporter;
        this.inProgressTasks = inProgressTasks;
        this.inProgressTasks.incrementAndGet();
        this.serverName = server.getServerName();
        this.splitTaskExecutor = splitTaskExecutor;
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process() throws IOException {
        long startTime = System.currentTimeMillis();
        try {
            SplitLogWorker.TaskExecutor.Status status = this.splitTaskExecutor.exec(this.splitTaskDetails.getWALFile(), this.mode, this.reporter);
            switch (status) {
                case DONE: {
                    this.coordination.endTask(new SplitLogTask.Done(this.serverName, this.mode), SplitLogCounters.tot_wkr_task_done, this.splitTaskDetails);
                    return;
                }
                case PREEMPTED: {
                    SplitLogCounters.tot_wkr_preempt_task.incrementAndGet();
                    LOG.warn((Object)("task execution preempted " + this.splitTaskDetails.getWALFile()));
                    return;
                }
                case ERR: {
                    if (this.server != null && !this.server.isStopped()) {
                        this.coordination.endTask(new SplitLogTask.Err(this.serverName, this.mode), SplitLogCounters.tot_wkr_task_err, this.splitTaskDetails);
                        return;
                    }
                }
                case RESIGNED: {
                    if (this.server != null && this.server.isStopped()) {
                        LOG.info((Object)("task execution interrupted because worker is exiting " + this.splitTaskDetails.toString()));
                    }
                    this.coordination.endTask(new SplitLogTask.Resigned(this.serverName, this.mode), SplitLogCounters.tot_wkr_task_resigned, this.splitTaskDetails);
                    return;
                }
            }
            return;
        }
        finally {
            LOG.info((Object)("worker " + this.serverName + " done with task " + this.splitTaskDetails.toString() + " in " + (System.currentTimeMillis() - startTime) + "ms"));
            this.inProgressTasks.decrementAndGet();
        }
    }
}

