/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.util.LRUDictionary;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;

@InterfaceAudience.Private
public abstract class WriterBase
implements DefaultWALProvider.Writer {
    protected CompressionContext compressionContext;
    protected Configuration conf;

    @Override
    public void init(FileSystem fs, Path path, Configuration conf, boolean overwritable) throws IOException {
        this.conf = conf;
    }

    public boolean initializeCompressionContext(Configuration conf, Path path) throws IOException {
        boolean doCompress = conf.getBoolean("hbase.regionserver.wal.enablecompression", false);
        if (doCompress) {
            try {
                this.compressionContext = new CompressionContext(LRUDictionary.class, FSUtils.isRecoveredEdits((Path)path), conf.getBoolean("hbase.regionserver.wal.tags.enablecompression", true));
            }
            catch (Exception e) {
                throw new IOException("Failed to initiate CompressionContext", e);
            }
        }
        return doCompress;
    }
}

