/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.UUID;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.replication.BaseReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.wal.WAL;

@InterfaceAudience.Private
public class VerifyWALEntriesReplicationEndpoint
extends BaseReplicationEndpoint {
    @Override
    public boolean canReplicateToSameCluster() {
        return true;
    }

    @Override
    public UUID getPeerUUID() {
        return this.ctx.getClusterId();
    }

    @Override
    public WALEntryFilter getWALEntryfilter() {
        return null;
    }

    private void checkCell(Cell cell) {
        CellUtil.cloneRow((Cell)cell);
        CellUtil.cloneFamily((Cell)cell);
        CellUtil.cloneQualifier((Cell)cell);
        CellUtil.cloneValue((Cell)cell);
    }

    @Override
    public boolean replicate(ReplicationEndpoint.ReplicateContext replicateContext) {
        for (WAL.Entry entry : replicateContext.getEntries()) {
            for (Cell cell : entry.getEdit().getCells()) {
                this.checkCell(cell);
            }
        }
        return true;
    }

    protected void doStart() {
        this.notifyStarted();
    }

    protected void doStop() {
        this.notifyStopped();
    }
}

