/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ReplicationSourceLogQueue {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationSource.class);
    private Map<String, PriorityBlockingQueue<Path>> queues = new ConcurrentHashMap<String, PriorityBlockingQueue<Path>>();
    private MetricsSource metrics;
    private Configuration conf;
    private int queueSizePerGroup;
    private int logQueueWarnThreshold;

    public ReplicationSourceLogQueue(Configuration conf, MetricsSource metrics) {
        this.conf = conf;
        this.metrics = metrics;
        this.queueSizePerGroup = this.conf.getInt("hbase.regionserver.maxlogs", 32);
        this.logQueueWarnThreshold = this.conf.getInt("replication.source.log.queue.warn", 2);
    }

    public boolean enqueueLog(Path wal, String walGroupId) {
        boolean exists = false;
        PriorityBlockingQueue<Path> queue = this.queues.get(walGroupId);
        if (queue == null) {
            queue = new PriorityBlockingQueue<Path>(this.queueSizePerGroup, new ReplicationSource.LogsComparator());
            queue.put(wal);
            this.queues.put(walGroupId, queue);
        } else {
            exists = true;
            queue.put(wal);
        }
        this.metrics.incrSizeOfLogQueue();
        this.metrics.setOldestWalAge(this.getOldestWalAge());
        int queueSize = queue.size();
        if (queueSize > this.logQueueWarnThreshold) {
            LOG.warn("WAL group " + walGroupId + " queue size: " + queueSize + " exceeds value of replication.source.log.queue.warn: " + this.logQueueWarnThreshold);
        }
        return exists;
    }

    public int getQueueSize(String walGroupId) {
        Queue queue = this.queues.get(walGroupId);
        if (queue == null) {
            return 0;
        }
        return queue.size();
    }

    public int getNumQueues() {
        return this.queues.size();
    }

    public Map<String, PriorityBlockingQueue<Path>> getQueues() {
        return this.queues;
    }

    public PriorityBlockingQueue<Path> getQueue(String walGroupId) {
        return this.queues.get(walGroupId);
    }

    public void remove(String walGroupId) {
        PriorityBlockingQueue<Path> queue = this.getQueue(walGroupId);
        if (queue == null || queue.isEmpty()) {
            return;
        }
        queue.remove();
        this.metrics.decrSizeOfLogQueue();
        this.metrics.setOldestWalAge(this.getOldestWalAge());
    }

    public void clear(String walGroupId) {
        PriorityBlockingQueue<Path> queue = this.getQueue(walGroupId);
        while (!queue.isEmpty()) {
            queue.remove();
            this.metrics.decrSizeOfLogQueue();
        }
        this.metrics.setOldestWalAge(this.getOldestWalAge());
    }

    long getOldestWalAge() {
        long now = EnvironmentEdgeManager.currentTime();
        long timestamp = this.getOldestWalTimestamp();
        if (timestamp == Long.MAX_VALUE) {
            timestamp = now;
        }
        long age = now - timestamp;
        return age;
    }

    private long getOldestWalTimestamp() {
        long oldestWalTimestamp = Long.MAX_VALUE;
        for (Map.Entry<String, PriorityBlockingQueue<Path>> entry : this.queues.entrySet()) {
            PriorityBlockingQueue<Path> queue = entry.getValue();
            Path path = queue.peek();
            if (path == null) continue;
            oldestWalTimestamp = Math.min(oldestWalTimestamp, ReplicationSource.LogsComparator.getTS(path));
        }
        return oldestWalTimestamp;
    }

    public MetricsSource getMetrics() {
        return this.metrics;
    }
}

