/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import com.google.protobuf.Message;
import java.io.IOException;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.SnapshotCleanupProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class SnapshotCleanupTracker
extends ZooKeeperNodeTracker {
    public SnapshotCleanupTracker(ZooKeeperWatcher watcher, Abortable abortable) {
        super(watcher, watcher.snapshotCleanupZNode, abortable);
    }

    public boolean isSnapshotCleanupEnabled() {
        byte[] snapshotCleanupZNodeData = super.getData(false);
        try {
            return snapshotCleanupZNodeData == null || this.parseFrom(snapshotCleanupZNodeData).getSnapshotCleanupEnabled();
        }
        catch (DeserializationException dex) {
            LOG.error((Object)("ZK state for Snapshot Cleanup could not be parsed " + Bytes.toStringBinary((byte[])snapshotCleanupZNodeData)), (Throwable)dex);
            return false;
        }
    }

    public void setSnapshotCleanupEnabled(boolean snapshotCleanupEnabled) throws KeeperException {
        byte[] snapshotCleanupZNodeData = this.toByteArray(snapshotCleanupEnabled);
        try {
            ZKUtil.setData((ZooKeeperWatcher)this.watcher, (String)this.watcher.snapshotCleanupZNode, (byte[])snapshotCleanupZNodeData);
        }
        catch (KeeperException.NoNodeException nne) {
            ZKUtil.createAndWatch((ZooKeeperWatcher)this.watcher, (String)this.watcher.snapshotCleanupZNode, (byte[])snapshotCleanupZNodeData);
        }
        super.nodeDataChanged(this.watcher.snapshotCleanupZNode);
    }

    private byte[] toByteArray(boolean isSnapshotCleanupEnabled) {
        SnapshotCleanupProtos.SnapshotCleanupState.Builder builder = SnapshotCleanupProtos.SnapshotCleanupState.newBuilder();
        builder.setSnapshotCleanupEnabled(isSnapshotCleanupEnabled);
        return ProtobufUtil.prependPBMagic((byte[])builder.build().toByteArray());
    }

    private SnapshotCleanupProtos.SnapshotCleanupState parseFrom(byte[] pbBytes) throws DeserializationException {
        ProtobufUtil.expectPBMagicPrefix((byte[])pbBytes);
        SnapshotCleanupProtos.SnapshotCleanupState.Builder builder = SnapshotCleanupProtos.SnapshotCleanupState.newBuilder();
        try {
            int magicLen = ProtobufUtil.lengthOfPBMagic();
            ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])pbBytes, (int)magicLen, (int)(pbBytes.length - magicLen));
        }
        catch (IOException e) {
            throw new DeserializationException((Throwable)e);
        }
        return builder.build();
    }
}

