/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hadoop.hbase.master.balancer.SimpleLoadBalancer;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestSimpleLoadBalancer
extends BalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSimpleLoadBalancer.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSimpleLoadBalancer.class);
    private static SimpleLoadBalancer loadBalancer;
    int[][] clusterStateMocks = new int[][]{{0}, {1}, {10}, {0, 0}, {2, 0}, {2, 1}, {2, 2}, {2, 3}, {2, 4}, {1, 1}, {0, 1}, {10, 1}, {14, 1432}, {47, 53}, {0, 1, 2}, {1, 2, 3}, {0, 2, 2}, {0, 3, 0}, {0, 4, 0}, {20, 20, 0}, {0, 1, 2, 3}, {4, 0, 0, 0}, {5, 0, 0, 0}, {6, 6, 0, 0}, {6, 2, 0, 0}, {6, 1, 0, 0}, {6, 0, 0, 0}, {4, 4, 4, 7}, {4, 4, 4, 8}, {0, 0, 0, 7}, {1, 1, 1, 1, 4}, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 10}, {6, 6, 5, 6, 6, 6, 6, 6, 6, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 54}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 55}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 56}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 16}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 8}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 9}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 10}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 123}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 155}, {0, 0, 144, 1, 1, 1, 1, 1123, 133, 138, 12, 1444}, {0, 0, 144, 1, 0, 4, 1, 1123, 133, 138, 12, 1444}, {1538, 1392, 1561, 1557, 1535, 1553, 1385, 1542, 1619}};
    int[] mockUniformCluster = new int[]{5, 5, 5, 5, 5, 0};
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setClass("hbase.util.ip.to.rack.determiner", BalancerTestBase.MockMapping.class, DNSToSwitchMapping.class);
        conf.set("hbase.regions.slop", "0");
        loadBalancer = new SimpleLoadBalancer();
        MasterServices services = (MasterServices)Mockito.mock(MasterServices.class);
        Mockito.when((Object)services.getConfiguration()).thenReturn((Object)conf);
        loadBalancer.setMasterServices(services);
        loadBalancer.initialize();
    }

    @Test
    public void testBalanceClusterOverall() throws Exception {
        TreeMap<TableName, TreeMap<ServerName, List<RegionInfo>>> clusterLoad = new TreeMap<TableName, TreeMap<ServerName, List<RegionInfo>>>();
        for (int[] mockCluster : this.clusterStateMocks) {
            TreeMap<ServerName, List<RegionInfo>> clusterServers = this.mockClusterServers(mockCluster, 30);
            List<ServerAndLoad> clusterList = this.convertToList(clusterServers);
            clusterLoad.put(TableName.valueOf((String)this.name.getMethodName()), clusterServers);
            HashMap<TableName, TreeMap<ServerName, List<RegionInfo>>> result = this.mockClusterServersWithTables(clusterServers);
            loadBalancer.setClusterLoad(clusterLoad);
            ArrayList<RegionPlan> clusterplans = new ArrayList<RegionPlan>();
            ArrayList regionAmountList = new ArrayList();
            for (Map.Entry<TableName, TreeMap<ServerName, List<RegionInfo>>> mapEntry : result.entrySet()) {
                TableName tableName = mapEntry.getKey();
                TreeMap<ServerName, List<RegionInfo>> servers = mapEntry.getValue();
                List<ServerAndLoad> list = this.convertToList(servers);
                LOG.info("Mock Cluster : " + this.printMock(list) + " " + this.printStats(list));
                List partialplans = loadBalancer.balanceTable(tableName, servers);
                if (partialplans != null) {
                    clusterplans.addAll(partialplans);
                }
                List<ServerAndLoad> balancedClusterPerTable = this.reconcile(list, partialplans, servers);
                LOG.info("Mock Balance : " + this.printMock(balancedClusterPerTable));
                this.assertClusterAsBalanced(balancedClusterPerTable);
                for (Map.Entry<ServerName, List<RegionInfo>> entry : servers.entrySet()) {
                    this.returnRegions(entry.getValue());
                    this.returnServer(entry.getKey());
                }
            }
            List<ServerAndLoad> balancedCluster = this.reconcile(clusterList, clusterplans, clusterServers);
            Assert.assertTrue((boolean)this.assertClusterOverallAsBalanced(balancedCluster, result.keySet().size()));
        }
    }

    @Test
    public void testImpactOfBalanceClusterOverall() throws Exception {
        this.testImpactOfBalanceClusterOverall(false);
    }

    @Test
    public void testImpactOfBalanceClusterOverallWithLoadOfAllTable() throws Exception {
        this.testImpactOfBalanceClusterOverall(true);
    }

    private void testImpactOfBalanceClusterOverall(boolean useLoadOfAllTable) throws Exception {
        TreeMap<TableName, TreeMap<ServerName, List<RegionInfo>>> clusterLoad = new TreeMap<TableName, TreeMap<ServerName, List<RegionInfo>>>();
        TreeMap<ServerName, List<RegionInfo>> clusterServers = this.mockUniformClusterServers(this.mockUniformCluster);
        List<ServerAndLoad> clusterList = this.convertToList(clusterServers);
        clusterLoad.put(TableName.valueOf((String)this.name.getMethodName()), clusterServers);
        HashMap<TableName, TreeMap<ServerName, List<RegionInfo>>> LoadOfAllTable = this.mockClusterServersWithTables(clusterServers);
        if (useLoadOfAllTable) {
            loadBalancer.setClusterLoad(LoadOfAllTable);
        } else {
            loadBalancer.setClusterLoad(clusterLoad);
        }
        ArrayList<RegionPlan> clusterplans1 = new ArrayList<RegionPlan>();
        ArrayList regionAmountList = new ArrayList();
        for (Map.Entry<TableName, TreeMap<ServerName, List<RegionInfo>>> mapEntry : LoadOfAllTable.entrySet()) {
            TableName tableName = mapEntry.getKey();
            TreeMap<ServerName, List<RegionInfo>> servers = mapEntry.getValue();
            List<ServerAndLoad> list = this.convertToList(servers);
            LOG.info("Mock Cluster : " + this.printMock(list) + " " + this.printStats(list));
            List partialplans = loadBalancer.balanceTable(tableName, servers);
            if (partialplans != null) {
                clusterplans1.addAll(partialplans);
            }
            List<ServerAndLoad> balancedClusterPerTable = this.reconcile(list, partialplans, servers);
            LOG.info("Mock Balance : " + this.printMock(balancedClusterPerTable));
            this.assertClusterAsBalanced(balancedClusterPerTable);
            for (Map.Entry<ServerName, List<RegionInfo>> entry : servers.entrySet()) {
                this.returnRegions(entry.getValue());
                this.returnServer(entry.getKey());
            }
        }
        List<ServerAndLoad> balancedCluster1 = this.reconcile(clusterList, clusterplans1, clusterServers);
        Assert.assertTrue((boolean)this.assertClusterOverallAsBalanced(balancedCluster1, LoadOfAllTable.keySet().size()));
    }

    @Test
    public void testBalanceClusterOverallStrictly() {
        int[][] regionsPerServerPerTable = new int[][]{{3, 3, 4, 4, 4, 4, 5, 5, 5}, {2, 2, 2, 2, 2, 2, 2, 2, 1}};
        TreeMap<ServerName, List<RegionInfo>> serverRegionInfo = this.mockClusterServers(regionsPerServerPerTable);
        List<ServerAndLoad> serverAndLoads = this.convertToList(serverRegionInfo);
        HashMap<TableName, TreeMap<ServerName, List<RegionInfo>>> loadOfAllTable = this.mockClusterServersWithTables(serverRegionInfo);
        loadBalancer.setClusterLoad(loadOfAllTable);
        List partialplans = loadBalancer.balanceTable(TableName.valueOf((String)"table0"), (Map)loadOfAllTable.get(TableName.valueOf((String)"table0")));
        List<ServerAndLoad> balancedServerLoads = this.reconcile(serverAndLoads, partialplans, serverRegionInfo);
        for (ServerAndLoad serverAndLoad : balancedServerLoads) {
            Assert.assertEquals((long)6L, (long)serverAndLoad.getLoad());
        }
    }
}

