/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class PrefetchExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(PrefetchExecutor.class);
    private static final Map<Path, Future<?>> prefetchFutures = new ConcurrentSkipListMap();
    private static final ScheduledExecutorService prefetchExecutorPool;
    private static final int prefetchDelayMillis;
    private static final float prefetchDelayVariation;
    private static final Pattern prefetchPathExclude;

    public static void request(Path path, Runnable runnable) {
        if (!prefetchPathExclude.matcher(path.toString()).find()) {
            long delay = prefetchDelayMillis > 0 ? (long)((float)prefetchDelayMillis * (1.0f - prefetchDelayVariation / 2.0f) + (float)prefetchDelayMillis * (prefetchDelayVariation / 2.0f) * ThreadLocalRandom.current().nextFloat()) : 0L;
            try {
                LOG.debug("Prefetch requested for {}, delay={} ms", (Object)path, (Object)delay);
                Runnable tracedRunnable = TraceUtil.tracedRunnable((Runnable)runnable, (String)"PrefetchExecutor.request");
                ScheduledFuture<?> future = prefetchExecutorPool.schedule(tracedRunnable, delay, TimeUnit.MILLISECONDS);
                prefetchFutures.put(path, future);
            }
            catch (RejectedExecutionException e) {
                prefetchFutures.remove(path);
                LOG.warn("Prefetch request rejected for {}", (Object)path);
            }
        }
    }

    public static void complete(Path path) {
        prefetchFutures.remove(path);
        LOG.debug("Prefetch completed for {}", (Object)path);
    }

    public static void cancel(Path path) {
        Future<?> future = prefetchFutures.get(path);
        if (future != null) {
            future.cancel(true);
            prefetchFutures.remove(path);
            LOG.debug("Prefetch cancelled for {}", (Object)path);
        }
    }

    public static boolean isCompleted(Path path) {
        Future<?> future = prefetchFutures.get(path);
        if (future != null) {
            return future.isDone();
        }
        return true;
    }

    private PrefetchExecutor() {
    }

    static ScheduledExecutorService getExecutorPool() {
        return prefetchExecutorPool;
    }

    static {
        Configuration conf = HBaseConfiguration.create();
        prefetchDelayMillis = conf.getInt("hbase.hfile.prefetch.delay", 1000);
        prefetchDelayVariation = conf.getFloat("hbase.hfile.prefetch.delay.variation", 0.2f);
        int prefetchThreads = conf.getInt("hbase.hfile.thread.prefetch", 4);
        prefetchExecutorPool = new ScheduledThreadPoolExecutor(prefetchThreads, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                String name = "hfile-prefetch-" + EnvironmentEdgeManager.currentTime();
                Thread t = new Thread(r, name);
                t.setDaemon(true);
                return t;
            }
        });
        prefetchPathExclude = Pattern.compile("(/" + ".tmp".replace(".", "\\.") + '/' + ")|(" + '/' + "compaction.dir".replace(".", "\\.") + '/' + ")");
    }
}

