/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.RegionReplicaTestHelper;
import org.apache.hadoop.hbase.client.RpcConnectionRegistry;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestRpcConnectionRegistry {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRpcConnectionRegistry.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private RpcConnectionRegistry registry;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.getConfiguration().setLong("hbase.client.bootstrap.initial_refresh_delay_secs", 1L);
        UTIL.getConfiguration().setLong("hbase.client.bootstrap.refresh_interval_secs", 1L);
        UTIL.getConfiguration().setLong("hbase.client.bootstrap.min_secs_between_refreshes", 0L);
        UTIL.getConfiguration().setLong("hbase.server.bootstrap.request_master_min_interval.secs", 1L);
        UTIL.startMiniCluster(3);
        HBaseTestingUtility.setReplicas(UTIL.getAdmin(), TableName.META_TABLE_NAME, 3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws IOException {
        this.registry = new RpcConnectionRegistry(UTIL.getConfiguration(), User.getCurrent());
    }

    @After
    public void tearDown() throws IOException {
        Closeables.close((Closeable)this.registry, (boolean)true);
    }

    private void setMaxNodeCount(int count) {
        UTIL.getMiniHBaseCluster().getMasterThreads().stream().map(t -> t.getMaster().getConfiguration()).forEach(conf -> conf.setInt("hbase.client.bootstrap.node.limit", count));
        UTIL.getMiniHBaseCluster().getRegionServerThreads().stream().map(t -> t.getRegionServer().getConfiguration()).forEach(conf -> conf.setInt("hbase.client.bootstrap.node.limit", count));
    }

    @Test
    public void testRegistryRPCs() throws Exception {
        HMaster activeMaster = UTIL.getHBaseCluster().getMaster();
        Set initialParsedServers = this.registry.getParsedServers();
        MatcherAssert.assertThat((Object)initialParsedServers, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)initialParsedServers, (Matcher)Matchers.hasItem((Object)ServerName.valueOf((String)activeMaster.getServerName().getHostname(), (int)activeMaster.getServerName().getPort(), (long)-1L)));
        UTIL.waitFor(5000L, () -> this.registry.getParsedServers().contains(activeMaster.getServerManager().getOnlineServersList().get(0)));
        Set parsedServers = this.registry.getParsedServers();
        MatcherAssert.assertThat((Object)parsedServers, (Matcher)Matchers.hasSize((int)activeMaster.getServerManager().getOnlineServersList().size()));
        MatcherAssert.assertThat((Object)parsedServers, (Matcher)Matchers.hasItems((Object[])activeMaster.getServerManager().getOnlineServersList().toArray(new ServerName[0])));
        RegionReplicaTestHelper.waitUntilAllMetaReplicasAreReady(UTIL, (ConnectionRegistry)this.registry);
        Assert.assertEquals(this.registry.getClusterId().get(), (Object)activeMaster.getClusterId());
        Assert.assertEquals(this.registry.getActiveMaster().get(), (Object)activeMaster.getServerName());
        List<HRegionLocation> metaLocations = Arrays.asList(((RegionLocations)this.registry.getMetaRegionLocations().get()).getRegionLocations());
        List actualMetaLocations = (List)activeMaster.getMetaRegionLocationCache().getMetaRegionLocations().get();
        Collections.sort(metaLocations);
        Collections.sort(actualMetaLocations);
        Assert.assertEquals((Object)actualMetaLocations, metaLocations);
        this.setMaxNodeCount(1);
        UTIL.waitFor(10000L, () -> this.registry.getParsedServers().size() == 1);
    }

    @Test
    public void testBrokenBootstrapNodes() throws Exception {
        Configuration conf = new Configuration(UTIL.getConfiguration());
        String currentMasterAddrs = (String)Preconditions.checkNotNull((Object)conf.get("hbase.masters"));
        HMaster activeMaster = UTIL.getHBaseCluster().getMaster();
        String clusterId = activeMaster.getClusterId();
        ServerName badServer = ServerName.valueOf((String)"localhost", (int)1234, (long)-1L);
        conf.set("hbase.client.bootstrap.servers", badServer.toShortString());
        try (RpcConnectionRegistry reg = new RpcConnectionRegistry(conf, User.getCurrent());){
            Assert.assertThrows(IOException.class, () -> reg.getParsedServers());
        }
        conf.set("hbase.client.bootstrap.servers", badServer.toShortString() + ", " + currentMasterAddrs);
        for (int i = 0; i < 10; ++i) {
            try (RpcConnectionRegistry reg = new RpcConnectionRegistry(conf, User.getCurrent());){
                Assert.assertEquals((Object)clusterId, reg.getClusterId().get());
                continue;
            }
        }
    }
}

