/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;

public class BadMasterObserverForCreateDeleteTable
implements MasterObserver,
MasterCoprocessor {
    private boolean createFailedOnce = false;
    private boolean deleteFailedOnce = false;

    public void postCompletedCreateTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor desc, RegionInfo[] regions) throws IOException {
        if (!this.createFailedOnce && !desc.getTableName().isSystemTable()) {
            this.createFailedOnce = true;
            throw new IOException("execute postCompletedCreateTableAction failed once.");
        }
    }

    public void postCompletedDeleteTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (!this.deleteFailedOnce && !tableName.isSystemTable()) {
            this.deleteFailedOnce = true;
            throw new IOException("execute postCompletedDeleteTableAction failed once.");
        }
    }

    public Optional<MasterObserver> getMasterObserver() {
        return Optional.of(this);
    }
}

