/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestStochasticLoadBalancerRegionReplicaLargeCluster
extends BalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStochasticLoadBalancerRegionReplicaLargeCluster.class);

    @Test
    public void testRegionReplicasOnLargeCluster() {
        conf.setFloat("hbase.master.balancer.stochastic.moveCost", 0.0f);
        conf.setFloat("hbase.master.balancer.stochastic.tableSkewCost", 0.0f);
        loadBalancer.onConfigurationChange(conf);
        int numNodes = 1000;
        int numRegions = 20 * numNodes;
        int numRegionsPerServer = 19;
        int numTables = 100;
        int replication = 3;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, replication, numTables, true, true);
    }
}

