/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.master.procedure.ReopenTableRegionsProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestReopenTableRegionsProcedureBatching {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReopenTableRegionsProcedureBatching.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final int BACKOFF_MILLIS_PER_RS = 0;
    private static final int REOPEN_BATCH_SIZE_MAX = 1;
    private static TableName TABLE_NAME = TableName.valueOf((String)"Batching");
    private static byte[] CF = Bytes.toBytes((String)"cf");

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setInt("hbase.master.wait.on.regionservers.mintostart", 1);
        UTIL.startMiniCluster(1);
        UTIL.createMultiRegionTable(TABLE_NAME, CF);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testSmallMaxBatchSize() throws IOException {
        AssignmentManager am = UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager();
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        List regions = UTIL.getAdmin().getRegions(TABLE_NAME);
        Assert.assertTrue((2 <= regions.size() ? 1 : 0) != 0);
        Set<StuckRegion> stuckRegions = regions.stream().map(r -> this.stickRegion(am, (ProcedureExecutor<MasterProcedureEnv>)procExec, (RegionInfo)r)).collect(Collectors.toSet());
        ReopenTableRegionsProcedure proc = new ReopenTableRegionsProcedure(TABLE_NAME, 0L, 1);
        procExec.submitProcedure((Procedure)proc);
        UTIL.waitFor(10000L, () -> proc.getState() == ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
        this.confirmBatchSize(1, stuckRegions, proc);
        ProcedureSyncWait.waitForProcedureToComplete((ProcedureExecutor)procExec, (Procedure)proc, (long)60000L);
        Assert.assertTrue((proc.getBatchesProcessed() >= (long)regions.size() ? 1 : 0) != 0);
        Assert.assertEquals((long)proc.getRegionsReopened(), (long)regions.size());
    }

    @Test
    public void testDefaultMaxBatchSize() throws IOException {
        AssignmentManager am = UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager();
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        List regions = UTIL.getAdmin().getRegions(TABLE_NAME);
        Assert.assertTrue((2 <= regions.size() ? 1 : 0) != 0);
        Set<StuckRegion> stuckRegions = regions.stream().map(r -> this.stickRegion(am, (ProcedureExecutor<MasterProcedureEnv>)procExec, (RegionInfo)r)).collect(Collectors.toSet());
        ReopenTableRegionsProcedure proc = new ReopenTableRegionsProcedure(TABLE_NAME);
        procExec.submitProcedure((Procedure)proc);
        UTIL.waitFor(10000L, () -> proc.getState() == ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
        this.confirmBatchSize(regions.size(), stuckRegions, proc);
        ProcedureSyncWait.waitForProcedureToComplete((ProcedureExecutor)procExec, (Procedure)proc, (long)60000L);
        Assert.assertEquals((long)proc.getRegionsReopened(), (long)regions.size());
    }

    @Test
    public void testNegativeBatchSizeDoesNotBreak() throws IOException {
        AssignmentManager am = UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager();
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        List regions = UTIL.getAdmin().getRegions(TABLE_NAME);
        Assert.assertTrue((2 <= regions.size() ? 1 : 0) != 0);
        Set<StuckRegion> stuckRegions = regions.stream().map(r -> this.stickRegion(am, (ProcedureExecutor<MasterProcedureEnv>)procExec, (RegionInfo)r)).collect(Collectors.toSet());
        ReopenTableRegionsProcedure proc = new ReopenTableRegionsProcedure(TABLE_NAME, 0L, -100);
        procExec.submitProcedure((Procedure)proc);
        UTIL.waitFor(10000L, () -> proc.getState() == ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
        this.confirmBatchSize(1, stuckRegions, proc);
        ProcedureSyncWait.waitForProcedureToComplete((ProcedureExecutor)procExec, (Procedure)proc, (long)60000L);
        Assert.assertTrue((proc.getBatchesProcessed() >= (long)regions.size() ? 1 : 0) != 0);
        Assert.assertEquals((long)proc.getRegionsReopened(), (long)regions.size());
    }

    @Test
    public void testBatchSizeDoesNotOverflow() {
        ReopenTableRegionsProcedure proc = new ReopenTableRegionsProcedure(TABLE_NAME, 0L, Integer.MAX_VALUE);
        int currentBatchSize = 1;
        while (currentBatchSize < Integer.MAX_VALUE) {
            currentBatchSize = proc.progressBatchSize();
            Assert.assertTrue((currentBatchSize > 0 ? 1 : 0) != 0);
        }
    }

    private void confirmBatchSize(int expectedBatchSize, Set<StuckRegion> stuckRegions, ReopenTableRegionsProcedure proc) {
        while (proc.getBatchesProcessed() == 0L) {
        }
        stuckRegions.forEach(this::unstickRegion);
        UTIL.waitFor(5000L, () -> (long)expectedBatchSize == proc.getRegionsReopened());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StuckRegion stickRegion(AssignmentManager am, ProcedureExecutor<MasterProcedureEnv> procExec, RegionInfo regionInfo) {
        long openSeqNum;
        RegionStateNode regionNode = am.getRegionStates().getRegionStateNode(regionInfo);
        TransitRegionStateProcedure trsp = TransitRegionStateProcedure.unassign((MasterProcedureEnv)((MasterProcedureEnv)procExec.getEnvironment()), (RegionInfo)regionInfo);
        regionNode.lock();
        try {
            openSeqNum = regionNode.getOpenSeqNum();
            regionNode.setState(RegionState.State.OPENING, new RegionState.State[0]);
            regionNode.setOpenSeqNum(-1L);
            regionNode.setProcedure(trsp);
        }
        finally {
            regionNode.unlock();
        }
        return new StuckRegion(trsp, regionNode, openSeqNum);
    }

    private void unstickRegion(StuckRegion stuckRegion) {
        stuckRegion.regionNode.lock();
        try {
            stuckRegion.regionNode.setState(RegionState.State.OPEN, new RegionState.State[0]);
            stuckRegion.regionNode.setOpenSeqNum(stuckRegion.openSeqNum);
            stuckRegion.regionNode.unsetProcedure(stuckRegion.trsp);
        }
        finally {
            stuckRegion.regionNode.unlock();
        }
    }

    static class StuckRegion {
        final TransitRegionStateProcedure trsp;
        final RegionStateNode regionNode;
        final long openSeqNum;

        public StuckRegion(TransitRegionStateProcedure trsp, RegionStateNode regionNode, long openSeqNum) {
            this.trsp = trsp;
            this.regionNode = regionNode;
            this.openSeqNum = openSeqNum;
        }
    }
}

