/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.quotas.DefaultOperationQuota;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestDefaultOperationQuota {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDefaultOperationQuota.class);

    @Test
    public void testScanEstimateNewScanner() {
        long blockSize = 65536L;
        long nextCallSeq = 0L;
        long maxScannerResultSize = 0x6400000L;
        long maxBlockBytesScanned = 0L;
        long prevBBSDifference = 0L;
        long estimate = DefaultOperationQuota.getScanReadConsumeEstimate((long)blockSize, (long)nextCallSeq, (long)maxScannerResultSize, (long)maxBlockBytesScanned, (long)prevBBSDifference);
        Assert.assertEquals((long)blockSize, (long)estimate);
    }

    @Test
    public void testScanEstimateSecondNextCall() {
        long blockSize = 65536L;
        long nextCallSeq = 1L;
        long maxScannerResultSize = 0x6400000L;
        long maxBlockBytesScanned = 10L * blockSize;
        long prevBBSDifference = 10L * blockSize;
        long estimate = DefaultOperationQuota.getScanReadConsumeEstimate((long)blockSize, (long)nextCallSeq, (long)maxScannerResultSize, (long)maxBlockBytesScanned, (long)prevBBSDifference);
        Assert.assertEquals((long)maxBlockBytesScanned, (long)estimate);
    }

    @Test
    public void testScanEstimateFlatWorkload() {
        long blockSize = 65536L;
        long nextCallSeq = 100L;
        long maxScannerResultSize = 0x6400000L;
        long maxBlockBytesScanned = 10L * blockSize;
        long prevBBSDifference = 0L;
        long estimate = DefaultOperationQuota.getScanReadConsumeEstimate((long)blockSize, (long)nextCallSeq, (long)maxScannerResultSize, (long)maxBlockBytesScanned, (long)prevBBSDifference);
        Assert.assertEquals((long)maxBlockBytesScanned, (long)estimate);
    }

    @Test
    public void testScanEstimateVariableFlatWorkload() {
        long blockSize = 65536L;
        long nextCallSeq = 1L;
        long maxScannerResultSize = 0x6400000L;
        long maxBlockBytesScanned = 10L * blockSize;
        long prevBBSDifference = 0L;
        for (int i = 0; i < 100; ++i) {
            long variation = Math.round(Math.random() * (double)blockSize);
            if (variation % 2L == 0L) {
                variation *= -1L;
            }
            prevBBSDifference = variation;
            long estimate = DefaultOperationQuota.getScanReadConsumeEstimate((long)blockSize, (long)(nextCallSeq + (long)i), (long)maxScannerResultSize, (long)maxBlockBytesScanned, (long)prevBBSDifference);
            Assert.assertEquals((long)maxBlockBytesScanned, (long)estimate);
        }
    }

    @Test
    public void testScanEstimateGrowingWorkload() {
        long nextCallSeq = 100L;
        long blockSize = 65536L;
        long maxBlockBytesScanned = 20L * blockSize;
        long maxScannerResultSize = 0x6400000L;
        long prevBBSDifference = 10L * blockSize;
        long estimate = DefaultOperationQuota.getScanReadConsumeEstimate((long)blockSize, (long)nextCallSeq, (long)maxScannerResultSize, (long)maxBlockBytesScanned, (long)prevBBSDifference);
        Assert.assertTrue((nextCallSeq * maxBlockBytesScanned == estimate || maxScannerResultSize == estimate ? 1 : 0) != 0);
    }

    @Test
    public void testScanEstimateShrinkingWorkload() {
        long blockSize = 65536L;
        long nextCallSeq = 100L;
        long maxScannerResultSize = 0x6400000L;
        long maxBlockBytesScanned = 20L * blockSize;
        long prevBBSDifference = -10L * blockSize;
        long estimate = DefaultOperationQuota.getScanReadConsumeEstimate((long)blockSize, (long)nextCallSeq, (long)maxScannerResultSize, (long)maxBlockBytesScanned, (long)prevBBSDifference);
        Assert.assertEquals((long)maxBlockBytesScanned, (long)estimate);
    }
}

