/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ipc.BlockingRpcClient;
import org.apache.hadoop.hbase.ipc.FallbackDisallowedException;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerFactory;
import org.apache.hadoop.hbase.ipc.TestProtobufRpcServiceImpl;
import org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingRpcChannel;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SecurityTests.class, MediumTests.class})
public class TestMultipleServerPrincipalsFallbackToSimple {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMultipleServerPrincipalsFallbackToSimple.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final File KEYTAB_FILE = new File(TEST_UTIL.getDataTestDir("keytab").toUri().getPath());
    private static MiniKdc KDC;
    private static String HOST;
    private static String SERVER_PRINCIPAL;
    private static String SERVER_PRINCIPAL2;
    private static String CLIENT_PRINCIPAL;
    @Parameterized.Parameter
    public Class<? extends RpcClient> rpcClientImpl;
    private Configuration clientConf;
    private UserGroupInformation clientUGI;
    private RpcServer rpcServer;
    private RpcClient rpcClient;

    @Parameterized.Parameters(name="{index}: rpcClientImpl={0}")
    public static List<Object[]> params() {
        return Arrays.asList({NettyRpcClient.class}, {BlockingRpcClient.class});
    }

    private static void setSecuredConfiguration(Configuration conf) {
        conf.set("hadoop.security.authentication", "kerberos");
        conf.set("hbase.security.authentication", "kerberos");
        conf.setBoolean("hbase.security.authorization", true);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        KDC = TEST_UTIL.setupMiniKdc(KEYTAB_FILE);
        SERVER_PRINCIPAL = "server/" + HOST;
        SERVER_PRINCIPAL2 = "server2/" + HOST;
        CLIENT_PRINCIPAL = "client";
        KDC.createPrincipal(KEYTAB_FILE, new String[]{CLIENT_PRINCIPAL, SERVER_PRINCIPAL, SERVER_PRINCIPAL2});
        TEST_UTIL.getConfiguration().setInt("hbase.security.relogin.maxbackoff", 1);
        TEST_UTIL.getConfiguration().setInt("hbase.security.relogin.maxretries", 0);
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.client.failed.servers.expiry", 10);
    }

    @Before
    public void setUp() throws Exception {
        this.clientConf = new Configuration(TEST_UTIL.getConfiguration());
        TestMultipleServerPrincipalsFallbackToSimple.setSecuredConfiguration(this.clientConf);
        this.clientConf.setClass("hbase.rpc.client.impl", this.rpcClientImpl, RpcClient.class);
        String serverPrincipalConfigName = "hbase.test.multiple.principal.first";
        String serverPrincipalConfigName2 = "hbase.test.multiple.principal.second";
        this.clientConf.set(serverPrincipalConfigName, "server/localhost@" + KDC.getRealm());
        this.clientConf.set(serverPrincipalConfigName2, "server2/localhost@" + KDC.getRealm());
        SecurityInfo securityInfo = new SecurityInfo(AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN, new String[]{serverPrincipalConfigName2, serverPrincipalConfigName});
        SecurityInfo.addInfo((String)TestRpcServiceProtos.TestProtobufRpcProto.getDescriptor().getName(), (SecurityInfo)securityInfo);
        UserGroupInformation.setConfiguration((Configuration)this.clientConf);
        this.clientUGI = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)CLIENT_PRINCIPAL, (String)KEYTAB_FILE.getCanonicalPath());
        this.rpcServer = RpcServerFactory.createRpcServer(null, (String)this.getClass().getSimpleName(), (List)Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), (InetSocketAddress)new InetSocketAddress(HOST, 0), (Configuration)TEST_UTIL.getConfiguration(), (RpcScheduler)new FifoRpcScheduler(TEST_UTIL.getConfiguration(), 1));
        this.rpcServer.start();
    }

    @After
    public void tearDown() throws IOException {
        Closeables.close((Closeable)this.rpcClient, (boolean)true);
        this.rpcServer.stop();
    }

    private RpcClient createClient() throws Exception {
        return (RpcClient)this.clientUGI.doAs(() -> RpcClientFactory.createClient((Configuration)this.clientConf, (String)HConstants.DEFAULT_CLUSTER_ID.toString()));
    }

    private String echo(String msg) throws Exception {
        return (String)this.clientUGI.doAs(() -> {
            BlockingRpcChannel channel = this.rpcClient.createBlockingRpcChannel(ServerName.valueOf((String)HOST, (int)this.rpcServer.getListenerAddress().getPort(), (long)-1L), User.getCurrent(), 10000);
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestRpcServiceProtos.TestProtobufRpcProto.newBlockingStub((BlockingRpcChannel)channel);
            return stub.echo(null, TestProtos.EchoRequestProto.newBuilder().setMessage(msg).build()).getMessage();
        });
    }

    @Test
    public void testAllowFallbackToSimple() throws Exception {
        this.clientConf.setBoolean("hbase.ipc.client.fallback-to-simple-auth-allowed", true);
        this.rpcClient = this.createClient();
        Assert.assertEquals((Object)"allow", (Object)this.echo("allow"));
    }

    @Test
    public void testDisallowFallbackToSimple() throws Exception {
        this.clientConf.setBoolean("hbase.ipc.client.fallback-to-simple-auth-allowed", false);
        this.rpcClient = this.createClient();
        UndeclaredThrowableException error = (UndeclaredThrowableException)Assert.assertThrows(UndeclaredThrowableException.class, () -> this.echo("disallow"));
        Throwable cause = error.getCause().getCause().getCause();
        MatcherAssert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(FallbackDisallowedException.class));
    }

    static {
        HOST = "localhost";
    }
}

