/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.security.access.GlobalPermission;
import org.apache.hadoop.hbase.security.access.NamespacePermission;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SecurityTests.class, SmallTests.class})
public class TestPermissionBuilder {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestPermissionBuilder.class);

    @Test
    public void testBuildGlobalPermission() {
        Permission permission = Permission.newBuilder().build();
        Assert.assertTrue((boolean)(permission instanceof GlobalPermission));
        Assert.assertEquals((long)0L, (long)permission.getActions().length);
        permission = Permission.newBuilder().withActionCodes(Bytes.toBytes((String)"A")).build();
        Assert.assertTrue((boolean)(permission instanceof GlobalPermission));
        Assert.assertEquals((long)1L, (long)permission.getActions().length);
        Assert.assertTrue((permission.getActions()[0] == Permission.Action.ADMIN ? 1 : 0) != 0);
        byte[] qualifier = Bytes.toBytes((String)"q");
        try {
            permission = Permission.newBuilder().withQualifier(qualifier).withActions(new Permission.Action[]{Permission.Action.CREATE, Permission.Action.READ}).build();
            Assert.fail((String)"Should throw NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        permission = Permission.newBuilder().withActionCodes(Bytes.toBytes((String)"ACP")).withActions(new Permission.Action[]{Permission.Action.READ, Permission.Action.ADMIN}).build();
        Assert.assertEquals((long)3L, (long)permission.getActions().length);
        Assert.assertEquals((Object)Permission.Action.READ, (Object)permission.getActions()[0]);
        Assert.assertEquals((Object)Permission.Action.CREATE, (Object)permission.getActions()[1]);
        Assert.assertEquals((Object)Permission.Action.ADMIN, (Object)permission.getActions()[2]);
    }

    @Test
    public void testBuildNamespacePermission() {
        String namespace = "ns";
        Permission permission = Permission.newBuilder((String)namespace).withActions(new Permission.Action[]{Permission.Action.CREATE, Permission.Action.READ}).build();
        Assert.assertTrue((boolean)(permission instanceof NamespacePermission));
        NamespacePermission namespacePermission = (NamespacePermission)permission;
        Assert.assertEquals((Object)namespace, (Object)namespacePermission.getNamespace());
        Assert.assertEquals((long)2L, (long)permission.getActions().length);
        Assert.assertEquals((Object)Permission.Action.READ, (Object)permission.getActions()[0]);
        Assert.assertEquals((Object)Permission.Action.CREATE, (Object)permission.getActions()[1]);
        byte[] family = Bytes.toBytes((String)"f");
        try {
            permission = Permission.newBuilder((String)namespace).withFamily(family).withActions(new Permission.Action[]{Permission.Action.CREATE, Permission.Action.READ}).build();
            Assert.fail((String)"Should throw NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testBuildTablePermission() {
        TableName tableName = TableName.valueOf((String)"ns", (String)"table");
        byte[] family = Bytes.toBytes((String)"f");
        byte[] qualifier = Bytes.toBytes((String)"q");
        Permission permission = Permission.newBuilder((TableName)tableName).withActions(new Permission.Action[]{Permission.Action.WRITE, Permission.Action.READ}).build();
        Assert.assertTrue((boolean)(permission instanceof TablePermission));
        Assert.assertEquals((long)2L, (long)permission.getActions().length);
        Assert.assertEquals((Object)Permission.Action.READ, (Object)permission.getActions()[0]);
        Assert.assertEquals((Object)Permission.Action.WRITE, (Object)permission.getActions()[1]);
        TablePermission tPerm = (TablePermission)permission;
        Assert.assertEquals((Object)tableName, (Object)tPerm.getTableName());
        Assert.assertEquals(null, (Object)tPerm.getFamily());
        Assert.assertEquals(null, (Object)tPerm.getQualifier());
        permission = Permission.newBuilder((TableName)tableName).withFamily(family).withActions(new Permission.Action[]{Permission.Action.EXEC}).build();
        Assert.assertTrue((boolean)(permission instanceof TablePermission));
        Assert.assertEquals((long)1L, (long)permission.getActions().length);
        Assert.assertEquals((Object)Permission.Action.EXEC, (Object)permission.getActions()[0]);
        tPerm = (TablePermission)permission;
        Assert.assertEquals((Object)tableName, (Object)tPerm.getTableName());
        Assert.assertTrue((boolean)Bytes.equals((byte[])family, (byte[])tPerm.getFamily()));
        Assert.assertTrue((boolean)Bytes.equals(null, (byte[])tPerm.getQualifier()));
        permission = Permission.newBuilder((TableName)tableName).withFamily(family).withQualifier(qualifier).build();
        Assert.assertTrue((boolean)(permission instanceof TablePermission));
        Assert.assertEquals((long)0L, (long)permission.getActions().length);
        tPerm = (TablePermission)permission;
        Assert.assertEquals((Object)tableName, (Object)tPerm.getTableName());
        Assert.assertTrue((boolean)Bytes.equals((byte[])family, (byte[])tPerm.getFamily()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])qualifier, (byte[])tPerm.getQualifier()));
    }
}

