/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Splitter;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ReplicationPeerConfig {
    private String clusterKey;
    private String replicationEndpointImpl;
    private final Map<byte[], byte[]> peerData = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
    private final Map<String, String> configuration = new HashMap<String, String>(0);
    private Map<TableName, ? extends Collection<String>> tableCFsMap = null;
    private long bandwidth = 0L;
    public static final String HBASE_REPLICATION_PEER_BASE_CONFIG = "hbase.replication.peer.base.config";

    public ReplicationPeerConfig setClusterKey(String clusterKey) {
        this.clusterKey = clusterKey;
        return this;
    }

    public ReplicationPeerConfig setReplicationEndpointImpl(String replicationEndpointImpl) {
        this.replicationEndpointImpl = replicationEndpointImpl;
        return this;
    }

    public String getClusterKey() {
        return this.clusterKey;
    }

    public String getReplicationEndpointImpl() {
        return this.replicationEndpointImpl;
    }

    public Map<byte[], byte[]> getPeerData() {
        return this.peerData;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public Map<TableName, List<String>> getTableCFsMap() {
        return this.tableCFsMap;
    }

    public void setTableCFsMap(Map<TableName, ? extends Collection<String>> tableCFsMap) {
        this.tableCFsMap = tableCFsMap;
    }

    public long getBandwidth() {
        return this.bandwidth;
    }

    public ReplicationPeerConfig setBandwidth(long bandwidth) {
        this.bandwidth = bandwidth;
        return this;
    }

    public void addBasePeerConfigsIfNotPresent(Configuration conf) {
        String basePeerConfigs = conf.get(HBASE_REPLICATION_PEER_BASE_CONFIG, "");
        if (basePeerConfigs.length() != 0) {
            Map<String, String> basePeerConfigMap = Splitter.on(';').trimResults().omitEmptyStrings().withKeyValueSeparator("=").split(basePeerConfigs);
            for (Map.Entry<String, String> entry : basePeerConfigMap.entrySet()) {
                String configName = entry.getKey();
                String configValue = entry.getValue();
                if (this.getConfiguration().containsKey(configName)) continue;
                this.getConfiguration().put(configName, configValue);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("clusterKey=").append(this.clusterKey).append(",");
        builder.append("replicationEndpointImpl=").append(this.replicationEndpointImpl);
        if (this.tableCFsMap != null) {
            builder.append(this.tableCFsMap.toString()).append(",");
        }
        builder.append("bandwidth=").append(this.bandwidth);
        return builder.toString();
    }
}

