/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.util;

import java.text.ParseException;
import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.counters.AbstractCounters;
import org.apache.hadoop.mapreduce.counters.CounterGroupBase;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class CountersStrings {
    private static final char GROUP_OPEN = '{';
    private static final char GROUP_CLOSE = '}';
    private static final char COUNTER_OPEN = '[';
    private static final char COUNTER_CLOSE = ']';
    private static final char UNIT_OPEN = '(';
    private static final char UNIT_CLOSE = ')';
    private static char[] charsToEscape = new char[]{'{', '}', '[', ']', '(', ')'};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toEscapedCompactString(Counter counter) {
        long currentValue;
        String escapedDispName;
        String escapedName;
        Counter counter2 = counter;
        synchronized (counter2) {
            escapedName = CountersStrings.escape(counter.getName());
            escapedDispName = CountersStrings.escape(counter.getDisplayName());
            currentValue = counter.getValue();
        }
        int length = escapedName.length() + escapedDispName.length() + 4;
        StringBuilder builder = new StringBuilder(length += 8);
        builder.append('[');
        builder.append('(');
        builder.append(escapedName);
        builder.append(')');
        builder.append('(');
        builder.append(escapedDispName);
        builder.append(')');
        builder.append('(');
        builder.append(currentValue);
        builder.append(')');
        builder.append(']');
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <G extends CounterGroupBase<?>> String toEscapedCompactString(G group) {
        String escapedDispName;
        String escapedName;
        ArrayList<String> escapedStrs = Lists.newArrayList();
        G g = group;
        synchronized (g) {
            escapedName = CountersStrings.escape(group.getName());
            escapedDispName = CountersStrings.escape(group.getDisplayName());
            boolean i = false;
            int length = escapedName.length() + escapedDispName.length();
            for (Counter counter : group) {
                String escapedStr = CountersStrings.toEscapedCompactString(counter);
                escapedStrs.add(escapedStr);
                length += escapedStr.length();
            }
        }
        StringBuilder builder = new StringBuilder(length += 6);
        builder.append('{');
        builder.append('(');
        builder.append(escapedName);
        builder.append(')');
        builder.append('(');
        builder.append(escapedDispName);
        builder.append(')');
        for (String escaped : escapedStrs) {
            builder.append(escaped);
        }
        builder.append('}');
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <C extends Counter, G extends CounterGroupBase<C>, T extends AbstractCounters<C, G>> String toEscapedCompactString(T counters) {
        StringBuilder builder = new StringBuilder();
        T t = counters;
        synchronized (t) {
            for (CounterGroupBase group : counters) {
                builder.append(CountersStrings.toEscapedCompactString(group));
            }
        }
        return builder.toString();
    }

    private static String escape(String string) {
        return StringUtils.escapeString(string, '\\', charsToEscape);
    }

    private static String unescape(String string) {
        return StringUtils.unEscapeString(string, '\\', charsToEscape);
    }

    private static String getBlock(String str, char open, char close, IntWritable index) throws ParseException {
        StringBuilder split = new StringBuilder();
        int next = StringUtils.findNext(str, open, '\\', index.get(), split);
        split.setLength(0);
        if (next >= 0) {
            ++next;
            if ((next = StringUtils.findNext(str, close, '\\', next, split)) >= 0) {
                index.set(++next);
                return split.toString();
            }
            throw new ParseException("Unexpected end of block", next);
        }
        return null;
    }

    public static <C extends Counter, G extends CounterGroupBase<C>, T extends AbstractCounters<C, G>> T parseEscapedCompactString(String compactString, T counters) throws ParseException {
        IntWritable index = new IntWritable(0);
        String groupString = CountersStrings.getBlock(compactString, '{', '}', index);
        while (groupString != null) {
            IntWritable groupIndex = new IntWritable(0);
            String groupName = StringInterner.weakIntern(CountersStrings.getBlock(groupString, '(', ')', groupIndex));
            groupName = StringInterner.weakIntern(CountersStrings.unescape(groupName));
            String groupDisplayName = StringInterner.weakIntern(CountersStrings.getBlock(groupString, '(', ')', groupIndex));
            groupDisplayName = StringInterner.weakIntern(CountersStrings.unescape(groupDisplayName));
            G group = counters.getGroup(groupName);
            group.setDisplayName(groupDisplayName);
            String counterString = CountersStrings.getBlock(groupString, '[', ']', groupIndex);
            while (counterString != null) {
                IntWritable counterIndex = new IntWritable(0);
                String counterName = StringInterner.weakIntern(CountersStrings.getBlock(counterString, '(', ')', counterIndex));
                counterName = StringInterner.weakIntern(CountersStrings.unescape(counterName));
                String counterDisplayName = StringInterner.weakIntern(CountersStrings.getBlock(counterString, '(', ')', counterIndex));
                counterDisplayName = StringInterner.weakIntern(CountersStrings.unescape(counterDisplayName));
                long value = Long.parseLong(CountersStrings.getBlock(counterString, '(', ')', counterIndex));
                C counter = group.findCounter(counterName);
                counter.setDisplayName(counterDisplayName);
                counter.increment(value);
                counterString = CountersStrings.getBlock(groupString, '[', ']', groupIndex);
            }
            groupString = CountersStrings.getBlock(compactString, '{', '}', index);
        }
        return counters;
    }
}

