/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.druid.DruidConnectionImpl;
import org.apache.calcite.adapter.druid.DruidDateTimeUtils;
import org.apache.calcite.adapter.druid.DruidRules;
import org.apache.calcite.adapter.druid.DruidTable;
import org.apache.calcite.adapter.druid.QueryType;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.interpreter.BindableRel;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.interpreter.InterpretableRel;
import org.apache.calcite.interpreter.Interpreter;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.Sink;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.hive.com.fasterxml.jackson.core.JsonFactory;
import org.apache.hive.com.fasterxml.jackson.core.JsonGenerator;
import org.joda.time.Interval;
import org.joda.time.chrono.ISOChronology;

public class DruidQuery
extends AbstractRelNode
implements BindableRel {
    protected QuerySpec querySpec;
    final RelOptTable table;
    final DruidTable druidTable;
    final ImmutableList<Interval> intervals;
    final ImmutableList<RelNode> rels;
    private static final Pattern VALID_SIG = Pattern.compile("sf?p?a?l?");
    protected static final String DRUID_QUERY_FETCH = "druid.query.fetch";

    protected DruidQuery(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, DruidTable druidTable, List<Interval> intervals, List<RelNode> rels) {
        super(cluster, traitSet);
        this.table = table;
        this.druidTable = druidTable;
        this.intervals = ImmutableList.copyOf(intervals);
        this.rels = ImmutableList.copyOf(rels);
        assert (this.isValid(Litmus.THROW));
    }

    String signature() {
        StringBuilder b = new StringBuilder();
        for (RelNode rel : this.rels) {
            b.append((char)(rel instanceof TableScan ? 115 : (rel instanceof Project ? 112 : (rel instanceof Filter ? 102 : (rel instanceof Aggregate ? 97 : (rel instanceof Sort ? 108 : 33))))));
        }
        return b.toString();
    }

    @Override
    public boolean isValid(Litmus litmus) {
        if (!super.isValid(litmus)) {
            return false;
        }
        String signature = this.signature();
        if (!DruidQuery.isValidSignature(signature)) {
            return litmus.fail("invalid signature [{}]", signature);
        }
        for (Interval interval : this.intervals) {
            if (interval.getChronology() == ISOChronology.getInstanceUTC()) continue;
            return litmus.fail("interval must be UTC", interval);
        }
        if (this.rels.isEmpty()) {
            return litmus.fail("must have at least one rel", new Object[0]);
        }
        for (int i = 0; i < this.rels.size(); ++i) {
            Filter filter;
            RelNode r = (RelNode)this.rels.get(i);
            if (i == 0) {
                if (!(r instanceof TableScan)) {
                    return litmus.fail("first rel must be TableScan, was ", r);
                }
                if (r.getTable() == this.table) continue;
                return litmus.fail("first rel must be based on table table", new Object[0]);
            }
            List<RelNode> inputs = r.getInputs();
            if (inputs.size() != 1 || inputs.get(0) != this.rels.get(i - 1)) {
                return litmus.fail("each rel must have a single input", new Object[0]);
            }
            if (r instanceof Aggregate) {
                Aggregate aggregate = (Aggregate)r;
                if (aggregate.getGroupSets().size() != 1 || aggregate.indicator) {
                    return litmus.fail("no grouping sets", new Object[0]);
                }
                for (AggregateCall call : aggregate.getAggCallList()) {
                    if (call.filterArg < 0) continue;
                    return litmus.fail("no filtered aggregate functions", new Object[0]);
                }
            }
            if (r instanceof Filter && !this.isValidFilter((filter = (Filter)r).getCondition())) {
                return litmus.fail("invalid filter [{}]", filter.getCondition());
            }
            if (!(r instanceof Sort)) continue;
            Sort sort = (Sort)r;
            if (sort.offset == null || RexLiteral.intValue(sort.offset) == 0) continue;
            return litmus.fail("offset not supported", new Object[0]);
        }
        return true;
    }

    boolean isValidFilter(RexNode e) {
        switch (e.getKind()) {
            case INPUT_REF: 
            case LITERAL: {
                return true;
            }
            case AND: 
            case OR: 
            case NOT: 
            case EQUALS: 
            case NOT_EQUALS: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case BETWEEN: 
            case IN: 
            case CAST: {
                return this.areValidFilters(((RexCall)e).getOperands());
            }
        }
        return false;
    }

    private boolean areValidFilters(List<RexNode> es) {
        for (RexNode e : es) {
            if (this.isValidFilter(e)) continue;
            return false;
        }
        return true;
    }

    static boolean isValidSignature(String signature) {
        return VALID_SIG.matcher(signature).matches();
    }

    public static DruidQuery create(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, DruidTable druidTable, List<RelNode> rels) {
        return new DruidQuery(cluster, traitSet, table, druidTable, druidTable.intervals, rels);
    }

    private static DruidQuery create(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, DruidTable druidTable, List<Interval> intervals, List<RelNode> rels) {
        return new DruidQuery(cluster, traitSet, table, druidTable, intervals, rels);
    }

    public static DruidQuery extendQuery(DruidQuery query, RelNode r) {
        ImmutableList.Builder builder = ImmutableList.builder();
        return DruidQuery.create(query.getCluster(), r.getTraitSet(), query.getTable(), query.druidTable, query.intervals, (List<RelNode>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)builder.addAll(query.rels)).add(r)).build()));
    }

    public static DruidQuery extendQuery(DruidQuery query, List<Interval> intervals) {
        return DruidQuery.create(query.getCluster(), query.getTraitSet(), query.getTable(), query.druidTable, intervals, query.rels);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return this;
    }

    @Override
    public RelDataType deriveRowType() {
        return this.getCluster().getTypeFactory().createStructType(Pair.right(Util.last(this.rels).getRowType().getFieldList()), this.getQuerySpec().fieldNames);
    }

    public TableScan getTableScan() {
        return (TableScan)this.rels.get(0);
    }

    public RelNode getTopNode() {
        return Util.last(this.rels);
    }

    @Override
    public RelOptTable getTable() {
        return this.table;
    }

    public DruidTable getDruidTable() {
        return this.druidTable;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        for (RelNode rel : this.rels) {
            if (rel instanceof TableScan) {
                TableScan tableScan = (TableScan)rel;
                pw.item("table", tableScan.getTable().getQualifiedName());
                pw.item("intervals", this.intervals);
                continue;
            }
            if (rel instanceof Filter) {
                pw.item("filter", ((Filter)rel).getCondition());
                continue;
            }
            if (rel instanceof Project) {
                pw.item("projects", ((Project)rel).getProjects());
                continue;
            }
            if (rel instanceof Aggregate) {
                Aggregate aggregate = (Aggregate)rel;
                pw.item("groups", aggregate.getGroupSet()).item("aggs", aggregate.getAggCallList());
                continue;
            }
            if (rel instanceof Sort) {
                Sort sort = (Sort)rel;
                for (Ord<RelFieldCollation> ord : Ord.zip(sort.collation.getFieldCollations())) {
                    pw.item("sort" + ord.i, ((RelFieldCollation)ord.e).getFieldIndex());
                }
                for (Ord<RelFieldCollation> ord : Ord.zip(sort.collation.getFieldCollations())) {
                    pw.item("dir" + ord.i, ((RelFieldCollation)ord.e).shortString());
                }
                pw.itemIf("fetch", sort.fetch, sort.fetch != null);
                continue;
            }
            throw new AssertionError((Object)("rel type not supported in Druid query " + rel));
        }
        return pw;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return Util.last(this.rels).computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    @Override
    public void register(RelOptPlanner planner) {
        for (RelOptRule rule : DruidRules.RULES) {
            planner.addRule(rule);
        }
        for (RelOptRule rule : Bindables.RULES) {
            planner.addRule(rule);
        }
    }

    @Override
    public Class<Object[]> getElementType() {
        return Object[].class;
    }

    @Override
    public Enumerable<Object[]> bind(DataContext dataContext) {
        return this.table.unwrap(ScannableTable.class).scan(dataContext);
    }

    @Override
    public Node implement(InterpretableRel.InterpreterImplementor implementor) {
        return new DruidQueryNode(implementor.interpreter, this);
    }

    public QuerySpec getQuerySpec() {
        if (this.querySpec == null) {
            this.querySpec = this.deriveQuerySpec();
            assert (this.querySpec != null) : this;
        }
        return this.querySpec;
    }

    protected QuerySpec deriveQuerySpec() {
        RelDataType rowType = this.table.getRowType();
        int i = 1;
        RexNode filter = null;
        if (i < this.rels.size() && this.rels.get(i) instanceof Filter) {
            Filter filterRel = (Filter)this.rels.get(i++);
            filter = filterRel.getCondition();
        }
        List<RexNode> projects = null;
        if (i < this.rels.size() && this.rels.get(i) instanceof Project) {
            Project project = (Project)this.rels.get(i++);
            projects = project.getProjects();
        }
        ImmutableBitSet groupSet = null;
        List<AggregateCall> aggCalls = null;
        List<String> aggNames = null;
        if (i < this.rels.size() && this.rels.get(i) instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)this.rels.get(i++);
            groupSet = aggregate.getGroupSet();
            aggCalls = aggregate.getAggCallList();
            aggNames = Util.skip(aggregate.getRowType().getFieldNames(), groupSet.cardinality());
        }
        ArrayList<Integer> collationIndexes = null;
        ArrayList<RelFieldCollation.Direction> collationDirections = null;
        Integer fetch = null;
        if (i < this.rels.size() && this.rels.get(i) instanceof Sort) {
            Sort sort = (Sort)this.rels.get(i++);
            collationIndexes = new ArrayList<Integer>();
            collationDirections = new ArrayList<RelFieldCollation.Direction>();
            for (RelFieldCollation fCol : sort.collation.getFieldCollations()) {
                collationIndexes.add(fCol.getFieldIndex());
                collationDirections.add(fCol.getDirection());
            }
            Integer n = fetch = sort.fetch != null ? Integer.valueOf(RexLiteral.intValue(sort.fetch)) : null;
        }
        if (i != this.rels.size()) {
            throw new AssertionError((Object)"could not implement all rels");
        }
        return this.getQuery(rowType, filter, projects, groupSet, aggCalls, aggNames, collationIndexes, collationDirections, fetch);
    }

    public QueryType getQueryType() {
        return this.getQuerySpec().queryType;
    }

    public String getQueryString() {
        return this.getQuerySpec().queryString;
    }

    protected QuerySpec getQuery(RelDataType rowType, RexNode filter, List<RexNode> projects, ImmutableBitSet groupSet, List<AggregateCall> aggCalls, List<String> aggNames, List<Integer> collationIndexes, List<RelFieldCollation.Direction> collationDirections, Integer fetch) {
        QueryType queryType = QueryType.SELECT;
        Translator translator = new Translator(this.druidTable, rowType);
        Collection<String> fieldNames = rowType.getFieldNames();
        JsonFilter jsonFilter = null;
        if (filter != null) {
            jsonFilter = translator.translateFilter(filter);
        }
        if (projects != null) {
            translator.metrics.clear();
            translator.dimensions.clear();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (RexNode project : projects) {
                builder.add(translator.translate(project, true));
            }
            fieldNames = builder.build();
        }
        ArrayList<String> dimensions = new ArrayList<String>();
        ArrayList<JsonAggregation> aggregations = new ArrayList<JsonAggregation>();
        String granularity = "all";
        RelFieldCollation.Direction timeSeriesDirection = null;
        JsonLimit limit = null;
        if (groupSet != null) {
            boolean bl;
            String s;
            Iterator<Comparable<Integer>> iterator;
            assert (aggCalls != null);
            assert (aggNames != null);
            assert (aggCalls.size() == aggNames.size());
            int timePositionIdx = -1;
            ImmutableList.Builder builder = ImmutableList.builder();
            if (projects != null) {
                iterator = groupSet.iterator();
                while (iterator.hasNext()) {
                    int n = iterator.next();
                    s = (String)fieldNames.get(n);
                    RexNode project = projects.get(n);
                    if (project instanceof RexInputRef) {
                        RexInputRef ref = (RexInputRef)project;
                        String origin = this.druidTable.getRowType(this.getCluster().getTypeFactory()).getFieldList().get(ref.getIndex()).getName();
                        if (origin.equals(this.druidTable.timestampFieldName)) {
                            granularity = "none";
                            builder.add(s);
                            assert (timePositionIdx == -1);
                            timePositionIdx = n;
                            continue;
                        }
                        dimensions.add(s);
                        builder.add(s);
                        continue;
                    }
                    if (project instanceof RexCall) {
                        RexCall call = (RexCall)project;
                        String funcGranularity = DruidDateTimeUtils.extractGranularity(call);
                        if (funcGranularity != null) {
                            granularity = funcGranularity;
                            builder.add(s);
                            assert (timePositionIdx == -1);
                            timePositionIdx = n;
                            continue;
                        }
                        dimensions.add(s);
                        builder.add(s);
                        continue;
                    }
                    throw new AssertionError((Object)("incompatible project expression: " + project));
                }
            } else {
                iterator = groupSet.iterator();
                while (iterator.hasNext()) {
                    int n = iterator.next();
                    s = (String)fieldNames.get(n);
                    if (s.equals(this.druidTable.timestampFieldName)) {
                        granularity = "NONE";
                        builder.add(s);
                        assert (timePositionIdx == -1);
                        timePositionIdx = n;
                        continue;
                    }
                    dimensions.add(s);
                    builder.add(s);
                }
            }
            for (Pair pair : Pair.zip(aggCalls, aggNames)) {
                JsonAggregation jsonAggregation = this.getJsonAggregation((List<String>)fieldNames, (String)pair.right, (AggregateCall)pair.left);
                aggregations.add(jsonAggregation);
                builder.add(jsonAggregation.name);
            }
            fieldNames = builder.build();
            ImmutableCollection collations = null;
            boolean bl2 = false;
            if (collationIndexes != null) {
                assert (collationDirections != null);
                ImmutableList.Builder colBuilder = ImmutableList.builder();
                for (Pair<Integer, RelFieldCollation.Direction> p : Pair.zip(collationIndexes, collationDirections)) {
                    colBuilder.add(new JsonCollation((String)fieldNames.get((Integer)p.left), p.right == RelFieldCollation.Direction.DESCENDING ? "descending" : "ascending"));
                    if ((Integer)p.left >= groupSet.cardinality() && p.right == RelFieldCollation.Direction.DESCENDING) {
                        bl = true;
                        continue;
                    }
                    if ((Integer)p.left != timePositionIdx) continue;
                    assert (timeSeriesDirection == null);
                    timeSeriesDirection = (RelFieldCollation.Direction)((Object)p.right);
                }
                collations = colBuilder.build();
            }
            limit = new JsonLimit("default", fetch, (ImmutableList)collations);
            if (dimensions.isEmpty() && (collations == null || timeSeriesDirection != null)) {
                queryType = QueryType.TIMESERIES;
                assert (fetch == null);
            } else {
                queryType = dimensions.size() == 1 && bl && collations.size() == 1 && fetch != null ? QueryType.TOP_N : QueryType.GROUP_BY;
            }
        } else {
            assert (aggCalls == null);
            assert (aggNames == null);
            assert (collationIndexes == null || collationIndexes.isEmpty());
            assert (collationDirections == null || collationDirections.isEmpty());
        }
        StringWriter sw = new StringWriter();
        JsonFactory factory = new JsonFactory();
        try {
            JsonGenerator generator = factory.createGenerator(sw);
            switch (queryType) {
                case TIMESERIES: {
                    generator.writeStartObject();
                    generator.writeStringField("queryType", "timeseries");
                    generator.writeStringField("dataSource", this.druidTable.dataSource);
                    generator.writeBooleanField("descending", timeSeriesDirection != null && timeSeriesDirection == RelFieldCollation.Direction.DESCENDING);
                    generator.writeStringField("granularity", granularity);
                    DruidQuery.writeFieldIf(generator, "filter", jsonFilter);
                    DruidQuery.writeField(generator, "aggregations", aggregations);
                    DruidQuery.writeFieldIf(generator, "postAggregations", null);
                    DruidQuery.writeField(generator, "intervals", this.intervals);
                    generator.writeEndObject();
                    break;
                }
                case TOP_N: {
                    generator.writeStartObject();
                    generator.writeStringField("queryType", "topN");
                    generator.writeStringField("dataSource", this.druidTable.dataSource);
                    generator.writeStringField("granularity", granularity);
                    generator.writeStringField("dimension", (String)dimensions.get(0));
                    generator.writeStringField("metric", (String)fieldNames.get(collationIndexes.get(0)));
                    DruidQuery.writeFieldIf(generator, "filter", jsonFilter);
                    DruidQuery.writeField(generator, "aggregations", aggregations);
                    DruidQuery.writeFieldIf(generator, "postAggregations", null);
                    DruidQuery.writeField(generator, "intervals", this.intervals);
                    generator.writeNumberField("threshold", fetch);
                    generator.writeEndObject();
                    break;
                }
                case GROUP_BY: {
                    generator.writeStartObject();
                    if (aggregations.isEmpty()) {
                        aggregations.add(new JsonAggregation("longSum", "dummy_agg", "dummy_agg"));
                    }
                    generator.writeStringField("queryType", "groupBy");
                    generator.writeStringField("dataSource", this.druidTable.dataSource);
                    generator.writeStringField("granularity", granularity);
                    DruidQuery.writeField(generator, "dimensions", dimensions);
                    DruidQuery.writeFieldIf(generator, "limitSpec", limit);
                    DruidQuery.writeFieldIf(generator, "filter", jsonFilter);
                    DruidQuery.writeField(generator, "aggregations", aggregations);
                    DruidQuery.writeFieldIf(generator, "postAggregations", null);
                    DruidQuery.writeField(generator, "intervals", this.intervals);
                    DruidQuery.writeFieldIf(generator, "having", null);
                    generator.writeEndObject();
                    break;
                }
                case SELECT: {
                    generator.writeStartObject();
                    generator.writeStringField("queryType", "select");
                    generator.writeStringField("dataSource", this.druidTable.dataSource);
                    generator.writeBooleanField("descending", false);
                    DruidQuery.writeField(generator, "intervals", this.intervals);
                    DruidQuery.writeFieldIf(generator, "filter", jsonFilter);
                    DruidQuery.writeField(generator, "dimensions", translator.dimensions);
                    DruidQuery.writeField(generator, "metrics", translator.metrics);
                    generator.writeStringField("granularity", granularity);
                    generator.writeFieldName("pagingSpec");
                    generator.writeStartObject();
                    generator.writeNumberField("threshold", fetch != null ? fetch.intValue() : CalciteConnectionProperty.DRUID_FETCH.wrap(new Properties()).getInt());
                    generator.writeEndObject();
                    generator.writeFieldName("context");
                    generator.writeStartObject();
                    generator.writeBooleanField(DRUID_QUERY_FETCH, fetch != null);
                    generator.writeEndObject();
                    generator.writeEndObject();
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown query type " + (Object)((Object)queryType)));
                }
            }
            generator.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new QuerySpec(queryType, sw.toString(), (List<String>)fieldNames);
    }

    protected JsonAggregation getJsonAggregation(List<String> fieldNames, String name, AggregateCall aggCall) {
        ArrayList<String> list = new ArrayList<String>();
        for (Integer arg : aggCall.getArgList()) {
            list.add(fieldNames.get(arg));
        }
        String only = Iterables.getFirst(list, null);
        boolean b = aggCall.getType().getSqlTypeName() == SqlTypeName.DOUBLE;
        switch (aggCall.getAggregation().getKind()) {
            case COUNT: {
                if (aggCall.isDistinct()) {
                    return new JsonCardinalityAggregation("cardinality", name, list);
                }
                return new JsonAggregation("count", name, only);
            }
            case SUM: 
            case SUM0: {
                return new JsonAggregation(b ? "doubleSum" : "longSum", name, only);
            }
            case MIN: {
                return new JsonAggregation(b ? "doubleMin" : "longMin", name, only);
            }
            case MAX: {
                return new JsonAggregation(b ? "doubleMax" : "longMax", name, only);
            }
        }
        throw new AssertionError((Object)("unknown aggregate " + aggCall));
    }

    protected static void writeField(JsonGenerator generator, String fieldName, Object o) throws IOException {
        generator.writeFieldName(fieldName);
        DruidQuery.writeObject(generator, o);
    }

    protected static void writeFieldIf(JsonGenerator generator, String fieldName, Object o) throws IOException {
        if (o != null) {
            DruidQuery.writeField(generator, fieldName, o);
        }
    }

    protected static void writeArray(JsonGenerator generator, List<?> elements) throws IOException {
        generator.writeStartArray();
        for (Object o : elements) {
            DruidQuery.writeObject(generator, o);
        }
        generator.writeEndArray();
    }

    protected static void writeObject(JsonGenerator generator, Object o) throws IOException {
        if (o instanceof String) {
            String s = (String)o;
            generator.writeString(s);
        } else if (o instanceof Interval) {
            Interval i = (Interval)o;
            generator.writeString(i.toString());
        } else if (o instanceof Integer) {
            Integer i = (Integer)o;
            generator.writeNumber(i);
        } else if (o instanceof List) {
            DruidQuery.writeArray(generator, (List)o);
        } else if (o instanceof Json) {
            ((Json)o).write(generator);
        } else {
            throw new AssertionError((Object)("not a json object: " + o));
        }
    }

    static String metadataQuery(String dataSourceName, List<Interval> intervals) {
        StringWriter sw = new StringWriter();
        JsonFactory factory = new JsonFactory();
        try {
            JsonGenerator generator = factory.createGenerator(sw);
            generator.writeStartObject();
            generator.writeStringField("queryType", "segmentMetadata");
            generator.writeStringField("dataSource", dataSourceName);
            generator.writeBooleanField("merge", true);
            generator.writeBooleanField("lenientAggregatorMerge", true);
            generator.writeArrayFieldStart("analysisTypes");
            generator.writeString("aggregators");
            generator.writeEndArray();
            DruidQuery.writeFieldIf(generator, "intervals", intervals);
            generator.writeEndObject();
            generator.close();
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
        return sw.toString();
    }

    private static class JsonCompositeFilter
    extends JsonFilter {
        private final List<? extends JsonFilter> fields;

        private JsonCompositeFilter(String type, List<? extends JsonFilter> fields) {
            super(type);
            this.fields = fields;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type);
            switch (this.type) {
                case "NOT": {
                    DruidQuery.writeField(generator, "field", this.fields.get(0));
                    break;
                }
                default: {
                    DruidQuery.writeField(generator, "fields", this.fields);
                }
            }
            generator.writeEndObject();
        }
    }

    private static class JsonBound
    extends JsonFilter {
        private final String dimension;
        private final String lower;
        private final boolean lowerStrict;
        private final String upper;
        private final boolean upperStrict;
        private final boolean alphaNumeric;

        private JsonBound(String type, String dimension, String lower, boolean lowerStrict, String upper, boolean upperStrict, boolean alphaNumeric) {
            super(type);
            this.dimension = dimension;
            this.lower = lower;
            this.lowerStrict = lowerStrict;
            this.upper = upper;
            this.upperStrict = upperStrict;
            this.alphaNumeric = alphaNumeric;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type);
            generator.writeStringField("dimension", this.dimension);
            if (this.lower != null) {
                generator.writeStringField("lower", this.lower);
                generator.writeBooleanField("lowerStrict", this.lowerStrict);
            }
            if (this.upper != null) {
                generator.writeStringField("upper", this.upper);
                generator.writeBooleanField("upperStrict", this.upperStrict);
            }
            generator.writeBooleanField("alphaNumeric", this.alphaNumeric);
            generator.writeEndObject();
        }
    }

    private static class JsonSelector
    extends JsonFilter {
        private final String dimension;
        private final String value;

        private JsonSelector(String type, String dimension, String value) {
            super(type);
            this.dimension = dimension;
            this.value = value;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type);
            generator.writeStringField("dimension", this.dimension);
            generator.writeStringField("value", this.value);
            generator.writeEndObject();
        }
    }

    private static abstract class JsonFilter
    implements Json {
        final String type;

        private JsonFilter(String type) {
            this.type = type;
        }
    }

    private static class JsonCardinalityAggregation
    extends JsonAggregation {
        final List<String> fieldNames;

        private JsonCardinalityAggregation(String type, String name, List<String> fieldNames) {
            super(type, name, null);
            this.fieldNames = fieldNames;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type);
            generator.writeStringField("name", this.name);
            DruidQuery.writeFieldIf(generator, "fieldNames", this.fieldNames);
            generator.writeEndObject();
        }
    }

    private static class JsonCollation
    implements Json {
        final String dimension;
        final String direction;

        private JsonCollation(String dimension, String direction) {
            this.dimension = dimension;
            this.direction = direction;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("dimension", this.dimension);
            DruidQuery.writeFieldIf(generator, "direction", this.direction);
            generator.writeEndObject();
        }
    }

    private static class JsonLimit
    implements Json {
        final String type;
        final Integer limit;
        final ImmutableList<JsonCollation> collations;

        private JsonLimit(String type, Integer limit, ImmutableList<JsonCollation> collations) {
            this.type = type;
            this.limit = limit;
            this.collations = collations;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type);
            DruidQuery.writeFieldIf(generator, "limit", this.limit);
            DruidQuery.writeFieldIf(generator, "columns", this.collations);
            generator.writeEndObject();
        }
    }

    private static class JsonAggregation
    implements Json {
        final String type;
        final String name;
        final String fieldName;

        private JsonAggregation(String type, String name, String fieldName) {
            this.type = type;
            this.name = name;
            this.fieldName = fieldName;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type);
            generator.writeStringField("name", this.name);
            DruidQuery.writeFieldIf(generator, "fieldName", this.fieldName);
            generator.writeEndObject();
        }
    }

    private static interface Json {
        public void write(JsonGenerator var1) throws IOException;
    }

    private static class DruidQueryNode
    implements Node {
        private final Sink sink;
        private final DruidQuery query;
        private final QuerySpec querySpec;

        DruidQueryNode(Interpreter interpreter, DruidQuery query) {
            this.query = query;
            this.sink = interpreter.sink(query);
            this.querySpec = query.getQuerySpec();
            Hook.QUERY_PLAN.run(this.querySpec);
        }

        @Override
        public void run() throws InterruptedException {
            int previousOffset;
            ArrayList<ColumnMetaData.Rep> fieldTypes = new ArrayList<ColumnMetaData.Rep>();
            for (RelDataTypeField field : this.query.getRowType().getFieldList()) {
                fieldTypes.add(this.getPrimitive(field));
            }
            DruidConnectionImpl connection = new DruidConnectionImpl(this.query.druidTable.schema.url, this.query.druidTable.schema.coordinatorUrl);
            boolean limitQuery = DruidQueryNode.containsLimit(this.querySpec);
            DruidConnectionImpl.Page page = new DruidConnectionImpl.Page();
            do {
                previousOffset = page.offset;
                String queryString = this.querySpec.getQueryString(page.pagingIdentifier, page.offset);
                connection.request(this.querySpec.queryType, queryString, this.sink, this.querySpec.fieldNames, fieldTypes, page);
            } while (!limitQuery && page.pagingIdentifier != null && page.offset > previousOffset);
        }

        private static boolean containsLimit(QuerySpec querySpec) {
            return querySpec.queryString.contains("\"context\":{\"druid.query.fetch\":true");
        }

        private ColumnMetaData.Rep getPrimitive(RelDataTypeField field) {
            if (field.getName().equals(this.query.druidTable.timestampFieldName)) {
                return ColumnMetaData.Rep.JAVA_SQL_TIMESTAMP;
            }
            switch (field.getType().getSqlTypeName()) {
                case BIGINT: {
                    return ColumnMetaData.Rep.LONG;
                }
                case INTEGER: {
                    return ColumnMetaData.Rep.INTEGER;
                }
                case SMALLINT: {
                    return ColumnMetaData.Rep.SHORT;
                }
                case TINYINT: {
                    return ColumnMetaData.Rep.BYTE;
                }
                case REAL: {
                    return ColumnMetaData.Rep.FLOAT;
                }
                case DOUBLE: 
                case FLOAT: {
                    return ColumnMetaData.Rep.DOUBLE;
                }
            }
            return null;
        }
    }

    private static class Translator {
        final List<String> dimensions = new ArrayList<String>();
        final List<String> metrics = new ArrayList<String>();
        final DruidTable druidTable;
        final RelDataType rowType;

        Translator(DruidTable druidTable, RelDataType rowType) {
            this.druidTable = druidTable;
            this.rowType = rowType;
            for (RelDataTypeField f : rowType.getFieldList()) {
                String fieldName = f.getName();
                if (druidTable.metricFieldNames.contains(fieldName)) {
                    this.metrics.add(fieldName);
                    continue;
                }
                if (druidTable.timestampFieldName.equals(fieldName) || "__time".equals(fieldName)) continue;
                this.dimensions.add(fieldName);
            }
        }

        String translate(RexNode e, boolean set) {
            switch (e.getKind()) {
                case INPUT_REF: {
                    RexInputRef ref = (RexInputRef)e;
                    String fieldName = this.rowType.getFieldList().get(ref.getIndex()).getName();
                    if (set) {
                        if (this.druidTable.metricFieldNames.contains(fieldName)) {
                            this.metrics.add(fieldName);
                        } else if (!this.druidTable.timestampFieldName.equals(fieldName) && !"__time".equals(fieldName)) {
                            this.dimensions.add(fieldName);
                        }
                    }
                    return fieldName;
                }
                case CAST: {
                    return this.tr(e, 0, set);
                }
                case LITERAL: {
                    return ((RexLiteral)e).getValue2().toString();
                }
                case FLOOR: {
                    RexCall call = (RexCall)e;
                    assert (DruidDateTimeUtils.extractGranularity(call) != null);
                    return this.tr(call, 0, set);
                }
            }
            throw new AssertionError((Object)("invalid expression " + e));
        }

        private JsonFilter translateFilter(RexNode e) {
            switch (e.getKind()) {
                case EQUALS: 
                case NOT_EQUALS: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    int posConstant;
                    int posRef;
                    RexCall call = (RexCall)e;
                    if (RexUtil.isConstant(call.getOperands().get(1))) {
                        posRef = 0;
                        posConstant = 1;
                    } else if (RexUtil.isConstant(call.getOperands().get(0))) {
                        posRef = 1;
                        posConstant = 0;
                    } else {
                        throw new AssertionError((Object)("it is not a valid comparison: " + e));
                    }
                    switch (e.getKind()) {
                        case EQUALS: {
                            return new JsonSelector("selector", this.tr(e, posRef), this.tr(e, posConstant));
                        }
                        case NOT_EQUALS: {
                            return new JsonCompositeFilter("not", ImmutableList.of(new JsonSelector("selector", this.tr(e, posRef), this.tr(e, posConstant))));
                        }
                        case GREATER_THAN: {
                            return new JsonBound("bound", this.tr(e, posRef), this.tr(e, posConstant), true, null, false, false);
                        }
                        case GREATER_THAN_OR_EQUAL: {
                            return new JsonBound("bound", this.tr(e, posRef), this.tr(e, posConstant), false, null, false, false);
                        }
                        case LESS_THAN: {
                            return new JsonBound("bound", this.tr(e, posRef), null, false, this.tr(e, posConstant), true, false);
                        }
                        case LESS_THAN_OR_EQUAL: {
                            return new JsonBound("bound", this.tr(e, posRef), null, false, this.tr(e, posConstant), false, false);
                        }
                    }
                    break;
                }
                case AND: 
                case OR: 
                case NOT: {
                    RexCall call = (RexCall)e;
                    return new JsonCompositeFilter(e.getKind().toString().toLowerCase(), this.translateFilters(call.getOperands()));
                }
            }
            throw new AssertionError((Object)("cannot translate filter: " + e));
        }

        private String tr(RexNode call, int index) {
            return this.tr(call, index, false);
        }

        private String tr(RexNode call, int index, boolean set) {
            return this.translate(((RexCall)call).getOperands().get(index), set);
        }

        private List<JsonFilter> translateFilters(List<RexNode> operands) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (RexNode operand : operands) {
                builder.add(this.translateFilter(operand));
            }
            return builder.build();
        }
    }

    public static class QuerySpec {
        final QueryType queryType;
        final String queryString;
        final List<String> fieldNames;

        QuerySpec(QueryType queryType, String queryString, List<String> fieldNames) {
            this.queryType = Preconditions.checkNotNull(queryType);
            this.queryString = Preconditions.checkNotNull(queryString);
            this.fieldNames = ImmutableList.copyOf(fieldNames);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.queryType, this.queryString, this.fieldNames});
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof QuerySpec && this.queryType == ((QuerySpec)obj).queryType && this.queryString.equals(((QuerySpec)obj).queryString) && this.fieldNames.equals(((QuerySpec)obj).fieldNames);
        }

        public String toString() {
            return "{queryType: " + (Object)((Object)this.queryType) + ", queryString: " + this.queryString + ", fieldNames: " + this.fieldNames + "}";
        }

        public String getQueryString(String pagingIdentifier, int offset) {
            if (pagingIdentifier == null) {
                return this.queryString;
            }
            return this.queryString.replace("\"threshold\":", "\"pagingIdentifiers\":{\"" + pagingIdentifier + "\":" + offset + "},\"threshold\":");
        }
    }
}

