/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.calcite.adapter.druid.DruidConnectionImpl;
import org.apache.calcite.adapter.druid.DruidTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Compatible;

public class DruidSchema
extends AbstractSchema {
    final String url;
    final String coordinatorUrl;
    private final boolean discoverTables;

    public DruidSchema(String url, String coordinatorUrl, boolean discoverTables) {
        this.url = Preconditions.checkNotNull(url);
        this.coordinatorUrl = Preconditions.checkNotNull(coordinatorUrl);
        this.discoverTables = discoverTables;
    }

    @Override
    protected Map<String, Table> getTableMap() {
        if (!this.discoverTables) {
            return ImmutableMap.of();
        }
        final DruidConnectionImpl connection = new DruidConnectionImpl(this.url, this.coordinatorUrl);
        return Compatible.INSTANCE.asMap(ImmutableSet.copyOf(connection.tableNames()), CacheBuilder.newBuilder().build(new CacheLoader<String, Table>(){

            @Override
            public Table load(@Nonnull String tableName) throws Exception {
                LinkedHashMap<String, SqlTypeName> fieldMap = new LinkedHashMap<String, SqlTypeName>();
                LinkedHashSet<String> metricNameSet = new LinkedHashSet<String>();
                connection.metadata(tableName, "__time", null, fieldMap, metricNameSet);
                return DruidTable.create(DruidSchema.this, tableName, null, fieldMap, metricNameSet, "__time", connection);
            }
        }));
    }
}

