/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.druid.DruidConnectionImpl;
import org.apache.calcite.adapter.druid.DruidSchema;
import org.apache.calcite.adapter.druid.DruidTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableFactory;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;
import org.joda.time.Interval;
import org.joda.time.chrono.ISOChronology;

public class DruidTableFactory
implements TableFactory {
    public static final DruidTableFactory INSTANCE = new DruidTableFactory();

    private DruidTableFactory() {
    }

    public Table create(SchemaPlus schema, String name, Map operand, RelDataType rowType) {
        Object metricsRaw;
        DruidSchema druidSchema = schema.unwrap(DruidSchema.class);
        String dataSource = (String)operand.get("dataSource");
        LinkedHashSet<String> metricNameBuilder = new LinkedHashSet<String>();
        LinkedHashMap<String, SqlTypeName> fieldBuilder = new LinkedHashMap<String, SqlTypeName>();
        String timestampColumnName = operand.get("timestampColumn") != null ? (String)operand.get("timestampColumn") : "__time";
        fieldBuilder.put(timestampColumnName, SqlTypeName.TIMESTAMP);
        Object dimensionsRaw = operand.get("dimensions");
        if (dimensionsRaw instanceof List) {
            List dimensions = (List)dimensionsRaw;
            for (Object dimension : dimensions) {
                fieldBuilder.put((String)dimension, SqlTypeName.VARCHAR);
            }
        }
        if ((metricsRaw = operand.get("metrics")) instanceof List) {
            List metrics = (List)metricsRaw;
            for (Object metric : metrics) {
                SqlTypeName sqlTypeName;
                String metricName;
                if (metric instanceof Map) {
                    Map map2 = (Map)metric;
                    if (!(map2.get("name") instanceof String)) {
                        throw new IllegalArgumentException("metric must have name");
                    }
                    metricName = (String)map2.get("name");
                    Object type = map2.get("type");
                    sqlTypeName = "long".equals(type) ? SqlTypeName.BIGINT : ("double".equals(type) ? SqlTypeName.DOUBLE : SqlTypeName.BIGINT);
                } else {
                    metricName = (String)metric;
                    sqlTypeName = SqlTypeName.BIGINT;
                }
                fieldBuilder.put(metricName, sqlTypeName);
                metricNameBuilder.add(metricName);
            }
        }
        String dataSourceName = Util.first(dataSource, name);
        DruidConnectionImpl c = dimensionsRaw == null || metricsRaw == null ? new DruidConnectionImpl(druidSchema.url, druidSchema.url.replace(":8082", ":8081")) : null;
        Object intervalString = operand.get("interval");
        ImmutableList<Interval> intervals = intervalString instanceof String ? ImmutableList.of(new Interval(intervalString, ISOChronology.getInstanceUTC())) : null;
        return DruidTable.create(druidSchema, dataSourceName, intervals, fieldBuilder, metricNameBuilder, timestampColumnName, c);
    }
}

