/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.FunctionExpression;
import org.apache.calcite.linq4j.tree.MemberDeclaration;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.runtime.Utilities;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class PhysTypeImpl
implements PhysType {
    private final JavaTypeFactory typeFactory;
    private final RelDataType rowType;
    private final Type javaRowClass;
    private final List<Class> fieldClasses = new ArrayList<Class>();
    final JavaRowFormat format;

    PhysTypeImpl(JavaTypeFactory typeFactory, RelDataType rowType, Type javaRowClass, JavaRowFormat format) {
        this.typeFactory = typeFactory;
        this.rowType = rowType;
        this.javaRowClass = javaRowClass;
        this.format = format;
        for (RelDataTypeField field : rowType.getFieldList()) {
            this.fieldClasses.add(EnumUtils.javaRowClass(typeFactory, field.getType()));
        }
    }

    public static PhysType of(JavaTypeFactory typeFactory, RelDataType rowType, JavaRowFormat format) {
        return PhysTypeImpl.of(typeFactory, rowType, format, true);
    }

    public static PhysType of(JavaTypeFactory typeFactory, RelDataType rowType, JavaRowFormat format, boolean optimize) {
        if (optimize) {
            format = format.optimize(rowType);
        }
        Type javaRowClass = format.javaRowClass(typeFactory, rowType);
        return new PhysTypeImpl(typeFactory, rowType, javaRowClass, format);
    }

    static PhysType of(JavaTypeFactory typeFactory, Type javaRowClass) {
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        if (javaRowClass instanceof Types.RecordType) {
            Types.RecordType recordType = (Types.RecordType)javaRowClass;
            for (Types.RecordField field : recordType.getRecordFields()) {
                builder.add(field.getName(), typeFactory.createType(field.getType()));
            }
        }
        RelDataType rowType = builder.build();
        return new PhysTypeImpl(typeFactory, rowType, javaRowClass, JavaRowFormat.CUSTOM);
    }

    @Override
    public JavaRowFormat getFormat() {
        return this.format;
    }

    @Override
    public PhysType project(List<Integer> integers, JavaRowFormat format) {
        return this.project(integers, false, format);
    }

    @Override
    public PhysType project(List<Integer> integers, boolean indicator, JavaRowFormat format) {
        RelDataTypeFactory.FieldInfoBuilder builder = this.typeFactory.builder();
        for (int index : integers) {
            builder.add(this.rowType.getFieldList().get(index));
        }
        if (indicator) {
            RelDataType booleanType = this.typeFactory.createTypeWithNullability(this.typeFactory.createSqlType(SqlTypeName.BOOLEAN), false);
            for (int index : integers) {
                builder.add("i$" + this.rowType.getFieldList().get(index).getName(), booleanType);
            }
        }
        RelDataType projectedRowType = builder.build();
        return PhysTypeImpl.of(this.typeFactory, projectedRowType, format.optimize(projectedRowType));
    }

    @Override
    public Expression generateSelector(ParameterExpression parameter, List<Integer> fields) {
        return this.generateSelector(parameter, fields, this.format);
    }

    @Override
    public Expression generateSelector(ParameterExpression parameter, List<Integer> fields, JavaRowFormat targetFormat) {
        switch (fields.size()) {
            case 0: {
                targetFormat = JavaRowFormat.LIST;
                break;
            }
            case 1: {
                targetFormat = JavaRowFormat.SCALAR;
            }
        }
        PhysType targetPhysType = this.project(fields, targetFormat);
        switch (this.format) {
            case SCALAR: {
                return Expressions.call(BuiltInMethod.IDENTITY_SELECTOR.method, new Expression[0]);
            }
        }
        return Expressions.lambda(Function1.class, targetPhysType.record(this.fieldReferences(parameter, fields)), parameter);
    }

    @Override
    public Expression generateSelector(ParameterExpression parameter, List<Integer> fields, List<Integer> usedFields, JavaRowFormat targetFormat) {
        PhysType targetPhysType = this.project(fields, true, targetFormat);
        ArrayList<Expression> expressions = Lists.newArrayList();
        for (Ord<Integer> ord : Ord.zip(fields)) {
            Integer field = (Integer)ord.e;
            if (usedFields.contains(field)) {
                expressions.add(this.fieldReference(parameter, field));
                continue;
            }
            Primitive primitive = Primitive.of(targetPhysType.fieldClass(ord.i));
            expressions.add(Expressions.constant(primitive != null ? primitive.defaultValue : null));
        }
        for (Integer field : fields) {
            expressions.add(Expressions.constant(!usedFields.contains(field)));
        }
        return Expressions.lambda(Function1.class, targetPhysType.record(expressions), parameter);
    }

    @Override
    public Expression selector(ParameterExpression parameter, List<Integer> fields, JavaRowFormat targetFormat) {
        switch (fields.size()) {
            case 0: {
                targetFormat = JavaRowFormat.LIST;
                break;
            }
            case 1: {
                targetFormat = JavaRowFormat.SCALAR;
            }
        }
        PhysType targetPhysType = this.project(fields, targetFormat);
        switch (this.format) {
            case SCALAR: {
                return parameter;
            }
        }
        return targetPhysType.record(this.fieldReferences(parameter, fields));
    }

    @Override
    public List<Expression> accessors(Expression v1, List<Integer> argList) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (int field : argList) {
            expressions.add(Types.castIfNecessary(this.fieldClass(field), this.fieldReference(v1, field)));
        }
        return expressions;
    }

    @Override
    public PhysType makeNullable(boolean nullable) {
        if (!nullable) {
            return this;
        }
        return new PhysTypeImpl(this.typeFactory, this.typeFactory.createTypeWithNullability(this.rowType, true), Primitive.box(this.javaRowClass), this.format);
    }

    @Override
    public Expression convertTo(Expression exp, PhysType targetPhysType) {
        JavaRowFormat targetFormat = targetPhysType.getFormat();
        if (this.format == targetFormat) {
            return exp;
        }
        ParameterExpression o_ = Expressions.parameter(this.javaRowClass, "o");
        int fieldCount = this.rowType.getFieldCount();
        return Expressions.call(exp, BuiltInMethod.SELECT.method, this.generateSelector(o_, Util.range(fieldCount), targetFormat));
    }

    @Override
    public Pair<Expression, Expression> generateCollationKey(List<RelFieldCollation> collations) {
        if (collations.size() == 1) {
            RelFieldCollation collation = collations.get(0);
            ParameterExpression parameter = Expressions.parameter(this.javaRowClass, "v");
            FunctionExpression<Function1> selector = Expressions.lambda(Function1.class, this.fieldReference(parameter, collation.getFieldIndex()), parameter);
            return Pair.of(selector, Expressions.call(BuiltInMethod.NULLS_COMPARATOR.method, Expressions.constant(collation.nullDirection == RelFieldCollation.NullDirection.FIRST), Expressions.constant(collation.getDirection() == RelFieldCollation.Direction.DESCENDING)));
        }
        MethodCallExpression selector = Expressions.call(BuiltInMethod.IDENTITY_SELECTOR.method, new Expression[0]);
        BlockBuilder body = new BlockBuilder();
        ParameterExpression parameterV0 = Expressions.parameter(this.javaRowClass, "v0");
        ParameterExpression parameterV1 = Expressions.parameter(this.javaRowClass, "v1");
        ParameterExpression parameterC = Expressions.parameter(Integer.TYPE, "c");
        int mod = collations.size() == 1 ? 16 : 0;
        body.add(Expressions.declare(mod, parameterC, null));
        for (RelFieldCollation collation : collations) {
            boolean descending;
            int index = collation.getFieldIndex();
            Expression arg0 = this.fieldReference(parameterV0, index);
            Expression arg1 = this.fieldReference(parameterV1, index);
            switch (Primitive.flavor(this.fieldClass(index))) {
                case OBJECT: {
                    arg0 = Types.castIfNecessary(Comparable.class, arg0);
                    arg1 = Types.castIfNecessary(Comparable.class, arg1);
                }
            }
            boolean nullsFirst = collation.nullDirection == RelFieldCollation.NullDirection.FIRST;
            boolean bl = descending = collation.getDirection() == RelFieldCollation.Direction.DESCENDING;
            Method method = (this.fieldNullable((int)index) ? (nullsFirst ^ descending ? BuiltInMethod.COMPARE_NULLS_FIRST : BuiltInMethod.COMPARE_NULLS_LAST) : BuiltInMethod.COMPARE).method;
            body.add(Expressions.statement(Expressions.assign(parameterC, Expressions.call(method.getDeclaringClass(), method.getName(), arg0, arg1))));
            body.add(Expressions.ifThen(Expressions.notEqual(parameterC, Expressions.constant(0)), Expressions.return_(null, descending ? Expressions.negate(parameterC) : parameterC)));
        }
        body.add(Expressions.return_(null, Expressions.constant(0)));
        Expressions.FluentList<MemberDeclaration> memberDeclarations = Expressions.list(Expressions.methodDecl(1, Integer.TYPE, "compare", ImmutableList.of(parameterV0, parameterV1), body.toBlock()));
        ParameterExpression parameterO0 = Expressions.parameter(Object.class, "o0");
        ParameterExpression parameterO1 = Expressions.parameter(Object.class, "o1");
        BlockBuilder bridgeBody = new BlockBuilder();
        bridgeBody.add(Expressions.return_(null, Expressions.call((Expression)Expressions.parameter(Comparable.class, "this"), BuiltInMethod.COMPARATOR_COMPARE.method, Expressions.convert_(parameterO0, this.javaRowClass), Expressions.convert_(parameterO1, this.javaRowClass))));
        memberDeclarations.add(EnumUtils.overridingMethodDecl(BuiltInMethod.COMPARATOR_COMPARE.method, ImmutableList.of(parameterO0, parameterO1), bridgeBody.toBlock()));
        return Pair.of(selector, Expressions.new_(Comparator.class, Collections.emptyList(), memberDeclarations));
    }

    @Override
    public Expression generateComparator(RelCollation collation) {
        BlockBuilder body = new BlockBuilder();
        Type javaRowClass = Primitive.box(this.javaRowClass);
        ParameterExpression parameterV0 = Expressions.parameter(javaRowClass, "v0");
        ParameterExpression parameterV1 = Expressions.parameter(javaRowClass, "v1");
        ParameterExpression parameterC = Expressions.parameter(Integer.TYPE, "c");
        int mod = collation.getFieldCollations().size() == 1 ? 16 : 0;
        body.add(Expressions.declare(mod, parameterC, null));
        for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
            boolean descending;
            int index = fieldCollation.getFieldIndex();
            Expression arg0 = this.fieldReference(parameterV0, index);
            Expression arg1 = this.fieldReference(parameterV1, index);
            switch (Primitive.flavor(this.fieldClass(index))) {
                case OBJECT: {
                    arg0 = Types.castIfNecessary(Comparable.class, arg0);
                    arg1 = Types.castIfNecessary(Comparable.class, arg1);
                }
            }
            boolean nullsFirst = fieldCollation.nullDirection == RelFieldCollation.NullDirection.FIRST;
            boolean bl = descending = fieldCollation.getDirection() == RelFieldCollation.Direction.DESCENDING;
            body.add(Expressions.statement(Expressions.assign(parameterC, Expressions.call(Utilities.class, this.fieldNullable(index) ? (nullsFirst != descending ? "compareNullsFirst" : "compareNullsLast") : "compare", new Expression[]{arg0, arg1}))));
            body.add(Expressions.ifThen(Expressions.notEqual(parameterC, Expressions.constant(0)), Expressions.return_(null, descending ? Expressions.negate(parameterC) : parameterC)));
        }
        body.add(Expressions.return_(null, Expressions.constant(0)));
        Expressions.FluentList<MemberDeclaration> memberDeclarations = Expressions.list(Expressions.methodDecl(1, Integer.TYPE, "compare", ImmutableList.of(parameterV0, parameterV1), body.toBlock()));
        ParameterExpression parameterO0 = Expressions.parameter(Object.class, "o0");
        ParameterExpression parameterO1 = Expressions.parameter(Object.class, "o1");
        BlockBuilder bridgeBody = new BlockBuilder();
        bridgeBody.add(Expressions.return_(null, Expressions.call((Expression)Expressions.parameter(Comparable.class, "this"), BuiltInMethod.COMPARATOR_COMPARE.method, Expressions.convert_(parameterO0, javaRowClass), Expressions.convert_(parameterO1, javaRowClass))));
        memberDeclarations.add(EnumUtils.overridingMethodDecl(BuiltInMethod.COMPARATOR_COMPARE.method, ImmutableList.of(parameterO0, parameterO1), bridgeBody.toBlock()));
        return Expressions.new_(Comparator.class, Collections.emptyList(), memberDeclarations);
    }

    @Override
    public RelDataType getRowType() {
        return this.rowType;
    }

    @Override
    public Expression record(List<Expression> expressions) {
        return this.format.record(this.javaRowClass, expressions);
    }

    @Override
    public Type getJavaRowType() {
        return this.javaRowClass;
    }

    @Override
    public Type getJavaFieldType(int index) {
        return this.format.javaFieldClass(this.typeFactory, this.rowType, index);
    }

    @Override
    public PhysType component(int fieldOrdinal) {
        RelDataTypeField field = this.rowType.getFieldList().get(fieldOrdinal);
        return PhysTypeImpl.of(this.typeFactory, this.toStruct(field.getType().getComponentType()), this.format, false);
    }

    @Override
    public PhysType field(int ordinal) {
        RelDataTypeField field = this.rowType.getFieldList().get(ordinal);
        RelDataType type = field.getType();
        return PhysTypeImpl.of(this.typeFactory, this.toStruct(type), this.format, false);
    }

    private RelDataType toStruct(RelDataType type) {
        if (type.isStruct()) {
            return type;
        }
        return this.typeFactory.builder().add(SqlUtil.deriveAliasFromOrdinal(0), type).build();
    }

    @Override
    public Expression comparer() {
        return this.format.comparer();
    }

    private List<Expression> fieldReferences(final Expression parameter, final List<Integer> fields) {
        return new AbstractList<Expression>(){

            @Override
            public Expression get(int index) {
                return PhysTypeImpl.this.fieldReference(parameter, (Integer)fields.get(index));
            }

            @Override
            public int size() {
                return fields.size();
            }
        };
    }

    @Override
    public Class fieldClass(int field) {
        return this.fieldClasses.get(field);
    }

    @Override
    public boolean fieldNullable(int field) {
        return this.rowType.getFieldList().get(field).getType().isNullable();
    }

    @Override
    public Expression generateAccessor(List<Integer> fields) {
        ParameterExpression v1 = Expressions.parameter(this.javaRowClass, "v1");
        switch (fields.size()) {
            case 0: {
                return Expressions.lambda(Function1.class, (Expression)Expressions.field(null, BuiltInMethod.COMPARABLE_EMPTY_LIST.field), v1);
            }
            case 1: {
                int field0 = fields.get(0);
                Class returnType = this.fieldClasses.get(field0);
                Expression fieldReference = Types.castIfNecessary(returnType, this.fieldReference(v1, field0));
                return Expressions.lambda(Function1.class, fieldReference, v1);
            }
        }
        Expressions.FluentList list = Expressions.list();
        for (int field : fields) {
            list.add(this.fieldReference(v1, field));
        }
        switch (list.size()) {
            case 2: {
                return Expressions.lambda(Function1.class, (Expression)Expressions.call(List.class, null, BuiltInMethod.LIST2.method, list), v1);
            }
            case 3: {
                return Expressions.lambda(Function1.class, (Expression)Expressions.call(List.class, null, BuiltInMethod.LIST3.method, list), v1);
            }
            case 4: {
                return Expressions.lambda(Function1.class, (Expression)Expressions.call(List.class, null, BuiltInMethod.LIST4.method, list), v1);
            }
            case 5: {
                return Expressions.lambda(Function1.class, (Expression)Expressions.call(List.class, null, BuiltInMethod.LIST5.method, list), v1);
            }
            case 6: {
                return Expressions.lambda(Function1.class, (Expression)Expressions.call(List.class, null, BuiltInMethod.LIST6.method, list), v1);
            }
        }
        return Expressions.lambda(Function1.class, (Expression)Expressions.call(List.class, null, BuiltInMethod.LIST_N.method, new Expression[]{Expressions.newArrayInit(Comparable.class, list)}), v1);
    }

    @Override
    public Expression fieldReference(Expression expression, int field) {
        return this.fieldReference(expression, field, null);
    }

    @Override
    public Expression fieldReference(Expression expression, int field, Type storageType) {
        if (storageType == null) {
            storageType = this.fieldClass(field);
        }
        return this.format.field(expression, field, storageType);
    }
}

