/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;

class SimpleCalciteSchema
extends CalciteSchema {
    SimpleCalciteSchema(CalciteSchema parent, Schema schema, String name) {
        super(parent, schema, name);
    }

    @Override
    public void setCache(boolean cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CalciteSchema add(String name, Schema schema) {
        SimpleCalciteSchema calciteSchema = new SimpleCalciteSchema(this, schema, name);
        this.subSchemaMap.put(name, calciteSchema);
        return calciteSchema;
    }

    @Override
    protected CalciteSchema getImplicitSubSchema(String schemaName, boolean caseSensitive) {
        Schema s = this.schema.getSubSchema(schemaName);
        if (s != null) {
            return new SimpleCalciteSchema(this, s, schemaName);
        }
        return null;
    }

    @Override
    protected CalciteSchema.TableEntry getImplicitTable(String tableName, boolean caseSensitive) {
        Table table = this.schema.getTable(tableName);
        if (table != null) {
            return this.tableEntry(tableName, table);
        }
        return null;
    }

    @Override
    protected void addImplicitSubSchemaToBuilder(ImmutableSortedMap.Builder<String, CalciteSchema> builder) {
        ImmutableMap explicitSubSchemas = builder.build();
        for (String schemaName : this.schema.getSubSchemaNames()) {
            Schema s;
            if (explicitSubSchemas.containsKey(schemaName) || (s = this.schema.getSubSchema(schemaName)) == null) continue;
            SimpleCalciteSchema calciteSchema = new SimpleCalciteSchema(this, s, schemaName);
            builder.put((Object)schemaName, (Object)calciteSchema);
        }
    }

    @Override
    protected void addImplicitTableToBuilder(ImmutableSortedSet.Builder<String> builder) {
        builder.addAll(this.schema.getTableNames());
    }

    @Override
    protected void addImplicitFunctionToBuilder(ImmutableList.Builder<Function> builder) {
        for (String functionName : this.schema.getFunctionNames()) {
            builder.addAll(this.schema.getFunctions(functionName));
        }
    }

    @Override
    protected void addImplicitFuncNamesToBuilder(ImmutableSortedSet.Builder<String> builder) {
        builder.addAll(this.schema.getFunctionNames());
    }

    @Override
    protected void addImplicitTablesBasedOnNullaryFunctionsToBuilder(ImmutableSortedMap.Builder<String, Table> builder) {
        ImmutableMap explicitTables = builder.build();
        for (String s : this.schema.getFunctionNames()) {
            if (explicitTables.containsKey(s)) continue;
            for (Function function : this.schema.getFunctions(s)) {
                if (!(function instanceof TableMacro) || !function.getParameters().isEmpty()) continue;
                TranslatableTable table = ((TableMacro)function).apply(ImmutableList.of());
                builder.put((Object)s, (Object)table);
            }
        }
    }

    @Override
    protected CalciteSchema.TableEntry getImplicitTableBasedOnNullaryFunction(String tableName, boolean caseSensitive) {
        for (String s : this.schema.getFunctionNames()) {
            for (Function function : this.schema.getFunctions(s)) {
                if (!(function instanceof TableMacro) || !function.getParameters().isEmpty()) continue;
                TranslatableTable table = ((TableMacro)function).apply(ImmutableList.of());
                return this.tableEntry(tableName, table);
            }
        }
        return null;
    }

    @Override
    protected boolean isCacheEnabled() {
        return false;
    }
}

