/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.hep;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.calcite.linq4j.function.Functions;
import org.apache.calcite.plan.AbstractRelOptPlanner;
import org.apache.calcite.plan.CommonRelSubExprRule;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptCostFactory;
import org.apache.calcite.plan.RelOptCostImpl;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.hep.HepInstruction;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepRelMetadataProvider;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.hep.HepRuleCall;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.Converter;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.convert.TraitMatchingRule;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.graph.BreadthFirstIterator;
import org.apache.calcite.util.graph.CycleDetector;
import org.apache.calcite.util.graph.DefaultDirectedGraph;
import org.apache.calcite.util.graph.DefaultEdge;
import org.apache.calcite.util.graph.DepthFirstIterator;
import org.apache.calcite.util.graph.DirectedGraph;
import org.apache.calcite.util.graph.Graphs;
import org.apache.calcite.util.graph.TopologicalOrderIterator;

public class HepPlanner
extends AbstractRelOptPlanner {
    private HepProgram mainProgram;
    private HepProgram currentProgram;
    private HepRelVertex root;
    private RelTraitSet requestedRootTraits;
    private Map<String, HepRelVertex> mapDigestToVertex;
    private final Set<RelOptRule> allRules;
    private int nTransformations;
    private int graphSizeLastGC;
    private int nTransformationsLastGC;
    private boolean noDAG;
    private DirectedGraph<HepRelVertex, DefaultEdge> graph;
    private final Function2<RelNode, RelNode, Void> onCopyHook;

    public HepPlanner(HepProgram program) {
        this(program, null, false, null, RelOptCostImpl.FACTORY);
    }

    public HepPlanner(HepProgram program, Context context) {
        this(program, context, false, null, RelOptCostImpl.FACTORY);
    }

    public HepPlanner(HepProgram program, Context context, boolean noDAG, Function2<RelNode, RelNode, Void> onCopyHook, RelOptCostFactory costFactory) {
        super(costFactory, context);
        this.mainProgram = program;
        this.onCopyHook = Util.first(onCopyHook, Functions.ignore2());
        this.mapDigestToVertex = new HashMap<String, HepRelVertex>();
        this.graph = DefaultDirectedGraph.create();
        this.allRules = new LinkedHashSet<RelOptRule>();
        this.noDAG = noDAG;
    }

    @Override
    public void setRoot(RelNode rel) {
        this.root = this.addRelToGraph(rel);
        this.dumpGraph();
    }

    @Override
    public RelNode getRoot() {
        return this.root;
    }

    @Override
    public boolean addRule(RelOptRule rule) {
        boolean added = this.allRules.add(rule);
        if (added) {
            this.mapRuleDescription(rule);
        }
        return added;
    }

    @Override
    public void clear() {
        super.clear();
        for (RelOptRule rule : ImmutableList.copyOf(this.allRules)) {
            this.removeRule(rule);
        }
    }

    @Override
    public boolean removeRule(RelOptRule rule) {
        this.unmapRuleDescription(rule);
        return this.allRules.remove(rule);
    }

    @Override
    public RelNode changeTraits(RelNode rel, RelTraitSet toTraits) {
        if (rel == this.root || rel == this.root.getCurrentRel()) {
            this.requestedRootTraits = toTraits;
        }
        return rel;
    }

    @Override
    public RelNode findBestExp() {
        assert (this.root != null);
        this.executeProgram(this.mainProgram);
        this.collectGarbage();
        return this.buildFinalPlan(this.root);
    }

    private void executeProgram(HepProgram program) {
        HepProgram savedProgram = this.currentProgram;
        this.currentProgram = program;
        this.currentProgram.initialize(program == this.mainProgram);
        for (HepInstruction instruction : this.currentProgram.instructions) {
            instruction.execute(this);
            int delta = this.nTransformations - this.nTransformationsLastGC;
            if (delta <= this.graphSizeLastGC) continue;
            this.collectGarbage();
        }
        this.currentProgram = savedProgram;
    }

    void executeInstruction(HepInstruction.MatchLimit instruction) {
        LOGGER.trace("Setting match limit to {}", (Object)instruction.limit);
        this.currentProgram.matchLimit = instruction.limit;
    }

    void executeInstruction(HepInstruction.MatchOrder instruction) {
        LOGGER.trace("Setting match limit to {}", (Object)instruction.order);
        this.currentProgram.matchOrder = instruction.order;
    }

    void executeInstruction(HepInstruction.RuleInstance instruction) {
        if (this.skippingGroup()) {
            return;
        }
        if (instruction.rule == null) {
            assert (instruction.ruleDescription != null);
            instruction.rule = this.getRuleByDescription(instruction.ruleDescription);
            LOGGER.trace("Looking up rule with description {}, found {}", (Object)instruction.ruleDescription, (Object)instruction.rule);
        }
        if (instruction.rule != null) {
            this.applyRules(Collections.singleton(instruction.rule), true);
        }
    }

    void executeInstruction(HepInstruction.RuleClass<?> instruction) {
        if (this.skippingGroup()) {
            return;
        }
        LOGGER.trace("Applying rule class {}", (Object)instruction.ruleClass);
        if (instruction.ruleSet == null) {
            instruction.ruleSet = new LinkedHashSet<RelOptRule>();
            for (RelOptRule rule : this.allRules) {
                if (!instruction.ruleClass.isInstance(rule)) continue;
                instruction.ruleSet.add(rule);
            }
        }
        this.applyRules(instruction.ruleSet, true);
    }

    void executeInstruction(HepInstruction.RuleCollection instruction) {
        if (this.skippingGroup()) {
            return;
        }
        this.applyRules(instruction.rules, true);
    }

    private boolean skippingGroup() {
        if (this.currentProgram.group != null) {
            return !this.currentProgram.group.collecting;
        }
        return false;
    }

    void executeInstruction(HepInstruction.ConverterRules instruction) {
        assert (this.currentProgram.group == null);
        if (instruction.ruleSet == null) {
            instruction.ruleSet = new LinkedHashSet<RelOptRule>();
            for (RelOptRule rule : this.allRules) {
                ConverterRule converter;
                if (!(rule instanceof ConverterRule) || (converter = (ConverterRule)rule).isGuaranteed() != instruction.guaranteed) continue;
                instruction.ruleSet.add(converter);
                if (instruction.guaranteed) continue;
                instruction.ruleSet.add(new TraitMatchingRule(converter));
            }
        }
        this.applyRules(instruction.ruleSet, instruction.guaranteed);
    }

    void executeInstruction(HepInstruction.CommonRelSubExprRules instruction) {
        assert (this.currentProgram.group == null);
        if (instruction.ruleSet == null) {
            instruction.ruleSet = new LinkedHashSet<RelOptRule>();
            for (RelOptRule rule : this.allRules) {
                if (!(rule instanceof CommonRelSubExprRule)) continue;
                instruction.ruleSet.add(rule);
            }
        }
        this.applyRules(instruction.ruleSet, true);
    }

    void executeInstruction(HepInstruction.Subprogram instruction) {
        int nTransformationsBefore;
        LOGGER.trace("Entering subprogram");
        do {
            nTransformationsBefore = this.nTransformations;
            this.executeProgram(instruction.subprogram);
        } while (this.nTransformations != nTransformationsBefore);
        LOGGER.trace("Leaving subprogram");
    }

    void executeInstruction(HepInstruction.BeginGroup instruction) {
        assert (this.currentProgram.group == null);
        this.currentProgram.group = instruction.endGroup;
        LOGGER.trace("Entering group");
    }

    void executeInstruction(HepInstruction.EndGroup instruction) {
        assert (this.currentProgram.group == instruction);
        this.currentProgram.group = null;
        instruction.collecting = false;
        this.applyRules(instruction.ruleSet, true);
        LOGGER.trace("Leaving group");
    }

    private void applyRules(Collection<RelOptRule> rules, boolean forceConversions) {
        boolean fixpoint;
        if (this.currentProgram.group != null) {
            assert (this.currentProgram.group.collecting);
            this.currentProgram.group.ruleSet.addAll(rules);
            return;
        }
        LOGGER.trace("Applying rule set {}", (Object)rules);
        boolean fullRestartAfterTransformation = this.currentProgram.matchOrder != HepMatchOrder.ARBITRARY;
        int nMatches = 0;
        do {
            Iterator<HepRelVertex> iter = this.getGraphIterator(this.root);
            fixpoint = true;
            block1: while (iter.hasNext()) {
                HepRelVertex vertex = iter.next();
                for (RelOptRule rule : rules) {
                    HepRelVertex newVertex = this.applyRule(rule, vertex, forceConversions);
                    if (newVertex == null) continue;
                    if (++nMatches >= this.currentProgram.matchLimit) {
                        return;
                    }
                    if (fullRestartAfterTransformation) {
                        iter = this.getGraphIterator(this.root);
                        continue block1;
                    }
                    iter = this.getGraphIterator(newVertex);
                    fixpoint = false;
                    continue block1;
                }
            }
        } while (!fixpoint);
    }

    private Iterator<HepRelVertex> getGraphIterator(HepRelVertex start) {
        this.collectGarbage();
        if (this.currentProgram.matchOrder == HepMatchOrder.ARBITRARY) {
            return DepthFirstIterator.of(this.graph, start).iterator();
        }
        assert (start == this.root);
        Iterable<HepRelVertex> iter = TopologicalOrderIterator.of(this.graph);
        if (this.currentProgram.matchOrder == HepMatchOrder.TOP_DOWN) {
            return iter.iterator();
        }
        assert (this.currentProgram.matchOrder == HepMatchOrder.BOTTOM_UP);
        ArrayList<HepRelVertex> list = new ArrayList<HepRelVertex>();
        for (HepRelVertex vertex : iter) {
            list.add(vertex);
        }
        Collections.reverse(list);
        return list.iterator();
    }

    private HepRelVertex applyRule(RelOptRule rule, HepRelVertex vertex, boolean forceConversions) {
        RelTrait parentTrait = null;
        ArrayList<RelNode> parents = null;
        if (rule instanceof ConverterRule) {
            ConverterRule converterRule = (ConverterRule)rule;
            if (converterRule.isGuaranteed() || !forceConversions) {
                if (!this.doesConverterApply(converterRule, vertex)) {
                    return null;
                }
                parentTrait = converterRule.getOutTrait();
            }
        } else if (rule instanceof CommonRelSubExprRule) {
            List<HepRelVertex> parentVertices = this.getVertexParents(vertex);
            if (parentVertices.size() < 2) {
                return null;
            }
            parents = new ArrayList<RelNode>();
            for (HepRelVertex pVertex : parentVertices) {
                parents.add(pVertex.getCurrentRel());
            }
        }
        ArrayList<RelNode> bindings = new ArrayList<RelNode>();
        HashMap<RelNode, List<RelNode>> nodeChildren = new HashMap<RelNode, List<RelNode>>();
        boolean match = this.matchOperands(rule.getOperand(), vertex.getCurrentRel(), bindings, nodeChildren);
        if (!match) {
            return null;
        }
        HepRuleCall call = new HepRuleCall(this, rule.getOperand(), bindings.toArray(new RelNode[bindings.size()]), nodeChildren, parents);
        if (!rule.matches(call)) {
            return null;
        }
        this.fireRule(call);
        if (!call.getResults().isEmpty()) {
            return this.applyTransformationResults(vertex, call, parentTrait);
        }
        return null;
    }

    private boolean doesConverterApply(ConverterRule converterRule, HepRelVertex vertex) {
        RelTrait outTrait = converterRule.getOutTrait();
        List<HepRelVertex> parents = Graphs.predecessorListOf(this.graph, vertex);
        for (HepRelVertex parent : parents) {
            RelNode parentRel = parent.getCurrentRel();
            if (parentRel instanceof Converter || !parentRel.getTraitSet().contains(outTrait)) continue;
            return true;
        }
        return vertex == this.root && this.requestedRootTraits != null && this.requestedRootTraits.contains(outTrait);
    }

    private List<HepRelVertex> getVertexParents(HepRelVertex vertex) {
        ArrayList<HepRelVertex> parents = new ArrayList<HepRelVertex>();
        List<HepRelVertex> parentVertices = Graphs.predecessorListOf(this.graph, vertex);
        for (HepRelVertex pVertex : parentVertices) {
            RelNode parent = pVertex.getCurrentRel();
            for (int i = 0; i < parent.getInputs().size(); ++i) {
                HepRelVertex child = (HepRelVertex)parent.getInputs().get(i);
                if (child != vertex) continue;
                parents.add(pVertex);
            }
        }
        return parents;
    }

    private boolean matchOperands(RelOptRuleOperand operand, RelNode rel, List<RelNode> bindings, Map<RelNode, List<RelNode>> nodeChildren) {
        if (!operand.matches(rel)) {
            return false;
        }
        bindings.add(rel);
        List<RelNode> childRels = rel.getInputs();
        switch (operand.childPolicy) {
            case ANY: {
                return true;
            }
            case UNORDERED: {
                for (RelOptRuleOperand relOptRuleOperand : operand.getChildOperands()) {
                    HepRelVertex childRel;
                    boolean bl = false;
                    Iterator<RelNode> iterator = childRels.iterator();
                    while (iterator.hasNext() && !(bl = this.matchOperands(relOptRuleOperand, (childRel = (HepRelVertex)iterator.next()).getCurrentRel(), bindings, nodeChildren))) {
                    }
                    if (bl) continue;
                    return false;
                }
                ArrayList<RelNode> children = new ArrayList<RelNode>(childRels.size());
                for (HepRelVertex hepRelVertex : childRels) {
                    children.add(hepRelVertex.getCurrentRel());
                }
                nodeChildren.put(rel, children);
                return true;
            }
        }
        int n = operand.getChildOperands().size();
        if (childRels.size() < n) {
            return false;
        }
        for (Pair<RelNode, RelOptRuleOperand> pair : Pair.zip(childRels, operand.getChildOperands())) {
            boolean match = this.matchOperands((RelOptRuleOperand)pair.right, ((HepRelVertex)pair.left).getCurrentRel(), bindings, nodeChildren);
            if (match) continue;
            return false;
        }
        return true;
    }

    private HepRelVertex applyTransformationResults(HepRelVertex vertex, HepRuleCall call, RelTrait parentTrait) {
        assert (!call.getResults().isEmpty());
        RelNode bestRel = null;
        if (call.getResults().size() == 1) {
            bestRel = call.getResults().get(0);
        } else {
            RelOptCost bestCost = null;
            RelMetadataQuery mq = RelMetadataQuery.instance();
            for (RelNode rel : call.getResults()) {
                RelOptCost thisCost = this.getCost(rel, mq);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("considering {} with cumulative cost={} and rowcount={}", rel, thisCost, mq.getRowCount(rel));
                }
                if (bestRel != null && !thisCost.isLt(bestCost)) continue;
                bestRel = rel;
                bestCost = thisCost;
            }
        }
        ++this.nTransformations;
        this.notifyTransformation(call, bestRel, true);
        List<HepRelVertex> allParents = Graphs.predecessorListOf(this.graph, vertex);
        ArrayList<HepRelVertex> parents = new ArrayList<HepRelVertex>();
        for (HepRelVertex parent : allParents) {
            RelNode parentRel;
            if (parentTrait != null && ((parentRel = parent.getCurrentRel()) instanceof Converter || !parentRel.getTraitSet().contains(parentTrait))) continue;
            parents.add(parent);
        }
        HepRelVertex newVertex = this.addRelToGraph(bestRel);
        int iParentMatch = parents.indexOf(newVertex);
        if (iParentMatch != -1) {
            newVertex = (HepRelVertex)parents.get(iParentMatch);
        } else {
            this.contractVertices(newVertex, vertex, parents);
        }
        if (this.getListener() != null) {
            this.collectGarbage();
        }
        this.notifyTransformation(call, bestRel, false);
        this.dumpGraph();
        return newVertex;
    }

    @Override
    public RelNode register(RelNode rel, RelNode equivRel) {
        return rel;
    }

    @Override
    public void onCopy(RelNode rel, RelNode newRel) {
        this.onCopyHook.apply(rel, newRel);
    }

    @Override
    public RelNode ensureRegistered(RelNode rel, RelNode equivRel) {
        return rel;
    }

    @Override
    public boolean isRegistered(RelNode rel) {
        return true;
    }

    private HepRelVertex addRelToGraph(RelNode rel) {
        String digest;
        HepRelVertex equivVertex;
        if (rel instanceof HepRelVertex) {
            return (HepRelVertex)rel;
        }
        List<RelNode> inputs = rel.getInputs();
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
        for (RelNode input1 : inputs) {
            HepRelVertex childVertex = this.addRelToGraph(input1);
            newInputs.add(childVertex);
        }
        if (!Util.equalShallow(inputs, newInputs)) {
            RelNode oldRel = rel;
            rel = rel.copy(rel.getTraitSet(), newInputs);
            this.onCopy(oldRel, rel);
        }
        if (!this.noDAG && (equivVertex = this.mapDigestToVertex.get(digest = rel.getDigest())) != null) {
            return equivVertex;
        }
        HepRelVertex newVertex = new HepRelVertex(rel);
        this.graph.addVertex(newVertex);
        this.updateVertex(newVertex, rel);
        for (RelNode input : rel.getInputs()) {
            this.graph.addEdge(newVertex, (HepRelVertex)input);
        }
        return newVertex;
    }

    private void contractVertices(HepRelVertex preservedVertex, HepRelVertex discardedVertex, List<HepRelVertex> parents) {
        if (preservedVertex == discardedVertex) {
            return;
        }
        RelNode rel = preservedVertex.getCurrentRel();
        this.updateVertex(preservedVertex, rel);
        for (HepRelVertex parent : parents) {
            RelNode parentRel = parent.getCurrentRel();
            List<RelNode> inputs = parentRel.getInputs();
            for (int i = 0; i < inputs.size(); ++i) {
                RelNode child = inputs.get(i);
                if (child != discardedVertex) continue;
                parentRel.replaceInput(i, preservedVertex);
            }
            this.graph.removeEdge(parent, discardedVertex);
            this.graph.addEdge(parent, preservedVertex);
            this.updateVertex(parent, parentRel);
        }
        if (discardedVertex == this.root) {
            this.root = preservedVertex;
        }
    }

    private void updateVertex(HepRelVertex vertex, RelNode rel) {
        String newDigest;
        String oldDigest;
        if (rel != vertex.getCurrentRel()) {
            this.notifyDiscard(vertex.getCurrentRel());
        }
        if (this.mapDigestToVertex.get(oldDigest = vertex.getCurrentRel().toString()) == vertex) {
            this.mapDigestToVertex.remove(oldDigest);
        }
        if (this.mapDigestToVertex.get(newDigest = rel.recomputeDigest()) == null) {
            this.mapDigestToVertex.put(newDigest, vertex);
        }
        if (rel != vertex.getCurrentRel()) {
            vertex.replaceRel(rel);
        }
        this.notifyEquivalence(rel, vertex, false);
    }

    private RelNode buildFinalPlan(HepRelVertex vertex) {
        RelNode rel = vertex.getCurrentRel();
        this.notifyChosen(rel);
        List<RelNode> inputs = rel.getInputs();
        for (int i = 0; i < inputs.size(); ++i) {
            RelNode child = inputs.get(i);
            if (!(child instanceof HepRelVertex)) continue;
            child = this.buildFinalPlan((HepRelVertex)child);
            rel.replaceInput(i, child);
            rel.recomputeDigest();
        }
        return rel;
    }

    private void collectGarbage() {
        if (this.nTransformations == this.nTransformationsLastGC) {
            return;
        }
        this.nTransformationsLastGC = this.nTransformations;
        LOGGER.trace("collecting garbage");
        HashSet rootSet = new HashSet();
        if (this.graph.vertexSet().contains(this.root)) {
            BreadthFirstIterator.reachable(rootSet, this.graph, this.root);
        }
        if (rootSet.size() == this.graph.vertexSet().size()) {
            return;
        }
        HashSet<HepRelVertex> sweepSet = new HashSet<HepRelVertex>();
        for (HepRelVertex vertex : this.graph.vertexSet()) {
            if (rootSet.contains(vertex)) continue;
            sweepSet.add(vertex);
            RelNode rel = vertex.getCurrentRel();
            this.notifyDiscard(rel);
        }
        assert (!sweepSet.isEmpty());
        this.graph.removeAllVertices(sweepSet);
        this.graphSizeLastGC = this.graph.vertexSet().size();
        Iterator<Map.Entry<String, HepRelVertex>> digestIter = this.mapDigestToVertex.entrySet().iterator();
        while (digestIter.hasNext()) {
            HepRelVertex vertex;
            vertex = digestIter.next().getValue();
            if (!sweepSet.contains(vertex)) continue;
            digestIter.remove();
        }
    }

    private void assertNoCycles() {
        CycleDetector<HepRelVertex, DefaultEdge> cycleDetector = new CycleDetector<HepRelVertex, DefaultEdge>(this.graph);
        Set<HepRelVertex> cyclicVertices = cycleDetector.findCycles();
        if (cyclicVertices.isEmpty()) {
            return;
        }
        throw Util.newInternal("Query graph cycle detected in HepPlanner:  " + cyclicVertices);
    }

    private void dumpGraph() {
        if (!LOGGER.isTraceEnabled()) {
            return;
        }
        this.assertNoCycles();
        RelMetadataQuery mq = RelMetadataQuery.instance();
        StringBuilder sb = new StringBuilder();
        sb.append("\nBreadth-first from root:  {\n");
        for (HepRelVertex vertex : BreadthFirstIterator.of(this.graph, this.root)) {
            sb.append("    ").append(vertex).append(" = ");
            RelNode rel = vertex.getCurrentRel();
            sb.append(rel).append(", rowcount=").append(mq.getRowCount(rel)).append(", cumulative cost=").append(this.getCost(rel, mq)).append('\n');
        }
        sb.append("}");
        LOGGER.trace(sb.toString());
    }

    @Override
    public void registerMetadataProviders(List<RelMetadataProvider> list) {
        list.add(0, new HepRelMetadataProvider());
    }

    @Override
    public long getRelMetadataTimestamp(RelNode rel) {
        return this.nTransformations;
    }
}

