/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import com.google.common.base.Preconditions;
import java.util.Calendar;
import org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;

public class SqlTimestampLiteral
extends SqlAbstractDateTimeLiteral {
    public SqlTimestampLiteral(Calendar cal, int precision, boolean hasTimeZone, SqlParserPos pos) {
        this(cal, precision, hasTimeZone, "yyyy-MM-dd HH:mm:ss", pos);
    }

    public SqlTimestampLiteral(Calendar cal, int precision, boolean hasTimeZone, String format, SqlParserPos pos) {
        super(cal, hasTimeZone, SqlTypeName.TIMESTAMP, precision, format, pos);
        Preconditions.checkArgument(this.precision >= 0 && this.precision <= 3);
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return new SqlTimestampLiteral((Calendar)this.value, this.precision, this.hasTimeZone, this.formatString, pos);
    }

    @Override
    public String toString() {
        return "TIMESTAMP '" + this.toFormattedString() + "'";
    }

    @Override
    public String toFormattedString() {
        String result = this.getTimestamp().toString(this.formatString);
        Calendar cal = this.getCal();
        if (this.precision > 0) {
            assert (this.precision <= 3);
            String digits = Long.toString(cal.getTimeInMillis());
            result = result + "." + digits.substring(digits.length() - 3, digits.length() - 3 + this.precision);
        } else assert (0 == cal.get(14));
        return result;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        switch (writer.getDialect().getDatabaseProduct()) {
            case MSSQL: {
                writer.literal("'" + this.toFormattedString() + "'");
                break;
            }
            default: {
                writer.literal(this.toString());
            }
        }
    }
}

