/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.parser;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.util.Static;

public class SqlParserPos
implements Serializable {
    public static final SqlParserPos ZERO = new SqlParserPos(0, 0);
    private static final long serialVersionUID = 1L;
    private final int lineNumber;
    private final int columnNumber;
    private final int endLineNumber;
    private final int endColumnNumber;

    public SqlParserPos(int lineNumber, int columnNumber) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.endLineNumber = lineNumber;
        this.endColumnNumber = columnNumber;
    }

    public SqlParserPos(int startLineNumber, int startColumnNumber, int endLineNumber, int endColumnNumber) {
        this.lineNumber = startLineNumber;
        this.columnNumber = startColumnNumber;
        this.endLineNumber = endLineNumber;
        this.endColumnNumber = endColumnNumber;
    }

    public int hashCode() {
        return Objects.hash(this.lineNumber, this.columnNumber, this.endLineNumber, this.endColumnNumber);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof SqlParserPos && this.lineNumber == ((SqlParserPos)o).lineNumber && this.columnNumber == ((SqlParserPos)o).columnNumber && this.endLineNumber == ((SqlParserPos)o).endLineNumber && this.endColumnNumber == ((SqlParserPos)o).endColumnNumber;
    }

    public int getLineNum() {
        return this.lineNumber;
    }

    public int getColumnNum() {
        return this.columnNumber;
    }

    public int getEndLineNum() {
        return this.endLineNumber;
    }

    public int getEndColumnNum() {
        return this.endColumnNumber;
    }

    public String toString() {
        return Static.RESOURCE.parserContext(this.lineNumber, this.columnNumber).str();
    }

    public SqlParserPos plus(SqlParserPos pos) {
        return new SqlParserPos(this.getLineNum(), this.getColumnNum(), pos.getEndLineNum(), pos.getEndColumnNum());
    }

    public SqlParserPos plusAll(SqlNode[] nodes) {
        return this.plusAll(Arrays.asList(nodes));
    }

    public SqlParserPos plusAll(Collection<SqlNode> nodeList) {
        int line = this.getLineNum();
        int column = this.getColumnNum();
        int endLine = this.getEndLineNum();
        int endColumn = this.getEndColumnNum();
        return SqlParserPos.sum(SqlParserPos.toPos(nodeList), line, column, endLine, endColumn);
    }

    public static SqlParserPos sum(SqlNode[] nodes) {
        Iterable<SqlParserPos> poses = SqlParserPos.toPos(Arrays.asList(nodes));
        return SqlParserPos.sum(poses, Integer.MAX_VALUE, Integer.MAX_VALUE, -1, -1);
    }

    private static Iterable<SqlParserPos> toPos(Iterable<SqlNode> nodes) {
        return Iterables.transform(nodes, new Function<SqlNode, SqlParserPos>(){

            @Override
            public SqlParserPos apply(SqlNode input) {
                return input.getParserPosition();
            }
        });
    }

    public static SqlParserPos sum(List<? extends SqlNode> nodes) {
        return SqlParserPos.sum(nodes.toArray(new SqlNode[nodes.size()]));
    }

    public static SqlParserPos sum(Iterable<SqlParserPos> poses) {
        return SqlParserPos.sum(poses, Integer.MAX_VALUE, Integer.MAX_VALUE, -1, -1);
    }

    private static SqlParserPos sum(Iterable<SqlParserPos> poses, int line, int column, int endLine, int endColumn) {
        for (SqlParserPos pos : poses) {
            if (pos == null || pos.equals(ZERO)) continue;
            int testLine = pos.getLineNum();
            int testColumn = pos.getColumnNum();
            if (testLine < line || testLine == line && testColumn < column) {
                line = testLine;
                column = testColumn;
            }
            testLine = pos.getEndLineNum();
            testColumn = pos.getEndColumnNum();
            if (testLine <= endLine && (testLine != endLine || testColumn <= endColumn)) continue;
            endLine = testLine;
            endColumn = testColumn;
        }
        return new SqlParserPos(line, column, endLine, endColumn);
    }

    public boolean overlaps(SqlParserPos pos) {
        return this.startsBefore(pos) && this.endsAfter(pos) || pos.startsBefore(this) && pos.endsAfter(this);
    }

    private boolean startsBefore(SqlParserPos pos) {
        return this.lineNumber < pos.lineNumber || this.lineNumber == pos.lineNumber && this.columnNumber <= pos.columnNumber;
    }

    private boolean endsAfter(SqlParserPos pos) {
        return this.endLineNumber > pos.endLineNumber || this.endLineNumber == pos.endLineNumber && this.endColumnNumber >= pos.endColumnNumber;
    }

    public boolean startsAt(SqlParserPos pos) {
        return this.lineNumber == pos.lineNumber && this.columnNumber == pos.columnNumber;
    }
}

