/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.CreateTableMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageFactory;
import org.apache.hive.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.thrift.TException;

public class JSONCreateTableMessage
extends CreateTableMessage {
    @JsonProperty
    String server;
    @JsonProperty
    String servicePrincipal;
    @JsonProperty
    String db;
    @JsonProperty
    String table;
    @JsonProperty
    String tableObjJson;
    @JsonProperty
    Long timestamp;
    @JsonProperty
    List<String> files;

    public JSONCreateTableMessage() {
    }

    public JSONCreateTableMessage(String server, String servicePrincipal, String db, String table, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.db = db;
        this.table = table;
        this.timestamp = timestamp;
        this.checkValid();
    }

    public JSONCreateTableMessage(String server, String servicePrincipal, Table tableObj, Iterator<String> fileIter, Long timestamp) {
        this(server, servicePrincipal, tableObj.getDbName(), tableObj.getTableName(), timestamp);
        try {
            this.tableObjJson = JSONMessageFactory.createTableObjJson(tableObj);
        }
        catch (TException e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
        this.files = Lists.newArrayList(fileIter);
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getDB() {
        return this.db;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public Table getTableObj() throws Exception {
        return (Table)JSONMessageFactory.getTObj(this.tableObjJson, Table.class);
    }

    public String getTableObjJson() {
        return this.tableObjJson;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString(this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }

    @Override
    public Iterable<String> getFiles() {
        return this.files;
    }
}

