/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.AmbiguousMethodException;
import org.apache.hadoop.hive.ql.exec.NoMatchingMethodException;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFMethodResolver;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class ComparisonOpMethodResolver
implements UDFMethodResolver {
    private final Class<? extends UDF> udfClass;

    public ComparisonOpMethodResolver(Class<? extends UDF> udfClass) {
        this.udfClass = udfClass;
    }

    @Override
    public Method getEvalMethod(List<TypeInfo> argTypeInfos) throws UDFArgumentException {
        assert (argTypeInfos.size() == 2);
        List<Object> pTypeInfos = null;
        if (argTypeInfos.get(0).equals(TypeInfoFactory.voidTypeInfo) || argTypeInfos.get(1).equals(TypeInfoFactory.voidTypeInfo)) {
            pTypeInfos = new ArrayList<PrimitiveTypeInfo>();
            pTypeInfos.add(TypeInfoFactory.doubleTypeInfo);
            pTypeInfos.add(TypeInfoFactory.doubleTypeInfo);
        } else if (argTypeInfos.get(0).equals(TypeInfoFactory.booleanTypeInfo) && argTypeInfos.get(1).equals(TypeInfoFactory.booleanTypeInfo)) {
            pTypeInfos = new ArrayList();
            pTypeInfos.add(TypeInfoFactory.intTypeInfo);
            pTypeInfos.add(TypeInfoFactory.intTypeInfo);
        } else if (argTypeInfos.get(0) == argTypeInfos.get(1)) {
            pTypeInfos = argTypeInfos;
        } else {
            pTypeInfos = new ArrayList();
            pTypeInfos.add(TypeInfoFactory.doubleTypeInfo);
            pTypeInfos.add(TypeInfoFactory.doubleTypeInfo);
        }
        Method udfMethod = null;
        ArrayList<Method> evaluateMethods = new ArrayList<Method>();
        for (Method m : Arrays.asList(this.udfClass.getMethods())) {
            if (!m.getName().equals("evaluate")) continue;
            evaluateMethods.add(m);
            List<TypeInfo> acceptedTypeInfos = TypeInfoUtils.getParameterTypeInfos(m, pTypeInfos.size());
            if (acceptedTypeInfos == null) continue;
            boolean match = acceptedTypeInfos.size() == pTypeInfos.size();
            for (int i = 0; i < pTypeInfos.size() && match; ++i) {
                TypeInfo accepted = acceptedTypeInfos.get(i);
                if (accepted == pTypeInfos.get(i)) continue;
                match = false;
            }
            if (!match) continue;
            if (udfMethod != null) {
                throw new AmbiguousMethodException(this.udfClass, argTypeInfos, Arrays.asList(udfMethod, m));
            }
            udfMethod = m;
        }
        if (udfMethod == null) {
            throw new NoMatchingMethodException(this.udfClass, argTypeInfos, evaluateMethods);
        }
        return udfMethod;
    }
}

