/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.IOPrepareCache;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.FileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorizedRowBatchCtx {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(VectorizedRowBatchCtx.class.getName());
    private String[] rowColumnNames;
    private TypeInfo[] rowColumnTypeInfos;
    private int[] dataColumnNums;
    private int dataColumnCount;
    private int partitionColumnCount;
    private String[] scratchColumnTypeNames;

    public VectorizedRowBatchCtx() {
    }

    public VectorizedRowBatchCtx(String[] rowColumnNames, TypeInfo[] rowColumnTypeInfos, int[] dataColumnNums, int partitionColumnCount, String[] scratchColumnTypeNames) {
        this.rowColumnNames = rowColumnNames;
        this.rowColumnTypeInfos = rowColumnTypeInfos;
        this.dataColumnNums = dataColumnNums;
        this.partitionColumnCount = partitionColumnCount;
        this.scratchColumnTypeNames = scratchColumnTypeNames;
        this.dataColumnCount = rowColumnTypeInfos.length - partitionColumnCount;
    }

    public String[] getRowColumnNames() {
        return this.rowColumnNames;
    }

    public TypeInfo[] getRowColumnTypeInfos() {
        return this.rowColumnTypeInfos;
    }

    public int[] getDataColumnNums() {
        return this.dataColumnNums;
    }

    public int getDataColumnCount() {
        return this.dataColumnCount;
    }

    public int getPartitionColumnCount() {
        return this.partitionColumnCount;
    }

    public String[] getScratchColumnTypeNames() {
        return this.scratchColumnTypeNames;
    }

    public void init(StructObjectInspector structObjectInspector, String[] scratchColumnTypeNames) throws HiveException {
        this.rowColumnNames = VectorizedBatchUtil.columnNamesFromStructObjectInspector(structObjectInspector);
        this.rowColumnTypeInfos = VectorizedBatchUtil.typeInfosFromStructObjectInspector(structObjectInspector);
        this.dataColumnNums = null;
        this.partitionColumnCount = 0;
        this.dataColumnCount = this.rowColumnTypeInfos.length;
        this.scratchColumnTypeNames = scratchColumnTypeNames;
    }

    public static void getPartitionValues(VectorizedRowBatchCtx vrbCtx, Configuration hiveConf, FileSplit split, Object[] partitionValues) throws IOException {
        MapWork mapWork = Utilities.getMapWork(hiveConf);
        VectorizedRowBatchCtx.getPartitionValues(vrbCtx, mapWork, split, partitionValues);
    }

    public static void getPartitionValues(VectorizedRowBatchCtx vrbCtx, MapWork mapWork, FileSplit split, Object[] partitionValues) throws IOException {
        LinkedHashMap<Path, PartitionDesc> pathToPartitionInfo = mapWork.getPathToPartitionInfo();
        PartitionDesc partDesc = HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, split.getPath(), IOPrepareCache.get().getPartitionDescMap());
        VectorizedRowBatchCtx.getPartitionValues(vrbCtx, partDesc, partitionValues);
    }

    public static void getPartitionValues(VectorizedRowBatchCtx vrbCtx, PartitionDesc partDesc, Object[] partitionValues) {
        LinkedHashMap<String, String> partSpec = partDesc.getPartSpec();
        for (int i = 0; i < vrbCtx.partitionColumnCount; ++i) {
            Object objectValue;
            if (partSpec == null) {
                objectValue = null;
            } else {
                String key = vrbCtx.rowColumnNames[vrbCtx.dataColumnCount + i];
                TypeInfo partColTypeInfo = vrbCtx.rowColumnTypeInfos[vrbCtx.dataColumnCount + i];
                ObjectInspector objectInspector = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(partColTypeInfo);
                objectValue = ObjectInspectorConverters.getConverter((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, objectInspector).convert(partSpec.get(key));
                if (partColTypeInfo instanceof CharTypeInfo) {
                    objectValue = ((HiveChar)objectValue).getStrippedValue();
                }
            }
            partitionValues[i] = objectValue;
        }
    }

    public VectorizedRowBatch createVectorizedRowBatch() {
        int i;
        int dataAndPartColumnCount = this.rowColumnTypeInfos.length;
        int totalColumnCount = dataAndPartColumnCount + this.scratchColumnTypeNames.length;
        VectorizedRowBatch result = new VectorizedRowBatch(totalColumnCount);
        if (this.dataColumnNums == null) {
            for (i = 0; i < dataAndPartColumnCount; ++i) {
                TypeInfo typeInfo = this.rowColumnTypeInfos[i];
                result.cols[i] = VectorizedBatchUtil.createColumnVector(typeInfo);
            }
        } else {
            TypeInfo typeInfo;
            for (i = 0; i < this.dataColumnNums.length; ++i) {
                int columnNum = this.dataColumnNums[i];
                Preconditions.checkState(columnNum < dataAndPartColumnCount);
                typeInfo = this.rowColumnTypeInfos[columnNum];
                result.cols[columnNum] = VectorizedBatchUtil.createColumnVector(typeInfo);
            }
            int endColumnNum = this.dataColumnCount + this.partitionColumnCount;
            for (int partitionColumnNum = this.dataColumnCount; partitionColumnNum < endColumnNum; ++partitionColumnNum) {
                typeInfo = this.rowColumnTypeInfos[partitionColumnNum];
                result.cols[partitionColumnNum] = VectorizedBatchUtil.createColumnVector(typeInfo);
            }
        }
        for (i = 0; i < this.scratchColumnTypeNames.length; ++i) {
            String typeName = this.scratchColumnTypeNames[i];
            result.cols[this.rowColumnTypeInfos.length + i] = VectorizedBatchUtil.createColumnVector(typeName);
        }
        result.setPartitionInfo(this.dataColumnCount, this.partitionColumnCount);
        result.reset();
        return result;
    }

    public void addPartitionColsToBatch(VectorizedRowBatch batch, Object[] partitionValues) {
        if (partitionValues != null) {
            block16: for (int i = 0; i < this.partitionColumnCount; ++i) {
                Object value = partitionValues[i];
                int colIndex = this.dataColumnCount + i;
                String partitionColumnName = this.rowColumnNames[colIndex];
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)this.rowColumnTypeInfos[colIndex];
                switch (primitiveTypeInfo.getPrimitiveCategory()) {
                    case BOOLEAN: {
                        ColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            ((LongColumnVector)lcv).noNulls = false;
                            ((LongColumnVector)lcv).isNull[0] = true;
                            ((LongColumnVector)lcv).isRepeating = true;
                            continue block16;
                        }
                        ((LongColumnVector)lcv).fill((Boolean)value == true ? 1L : 0L);
                        ((LongColumnVector)lcv).isNull[0] = false;
                        continue block16;
                    }
                    case BYTE: {
                        ColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            ((LongColumnVector)lcv).noNulls = false;
                            ((LongColumnVector)lcv).isNull[0] = true;
                            ((LongColumnVector)lcv).isRepeating = true;
                            continue block16;
                        }
                        ((LongColumnVector)lcv).fill(((Byte)value).byteValue());
                        ((LongColumnVector)lcv).isNull[0] = false;
                        continue block16;
                    }
                    case SHORT: {
                        ColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            ((LongColumnVector)lcv).noNulls = false;
                            ((LongColumnVector)lcv).isNull[0] = true;
                            ((LongColumnVector)lcv).isRepeating = true;
                            continue block16;
                        }
                        ((LongColumnVector)lcv).fill(((Short)value).shortValue());
                        ((LongColumnVector)lcv).isNull[0] = false;
                        continue block16;
                    }
                    case INT: {
                        ColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            ((LongColumnVector)lcv).noNulls = false;
                            ((LongColumnVector)lcv).isNull[0] = true;
                            ((LongColumnVector)lcv).isRepeating = true;
                            continue block16;
                        }
                        ((LongColumnVector)lcv).fill(((Integer)value).intValue());
                        ((LongColumnVector)lcv).isNull[0] = false;
                        continue block16;
                    }
                    case LONG: {
                        ColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            ((LongColumnVector)lcv).noNulls = false;
                            ((LongColumnVector)lcv).isNull[0] = true;
                            ((LongColumnVector)lcv).isRepeating = true;
                            continue block16;
                        }
                        ((LongColumnVector)lcv).fill((Long)value);
                        ((LongColumnVector)lcv).isNull[0] = false;
                        continue block16;
                    }
                    case DATE: {
                        ColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            ((LongColumnVector)lcv).noNulls = false;
                            ((LongColumnVector)lcv).isNull[0] = true;
                            ((LongColumnVector)lcv).isRepeating = true;
                            continue block16;
                        }
                        ((LongColumnVector)lcv).fill(DateWritable.dateToDays((Date)value));
                        ((LongColumnVector)lcv).isNull[0] = false;
                        continue block16;
                    }
                    case TIMESTAMP: {
                        ColumnVector lcv = (TimestampColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            ((TimestampColumnVector)lcv).noNulls = false;
                            ((TimestampColumnVector)lcv).isNull[0] = true;
                            ((TimestampColumnVector)lcv).isRepeating = true;
                            continue block16;
                        }
                        ((TimestampColumnVector)lcv).fill((Timestamp)value);
                        ((TimestampColumnVector)lcv).isNull[0] = false;
                        continue block16;
                    }
                    case INTERVAL_YEAR_MONTH: {
                        ColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            ((LongColumnVector)lcv).noNulls = false;
                            ((LongColumnVector)lcv).isNull[0] = true;
                            ((LongColumnVector)lcv).isRepeating = true;
                        } else {
                            ((LongColumnVector)lcv).fill(((HiveIntervalYearMonth)value).getTotalMonths());
                            ((LongColumnVector)lcv).isNull[0] = false;
                        }
                    }
                    case INTERVAL_DAY_TIME: {
                        IntervalDayTimeColumnVector icv = (IntervalDayTimeColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            icv.noNulls = false;
                            icv.isNull[0] = true;
                            icv.isRepeating = true;
                        } else {
                            icv.fill((HiveIntervalDayTime)value);
                            icv.isNull[0] = false;
                        }
                    }
                    case FLOAT: {
                        DoubleColumnVector dcv = (DoubleColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            dcv.noNulls = false;
                            dcv.isNull[0] = true;
                            dcv.isRepeating = true;
                            continue block16;
                        }
                        dcv.fill(((Float)value).floatValue());
                        dcv.isNull[0] = false;
                        continue block16;
                    }
                    case DOUBLE: {
                        DoubleColumnVector dcv = (DoubleColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            dcv.noNulls = false;
                            dcv.isNull[0] = true;
                            dcv.isRepeating = true;
                            continue block16;
                        }
                        dcv.fill((Double)value);
                        dcv.isNull[0] = false;
                        continue block16;
                    }
                    case DECIMAL: {
                        DecimalColumnVector dv = (DecimalColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            dv.noNulls = false;
                            dv.isNull[0] = true;
                            dv.isRepeating = true;
                            continue block16;
                        }
                        HiveDecimal hd = (HiveDecimal)value;
                        dv.set(0, hd);
                        dv.isRepeating = true;
                        dv.isNull[0] = false;
                        continue block16;
                    }
                    case BINARY: {
                        BytesColumnVector bcv = (BytesColumnVector)batch.cols[colIndex];
                        byte[] bytes = (byte[])value;
                        if (bytes == null) {
                            bcv.noNulls = false;
                            bcv.isNull[0] = true;
                            bcv.isRepeating = true;
                            continue block16;
                        }
                        bcv.fill(bytes);
                        bcv.isNull[0] = false;
                        continue block16;
                    }
                    case STRING: 
                    case CHAR: 
                    case VARCHAR: {
                        BytesColumnVector bcv = (BytesColumnVector)batch.cols[colIndex];
                        String sVal = value.toString();
                        if (sVal == null) {
                            bcv.noNulls = false;
                            bcv.isNull[0] = true;
                            bcv.isRepeating = true;
                            continue block16;
                        }
                        bcv.setVal(0, sVal.getBytes());
                        bcv.isRepeating = true;
                        continue block16;
                    }
                    default: {
                        throw new RuntimeException("Unable to recognize the partition type " + (Object)((Object)primitiveTypeInfo.getPrimitiveCategory()) + " for column " + partitionColumnName);
                    }
                }
            }
        }
    }

    public final boolean isPartitionCol(int colNum) {
        return colNum >= this.dataColumnCount && colNum < this.rowColumnTypeInfos.length;
    }
}

