/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.StringGroupColEqualStringGroupScalarBase;

public class StringGroupColEqualCharScalar
extends StringGroupColEqualStringGroupScalarBase {
    public StringGroupColEqualCharScalar(int colNum, HiveChar value, int outputColumn) {
        this.colNum = colNum;
        this.value = value.getStrippedValue().getBytes();
        this.outputColumn = outputColumn;
    }

    public StringGroupColEqualCharScalar() {
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum + ", val " + StringGroupColEqualCharScalar.displayUtf8Bytes(this.value);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_FAMILY, VectorExpressionDescriptor.ArgumentType.getType("Char")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

