/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.lineage;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class LineageCtx
implements NodeProcessorCtx {
    private final Index index;
    private final ParseContext pctx;

    public LineageCtx(ParseContext pctx, Index index) {
        this.index = index;
        this.pctx = pctx;
    }

    public ParseContext getParseCtx() {
        return this.pctx;
    }

    public Index getIndex() {
        return this.index;
    }

    public static LineageInfo.DependencyType getNewDependencyType(LineageInfo.DependencyType old_type, LineageInfo.DependencyType curr_type) {
        if (old_type == LineageInfo.DependencyType.SCRIPT || curr_type == LineageInfo.DependencyType.SCRIPT) {
            return LineageInfo.DependencyType.SCRIPT;
        }
        if (old_type == LineageInfo.DependencyType.EXPRESSION || curr_type == LineageInfo.DependencyType.EXPRESSION) {
            return LineageInfo.DependencyType.EXPRESSION;
        }
        return LineageInfo.DependencyType.SIMPLE;
    }

    public static class Index {
        private final Map<Operator<? extends OperatorDesc>, LinkedHashMap<ColumnInfo, LineageInfo.Dependency>> depMap = new LinkedHashMap<Operator<? extends OperatorDesc>, LinkedHashMap<ColumnInfo, LineageInfo.Dependency>>();
        private final Map<Operator<? extends OperatorDesc>, Set<LineageInfo.Predicate>> condMap = new HashMap<Operator<? extends OperatorDesc>, Set<LineageInfo.Predicate>>();
        private LinkedHashMap<String, ObjectPair<SelectOperator, Table>> finalSelectOps = new LinkedHashMap();

        public LineageInfo.Dependency getDependency(Operator<? extends OperatorDesc> op, ColumnInfo col) {
            Map colMap = this.depMap.get(op);
            if (colMap == null) {
                return null;
            }
            return (LineageInfo.Dependency)colMap.get(col);
        }

        public LineageInfo.Dependency getDependency(Operator<? extends OperatorDesc> op, String internalName) {
            Map colMap = this.depMap.get(op);
            if (colMap != null) {
                for (Map.Entry e : colMap.entrySet()) {
                    if (!((ColumnInfo)e.getKey()).getInternalName().equals(internalName)) continue;
                    return (LineageInfo.Dependency)e.getValue();
                }
            }
            return null;
        }

        public void putDependency(Operator<? extends OperatorDesc> op, ColumnInfo col, LineageInfo.Dependency dep) {
            LinkedHashMap<ColumnInfo, LineageInfo.Dependency> colMap = this.depMap.get(op);
            if (colMap == null) {
                colMap = new LinkedHashMap();
                this.depMap.put(op, colMap);
            }
            colMap.put(col, dep);
        }

        public void mergeDependency(Operator<? extends OperatorDesc> op, ColumnInfo ci, LineageInfo.Dependency dep) {
            LineageInfo.Dependency old_dep = this.getDependency(op, ci);
            if (old_dep == null) {
                this.putDependency(op, ci, dep);
            } else {
                LineageInfo.DependencyType new_type = LineageCtx.getNewDependencyType(old_dep.getType(), LineageInfo.DependencyType.EXPRESSION);
                old_dep.setType(new_type);
                LinkedHashSet<LineageInfo.BaseColumnInfo> bci_set = new LinkedHashSet<LineageInfo.BaseColumnInfo>(old_dep.getBaseCols());
                bci_set.addAll(dep.getBaseCols());
                old_dep.setBaseCols(bci_set);
                old_dep.setExpr(null);
            }
        }

        public Map<ColumnInfo, LineageInfo.Dependency> getDependencies(Operator<? extends OperatorDesc> op) {
            return this.depMap.get(op);
        }

        public void addPredicate(Operator<? extends OperatorDesc> op, LineageInfo.Predicate cond) {
            Set<LineageInfo.Predicate> conds = this.condMap.get(op);
            if (conds == null) {
                conds = new LinkedHashSet<LineageInfo.Predicate>();
                this.condMap.put(op, conds);
            }
            for (LineageInfo.Predicate p : conds) {
                if (!StringUtils.equals(cond.getExpr(), p.getExpr())) continue;
                p.getBaseCols().addAll(cond.getBaseCols());
                return;
            }
            conds.add(cond);
        }

        public void copyPredicates(Operator<? extends OperatorDesc> srcOp, Operator<? extends OperatorDesc> tgtOp) {
            Set<LineageInfo.Predicate> conds = this.getPredicates(srcOp);
            if (conds != null) {
                for (LineageInfo.Predicate cond : conds) {
                    this.addPredicate(tgtOp, cond);
                }
            }
        }

        public Set<LineageInfo.Predicate> getPredicates(Operator<? extends OperatorDesc> op) {
            return this.condMap.get(op);
        }

        public void addFinalSelectOp(SelectOperator sop, Operator<? extends OperatorDesc> sinkOp) {
            String operatorId = sop.getOperatorId();
            if (!this.finalSelectOps.containsKey(operatorId)) {
                Table table = null;
                if (sinkOp instanceof FileSinkOperator) {
                    FileSinkOperator fso = (FileSinkOperator)sinkOp;
                    table = ((FileSinkDesc)fso.getConf()).getTable();
                }
                this.finalSelectOps.put(operatorId, new ObjectPair<SelectOperator, Table>(sop, table));
            }
        }

        public LinkedHashMap<String, ObjectPair<SelectOperator, Table>> getFinalSelectOps() {
            return this.finalSelectOps;
        }

        public void clear() {
            this.finalSelectOps.clear();
            this.depMap.clear();
            this.condMap.clear();
        }
    }
}

