/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.DependencyCollectionTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.plan.DependencyCollectionWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;

public class GenMRProcContext
implements NodeProcessorCtx {
    private HiveConf conf;
    private HashMap<Operator<? extends OperatorDesc>, Task<? extends Serializable>> opTaskMap;
    private HashMap<Task<? extends Serializable>, List<Operator<? extends OperatorDesc>>> taskToSeenOps;
    private HashMap<UnionOperator, GenMRUnionCtx> unionTaskMap;
    private List<FileSinkOperator> seenFileSinkOps;
    private ParseContext parseCtx;
    private List<Task<MoveWork>> mvTask;
    private List<Task<? extends Serializable>> rootTasks;
    private LinkedHashMap<Operator<? extends OperatorDesc>, GenMapRedCtx> mapCurrCtx;
    private Task<? extends Serializable> currTask;
    private TableScanOperator currTopOp;
    private UnionOperator currUnionOp;
    private String currAliasId;
    private DependencyCollectionTask dependencyTaskForMultiInsert;
    private Map<FileSinkDesc, Task<? extends Serializable>> linkedFileDescTasks;
    private Set<ReadEntity> inputs;
    private Set<WriteEntity> outputs;

    public GenMRProcContext() {
    }

    public GenMRProcContext(HiveConf conf, HashMap<Operator<? extends OperatorDesc>, Task<? extends Serializable>> opTaskMap, ParseContext parseCtx, List<Task<MoveWork>> mvTask, List<Task<? extends Serializable>> rootTasks, LinkedHashMap<Operator<? extends OperatorDesc>, GenMapRedCtx> mapCurrCtx, Set<ReadEntity> inputs, Set<WriteEntity> outputs) {
        this.conf = conf;
        this.opTaskMap = opTaskMap;
        this.mvTask = mvTask;
        this.parseCtx = parseCtx;
        this.rootTasks = rootTasks;
        this.mapCurrCtx = mapCurrCtx;
        this.inputs = inputs;
        this.outputs = outputs;
        this.currTask = null;
        this.currTopOp = null;
        this.currUnionOp = null;
        this.currAliasId = null;
        this.unionTaskMap = new HashMap();
        this.taskToSeenOps = new HashMap();
        this.dependencyTaskForMultiInsert = null;
        this.linkedFileDescTasks = null;
    }

    public HashMap<Operator<? extends OperatorDesc>, Task<? extends Serializable>> getOpTaskMap() {
        return this.opTaskMap;
    }

    public void setOpTaskMap(HashMap<Operator<? extends OperatorDesc>, Task<? extends Serializable>> opTaskMap) {
        this.opTaskMap = opTaskMap;
    }

    public boolean isSeenOp(Task task, Operator operator) {
        List<Operator<? extends OperatorDesc>> seenOps = this.taskToSeenOps.get(task);
        return seenOps != null && seenOps.contains(operator);
    }

    public void addSeenOp(Task task, Operator operator) {
        List<Operator<? extends OperatorDesc>> seenOps = this.taskToSeenOps.get(task);
        if (seenOps == null) {
            seenOps = new ArrayList<Operator<? extends OperatorDesc>>();
            this.taskToSeenOps.put(task, seenOps);
        }
        seenOps.add(operator);
    }

    public List<FileSinkOperator> getSeenFileSinkOps() {
        return this.seenFileSinkOps;
    }

    public void setSeenFileSinkOps(List<FileSinkOperator> seenFileSinkOps) {
        this.seenFileSinkOps = seenFileSinkOps;
    }

    public ParseContext getParseCtx() {
        return this.parseCtx;
    }

    public void setParseCtx(ParseContext parseCtx) {
        this.parseCtx = parseCtx;
    }

    public List<Task<MoveWork>> getMvTask() {
        return this.mvTask;
    }

    public void setMvTask(List<Task<MoveWork>> mvTask) {
        this.mvTask = mvTask;
    }

    public List<Task<? extends Serializable>> getRootTasks() {
        return this.rootTasks;
    }

    public void setRootTasks(List<Task<? extends Serializable>> rootTasks) {
        this.rootTasks = rootTasks;
    }

    public boolean addRootIfPossible(Task<? extends Serializable> task) {
        if ((task.getParentTasks() == null || task.getParentTasks().isEmpty()) && !this.rootTasks.contains(task)) {
            return this.rootTasks.add(task);
        }
        return false;
    }

    public LinkedHashMap<Operator<? extends OperatorDesc>, GenMapRedCtx> getMapCurrCtx() {
        return this.mapCurrCtx;
    }

    public void setMapCurrCtx(LinkedHashMap<Operator<? extends OperatorDesc>, GenMapRedCtx> mapCurrCtx) {
        this.mapCurrCtx = mapCurrCtx;
    }

    public Task<? extends Serializable> getCurrTask() {
        return this.currTask;
    }

    public void setCurrTask(Task<? extends Serializable> currTask) {
        this.currTask = currTask;
    }

    public TableScanOperator getCurrTopOp() {
        return this.currTopOp;
    }

    public void setCurrTopOp(TableScanOperator currTopOp) {
        this.currTopOp = currTopOp;
    }

    public UnionOperator getCurrUnionOp() {
        return this.currUnionOp;
    }

    public void setCurrUnionOp(UnionOperator currUnionOp) {
        this.currUnionOp = currUnionOp;
    }

    public String getCurrAliasId() {
        return this.currAliasId;
    }

    public void setCurrAliasId(String currAliasId) {
        this.currAliasId = currAliasId;
    }

    public GenMRUnionCtx getUnionTask(UnionOperator op) {
        return this.unionTaskMap.get(op);
    }

    public void setUnionTask(UnionOperator op, GenMRUnionCtx uTask) {
        this.unionTaskMap.put(op, uTask);
    }

    public Set<ReadEntity> getInputs() {
        return this.inputs;
    }

    public Set<WriteEntity> getOutputs() {
        return this.outputs;
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public void setConf(HiveConf conf) {
        this.conf = conf;
    }

    public DependencyCollectionTask getDependencyTaskForMultiInsert() {
        if (this.dependencyTaskForMultiInsert == null && this.conf.getBoolVar(HiveConf.ConfVars.HIVE_MULTI_INSERT_MOVE_TASKS_SHARE_DEPENDENCIES)) {
            this.dependencyTaskForMultiInsert = (DependencyCollectionTask)TaskFactory.get(new DependencyCollectionWork(), this.conf, new Task[0]);
        }
        return this.dependencyTaskForMultiInsert;
    }

    public Map<FileSinkDesc, Task<? extends Serializable>> getLinkedFileDescTasks() {
        return this.linkedFileDescTasks;
    }

    public void setLinkedFileDescTasks(Map<FileSinkDesc, Task<? extends Serializable>> linkedFileDescTasks) {
        this.linkedFileDescTasks = linkedFileDescTasks;
    }

    public static class GenMRUnionCtx {
        final Task<? extends Serializable> uTask;
        List<String> taskTmpDir;
        List<TableDesc> tt_desc;
        List<TableScanOperator> listTopOperators;

        public GenMRUnionCtx(Task<? extends Serializable> uTask) {
            this.uTask = uTask;
            this.taskTmpDir = new ArrayList<String>();
            this.tt_desc = new ArrayList<TableDesc>();
            this.listTopOperators = new ArrayList<TableScanOperator>();
        }

        public Task<? extends Serializable> getUTask() {
            return this.uTask;
        }

        public void addTaskTmpDir(String taskTmpDir) {
            this.taskTmpDir.add(taskTmpDir);
        }

        public List<String> getTaskTmpDir() {
            return this.taskTmpDir;
        }

        public void addTTDesc(TableDesc tt_desc) {
            this.tt_desc.add(tt_desc);
        }

        public List<TableDesc> getTTDesc() {
            return this.tt_desc;
        }

        public List<TableScanOperator> getListTopOperators() {
            return this.listTopOperators;
        }

        public void addListTopOperators(TableScanOperator topOperator) {
            this.listTopOperators.add(topOperator);
        }
    }

    public static class GenMapRedCtx {
        Task<? extends Serializable> currTask;
        String currAliasId;

        public GenMapRedCtx() {
        }

        public GenMapRedCtx(Task<? extends Serializable> currTask, String currAliasId) {
            this.currTask = currTask;
            this.currAliasId = currAliasId;
        }

        public Task<? extends Serializable> getCurrTask() {
            return this.currTask;
        }

        public String getCurrAliasId() {
            return this.currAliasId;
        }
    }
}

